/*
 * Copyright (C) 2009 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as 
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#include <glib.h>
#include <libgadget/libgadget.h>

typedef struct
{
  GadgetManager *manager;

} ManagerFixture;

static void
manager_fixture_setup (ManagerFixture *fix,
                       gconstpointer   test_data)
{
  /* FIXME: We need to create a manager with a custom module directory
   * in the future (with mocks)
   */
  //fix->manager = gadget_manager_get_default ();
  fix->manager = g_object_new (GADGET_TYPE_MANAGER,
                               "sources-dir", "./",
                               NULL);
  g_assert (fix->manager != NULL);
}

static void
manager_fixture_teardown (ManagerFixture *fix,
                          gconstpointer   test_data)
{
  g_assert (fix->manager != NULL);
  g_object_unref (fix->manager);
}

static void
test_gadget_manager_props (ManagerFixture *fix,
                           gconstpointer   test_data)
{
  gchar *sources_dir = NULL;

  g_object_get (fix->manager, "sources-dir", &sources_dir, NULL);

  g_assert (sources_dir);

  g_free (sources_dir);
}

static void
test_gadget_manager_module_load (ManagerFixture *fix,
                                 gconstpointer   test_data)
{
  gadget_manager_load_sources (fix->manager);
}

void
test_gadget_manager_create_suite (void)
{
#define DOMAIN "/GadgetManager"

  g_test_add (DOMAIN"/Properties",
              ManagerFixture, 
              NULL,
              manager_fixture_setup,
              test_gadget_manager_props,
              manager_fixture_teardown);

  g_test_add (DOMAIN"/ModuleLoad",
              ManagerFixture,
              NULL,
              manager_fixture_setup,
              test_gadget_manager_module_load,
              manager_fixture_teardown);
}


