
 /************************************************************************
  * Copyright 2005-2006 by Freescale Semiconductor, Inc.
  * All modifications are confidential and proprietary information
  * of Freescale Semiconductor, Inc. ALL RIGHTS RESERVED.
  ************************************************************************/

//+-------------------------------------------------------------------------
//
//  Microsoft Windows Media
//
//  Copyright (C) Microsoft Corporation, 1999 - 1999
//
//  File:       wmadec.h
//
//--------------------------------------------------------------------------

#ifndef WMADEC_H
#define WMADEC_H

#include "porting.h"
#define STRING_SIZE 255

#if !defined(_Embedded_x86) && !defined(HITACHI)
#ifdef macintosh
#include <MacTypes.h>
#include <Errors.h>
#include <Endian.h>
#include <MacMemory.h>
#define BIGENDIAN
#else
// #include <windows.h>
#include <memory.h>
// #include <mmsystem.h>
#endif 
#endif

#include <stdio.h>
#include "wmf.h"
#include "wmftypes.h"
#include "wmfdecode.h"



//#include "wmadec_api.h"
#include "wmadecs_api.h"
#ifndef WMFAPI_NO_DRM
#ifdef _ZMDRM_
#include "drmmanager_api.h"
#else
#include "drmbase.h"
#include "drmpd.h"
#endif
#endif
#include "wmf_types.h"
#include "wmfdecode.h"
typedef struct tPacketInfo
{
	U32_WMF	nSamplesPerSec;
	U64_WMF	cbPacketOffset;	
	U64_WMF	cbLastPacketOffset;	
	U32_WMF	cbPacketSize;	
	U32_WMF	cbMaxAudioSize;
	U16_WMF	nChannels;	
	U32_WMF	fccHandler;
	U32_WMF	dwScale;
	U32_WMF	dwRate;
	BITMAPINFOHEADER BitmapInfo;
	WAVEFORMATEX		tWaveFormat;	
	U8_WMF	bHasValidVideo;
	U8_WMF	bHasValidAudio;
	U8_WMF	bInit;

} WMINITINFO;



typedef struct tWMFDecoder
{
#ifndef _ASFPARSE_ONLY_
//    WMADECHANDLE hMSA;
	WMARawDecHandle hMSA;
#endif
    WMINITINFO* pPktInfo; 

    U32_WMF   cbHeader;
    U32_WMF   cbPacketSize;
    U32_WMF   cbAudioSize;
    U32_WMF   cPackets;
    U32_WMF   msDuration;
    U32_WMF   msPreroll;
	U32_WMF   dwMaxBitrate;
	U64_WMF	  cbFileSize;
	U8_WMF    bSeekable;


    U16_WMF   wFormatTag;
	U32_WMF   nAvgBytesPerSec;
    U32_WMF   nSamplesPerBlock;
    U16_WMF   nEncodeOpt;

#if 1//_WMDRM_SUPPORT_
	U8_WMF		encrptObjPresent;
	U8_WMF		extEncrptObjPresent;

	U8_WMF*   pbEncrptData;
	U8_WMF*   pbExEncrptData;
	U32_WMF   encryptObjSize;
	U32_WMF   extEncryptObjSize;
	Void_WMF* wmDRMstate;
#endif 

#ifndef WMFAPI_NO_DRM
#ifdef _ZMDRM_
    HDRMMGR hDRM;
#else
    CDrmPD *hDRM;
#endif
#endif

    U8_WMF*   pszType;
    U8_WMF*   pszKeyID;
 
    U32_WMF   cbEnhData;
    U8_WMF*   pbEnhData;
    U32_WMF   cbSecData;
    U8_WMF*   pbSecData;
// Members added by Amit for Video information;

    U16_WMF	wAudioStreamId;
	U16_WMF	wVideoStreamId;
	U32_WMF   windowWidth;
    U32_WMF   windowHeight;
    U8_WMF    flags;
    U16_WMF    imageInfoLen;
	U32_WMF  biSize; 
	U16_WMF   biPlanes; 
	
	U32_WMF  biSizeImage; 
	LONG	biXPelsPerMeter; 
	LONG	biYPelsPerMeter; 
	U32_WMF  biClrUsed; 
	U32_WMF  biClrImportant;
	U8_WMF	*pDisplay;
	void	*pVDec;
#ifndef _XBOX
	FILE	*pInput;
#endif
	U8_WMF	*pbAudio;
	U8_WMF	*pbHeader;
	U8_WMF	*pbPacket;

    PacketList TempList;
    U32_WMF   dwNbFrames;
    U32_WMF   dwTotAudioOut;
    U16_WMF    bFirst;
    U32_WMF   dwPrevPresTime;
    /* Marker */
    U32_WMF   m_dwMarkerNum;
    WMFContentDescription *m_pContentDesc;
    MarkerEntry *m_pMarkers;
    WMFExtendedContentDesc *m_pExtendedContentDesc;
    WMFScriptCommand *m_pScriptCommand;
    U32_WMF dwAudioTimeStamp;
        /* License Store */
    U32_WMF   m_dwLicenseLen;
    U8_WMF   *m_pLicData;
    U8_WMF bHasDRM;
    U16_WMF wGoodVideoStream1;
    U16_WMF wGoodVideoStream2;
	U8_WMF cbDone;
	U8_WMF cbVideoFrames;
	U8_WMF *pbVideoBuffer;
    U32_WMF dwVideoBufSize;
    U32_WMF dwVideoBufCurOffset;
	U32_WMF cbNbFramesVidBuf;
	U8_WMF *pbAudioBuffer;
    U32_WMF dwAudioBufSize;
    U32_WMF dwAudioBufCurOffset;
	U32_WMF cbNbFramesAudBuf;
    U32_WMF dwAudioBufDecoded;
    U32_WMF dwAudioPayloadSize;
	U8_WMF  bBlockStart;
	U32_WMF dwBlockLeft;
	U16_WMF bVideoStreams[16];
	U32_WMF dwPayloadLeft;
	U32_WMF dwAudPayloadPresTime;
	U8_WMF  bMBRFile;
	U8_WMF  bDecided;
	U8_WMF  bRawAudio;
	U8_WMF  bRawVideo;
	int hdr_size;
	asf_parser_content_descriptor meta_data;                // Meta data information contained in the file
	AudioStreamInfo audio_info;        // Audio information of the file
	VideoStreamInfo video_info;        // Video information of the file
    ASF_Void   *pvAppContext;

}WMFDecoder;

//extern const U8_WMF StandardPalette[3*256];


#endif

