/*
  This is part of the rtl8180-sa2400 driver
  released under the GPL (See file COPYING for details).
  Copyright (c) 2005 Andrea Merello <andreamrl@tiscali.it>
  
  This files contains programming code for the rtl8255 
  radio frontend.
  
  *Many* thanks to Realtek Corp. for their great support!
  
*/

#define BAND_A 1
#define BAND_BG 2

#include "r8180.h"
#include "r8180_hw.h"
#include "r8180_rtl8255.h"

u32 rtl8255_chan[] = {
	0,	//dummy channel 0
	0x13, //1	 
	0x115, //2  
	0x217, //3  
	0x219, //4  
	0x31b, //5  
	0x41d, //6  
	0x41f, //7  
	0x621, //8  
	0x623, //9 
	0x625, //10  
	0x627, //11  
	0x829, //12  
	0x82b, //13 
	0x92f, // 14  
};

static short rtl8255_gain_2G[]={
	0x33, 0x17, 0x7c, 0xc5,//-78
	0x43, 0x17, 0x7a, 0xc5,//-74
	0x53, 0x17, 0x78, 0xc5,//-70
	0x63, 0x17, 0x76, 0xc5,//-66
};


static short rtl8255_agc[]={
	0x1, 0x1, 0x1, 0x1, 0x1,         0x1, 0x1, 0x1, 0x1, 0x1, 
	
	0x1, 0x1, 0x2, 0x2, 0x3,         0x3, 0x4, 0x4, 0x5, 0x5,
	0x6, 0x6, 0x7, 0x7, 0x8,         0x8, 0x9, 0x9, 0xa, 0xa,
	0xb, 0xb, 0xc, 0xc, 0xd,         0xd, 0xe, 0xe, 0xf, 0xf,
	
	0x10, 0x10, 0x11, 0x11, 0x12,    0x12, 0x13, 0x13, 0x14, 0x14,
	0x15, 0x15, 0x16, 0x16, 0x17,    0x17, 0x18, 0x18, 0x19, 0x19,
	0x1a, 0x1a, 0x1b, 0x1b, 0x1c,    0x1c, 0x1d, 0x1d, 0x1e, 0x1e,
	0x1f, 0x1f,
	
	0x20, 0x20, 0x21, 0x21, 0x22,    0x22, 0x23, 0x23, 0x24, 0x24,
	0x25, 0x25, 0x26, 0x26, 0x27,    0x27, 0x28, 0x28, 0x29, 0x29,
	0x2a, 0x2a, 
	
	0x2a, 0x2a, 0x2a, 0x2a, 0x2a,    0x2a, 0x2a, 0x2a, 0x2a, 0x2a,
	0x2a, 0x2a, 0x2a, 0x2a, 0x2a,    0x2a, 0x2a, 0x2a, 0x2a, 0x2a,
	0x2a, 0x2a, 0x2a, 0x2a, 0x2a,    0x2a, 0x2a, 0x2a, 0x2a, 0x2a,
	0x2a, 0x2a, 0x2a, 0x2a

};

void rtl8255_set_gain(struct net_device *dev, short gain)
{

//	struct r8180_priv *priv = ieee80211_priv(dev);
	
	write_phy_ofdm(dev, 0x0d, rtl8255_gain_2G[gain * 4]);
	write_phy_ofdm(dev, 0x23, rtl8255_gain_2G[gain * 4 + 1]);
	write_phy_ofdm(dev, 0x1b, rtl8255_gain_2G[gain * 4 + 2]);
	write_phy_ofdm(dev, 0x1d, rtl8255_gain_2G[gain * 4 + 3]);
	//rtl8225_set_gain_usb(dev, gain);	
}

void write_rtl8255_reg0c(struct net_device *dev, u32 d1, u32 d2, u32 d3, u32 d4, 
u32 d5, u32 d6, u32 d7, u32 d8, u32 d9, u32 d10)
{
	int i,j;
	u16 out,select;
	u8 bit;
	u32 bangdata;
//	struct r8180_priv *priv = ieee80211_priv(dev);
	
	write_nic_word(dev,RFPinsEnable,
		(read_nic_word(dev,RFPinsEnable) | 0x7));
	
	select = read_nic_word(dev, RFPinsSelect);
	
	write_nic_word(dev, RFPinsSelect, select | 0x7 | SW_CONTROL_GPIO);
	
	out = read_nic_word(dev, RFPinsOutput) & 0xfff3;
	
	write_nic_word(dev, RFPinsOutput, out | BB_HOST_BANG_EN );//| 0x1fff);
	
	force_pci_posting(dev);
	udelay(2);
	
	write_nic_word(dev, RFPinsOutput, out);
	
	force_pci_posting(dev);
	udelay(2);
	
	for(j=0;j<10;j++)
	{
		switch(j)
		{
			case 9:
			bangdata = d10 | 0x0c;
			break;
			case 8:
			bangdata = d9;
			break;
			case 7:
			bangdata = d8;
			break;
			case 6:
			bangdata = d7;
			break;
			case 5:
			bangdata = d6;
			break;
			case 4:
			bangdata = d5;
			break;
			case 3:
			bangdata = d4;
			break;
			case 2:
			bangdata = d3;
			break;
			case 1:
			bangdata = d2;
			break;
			case 0:
			bangdata = d1;
			break;
			default:
			bangdata=0xbadc0de; /* avoid gcc complaints */
			break;
		}
		
		for(i=31; i>=0;i--){
		
			bit = (bangdata & (1<<i)) >> i;
			
			write_nic_word(dev, RFPinsOutput, bit | out);
			force_pci_posting(dev);
			udelay(1);
			write_nic_word(dev, RFPinsOutput, bit | out | BB_HOST_BANG_CLK);
			force_pci_posting(dev);
			udelay(1);
		//	write_nic_word(dev, RFPinsOutput, bit | out | BB_HOST_BANG_CLK);
			i--;
			bit = (bangdata & (1<<i)) >> i;
			
			write_nic_word(dev, RFPinsOutput, bit | out | BB_HOST_BANG_CLK);
			force_pci_posting(dev);
			udelay(1);
		//	write_nic_word(dev, RFPinsOutput, bit | out | BB_HOST_BANG_CLK);
			write_nic_word(dev, RFPinsOutput, bit | out);
			force_pci_posting(dev);
			udelay(1);
		}
	}
	
	write_nic_word(dev, RFPinsOutput, out | BB_HOST_BANG_EN);
	force_pci_posting(dev);
	udelay(10);

//	write_nic_word(dev, RFPinsOutput, out | BB_HOST_BANG_EN);
	write_nic_word(dev, RFPinsSelect, select | SW_CONTROL_GPIO);
//	rtl8185_rf_pins_enable(dev);
	
}

void write_rtl8255(struct net_device *dev, u8 adr, u16 data)
{
	int i;
	u16 out,select;
	u8 bit;
	u32 bangdata = (data << 4) | (adr & 0xf);
//	struct r8180_priv *priv = ieee80211_priv(dev);
	
	out = read_nic_word(dev, RFPinsOutput) & 0xfff3;
		
	write_nic_word(dev,RFPinsEnable,
		(read_nic_word(dev,RFPinsEnable) | 0x7));
	
	select = read_nic_word(dev, RFPinsSelect);
	
	write_nic_word(dev, RFPinsSelect, select | 0x7 | SW_CONTROL_GPIO);
	
	force_pci_posting(dev);
	udelay(10);
	
	write_nic_word(dev, RFPinsOutput, out | BB_HOST_BANG_EN );//| 0x1fff);
	
	force_pci_posting(dev);
	udelay(2);
	
	write_nic_word(dev, RFPinsOutput, out);
	
	force_pci_posting(dev);
	udelay(10);
	
	
	for(i=15; i>=0;i--){
	
		bit = (bangdata & (1<<i)) >> i;
		
		write_nic_word(dev, RFPinsOutput, bit | out);
		write_nic_word(dev, RFPinsOutput, bit | out | BB_HOST_BANG_CLK);
		write_nic_word(dev, RFPinsOutput, bit | out | BB_HOST_BANG_CLK);
		i--;
		bit = (bangdata & (1<<i)) >> i;
		
		write_nic_word(dev, RFPinsOutput, bit | out | BB_HOST_BANG_CLK);
		write_nic_word(dev, RFPinsOutput, bit | out | BB_HOST_BANG_CLK);
		write_nic_word(dev, RFPinsOutput, bit | out);
	}
	
	
	write_nic_word(dev, RFPinsOutput, out | BB_HOST_BANG_EN);
	
	force_pci_posting(dev);
	udelay(10);

	write_nic_word(dev, RFPinsOutput, out | BB_HOST_BANG_EN);
	write_nic_word(dev, RFPinsSelect, select | SW_CONTROL_GPIO);

	rtl8185_rf_pins_enable(dev);
}

void rtl8255_rf_close(struct net_device *dev)
{
	
//	rtl8180_set_anaparam(dev, RTL8225_ANAPARAM_OFF);
//	rtl8185_set_anaparam2(dev, RTL8225_ANAPARAM2_OFF);
}

void rtl8255_SetTXPowerLevel(struct net_device *dev, short ch)
{
	struct r8180_priv *priv = ieee80211_priv(dev);
	
	u8 cck_power_level = 0xff & priv->chtxpwr[ch];
	u8 ofdm_power_level = 0xff & priv->chtxpwr_ofdm[ch];
	write_nic_byte(dev, TX_GAIN_OFDM, ofdm_power_level);
	write_nic_byte(dev, TX_GAIN_CCK, cck_power_level);
	force_pci_posting(dev);
	mdelay(1);
	//write_nic_byte(dev, TX_AGC_CONTROL,4);
}
#if 0
/* switch between mode B and G */
void rtl8255_set_mode(struct net_device *dev, short modeb)
{
	write_phy_ofdm(dev, 0x15, (modeb ? 0x0 : 0x40));
	write_phy_ofdm(dev, 0x17, (modeb ? 0x0 : 0x40));
}
#endif

void rtl8255_rf_set_chan(struct net_device *dev, short ch)
{
	//write_rtl8225(dev, 0x7, rtl8225_chan[1]);
	write_rtl8255(dev, 0x5, 0x65);
	write_rtl8255(dev, 0x6, rtl8255_chan[ch]);
	write_rtl8255(dev, 0x7, 0x7c);
	write_rtl8255(dev, 0x8, 0x6);
	
	
	force_pci_posting(dev);
	set_current_state(TASK_INTERRUPTIBLE);
	schedule_timeout(HZ);
//	rtl8225_set_mode_B(dev);

	rtl8255_SetTXPowerLevel(dev, ch);	
	/* FIXME FIXME FIXME */
	
	#if 0
	write_nic_byte(dev,DIFS,0xe); //DIFS
	write_nic_byte(dev,SLOT,0x14); //SLOT
	write_nic_byte(dev,EIFS,0x5b); // EIFS
	//write_nic_byte(dev,0xbc,0); //CW CONFIG
	write_nic_byte(dev,0xbd,0xa4); //CW VALUE
	//write_nic_byte(dev,TX_AGC_CONTROL,4);
	//write_nic_byte(dev, 0x9d,7);
//Apr 20 13:25:03 localhost kernel: w8. 409d<-7  // CCK AGC
	/*write_nic_word(dev,0x84,0x488);
	write_nic_byte(dev,0x91,0x3e);
	write_nic_byte(dev,0x90,0x30);
	write_nic_word(dev,0x84,0x488);
	write_nic_byte(dev,0x91,0x3e);
	write_nic_byte(dev,0x90,0x20);
	*/
	//mdelay(100);
	#endif
}

void rtl8255_init_BGband(struct net_device *dev)
{	
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x804187cf, 0x40000027,
		0x92402ac0, 0xf0009, 0x28000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc00);
	write_rtl8255(dev, 0x4, 0xe00);
	write_rtl8255(dev, 0x4, 0xc00);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x800);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa00);
	write_rtl8255(dev, 0x4, 0x800);
	write_rtl8255(dev, 0x4, 0x400);
	write_rtl8255(dev, 0x3, 0x26);
	write_rtl8255(dev, 0x2, 0x27);
	write_rtl8255(dev, 0x4, 0x600);
	write_rtl8255(dev, 0x4, 0x400);
	write_rtl8255(dev, 0x4, 0x400);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x600);
	write_rtl8255(dev, 0x4, 0x400);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x804187ce, 0x80000027,
		0x92402ac0, 0xf0009, 0x28000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc01);
	write_rtl8255(dev, 0x4, 0xe01);
	write_rtl8255(dev, 0x4, 0xc01);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x801);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa01);
	write_rtl8255(dev, 0x4, 0x801);
	write_rtl8255(dev, 0x4, 0x401);
	write_rtl8255(dev, 0x3, 0x26);
	write_rtl8255(dev, 0x2, 0x27);
	write_rtl8255(dev, 0x4, 0x601);
	write_rtl8255(dev, 0x4, 0x401);
	write_rtl8255(dev, 0x4, 0x401);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x601);
	write_rtl8255(dev, 0x4, 0x401);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x80418bdf, 0x40000027,
		0x92402ac4, 0xf0009, 0x28000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc02);
	write_rtl8255(dev, 0x4, 0xe02);
	write_rtl8255(dev, 0x4, 0xc02);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x802);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa02);
	write_rtl8255(dev, 0x4, 0x802);
	write_rtl8255(dev, 0x4, 0x402);
	write_rtl8255(dev, 0x3, 0x26);
	write_rtl8255(dev, 0x2, 0x26);
	write_rtl8255(dev, 0x4, 0x602);
	write_rtl8255(dev, 0x4, 0x402);
	write_rtl8255(dev, 0x4, 0x402);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x602);
	write_rtl8255(dev, 0x4, 0x402);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x80418bbf, 0x40000027,
		0x92402ac4, 0xf0009, 0x28000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc03);
	write_rtl8255(dev, 0x4, 0xe03);
	write_rtl8255(dev, 0x4, 0xc03);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x803);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa03);
	write_rtl8255(dev, 0x4, 0x803);
	write_rtl8255(dev, 0x4, 0x403);
	write_rtl8255(dev, 0x3, 0x26);
	write_rtl8255(dev, 0x2, 0x26);
	write_rtl8255(dev, 0x4, 0x603);
	write_rtl8255(dev, 0x4, 0x403);
	write_rtl8255(dev, 0x4, 0x403);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x603);
	write_rtl8255(dev, 0x4, 0x403);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x80418b9f, 0x40000027,
		0x92402ac8, 0xf0009, 0x28000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc04);
	write_rtl8255(dev, 0x4, 0xe04);
	write_rtl8255(dev, 0x4, 0xc04);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x804);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa04);
	write_rtl8255(dev, 0x4, 0x804);
	write_rtl8255(dev, 0x4, 0x404);
	write_rtl8255(dev, 0x3, 0x26);
	write_rtl8255(dev, 0x2, 0x26);
	write_rtl8255(dev, 0x4, 0x604);
	write_rtl8255(dev, 0x4, 0x404);
	write_rtl8255(dev, 0x4, 0x404);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x604);
	write_rtl8255(dev, 0x4, 0x404);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x804183df, 0x40000027,
		0x92402ac8, 0xf0009, 0x28000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc05);
	write_rtl8255(dev, 0x4, 0xe05);
	write_rtl8255(dev, 0x4, 0xc05);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x805);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa05);
	write_rtl8255(dev, 0x4, 0x805);
	write_rtl8255(dev, 0x4, 0x405);
	write_rtl8255(dev, 0x3, 0x26);
	write_rtl8255(dev, 0x2, 0x26);
	write_rtl8255(dev, 0x4, 0x605);
	write_rtl8255(dev, 0x4, 0x405);
	write_rtl8255(dev, 0x4, 0x405);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x605);
	write_rtl8255(dev, 0x4, 0x405);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x804183cf, 0x27,
		0x92402acc, 0xf0009, 0x28000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc06);
	write_rtl8255(dev, 0x4, 0xe06);
	write_rtl8255(dev, 0x4, 0xc06);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x806);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa06);
	write_rtl8255(dev, 0x4, 0x806);
	write_rtl8255(dev, 0x4, 0x406);
	write_rtl8255(dev, 0x3, 0x25);
	write_rtl8255(dev, 0x2, 0x26);
	write_rtl8255(dev, 0x4, 0x606);
	write_rtl8255(dev, 0x4, 0x406);
	write_rtl8255(dev, 0x4, 0x406);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x606);
	write_rtl8255(dev, 0x4, 0x406);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x804183af, 0x27,
		0x92402acc, 0xf0009, 0x28000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc07);
	write_rtl8255(dev, 0x4, 0xe07);
	write_rtl8255(dev, 0x4, 0xc07);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x807);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa07);
	write_rtl8255(dev, 0x4, 0x807);
	write_rtl8255(dev, 0x4, 0x407);
	write_rtl8255(dev, 0x3, 0x25);
	write_rtl8255(dev, 0x2, 0x26);
	write_rtl8255(dev, 0x4, 0x607);
	write_rtl8255(dev, 0x4, 0x407);
	write_rtl8255(dev, 0x4, 0x407);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x607);
	write_rtl8255(dev, 0x4, 0x407);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x804083d7, 0x40000027,
		0x92402ad0, 0xf0009, 0x28000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc08);
	write_rtl8255(dev, 0x4, 0xe08);
	write_rtl8255(dev, 0x4, 0xc08);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x808);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa08);
	write_rtl8255(dev, 0x4, 0x808);
	write_rtl8255(dev, 0x4, 0x408);
	write_rtl8255(dev, 0x3, 0x25);
	write_rtl8255(dev, 0x2, 0x26);
	write_rtl8255(dev, 0x4, 0x608);
	write_rtl8255(dev, 0x4, 0x408);
	write_rtl8255(dev, 0x4, 0x408);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x608);
	write_rtl8255(dev, 0x4, 0x408);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x804083c7, 0x27,
		0x92402ad0, 0xf0009, 0x28000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc09);
	write_rtl8255(dev, 0x4, 0xe09);
	write_rtl8255(dev, 0x4, 0xc09);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x809);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa09);
	write_rtl8255(dev, 0x4, 0x809);
	write_rtl8255(dev, 0x4, 0x409);
	write_rtl8255(dev, 0x3, 0x25);
	write_rtl8255(dev, 0x2, 0x26);
	write_rtl8255(dev, 0x4, 0x609);
	write_rtl8255(dev, 0x4, 0x409);
	write_rtl8255(dev, 0x4, 0x409);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x609);
	write_rtl8255(dev, 0x4, 0x409);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x804043d7, 0x40000027,
		0x92402ad4, 0xf0009, 0x28000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc0a);
	write_rtl8255(dev, 0x4, 0xe0a);
	write_rtl8255(dev, 0x4, 0xc0a);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x80a);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa0a);
	write_rtl8255(dev, 0x4, 0x80a);
	write_rtl8255(dev, 0x4, 0x40a);
	write_rtl8255(dev, 0x3, 0x25);
	write_rtl8255(dev, 0x2, 0x26);
	write_rtl8255(dev, 0x4, 0x60a);
	write_rtl8255(dev, 0x4, 0x40a);
	write_rtl8255(dev, 0x4, 0x40a);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x60a);
	write_rtl8255(dev, 0x4, 0x40a);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x804043d7, 0x40000027,
		0x92402ad4, 0xf0009, 0x28000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc0b);
	write_rtl8255(dev, 0x4, 0xe0b);
	write_rtl8255(dev, 0x4, 0xc0b);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x80b);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa0b);
	write_rtl8255(dev, 0x4, 0x80b);
	write_rtl8255(dev, 0x4, 0x40b);
	write_rtl8255(dev, 0x3, 0x25);
	write_rtl8255(dev, 0x2, 0x26);
	write_rtl8255(dev, 0x4, 0x60b);
	write_rtl8255(dev, 0x4, 0x40b);
	write_rtl8255(dev, 0x4, 0x40b);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x60b);
	write_rtl8255(dev, 0x4, 0x40b);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x804043c7, 0x27,
		0x92402ad8, 0xf0009, 0x28000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc0c);
	write_rtl8255(dev, 0x4, 0xe0c);
	write_rtl8255(dev, 0x4, 0xc0c);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x80c);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa0c);
	write_rtl8255(dev, 0x4, 0x80c);
	write_rtl8255(dev, 0x4, 0x40c);
	write_rtl8255(dev, 0x3, 0x25);
	write_rtl8255(dev, 0x2, 0x26);
	write_rtl8255(dev, 0x4, 0x60c);
	write_rtl8255(dev, 0x4, 0x40c);
	write_rtl8255(dev, 0x4, 0x40c);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x60c);
	write_rtl8255(dev, 0x4, 0x40c);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x804043a7, 0x27,
		0x92402ad8, 0xf0009, 0x28000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc0d);
	write_rtl8255(dev, 0x4, 0xe0d);
	write_rtl8255(dev, 0x4, 0xc0d);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x80d);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa0d);
	write_rtl8255(dev, 0x4, 0x80d);
	write_rtl8255(dev, 0x4, 0x40d);
	write_rtl8255(dev, 0x3, 0x25);
	write_rtl8255(dev, 0x2, 0x26);
	write_rtl8255(dev, 0x4, 0x60d);
	write_rtl8255(dev, 0x4, 0x40d);
	write_rtl8255(dev, 0x4, 0x40d);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x60d);
	write_rtl8255(dev, 0x4, 0x40d);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x80404387, 0x27,
		0x92402aa8, 0xf0009, 0x28000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc0e);
	write_rtl8255(dev, 0x4, 0xe0e);
	write_rtl8255(dev, 0x4, 0xc0e);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x80e);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa0e);
	write_rtl8255(dev, 0x4, 0x80e);
	write_rtl8255(dev, 0x4, 0x40e);
	write_rtl8255(dev, 0x3, 0x25);
	write_rtl8255(dev, 0x2, 0x26);
	write_rtl8255(dev, 0x4, 0x60e);
	write_rtl8255(dev, 0x4, 0x40e);
	write_rtl8255(dev, 0x4, 0x40e);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x60e);
	write_rtl8255(dev, 0x4, 0x40e);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x804041c7, 0x27,
		0x92402aa8, 0xf0009, 0x28000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc0f);
	write_rtl8255(dev, 0x4, 0xe0f);
	write_rtl8255(dev, 0x4, 0xc0f);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x80f);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa0f);
	write_rtl8255(dev, 0x4, 0x80f);
	write_rtl8255(dev, 0x4, 0x40f);
	write_rtl8255(dev, 0x3, 0x25);
	write_rtl8255(dev, 0x2, 0x26);
	write_rtl8255(dev, 0x4, 0x60f);
	write_rtl8255(dev, 0x4, 0x40f);
	write_rtl8255(dev, 0x4, 0x40f);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x60f);
	write_rtl8255(dev, 0x4, 0x40f);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x804041a7, 0x27,
		0x92402aac, 0xf0009, 0x28000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc10);
	write_rtl8255(dev, 0x4, 0xe10);
	write_rtl8255(dev, 0x4, 0xc10);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x810);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa10);
	write_rtl8255(dev, 0x4, 0x810);
	write_rtl8255(dev, 0x4, 0x410);
	write_rtl8255(dev, 0x3, 0x25);
	write_rtl8255(dev, 0x2, 0x26);
	write_rtl8255(dev, 0x4, 0x610);
	write_rtl8255(dev, 0x4, 0x410);
	write_rtl8255(dev, 0x4, 0x410);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x610);
	write_rtl8255(dev, 0x4, 0x410);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x80404187, 0x27,
		0x92402aac, 0xf0009, 0x28000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc11);
	write_rtl8255(dev, 0x4, 0xe11);
	write_rtl8255(dev, 0x4, 0xc11);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x811);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa11);
	write_rtl8255(dev, 0x4, 0x811);
	write_rtl8255(dev, 0x4, 0x411);
	write_rtl8255(dev, 0x3, 0x25);
	write_rtl8255(dev, 0x2, 0x26);
	write_rtl8255(dev, 0x4, 0x611);
	write_rtl8255(dev, 0x4, 0x411);
	write_rtl8255(dev, 0x4, 0x411);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x611);
	write_rtl8255(dev, 0x4, 0x411);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x80404186, 0x80000027,
		0x92402ab0, 0xf0009, 0x28000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc12);
	write_rtl8255(dev, 0x4, 0xe12);
	write_rtl8255(dev, 0x4, 0xc12);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x812);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa12);
	write_rtl8255(dev, 0x4, 0x812);
	write_rtl8255(dev, 0x4, 0x412);
	write_rtl8255(dev, 0x3, 0x25);
	write_rtl8255(dev, 0x2, 0x26);
	write_rtl8255(dev, 0x4, 0x612);
	write_rtl8255(dev, 0x4, 0x412);
	write_rtl8255(dev, 0x4, 0x412);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x612);
	write_rtl8255(dev, 0x4, 0x412);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x80404186, 0x27,
		0x92402ab0, 0xf0009, 0x28000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc13);
	write_rtl8255(dev, 0x4, 0xe13);
	write_rtl8255(dev, 0x4, 0xc13);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x813);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa13);
	write_rtl8255(dev, 0x4, 0x813);
	write_rtl8255(dev, 0x4, 0x413);
	write_rtl8255(dev, 0x3, 0x25);
	write_rtl8255(dev, 0x2, 0x26);
	write_rtl8255(dev, 0x4, 0x613);
	write_rtl8255(dev, 0x4, 0x413);
	write_rtl8255(dev, 0x4, 0x413);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x613);
	write_rtl8255(dev, 0x4, 0x413);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x80404146, 0x27,
		0x92402ab4, 0xf0009, 0x28000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc14);
	write_rtl8255(dev, 0x4, 0xe14);
	write_rtl8255(dev, 0x4, 0xc14);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x814);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa14);
	write_rtl8255(dev, 0x4, 0x814);
	write_rtl8255(dev, 0x4, 0x414);
	write_rtl8255(dev, 0x3, 0x25);
	write_rtl8255(dev, 0x2, 0x26);
	write_rtl8255(dev, 0x4, 0x614);
	write_rtl8255(dev, 0x4, 0x414);
	write_rtl8255(dev, 0x4, 0x414);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x614);
	write_rtl8255(dev, 0x4, 0x414);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x80404126, 0x27,
		0x92402ab4, 0xf0009, 0x28000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc15);
	write_rtl8255(dev, 0x4, 0xe15);
	write_rtl8255(dev, 0x4, 0xc15);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x815);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa15);
	write_rtl8255(dev, 0x4, 0x815);
	write_rtl8255(dev, 0x4, 0x415);
	write_rtl8255(dev, 0x3, 0x25);
	write_rtl8255(dev, 0x2, 0x26);
	write_rtl8255(dev, 0x4, 0x615);
	write_rtl8255(dev, 0x4, 0x415);
	write_rtl8255(dev, 0x4, 0x415);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x615);
	write_rtl8255(dev, 0x4, 0x415);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x80404106, 0x27,
		0x92402ab8, 0xf0009, 0x28000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc16);
	write_rtl8255(dev, 0x4, 0xe16);
	write_rtl8255(dev, 0x4, 0xc16);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x816);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa16);
	write_rtl8255(dev, 0x4, 0x816);
	write_rtl8255(dev, 0x4, 0x416);
	write_rtl8255(dev, 0x3, 0x25);
	write_rtl8255(dev, 0x2, 0x26);
	write_rtl8255(dev, 0x4, 0x616);
	write_rtl8255(dev, 0x4, 0x416);
	write_rtl8255(dev, 0x4, 0x416);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x616);
	write_rtl8255(dev, 0x4, 0x416);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x80404105, 0x27,
		0x92402ab8, 0xf0009, 0x28000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc17);
	write_rtl8255(dev, 0x4, 0xe17);
	write_rtl8255(dev, 0x4, 0xc17);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x817);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa17);
	write_rtl8255(dev, 0x4, 0x817);
	write_rtl8255(dev, 0x4, 0x417);
	write_rtl8255(dev, 0x3, 0x25);
	write_rtl8255(dev, 0x2, 0x26);
	write_rtl8255(dev, 0x4, 0x617);
	write_rtl8255(dev, 0x4, 0x417);
	write_rtl8255(dev, 0x4, 0x417);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x617);
	write_rtl8255(dev, 0x4, 0x417);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x80404104, 0x80000027,
		0x92402a88, 0xf0009, 0x28000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc18);
	write_rtl8255(dev, 0x4, 0xe18);
	write_rtl8255(dev, 0x4, 0xc18);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x818);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa18);
	write_rtl8255(dev, 0x4, 0x818);
	write_rtl8255(dev, 0x4, 0x418);
	write_rtl8255(dev, 0x3, 0x25);
	write_rtl8255(dev, 0x2, 0x26);
	write_rtl8255(dev, 0x4, 0x618);
	write_rtl8255(dev, 0x4, 0x418);
	write_rtl8255(dev, 0x4, 0x418);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x618);
	write_rtl8255(dev, 0x4, 0x418);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x80404104, 0x27,
		0x92402a88, 0xf0009, 0x28000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc19);
	write_rtl8255(dev, 0x4, 0xe19);
	write_rtl8255(dev, 0x4, 0xc19);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x819);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa19);
	write_rtl8255(dev, 0x4, 0x819);
	write_rtl8255(dev, 0x4, 0x419);
	write_rtl8255(dev, 0x3, 0x25);
	write_rtl8255(dev, 0x2, 0x26);
	write_rtl8255(dev, 0x4, 0x619);
	write_rtl8255(dev, 0x4, 0x419);
	write_rtl8255(dev, 0x4, 0x419);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x619);
	write_rtl8255(dev, 0x4, 0x419);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x80404044, 0x27,
		0x92402a8c, 0xf0009, 0x28000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc1a);
	write_rtl8255(dev, 0x4, 0xe1a);
	write_rtl8255(dev, 0x4, 0xc1a);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x81a);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa1a);
	write_rtl8255(dev, 0x4, 0x81a);
	write_rtl8255(dev, 0x4, 0x41a);
	write_rtl8255(dev, 0x3, 0x25);
	write_rtl8255(dev, 0x2, 0x26);
	write_rtl8255(dev, 0x4, 0x61a);
	write_rtl8255(dev, 0x4, 0x41a);
	write_rtl8255(dev, 0x4, 0x41a);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x61a);
	write_rtl8255(dev, 0x4, 0x41a);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x80404024, 0x27,
		0x92402a8c, 0xf0009, 0x28000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc1b);
	write_rtl8255(dev, 0x4, 0xe1b);
	write_rtl8255(dev, 0x4, 0xc1b);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x81b);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa1b);
	write_rtl8255(dev, 0x4, 0x81b);
	write_rtl8255(dev, 0x4, 0x41b);
	write_rtl8255(dev, 0x3, 0x25);
	write_rtl8255(dev, 0x2, 0x26);
	write_rtl8255(dev, 0x4, 0x61b);
	write_rtl8255(dev, 0x4, 0x41b);
	write_rtl8255(dev, 0x4, 0x41b);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x61b);
	write_rtl8255(dev, 0x4, 0x41b);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x80404004, 0x27,
		0x92402a90, 0xf0009, 0x28000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc1c);
	write_rtl8255(dev, 0x4, 0xe1c);
	write_rtl8255(dev, 0x4, 0xc1c);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x81c);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa1c);
	write_rtl8255(dev, 0x4, 0x81c);
	write_rtl8255(dev, 0x4, 0x41c);
	write_rtl8255(dev, 0x3, 0x25);
	write_rtl8255(dev, 0x2, 0x26);
	write_rtl8255(dev, 0x4, 0x61c);
	write_rtl8255(dev, 0x4, 0x41c);
	write_rtl8255(dev, 0x4, 0x41c);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x61c);
	write_rtl8255(dev, 0x4, 0x41c);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x80404001, 0x27,
		0x92402a90, 0xf0009, 0x28000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc1d);
	write_rtl8255(dev, 0x4, 0xe1d);
	write_rtl8255(dev, 0x4, 0xc1d);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x81d);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa1d);
	write_rtl8255(dev, 0x4, 0x81d);
	write_rtl8255(dev, 0x4, 0x41d);
	write_rtl8255(dev, 0x3, 0x25);
	write_rtl8255(dev, 0x2, 0x26);
	write_rtl8255(dev, 0x4, 0x61d);
	write_rtl8255(dev, 0x4, 0x41d);
	write_rtl8255(dev, 0x4, 0x41d);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x61d);
	write_rtl8255(dev, 0x4, 0x41d);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x80404000, 0x80000027,
		0x92402a94, 0xf0009, 0x28000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc1e);
	write_rtl8255(dev, 0x4, 0xe1e);
	write_rtl8255(dev, 0x4, 0xc1e);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x81e);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa1e);
	write_rtl8255(dev, 0x4, 0x81e);
	write_rtl8255(dev, 0x4, 0x41e);
	write_rtl8255(dev, 0x3, 0x25);
	write_rtl8255(dev, 0x2, 0x26);
	write_rtl8255(dev, 0x4, 0x61e);
	write_rtl8255(dev, 0x4, 0x41e);
	write_rtl8255(dev, 0x4, 0x41e);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x61e);
	write_rtl8255(dev, 0x4, 0x41e);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x80404000, 0x27,
		0x92402a94, 0xf0009, 0x28000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc1f);
	write_rtl8255(dev, 0x4, 0xe1f);
	write_rtl8255(dev, 0x4, 0xc1f);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x81f);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa1f);
	write_rtl8255(dev, 0x4, 0x81f);
	write_rtl8255(dev, 0x4, 0x41f);
	write_rtl8255(dev, 0x3, 0x25);
	write_rtl8255(dev, 0x2, 0x26);
	write_rtl8255(dev, 0x4, 0x61f);
	write_rtl8255(dev, 0x4, 0x41f);
	write_rtl8255(dev, 0x4, 0x41f);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x61f);
	write_rtl8255(dev, 0x4, 0x41f);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x80404020, 0x80000027,
		0x92402a98, 0xf8009, 0x28000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc20);
	write_rtl8255(dev, 0x4, 0xe20);
	write_rtl8255(dev, 0x4, 0xc20);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x820);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa20);
	write_rtl8255(dev, 0x4, 0x820);
	write_rtl8255(dev, 0x4, 0x420);
	write_rtl8255(dev, 0x3, 0x25);
	write_rtl8255(dev, 0x2, 0x26);
	write_rtl8255(dev, 0x4, 0x620);
	write_rtl8255(dev, 0x4, 0x420);
	write_rtl8255(dev, 0x4, 0x420);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x620);
	write_rtl8255(dev, 0x4, 0x420);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x80404020, 0x27,
		0x92402a98, 0xf8009, 0x28000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc21);
	write_rtl8255(dev, 0x4, 0xe21);
	write_rtl8255(dev, 0x4, 0xc21);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x821);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa21);
	write_rtl8255(dev, 0x4, 0x821);
	write_rtl8255(dev, 0x4, 0x421);
	write_rtl8255(dev, 0x3, 0x25);
	write_rtl8255(dev, 0x2, 0x26);
	write_rtl8255(dev, 0x4, 0x621);
	write_rtl8255(dev, 0x4, 0x421);
	write_rtl8255(dev, 0x4, 0x421);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x621);
	write_rtl8255(dev, 0x4, 0x421);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x80404000, 0x80000027,
		0x92402a68, 0xf0009, 0x10028000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc22);
	write_rtl8255(dev, 0x4, 0xe22);
	write_rtl8255(dev, 0x4, 0xc22);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x822);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa22);
	write_rtl8255(dev, 0x4, 0x822);
	write_rtl8255(dev, 0x4, 0x422);
	write_rtl8255(dev, 0x3, 0x25);
	write_rtl8255(dev, 0x2, 0x26);
	write_rtl8255(dev, 0x4, 0x622);
	write_rtl8255(dev, 0x4, 0x422);
	write_rtl8255(dev, 0x4, 0x422);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x622);
	write_rtl8255(dev, 0x4, 0x422);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x80404010, 0x80000027,
		0x92402a68, 0xf0009, 0x20028000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc23);
	write_rtl8255(dev, 0x4, 0xe23);
	write_rtl8255(dev, 0x4, 0xc23);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x823);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa23);
	write_rtl8255(dev, 0x4, 0x823);
	write_rtl8255(dev, 0x4, 0x423);
	write_rtl8255(dev, 0x3, 0x25);
	write_rtl8255(dev, 0x2, 0x26);
	write_rtl8255(dev, 0x4, 0x623);
	write_rtl8255(dev, 0x4, 0x423);
	write_rtl8255(dev, 0x4, 0x423);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x623);
	write_rtl8255(dev, 0x4, 0x423);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x80404010, 0x80000027,
		0x92402a6c, 0xf0009, 0x30028000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc24);
	write_rtl8255(dev, 0x4, 0xe24);
	write_rtl8255(dev, 0x4, 0xc24);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x824);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa24);
	write_rtl8255(dev, 0x4, 0x824);
	write_rtl8255(dev, 0x4, 0x424);
	write_rtl8255(dev, 0x3, 0x25);
	write_rtl8255(dev, 0x2, 0x26);
	write_rtl8255(dev, 0x4, 0x624);
	write_rtl8255(dev, 0x4, 0x424);
	write_rtl8255(dev, 0x4, 0x424);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x624);
	write_rtl8255(dev, 0x4, 0x424);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x80404010, 0x80000027,
		0x92402a6c, 0xf0009, 0x40028000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc25);
	write_rtl8255(dev, 0x4, 0xe25);
	write_rtl8255(dev, 0x4, 0xc25);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x825);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa25);
	write_rtl8255(dev, 0x4, 0x825);
	write_rtl8255(dev, 0x4, 0x425);
	write_rtl8255(dev, 0x3, 0x25);
	write_rtl8255(dev, 0x2, 0x26);
	write_rtl8255(dev, 0x4, 0x625);
	write_rtl8255(dev, 0x4, 0x425);
	write_rtl8255(dev, 0x4, 0x425);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x625);
	write_rtl8255(dev, 0x4, 0x425);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x80404000, 0x80000027,
		0x92402a70, 0xf0009, 0x60028000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc26);
	write_rtl8255(dev, 0x4, 0xe26);
	write_rtl8255(dev, 0x4, 0xc26);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x826);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa26);
	write_rtl8255(dev, 0x4, 0x826);
	write_rtl8255(dev, 0x4, 0x426);
	write_rtl8255(dev, 0x3, 0x25);
	write_rtl8255(dev, 0x2, 0x26);
	write_rtl8255(dev, 0x4, 0x626);
	write_rtl8255(dev, 0x4, 0x426);
	write_rtl8255(dev, 0x4, 0x426);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x626);
	write_rtl8255(dev, 0x4, 0x426);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x80404031, 0x40000027,
		0x92402a70, 0xf0011, 0x60028000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc27);
	write_rtl8255(dev, 0x4, 0xe27);
	write_rtl8255(dev, 0x4, 0xc27);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x827);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa27);
	write_rtl8255(dev, 0x4, 0x827);
	write_rtl8255(dev, 0x4, 0x427);
	write_rtl8255(dev, 0x3, 0x25);
	write_rtl8255(dev, 0x2, 0x26);
	write_rtl8255(dev, 0x4, 0x627);
	write_rtl8255(dev, 0x4, 0x427);
	write_rtl8255(dev, 0x4, 0x427);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x627);
	write_rtl8255(dev, 0x4, 0x427);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x80404011, 0x40000027,
		0x92402a74, 0xf0011, 0x60028000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc28);
	write_rtl8255(dev, 0x4, 0xe28);
	write_rtl8255(dev, 0x4, 0xc28);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x828);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa28);
	write_rtl8255(dev, 0x4, 0x828);
	write_rtl8255(dev, 0x4, 0x428);
	write_rtl8255(dev, 0x3, 0x25);
	write_rtl8255(dev, 0x2, 0x26);
	write_rtl8255(dev, 0x4, 0x628);
	write_rtl8255(dev, 0x4, 0x428);
	write_rtl8255(dev, 0x4, 0x428);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x628);
	write_rtl8255(dev, 0x4, 0x428);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x80404010, 0xc0000027,
		0x92402a74, 0xf0011, 0x60028000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc29);
	write_rtl8255(dev, 0x4, 0xe29);
	write_rtl8255(dev, 0x4, 0xc29);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x829);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa29);
	write_rtl8255(dev, 0x4, 0x829);
	write_rtl8255(dev, 0x4, 0x429);
	write_rtl8255(dev, 0x3, 0x25);
	write_rtl8255(dev, 0x2, 0x26);
	write_rtl8255(dev, 0x4, 0x629);
	write_rtl8255(dev, 0x4, 0x429);
	write_rtl8255(dev, 0x4, 0x429);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x629);
	write_rtl8255(dev, 0x4, 0x429);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x80404000, 0x80000027,
		0x92402a78, 0xf0011, 0x60028000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc2a);
	write_rtl8255(dev, 0x4, 0xe2a);
	write_rtl8255(dev, 0x4, 0xc2a);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x82a);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa2a);
	write_rtl8255(dev, 0x4, 0x82a);
	write_rtl8255(dev, 0x4, 0x42a);
	write_rtl8255(dev, 0x3, 0x24);
	write_rtl8255(dev, 0x2, 0x26);
	write_rtl8255(dev, 0x4, 0x62a);
	write_rtl8255(dev, 0x4, 0x42a);
	write_rtl8255(dev, 0x4, 0x42a);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x62a);
	write_rtl8255(dev, 0x4, 0x42a);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x80404000, 0x80000027,
		0x92402a78, 0xf0011, 0x70028000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc2b);
	write_rtl8255(dev, 0x4, 0xe2b);
	write_rtl8255(dev, 0x4, 0xc2b);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x82b);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa2b);
	write_rtl8255(dev, 0x4, 0x82b);
	write_rtl8255(dev, 0x4, 0x42b);
	write_rtl8255(dev, 0x3, 0x24);
	write_rtl8255(dev, 0x2, 0x26);
	write_rtl8255(dev, 0x4, 0x62b);
	write_rtl8255(dev, 0x4, 0x42b);
	write_rtl8255(dev, 0x4, 0x42b);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x62b);
	write_rtl8255(dev, 0x4, 0x42b);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x80404000, 0x80000027,
		0x92402a48, 0xf0019, 0x70028000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc2c);
	write_rtl8255(dev, 0x4, 0xe2c);
	write_rtl8255(dev, 0x4, 0xc2c);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x82c);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa2c);
	write_rtl8255(dev, 0x4, 0x82c);
	write_rtl8255(dev, 0x4, 0x42c);
	write_rtl8255(dev, 0x3, 0x24);
	write_rtl8255(dev, 0x2, 0x26);
	write_rtl8255(dev, 0x4, 0x62c);
	write_rtl8255(dev, 0x4, 0x42c);
	write_rtl8255(dev, 0x4, 0x42c);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x62c);
	write_rtl8255(dev, 0x4, 0x42c);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x80404000, 0x80000027,
		0x92402a48, 0xf8019, 0x70028000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc2d);
	write_rtl8255(dev, 0x4, 0xe2d);
	write_rtl8255(dev, 0x4, 0xc2d);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x82d);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa2d);
	write_rtl8255(dev, 0x4, 0x82d);
	write_rtl8255(dev, 0x4, 0x42d);
	write_rtl8255(dev, 0x3, 0x24);
	write_rtl8255(dev, 0x2, 0x26);
	write_rtl8255(dev, 0x4, 0x62d);
	write_rtl8255(dev, 0x4, 0x42d);
	write_rtl8255(dev, 0x4, 0x42d);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x62d);
	write_rtl8255(dev, 0x4, 0x42d);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x80404000, 0x80000027,
		0x92402a4c, 0xf8019, 0x70028000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc2e);
	write_rtl8255(dev, 0x4, 0xe2e);
	write_rtl8255(dev, 0x4, 0xc2e);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x82e);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa2e);
	write_rtl8255(dev, 0x4, 0x82e);
	write_rtl8255(dev, 0x4, 0x42e);
	write_rtl8255(dev, 0x3, 0x24);
	write_rtl8255(dev, 0x2, 0x26);
	write_rtl8255(dev, 0x4, 0x62e);
	write_rtl8255(dev, 0x4, 0x42e);
	write_rtl8255(dev, 0x4, 0x42e);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x62e);
	write_rtl8255(dev, 0x4, 0x42e);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x80404000, 0x80000027,
		0x92402a4c, 0xf8019, 0x70028000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc2f);
	write_rtl8255(dev, 0x4, 0xe2f);
	write_rtl8255(dev, 0x4, 0xc2f);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x82f);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa2f);
	write_rtl8255(dev, 0x4, 0x82f);
	write_rtl8255(dev, 0x4, 0x42f);
	write_rtl8255(dev, 0x3, 0x24);
	write_rtl8255(dev, 0x2, 0x26);
	write_rtl8255(dev, 0x4, 0x62f);
	write_rtl8255(dev, 0x4, 0x42f);
	write_rtl8255(dev, 0x4, 0x42f);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x62f);
	write_rtl8255(dev, 0x4, 0x42f);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x80404000, 0x80000027,
		0x92402a50, 0xf8019, 0x70028000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc30);
	write_rtl8255(dev, 0x4, 0xe30);
	write_rtl8255(dev, 0x4, 0xc30);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x830);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa30);
	write_rtl8255(dev, 0x4, 0x830);
	write_rtl8255(dev, 0x4, 0x430);
	write_rtl8255(dev, 0x3, 0x24);
	write_rtl8255(dev, 0x2, 0x26);
	write_rtl8255(dev, 0x4, 0x630);
	write_rtl8255(dev, 0x4, 0x430);
	write_rtl8255(dev, 0x4, 0x430);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x630);
	write_rtl8255(dev, 0x4, 0x430);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x80404000, 0x80000027,
		0x92402a50, 0xf8019, 0x70028000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc31);
	write_rtl8255(dev, 0x4, 0xe31);
	write_rtl8255(dev, 0x4, 0xc31);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x831);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa31);
	write_rtl8255(dev, 0x4, 0x831);
	write_rtl8255(dev, 0x4, 0x431);
	write_rtl8255(dev, 0x3, 0x24);
	write_rtl8255(dev, 0x2, 0x26);
	write_rtl8255(dev, 0x4, 0x631);
	write_rtl8255(dev, 0x4, 0x431);
	write_rtl8255(dev, 0x4, 0x431);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x631);
	write_rtl8255(dev, 0x4, 0x431);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x80404000, 0x80000027,
		0x92402a54, 0xf8019, 0x70028000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc32);
	write_rtl8255(dev, 0x4, 0xe32);
	write_rtl8255(dev, 0x4, 0xc32);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x832);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa32);
	write_rtl8255(dev, 0x4, 0x832);
	write_rtl8255(dev, 0x4, 0x432);
	write_rtl8255(dev, 0x3, 0x24);
	write_rtl8255(dev, 0x2, 0x26);
	write_rtl8255(dev, 0x4, 0x632);
	write_rtl8255(dev, 0x4, 0x432);
	write_rtl8255(dev, 0x4, 0x432);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x632);
	write_rtl8255(dev, 0x4, 0x432);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x80404000, 0x80000027,
		0x92402a54, 0xf8019, 0x70028000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc33);
	write_rtl8255(dev, 0x4, 0xe33);
	write_rtl8255(dev, 0x4, 0xc33);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x833);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa33);
	write_rtl8255(dev, 0x4, 0x833);
	write_rtl8255(dev, 0x4, 0x433);
	write_rtl8255(dev, 0x3, 0x24);
	write_rtl8255(dev, 0x2, 0x26);
	write_rtl8255(dev, 0x4, 0x633);
	write_rtl8255(dev, 0x4, 0x433);
	write_rtl8255(dev, 0x4, 0x433);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x633);
	write_rtl8255(dev, 0x4, 0x433);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x80404000, 0x80000027,
		0x92402a58, 0xf8019, 0x70028000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc34);
	write_rtl8255(dev, 0x4, 0xe34);
	write_rtl8255(dev, 0x4, 0xc34);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x834);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa34);
	write_rtl8255(dev, 0x4, 0x834);
	write_rtl8255(dev, 0x4, 0x434);
	write_rtl8255(dev, 0x3, 0x24);
	write_rtl8255(dev, 0x2, 0x26);
	write_rtl8255(dev, 0x4, 0x634);
	write_rtl8255(dev, 0x4, 0x434);
	write_rtl8255(dev, 0x4, 0x434);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x634);
	write_rtl8255(dev, 0x4, 0x434);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x80404000, 0x80000027,
		0x92402a58, 0xf8019, 0x70028000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc35);
	write_rtl8255(dev, 0x4, 0xe35);
	write_rtl8255(dev, 0x4, 0xc35);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x835);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa35);
	write_rtl8255(dev, 0x4, 0x835);
	write_rtl8255(dev, 0x4, 0x435);
	write_rtl8255(dev, 0x3, 0x24);
	write_rtl8255(dev, 0x2, 0x26);
	write_rtl8255(dev, 0x4, 0x635);
	write_rtl8255(dev, 0x4, 0x435);
	write_rtl8255(dev, 0x4, 0x435);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x635);
	write_rtl8255(dev, 0x4, 0x435);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x80404000, 0x80000027,
		0x92402a24, 0xf8019, 0x70028000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc36);
	write_rtl8255(dev, 0x4, 0xe36);
	write_rtl8255(dev, 0x4, 0xc36);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x836);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa36);
	write_rtl8255(dev, 0x4, 0x836);
	write_rtl8255(dev, 0x4, 0x436);
	write_rtl8255(dev, 0x3, 0x24);
	write_rtl8255(dev, 0x2, 0x25);
	write_rtl8255(dev, 0x4, 0x636);
	write_rtl8255(dev, 0x4, 0x436);
	write_rtl8255(dev, 0x4, 0x436);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x636);
	write_rtl8255(dev, 0x4, 0x436);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x80404000, 0x80000027,
		0x92402a24, 0xf8019, 0x70028000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc37);
	write_rtl8255(dev, 0x4, 0xe37);
	write_rtl8255(dev, 0x4, 0xc37);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x837);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa37);
	write_rtl8255(dev, 0x4, 0x837);
	write_rtl8255(dev, 0x4, 0x437);
	write_rtl8255(dev, 0x3, 0x24);
	write_rtl8255(dev, 0x2, 0x25);
	write_rtl8255(dev, 0x4, 0x637);
	write_rtl8255(dev, 0x4, 0x437);
	write_rtl8255(dev, 0x4, 0x437);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x637);
	write_rtl8255(dev, 0x4, 0x437);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x80404000, 0x80000027,
		0x92402a28, 0xf8019, 0x70028000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc38);
	write_rtl8255(dev, 0x4, 0xe38);
	write_rtl8255(dev, 0x4, 0xc38);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x838);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa38);
	write_rtl8255(dev, 0x4, 0x838);
	write_rtl8255(dev, 0x4, 0x438);
	write_rtl8255(dev, 0x3, 0x24);
	write_rtl8255(dev, 0x2, 0x25);
	write_rtl8255(dev, 0x4, 0x638);
	write_rtl8255(dev, 0x4, 0x438);
	write_rtl8255(dev, 0x4, 0x438);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x638);
	write_rtl8255(dev, 0x4, 0x438);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x80404000, 0x80000027,
		0x92402a28, 0xf8019, 0x70028000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc39);
	write_rtl8255(dev, 0x4, 0xe39);
	write_rtl8255(dev, 0x4, 0xc39);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x839);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa39);
	write_rtl8255(dev, 0x4, 0x839);
	write_rtl8255(dev, 0x4, 0x439);
	write_rtl8255(dev, 0x3, 0x24);
	write_rtl8255(dev, 0x2, 0x25);
	write_rtl8255(dev, 0x4, 0x639);
	write_rtl8255(dev, 0x4, 0x439);
	write_rtl8255(dev, 0x4, 0x439);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x639);
	write_rtl8255(dev, 0x4, 0x439);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x80404000, 0x80000027,
		0x92402a00, 0xf8019, 0x70028000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc3a);
	write_rtl8255(dev, 0x4, 0xe3a);
	write_rtl8255(dev, 0x4, 0xc3a);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x83a);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa3a);
	write_rtl8255(dev, 0x4, 0x83a);
	write_rtl8255(dev, 0x4, 0x43a);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0x63a);
	write_rtl8255(dev, 0x4, 0x43a);
	write_rtl8255(dev, 0x4, 0x43a);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x63a);
	write_rtl8255(dev, 0x4, 0x43a);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x80404000, 0x80000027,
		0x92402a00, 0xf8019, 0x70028000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc3b);
	write_rtl8255(dev, 0x4, 0xe3b);
	write_rtl8255(dev, 0x4, 0xc3b);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x83b);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa3b);
	write_rtl8255(dev, 0x4, 0x83b);
	write_rtl8255(dev, 0x4, 0x43b);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0x63b);
	write_rtl8255(dev, 0x4, 0x43b);
	write_rtl8255(dev, 0x4, 0x43b);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x63b);
	write_rtl8255(dev, 0x4, 0x43b);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x80404000, 0x80000027,
		0x92402a00, 0xf8019, 0x70028000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc3c);
	write_rtl8255(dev, 0x4, 0xe3c);
	write_rtl8255(dev, 0x4, 0xc3c);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x83c);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa3c);
	write_rtl8255(dev, 0x4, 0x83c);
	write_rtl8255(dev, 0x4, 0x43c);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0x63c);
	write_rtl8255(dev, 0x4, 0x43c);
	write_rtl8255(dev, 0x4, 0x43c);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x63c);
	write_rtl8255(dev, 0x4, 0x43c);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x80404000, 0x80000027,
		0x92402a00, 0xf8019, 0x70028000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc3d);
	write_rtl8255(dev, 0x4, 0xe3d);
	write_rtl8255(dev, 0x4, 0xc3d);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x83d);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa3d);
	write_rtl8255(dev, 0x4, 0x83d);
	write_rtl8255(dev, 0x4, 0x43d);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0x63d);
	write_rtl8255(dev, 0x4, 0x43d);
	write_rtl8255(dev, 0x4, 0x43d);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x63d);
	write_rtl8255(dev, 0x4, 0x43d);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x80404000, 0x80000027,
		0x92402a00, 0xf8019, 0x70028000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc3e);
	write_rtl8255(dev, 0x4, 0xe3e);
	write_rtl8255(dev, 0x4, 0xc3e);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x83e);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa3e);
	write_rtl8255(dev, 0x4, 0x83e);
	write_rtl8255(dev, 0x4, 0x43e);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0x63e);
	write_rtl8255(dev, 0x4, 0x43e);
	write_rtl8255(dev, 0x4, 0x43e);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x63e);
	write_rtl8255(dev, 0x4, 0x43e);
	write_rtl8255_reg0c(dev, 0x1554, 0xa800403b, 0xf6d44278, 0x80404000, 0x80000027,
		0x92402a00, 0xf8011, 0x70028000, 0xc00, 0x0);
	write_rtl8255(dev, 0x1, 0x807);
	write_rtl8255(dev, 0x4, 0xc3f);
	write_rtl8255(dev, 0x4, 0xe3f);
	write_rtl8255(dev, 0x4, 0xc3f);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255(dev, 0x4, 0x83f);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0xa3f);
	write_rtl8255(dev, 0x4, 0x83f);
	write_rtl8255(dev, 0x4, 0x43f);
	write_rtl8255(dev, 0x3, 0x0);
	write_rtl8255(dev, 0x2, 0x0);
	write_rtl8255(dev, 0x4, 0x63f);
	write_rtl8255(dev, 0x4, 0x43f);
	write_rtl8255(dev, 0x4, 0x43f);
	write_rtl8255(dev, 0x3, 0x100);
	write_rtl8255(dev, 0x4, 0x63f);
	write_rtl8255(dev, 0x4, 0x43f);
	write_rtl8255(dev, 0x4, 0x0);
	write_rtl8255(dev, 0x1, 0x0);
	write_rtl8255_reg0c(dev, 0x3539, 0x70000c03, 0xfef46178, 0x408000, 0x403307,
		0x924f80c0, 0xf955c, 0x8400, 0x429200, 0x1ce20);
	write_rtl8255(dev, 0x1, 0x1c7);
	write_rtl8255(dev, 0x2, 0x26);
	write_rtl8255(dev, 0x3, 0x27);
	write_rtl8255(dev, 0x1, 0x47);
	write_rtl8255(dev, 0x4, 0x98c);
	write_rtl8255(dev, 0x5, 0x65);
	write_rtl8255(dev, 0x6, 0x13);
	write_rtl8255(dev, 0x7, 0x7c);
	write_rtl8255(dev, 0x8, 0x6);
	write_rtl8255(dev, 0x8, 0x7);
	write_rtl8255(dev, 0x8, 0x6);
	write_rtl8255(dev, 0x9, 0xce2);
	write_rtl8255(dev, 0xb, 0x1c5);
	write_rtl8255(dev, 0xd, 0xd7f);
	write_rtl8255(dev, 0xe, 0x369);
	write_rtl8255(dev, 0xa, 0xd56);
	write_rtl8255(dev, 0xa, 0xd57);
	mdelay(20);
	write_rtl8255(dev, 0xd, 0xd7e);
	
}


void rtl8255_set_band_param(struct net_device *dev, short band)
{
	if(band != BAND_A){
		write_nic_dword(dev, 0x94, 0x3dc00002);
		write_nic_dword(dev, 0x88, 0x00100040);
		
		write_phy_cck(dev, 0x13, 0xd0);
		
		write_phy_cck(dev, 0x41, 0x9d);
		write_nic_dword(dev, 0x8c, 0x00082205);
		write_nic_byte(dev, 0xb4, 0x66);
	}
}

void rtl8255_rf_init(struct net_device *dev) 
{
	struct r8180_priv *priv = ieee80211_priv(dev);
	int i;
	u16 brsr;
//	short channel /*= priv->chan*/ = 1;
	priv->chan = 1;
	
	write_nic_word(dev, RFPinsOutput, 0x80);
	write_nic_word(dev, RFPinsSelect, 0x80 | SW_CONTROL_GPIO);
	write_nic_word(dev, RFPinsEnable, 0x80);
	write_nic_word(dev, RFPinsSelect, SW_CONTROL_GPIO);
	
	write_nic_dword(dev, RF_TIMING, 0x000f800f);
	
	brsr = read_nic_word(dev, BRSR);
	
	write_nic_word(dev, 0x2c, 0xffff);
	
	
	rtl8180_set_anaparam(dev, RTL8255_ANAPARAM_ON); 
	rtl8185_set_anaparam2(dev, RTL8255_ANAPARAM2_ON);
	
	write_nic_dword(dev, 0x94, 0x11c00002);
	
	write_nic_dword(dev, RF_PARA, 0x100040);
	
	rtl8185_rf_pins_enable(dev);
	
	rtl8255_init_BGband(dev);
	rtl8255_set_band_param(dev,BAND_BG);
	
	write_phy_cck(dev, 0x0, 0x98);
	write_phy_cck(dev, 0x3, 0x20);
	write_phy_cck(dev, 0x4, 0x2e);
	write_phy_cck(dev, 0x5, 0x12);
	write_phy_cck(dev, 0x6, 0xfc);
	write_phy_cck(dev, 0x7, 0xd8);
	write_phy_cck(dev, 0x8, 0x2e);
	write_phy_cck(dev, 0x10, 0xd3);
	write_phy_cck(dev, 0x11, 0x88);
	write_phy_cck(dev, 0x12, 0x47);
	write_phy_cck(dev, 0x13, 0xd0); /* Ver C & D & 8187*/
		
	write_phy_cck(dev, 0x19, 0x0);
	write_phy_cck(dev, 0x1a, 0xa0);
	write_phy_cck(dev, 0x1b, 0x8);
	write_phy_cck(dev, 0x40, 0x86); /* CCK Carrier Sense Threshold */
	write_phy_cck(dev, 0x41, 0x9d); /* Energy Threshold */
	//write_phy_cck(dev, 0x42, 0x0);
	write_phy_cck(dev, 0x43, 0x8);
	
	write_nic_byte(dev, TESTR,0x8);
	
	for(i=0;i<128;i++){
		write_phy_ofdm(dev, 0x4b, rtl8255_agc[i]);
		write_phy_ofdm(dev, 0x4a, (u8)i+ 0x80);
	}
	
	
	write_phy_ofdm(dev, 0x0, 0x1);
	write_phy_ofdm(dev, 0x1, 0x2);
	write_phy_ofdm(dev, 0x2, 0x43);
	write_phy_ofdm(dev, 0x3, 0x0);
	write_phy_ofdm(dev, 0x4, 0x0);
	write_phy_ofdm(dev, 0x5, 0x0);
	write_phy_ofdm(dev, 0x6, 0x40);
	write_phy_ofdm(dev, 0x7, 0x0);
	write_phy_ofdm(dev, 0x8, 0x40);
	write_phy_ofdm(dev, 0x9, 0xfe);
	write_phy_ofdm(dev, 0xa, 0x9);
	write_phy_ofdm(dev, 0xb, 0x80);
	write_phy_ofdm(dev, 0xc, 0x1);
	write_phy_ofdm(dev, 0xd, 0x43);
	write_phy_ofdm(dev, 0xe, 0xd3); 
	write_phy_ofdm(dev, 0xf, 0x38);
	write_phy_ofdm(dev, 0x10, 0x4);
	write_phy_ofdm(dev, 0x11, 0x06);/*agc resp time 700*/
	write_phy_ofdm(dev, 0x12, 0x20);
	write_phy_ofdm(dev, 0x13, 0x20);
	write_phy_ofdm(dev, 0x14, 0x0);
	write_phy_ofdm(dev, 0x15, 0x40);
	write_phy_ofdm(dev, 0x16, 0x0);
	write_phy_ofdm(dev, 0x17, 0x40);
	write_phy_ofdm(dev, 0x18, 0xef);
	write_phy_ofdm(dev, 0x19, 0x25);
	write_phy_ofdm(dev, 0x1a, 0x20);
	write_phy_ofdm(dev, 0x1b, 0x7a);
	write_phy_ofdm(dev, 0x1c, 0x84);
	write_phy_ofdm(dev, 0x1e, 0x95);
	write_phy_ofdm(dev, 0x1f, 0x75);
	write_phy_ofdm(dev, 0x20, 0x1f);
	write_phy_ofdm(dev, 0x21, 0x17);
	write_phy_ofdm(dev, 0x22, 0x16);
	write_phy_ofdm(dev, 0x23, 0x70); //FIXME maybe not needed
	write_phy_ofdm(dev, 0x24, 0x70);
	write_phy_ofdm(dev, 0x25, 0x0);
	write_phy_ofdm(dev, 0x26, 0x10);
	write_phy_ofdm(dev, 0x27, 0x88); 
	
	
	write_nic_dword(dev, 0x94, 0x3dc00002); //BAND DEPEND.
//	write_nic_dword(dev, 0x94, 0x15c00002); //BAND DEPEND.
	
	write_phy_cck(dev, 0x4, 0x18);
	write_phy_cck(dev, 0x43, 0x18);
	write_phy_cck(dev, 0x6, 0xdc);
	write_phy_cck(dev, 0x44, 0x2b);
	write_phy_cck(dev, 0x45, 0x2b);
	write_phy_cck(dev, 0x46, 0x25);
	write_phy_cck(dev, 0x47, 0x15);
	write_phy_cck(dev, 0x48, 0x0);
	write_phy_cck(dev, 0x49, 0x0);
	write_phy_cck(dev, 0x4a, 0x0);
	write_phy_cck(dev, 0x4b, 0x0);
//	write_phy_cck(dev, 0x4c, 0x5);
#if 0
	write_phy_cck(dev, 0x41, 0x9d); /* Energy Threshold */
	// TESTR 0xb 8187
	write_phy_cck(dev, 0x10, 0x93);// & 0xfb);
#endif
	//rtl8255_set_gain(dev, 1); /* FIXME this '1' is random */

	rtl8255_SetTXPowerLevel(dev, priv->chan);
	
	write_phy_cck(dev, 0x10, 0x93 |0x4); /* Rx ant B, 0xd3 for A */
	write_phy_ofdm(dev, 0x26, 0x90); /* Rx ant B, 0x10 for A */
	
	rtl8185_tx_antenna(dev, 0x3); /* TX ant B, 0x0 for A*/
	/* make sure is waken up! */
	rtl8180_set_anaparam(dev, RTL8255_ANAPARAM_ON); 
	rtl8185_set_anaparam2(dev, RTL8255_ANAPARAM2_ON);
	
	rtl8255_set_band_param(dev,BAND_BG);
	
	write_phy_cck(dev, 0x41, 0x9d);
	
	rtl8255_set_gain(dev, 4);
	//rtl8255_set_energy_threshold(dev);
	write_phy_cck(dev, 0x41, 0x9d);
	rtl8255_rf_set_chan(dev, priv->chan);
	
	write_nic_word(dev, BRSR, brsr);
}

