/*
 * Copyright (C) 2007 Junjiro Okajima
 *
 * This program, aufs is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/* $Id: sysaufs.h,v 1.12 2007/11/26 01:34:33 sfjro Exp $ */

#ifndef __SYSAUFS_H__
#define __SYSAUFS_H__

#ifdef __KERNEL__

#include <linux/seq_file.h>
#include <linux/version.h>

/* ---------------------------------------------------------------------- */

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2, 6, 24)
static inline struct kset *subsys_get(struct kset *s)
{
	return kset_get(s);
}

static inline void subsys_put(struct kset *s)
{
	kset_put(s);
}
#endif

/* ---------------------------------------------------------------------- */

/* arguments for an entry under sysfs */
struct sysaufs_args {
	int index;
	struct mutex *mtx; /* template for sysaufs_read */
	struct super_block *sb;
};

typedef int (*sysaufs_op)(struct seq_file *seq, struct sysaufs_args *args,
			  int *do_size);

/* an entry under sysfs */
struct sysaufs_entry {
	struct bin_attribute attr;
	int allocated;	/* zero and minus means pages, otherwise bytes */
	int err;
	sysaufs_op *ops;
};

/* ---------------------------------------------------------------------- */

struct aufs_sbinfo;
typedef void (*each_sb_cb_t)(struct super_block *sb);

#ifdef CONFIG_AUFS_SYSAUFS
void sysaufs_add(struct aufs_sbinfo *sbinfo);
void sysaufs_del(struct aufs_sbinfo *sbinfo);
int __init sysaufs_init(void);
void sysaufs_fin(void);
void sysaufs_notify_remount(void);

void au_each_sb(each_sb_cb_t cb, int do_lock);

#else

static inline void sysaufs_add(struct aufs_sbinfo *sbinfo)
{
	/* nothing */
}

static inline void sysaufs_del(struct aufs_sbinfo *sbinfo)
{
	/* nothing */
}

#define sysaufs_init()			0
#define sysaufs_fin()			do {} while (0)
#define sysaufs_notify_remount()	do {} while (0)

static inline void au_each_sb(each_sb_cb_t cb, int do_lock)
{
	/* empty */
}
#endif /* CONFIG_AUFS_SYSAUFS */

#endif /* __KERNEL__ */
#endif /* __SYSAUFS_H__ */
