/* **********************************************************
 * Copyright 1998 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/



#ifndef _INITBLOCK_H
#define _INITBLOCK_H

#define INCLUDE_ALLOW_VMX
#define INCLUDE_ALLOW_VMCORE
#define INCLUDE_ALLOW_VMMON
#include "includeCheck.h"


#define MAX_LOGFILE_NAME_LENGTH 256
#define MAX_MONITOR_REGIONS     8
#define MAX_INITBLOCK_CPUS      32
#define INIT_BLOCK_MAGIC     (0x1789+13)

#ifdef _WIN32
#define __attribute__(_x)     // NOP
#include <PSHPACK1.H> // 1-byte packing alignment
#endif


typedef struct InitBlock {
   uint32 magicNumber;     /* Magic number (INIT_BLOCK_MAGIC) */
#ifdef _WIN32
   int    usercallHandle;
#endif
   Vcpuid numVCPUs;
   VA32   crosspage[MAX_INITBLOCK_CPUS];
   uint32 vmInitFailurePeriod;
} __attribute__ ((packed)) InitBlock;


#ifdef WIN32
#include <POPPACK.H>
#endif


/*
 * Option flags 
 */
/* None yet */

#endif
