/*
 * IRAM
 */
#define MX31_IRAM_BASE_ADDR		0x1FFC0000	/* internal ram */
#define MX31_IRAM_SIZE			SZ_16K
#define MX31_IRAM_BASE_ADDR_VIRT	0xFC340000

#define USB_IRAM_BASE_ADDR		(MX31_IRAM_BASE_ADDR)
#ifdef CONFIG_USB_STATIC_IRAM
#define USB_IRAM_SIZE   (2*SZ_8K)
#else
#define USB_IRAM_SIZE 0
#endif

#define OTG_BASE_ADDR		(AIPS1_BASE_ADDR + 0x00088000)
#define ATA_BASE_ADDR		(AIPS1_BASE_ADDR + 0x0008C000)
#define UART4_BASE_ADDR 	(AIPS1_BASE_ADDR + 0x000B0000)
#define UART5_BASE_ADDR 	(AIPS1_BASE_ADDR + 0x000B4000)

#define MMC_SDHC1_BASE_ADDR	(SPBA0_BASE_ADDR + 0x00004000)
#define MMC_SDHC2_BASE_ADDR	(SPBA0_BASE_ADDR + 0x00008000)
#define SIM1_BASE_ADDR		(SPBA0_BASE_ADDR + 0x00018000)
#define IIM_BASE_ADDR		(SPBA0_BASE_ADDR + 0x0001C000)

/*!
 * defines for SPBA modules
 */
#define SPBA_SDHC1	0x04
#define SPBA_SDHC2	0x08
#define SPBA_SIM	0x18
#define SPBA_IIM	0x1C

#define CSPI3_BASE_ADDR		(AIPS2_BASE_ADDR + 0x00084000)
#define FIRI_BASE_ADDR		(AIPS2_BASE_ADDR + 0x0008C000)
#define SCM_BASE_ADDR		(AIPS2_BASE_ADDR + 0x000AE000)
#define SMN_BASE_ADDR		(AIPS2_BASE_ADDR + 0x000AF000)
#define MPEG4_ENC_BASE_ADDR	(AIPS2_BASE_ADDR + 0x000C8000)
#define VPU_BASE_ADDR		MPEG4_ENC_BASE_ADDR

#define MX31_NFC_BASE_ADDR	(X_MEMC_BASE_ADDR + 0x0000)
#define NFC_BASE_ADDR		(X_MEMC_BASE_ADDR + 0x0000)
#define NFC_SIZE		0x1000
#define NFC_IO_ADDRESS(x)	0

/*
 * VL2CC for i.MX32
 */
#define VL2CC_BASE_ADDR		0xE0000000

/*!
 * Defines for modules using static and dynamic DMA channels
 */

#ifdef CONFIG_SDMA_IRAM
#define MXC_DMA_CHANNEL_IRAM         30
#endif				/*CONFIG_SDMA_IRAM */

#define MXC_DMA_CHANNEL_UART1_RX  MXC_DMA_DYNAMIC_CHANNEL
#define MXC_DMA_CHANNEL_UART1_TX  MXC_DMA_DYNAMIC_CHANNEL
#define MXC_DMA_CHANNEL_UART2_RX  MXC_DMA_DYNAMIC_CHANNEL
#define MXC_DMA_CHANNEL_UART2_TX  MXC_DMA_DYNAMIC_CHANNEL
#define MXC_DMA_CHANNEL_UART3_RX  MXC_DMA_DYNAMIC_CHANNEL
#define MXC_DMA_CHANNEL_UART3_TX  MXC_DMA_DYNAMIC_CHANNEL
#define MXC_DMA_CHANNEL_UART4_RX  MXC_DMA_DYNAMIC_CHANNEL
#define MXC_DMA_CHANNEL_UART4_TX  MXC_DMA_DYNAMIC_CHANNEL
#define MXC_DMA_CHANNEL_UART5_RX  MXC_DMA_DYNAMIC_CHANNEL
#define MXC_DMA_CHANNEL_UART5_TX  MXC_DMA_DYNAMIC_CHANNEL
#define MXC_DMA_CHANNEL_MMC1  MXC_DMA_DYNAMIC_CHANNEL
#define MXC_DMA_CHANNEL_MMC2  MXC_DMA_DYNAMIC_CHANNEL
#define MXC_DMA_CHANNEL_SSI1_TX  MXC_DMA_DYNAMIC_CHANNEL
#define MXC_DMA_CHANNEL_SSI1_RX  MXC_DMA_DYNAMIC_CHANNEL
#define MXC_DMA_CHANNEL_SSI2_RX  MXC_DMA_DYNAMIC_CHANNEL

#ifdef CONFIG_SDMA_IRAM
#define MXC_DMA_CHANNEL_SSI2_TX  (MXC_DMA_CHANNEL_IRAM + 1)
#else				/*CONFIG_SDMA_IRAM */
#define MXC_DMA_CHANNEL_SSI2_TX  MXC_DMA_DYNAMIC_CHANNEL
#endif				/*CONFIG_SDMA_IRAM */

#define MXC_DMA_CHANNEL_FIR_RX  MXC_DMA_DYNAMIC_CHANNEL
#define MXC_DMA_CHANNEL_FIR_TX  MXC_DMA_DYNAMIC_CHANNEL
#define MXC_DMA_CHANNEL_CSPI1_RX  MXC_DMA_DYNAMIC_CHANNEL
#define MXC_DMA_CHANNEL_CSPI1_TX  MXC_DMA_DYNAMIC_CHANNEL
#define MXC_DMA_CHANNEL_CSPI2_RX  MXC_DMA_DYNAMIC_CHANNEL
#define MXC_DMA_CHANNEL_CSPI2_TX  MXC_DMA_DYNAMIC_CHANNEL
#define MXC_DMA_CHANNEL_ATA_RX  MXC_DMA_DYNAMIC_CHANNEL
#define MXC_DMA_CHANNEL_ATA_TX  MXC_DMA_DYNAMIC_CHANNEL
#define MXC_DMA_CHANNEL_MEMORY  MXC_DMA_DYNAMIC_CHANNEL
#define MXC_DMA_CHANNEL_FIFO_MEMORY  MXC_DMA_DYNAMIC_CHANNEL

/*
 * DMA request assignments
 */
#define DMA_REQ_SDHC2      21
#define DMA_REQ_SDHC1      20
#define DMA_REQ_FIRI_TX    17
#define DMA_REQ_FIRI_RX    16
#define DMA_REQ_UART4_TX   13
#define DMA_REQ_UART4_RX   12
#define DMA_REQ_CSPI3_TX   11
#define DMA_REQ_CSPI3_RX   10
#define DMA_REQ_UART5_TX   11
#define DMA_REQ_UART5_RX   10
#define DMA_REQ_UART3_TX   9
#define DMA_REQ_UART3_RX   8
#define DMA_REQ_SIM        5

#define MXC_INT_MPEG4_ENCODER	5
#define MXC_INT_FIRI		7
#define MX31_INT_MMC_SDHC2	8
#define MXC_INT_MMC_SDHC2	8
#define MXC_INT_MMC_SDHC1	9
#define MX31_INT_SSI2		11
#define MX31_INT_SSI1		12
#define MXC_INT_MBX		16
#define MXC_INT_VPU		MXC_INT_MBX
#define MXC_INT_CSPI3		17
#define MXC_INT_SIM2		20
#define MXC_INT_SIM1		21
#define MXC_INT_CCM_DVFS	31
#define MXC_INT_USB1		35
#define MXC_INT_USB2		36
#define MXC_INT_USB3		37
#define MXC_INT_USB4		38
#define MXC_INT_MSHC2		40
#define MXC_INT_UART4		46
#define MXC_INT_UART5		47
#define MXC_INT_CCM		53
#define MXC_INT_PCMCIA		54

#define ARM11_PMU_IRQ		MXC_INT_EVTMON

/*!
 * NFMS bit in RCSR register for pagesize of nandflash
 */
#define NFMS (*((volatile u32 *)IO_ADDRESS(CCM_BASE_ADDR+0xc)))
#define NFMS_BIT 30
#define NFMS_NF_DWIDTH 		31
#define NFMS_NF_PG_SZ 		30

