/*
 * STMP USBCTRL Register Definitions
 *
 * Copyright 2008-2009 Freescale Semiconductor
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

#ifndef __ARCH_ARM___USBCTRL_H
#define __ARCH_ARM___USBCTRL_H  1

#include <mach/stmp3xxx_regs.h>

#define REGS_USBCTRL_BASE (REGS_BASE + 0x80000)
#define REGS_USBCTRL_BASE_PHYS (0x80080000)
#define REGS_USBCTRL_SIZE 0x00002000
HW_REGISTER_0(HW_USBCTRL_ID, REGS_USBCTRL_BASE, 0x00000000)
#define HW_USBCTRL_ID_ADDR (REGS_USBCTRL_BASE + 0x00000000)
#define BP_USBCTRL_ID_CIVERSION      29
#define BM_USBCTRL_ID_CIVERSION 0xE0000000
#define BF_USBCTRL_ID_CIVERSION(v) \
	(((v) << 29) & BM_USBCTRL_ID_CIVERSION)
#define BP_USBCTRL_ID_VERSION      25
#define BM_USBCTRL_ID_VERSION 0x1E000000
#define BF_USBCTRL_ID_VERSION(v)  \
	(((v) << 25) & BM_USBCTRL_ID_VERSION)
#define BP_USBCTRL_ID_REVISION      21
#define BM_USBCTRL_ID_REVISION 0x01E00000
#define BF_USBCTRL_ID_REVISION(v)  \
	(((v) << 21) & BM_USBCTRL_ID_REVISION)
#define BP_USBCTRL_ID_TAG      16
#define BM_USBCTRL_ID_TAG 0x001F0000
#define BF_USBCTRL_ID_TAG(v)  \
	(((v) << 16) & BM_USBCTRL_ID_TAG)
#define BP_USBCTRL_ID_NID      8
#define BM_USBCTRL_ID_NID 0x00003F00
#define BF_USBCTRL_ID_NID(v)  \
	(((v) << 8) & BM_USBCTRL_ID_NID)
#define BP_USBCTRL_ID_ID      0
#define BM_USBCTRL_ID_ID 0x0000003F
#define BF_USBCTRL_ID_ID(v)  \
	(((v) << 0) & BM_USBCTRL_ID_ID)
HW_REGISTER_0(HW_USBCTRL_HWGENERAL, REGS_USBCTRL_BASE, 0x00000004)
#define HW_USBCTRL_HWGENERAL_ADDR (REGS_USBCTRL_BASE + 0x00000004)
#define BP_USBCTRL_HWGENERAL_SM      9
#define BM_USBCTRL_HWGENERAL_SM 0x00000600
#define BF_USBCTRL_HWGENERAL_SM(v)  \
	(((v) << 9) & BM_USBCTRL_HWGENERAL_SM)
#define BP_USBCTRL_HWGENERAL_PHYM      6
#define BM_USBCTRL_HWGENERAL_PHYM 0x000001C0
#define BF_USBCTRL_HWGENERAL_PHYM(v)  \
	(((v) << 6) & BM_USBCTRL_HWGENERAL_PHYM)
#define BP_USBCTRL_HWGENERAL_PHYW      4
#define BM_USBCTRL_HWGENERAL_PHYW 0x00000030
#define BF_USBCTRL_HWGENERAL_PHYW(v)  \
	(((v) << 4) & BM_USBCTRL_HWGENERAL_PHYW)
#define BM_USBCTRL_HWGENERAL_BWT 0x00000008
#define BP_USBCTRL_HWGENERAL_CLKC      1
#define BM_USBCTRL_HWGENERAL_CLKC 0x00000006
#define BF_USBCTRL_HWGENERAL_CLKC(v)  \
	(((v) << 1) & BM_USBCTRL_HWGENERAL_CLKC)
#define BM_USBCTRL_HWGENERAL_RT 0x00000001
HW_REGISTER_0(HW_USBCTRL_HWHOST, REGS_USBCTRL_BASE, 0x00000008)
#define HW_USBCTRL_HWHOST_ADDR (REGS_USBCTRL_BASE + 0x00000008)
#define BP_USBCTRL_HWHOST_TTPER      24
#define BM_USBCTRL_HWHOST_TTPER 0xFF000000
#define BF_USBCTRL_HWHOST_TTPER(v) \
	(((v) << 24) & BM_USBCTRL_HWHOST_TTPER)
#define BP_USBCTRL_HWHOST_TTASY      16
#define BM_USBCTRL_HWHOST_TTASY 0x00FF0000
#define BF_USBCTRL_HWHOST_TTASY(v)  \
	(((v) << 16) & BM_USBCTRL_HWHOST_TTASY)
#define BP_USBCTRL_HWHOST_NPORT      1
#define BM_USBCTRL_HWHOST_NPORT 0x0000000E
#define BF_USBCTRL_HWHOST_NPORT(v)  \
	(((v) << 1) & BM_USBCTRL_HWHOST_NPORT)
#define BM_USBCTRL_HWHOST_HC 0x00000001
HW_REGISTER_0(HW_USBCTRL_HWDEVICE, REGS_USBCTRL_BASE, 0x0000000c)
#define HW_USBCTRL_HWDEVICE_ADDR (REGS_USBCTRL_BASE + 0x0000000c)
#define BP_USBCTRL_HWDEVICE_DEVEP      1
#define BM_USBCTRL_HWDEVICE_DEVEP 0x0000003E
#define BF_USBCTRL_HWDEVICE_DEVEP(v)  \
	(((v) << 1) & BM_USBCTRL_HWDEVICE_DEVEP)
#define BM_USBCTRL_HWDEVICE_DC 0x00000001
HW_REGISTER_0(HW_USBCTRL_HWTXBUF, REGS_USBCTRL_BASE, 0x00000010)
#define HW_USBCTRL_HWTXBUF_ADDR (REGS_USBCTRL_BASE + 0x00000010)
#define BM_USBCTRL_HWTXBUF_TXLCR 0x80000000
#define BP_USBCTRL_HWTXBUF_TXCHANADD      16
#define BM_USBCTRL_HWTXBUF_TXCHANADD 0x00FF0000
#define BF_USBCTRL_HWTXBUF_TXCHANADD(v)  \
	(((v) << 16) & BM_USBCTRL_HWTXBUF_TXCHANADD)
#define BP_USBCTRL_HWTXBUF_TXADD      8
#define BM_USBCTRL_HWTXBUF_TXADD 0x0000FF00
#define BF_USBCTRL_HWTXBUF_TXADD(v)  \
	(((v) << 8) & BM_USBCTRL_HWTXBUF_TXADD)
#define BP_USBCTRL_HWTXBUF_TXBURST      0
#define BM_USBCTRL_HWTXBUF_TXBURST 0x000000FF
#define BF_USBCTRL_HWTXBUF_TXBURST(v)  \
	(((v) << 0) & BM_USBCTRL_HWTXBUF_TXBURST)
HW_REGISTER_0(HW_USBCTRL_HWRXBUF, REGS_USBCTRL_BASE, 0x00000014)
#define HW_USBCTRL_HWRXBUF_ADDR (REGS_USBCTRL_BASE + 0x00000014)
#define BP_USBCTRL_HWRXBUF_RXADD      8
#define BM_USBCTRL_HWRXBUF_RXADD 0x0000FF00
#define BF_USBCTRL_HWRXBUF_RXADD(v)  \
	(((v) << 8) & BM_USBCTRL_HWRXBUF_RXADD)
#define BP_USBCTRL_HWRXBUF_RXBURST      0
#define BM_USBCTRL_HWRXBUF_RXBURST 0x000000FF
#define BF_USBCTRL_HWRXBUF_RXBURST(v)  \
	(((v) << 0) & BM_USBCTRL_HWRXBUF_RXBURST)
HW_REGISTER_0(HW_USBCTRL_GPTIMER0LD, REGS_USBCTRL_BASE, 0x00000080)
#define HW_USBCTRL_GPTIMER0LD_ADDR (REGS_USBCTRL_BASE + 0x00000080)
#define BP_USBCTRL_GPTIMER0LD_GPTLD      0
#define BM_USBCTRL_GPTIMER0LD_GPTLD 0x00FFFFFF
#define BF_USBCTRL_GPTIMER0LD_GPTLD(v)  \
	(((v) << 0) & BM_USBCTRL_GPTIMER0LD_GPTLD)
HW_REGISTER_0(HW_USBCTRL_GPTIMER0CTRL, REGS_USBCTRL_BASE, 0x00000084)
#define HW_USBCTRL_GPTIMER0CTRL_ADDR (REGS_USBCTRL_BASE + 0x00000084)
#define BM_USBCTRL_GPTIMER0CTRL_GPTRUN 0x80000000
#define BV_USBCTRL_GPTIMER0CTRL_GPTRUN__STOP 0
#define BV_USBCTRL_GPTIMER0CTRL_GPTRUN__RUN  1
#define BM_USBCTRL_GPTIMER0CTRL_GPTRST 0x40000000
#define BV_USBCTRL_GPTIMER0CTRL_GPTRST__NOACTION    0
#define BV_USBCTRL_GPTIMER0CTRL_GPTRST__LOADCOUNTER 1
#define BM_USBCTRL_GPTIMER0CTRL_GPTMODE 0x01000000
#define BV_USBCTRL_GPTIMER0CTRL_GPTMODE__ONESHOT 0
#define BV_USBCTRL_GPTIMER0CTRL_GPTMODE__REPEAT  1
#define BP_USBCTRL_GPTIMER0CTRL_GPTCNT      0
#define BM_USBCTRL_GPTIMER0CTRL_GPTCNT 0x00FFFFFF
#define BF_USBCTRL_GPTIMER0CTRL_GPTCNT(v)  \
	(((v) << 0) & BM_USBCTRL_GPTIMER0CTRL_GPTCNT)
HW_REGISTER_0(HW_USBCTRL_GPTIMER1LD, REGS_USBCTRL_BASE, 0x00000088)
#define HW_USBCTRL_GPTIMER1LD_ADDR (REGS_USBCTRL_BASE + 0x00000088)
#define BP_USBCTRL_GPTIMER1LD_GPTLD      0
#define BM_USBCTRL_GPTIMER1LD_GPTLD 0x00FFFFFF
#define BF_USBCTRL_GPTIMER1LD_GPTLD(v)  \
	(((v) << 0) & BM_USBCTRL_GPTIMER1LD_GPTLD)
HW_REGISTER_0(HW_USBCTRL_GPTIMER1CTRL, REGS_USBCTRL_BASE, 0x0000008c)
#define HW_USBCTRL_GPTIMER1CTRL_ADDR (REGS_USBCTRL_BASE + 0x0000008c)
#define BM_USBCTRL_GPTIMER1CTRL_GPTRUN 0x80000000
#define BV_USBCTRL_GPTIMER1CTRL_GPTRUN__STOP 0
#define BV_USBCTRL_GPTIMER1CTRL_GPTRUN__RUN  1
#define BM_USBCTRL_GPTIMER1CTRL_GPTRST 0x40000000
#define BV_USBCTRL_GPTIMER1CTRL_GPTRST__NOACTION    0
#define BV_USBCTRL_GPTIMER1CTRL_GPTRST__LOADCOUNTER 1
#define BM_USBCTRL_GPTIMER1CTRL_GPTMODE 0x01000000
#define BV_USBCTRL_GPTIMER1CTRL_GPTMODE__ONESHOT 0
#define BV_USBCTRL_GPTIMER1CTRL_GPTMODE__REPEAT  1
#define BP_USBCTRL_GPTIMER1CTRL_GPTCNT      0
#define BM_USBCTRL_GPTIMER1CTRL_GPTCNT 0x00FFFFFF
#define BF_USBCTRL_GPTIMER1CTRL_GPTCNT(v)  \
	(((v) << 0) & BM_USBCTRL_GPTIMER1CTRL_GPTCNT)
HW_REGISTER_0(HW_USBCTRL_SBUSCFG, REGS_USBCTRL_BASE, 0x00000090)
#define HW_USBCTRL_SBUSCFG_ADDR (REGS_USBCTRL_BASE + 0x00000090)
#define BP_USBCTRL_SBUSCFG_AHBBRST      0
#define BM_USBCTRL_SBUSCFG_AHBBRST 0x00000007
#define BF_USBCTRL_SBUSCFG_AHBBRST(v)  \
	(((v) << 0) & BM_USBCTRL_SBUSCFG_AHBBRST)
#define BV_USBCTRL_SBUSCFG_AHBBRST__U_INCR   0x0
#define BV_USBCTRL_SBUSCFG_AHBBRST__S_INCR4  0x1
#define BV_USBCTRL_SBUSCFG_AHBBRST__S_INCR8  0x2
#define BV_USBCTRL_SBUSCFG_AHBBRST__S_INCR16 0x3
#define BV_USBCTRL_SBUSCFG_AHBBRST__RESERVED 0x4
#define BV_USBCTRL_SBUSCFG_AHBBRST__U_INCR4  0x5
#define BV_USBCTRL_SBUSCFG_AHBBRST__U_INCR8  0x6
#define BV_USBCTRL_SBUSCFG_AHBBRST__U_INCR16 0x7
HW_REGISTER_0(HW_USBCTRL_CAPLENGTH, REGS_USBCTRL_BASE, 0x00000100)
#define HW_USBCTRL_CAPLENGTH_ADDR (REGS_USBCTRL_BASE + 0x00000100)
#define BP_USBCTRL_CAPLENGTH_HCIVERSION      16
#define BM_USBCTRL_CAPLENGTH_HCIVERSION 0xFFFF0000
#define BF_USBCTRL_CAPLENGTH_HCIVERSION(v) \
	(((v) << 16) & BM_USBCTRL_CAPLENGTH_HCIVERSION)
#define BP_USBCTRL_CAPLENGTH_CAPLENGTH      0
#define BM_USBCTRL_CAPLENGTH_CAPLENGTH 0x000000FF
#define BF_USBCTRL_CAPLENGTH_CAPLENGTH(v)  \
	(((v) << 0) & BM_USBCTRL_CAPLENGTH_CAPLENGTH)
HW_REGISTER_0(HW_USBCTRL_HCSPARAMS, REGS_USBCTRL_BASE, 0x00000104)
#define HW_USBCTRL_HCSPARAMS_ADDR (REGS_USBCTRL_BASE + 0x00000104)
#define BP_USBCTRL_HCSPARAMS_N_TT      24
#define BM_USBCTRL_HCSPARAMS_N_TT 0x0F000000
#define BF_USBCTRL_HCSPARAMS_N_TT(v)  \
	(((v) << 24) & BM_USBCTRL_HCSPARAMS_N_TT)
#define BP_USBCTRL_HCSPARAMS_N_PTT      20
#define BM_USBCTRL_HCSPARAMS_N_PTT 0x00F00000
#define BF_USBCTRL_HCSPARAMS_N_PTT(v)  \
	(((v) << 20) & BM_USBCTRL_HCSPARAMS_N_PTT)
#define BM_USBCTRL_HCSPARAMS_PI 0x00010000
#define BP_USBCTRL_HCSPARAMS_N_CC      12
#define BM_USBCTRL_HCSPARAMS_N_CC 0x0000F000
#define BF_USBCTRL_HCSPARAMS_N_CC(v)  \
	(((v) << 12) & BM_USBCTRL_HCSPARAMS_N_CC)
#define BP_USBCTRL_HCSPARAMS_N_PCC      8
#define BM_USBCTRL_HCSPARAMS_N_PCC 0x00000F00
#define BF_USBCTRL_HCSPARAMS_N_PCC(v)  \
	(((v) << 8) & BM_USBCTRL_HCSPARAMS_N_PCC)
#define BM_USBCTRL_HCSPARAMS_PPC 0x00000010
#define BP_USBCTRL_HCSPARAMS_N_PORTS      0
#define BM_USBCTRL_HCSPARAMS_N_PORTS 0x0000000F
#define BF_USBCTRL_HCSPARAMS_N_PORTS(v)  \
	(((v) << 0) & BM_USBCTRL_HCSPARAMS_N_PORTS)
HW_REGISTER_0(HW_USBCTRL_HCCPARAMS, REGS_USBCTRL_BASE, 0x00000108)
#define HW_USBCTRL_HCCPARAMS_ADDR (REGS_USBCTRL_BASE + 0x00000108)
#define BP_USBCTRL_HCCPARAMS_EECP      8
#define BM_USBCTRL_HCCPARAMS_EECP 0x0000FF00
#define BF_USBCTRL_HCCPARAMS_EECP(v)  \
	(((v) << 8) & BM_USBCTRL_HCCPARAMS_EECP)
#define BP_USBCTRL_HCCPARAMS_IST      4
#define BM_USBCTRL_HCCPARAMS_IST 0x000000F0
#define BF_USBCTRL_HCCPARAMS_IST(v)  \
	(((v) << 4) & BM_USBCTRL_HCCPARAMS_IST)
#define BM_USBCTRL_HCCPARAMS_ASP 0x00000004
#define BM_USBCTRL_HCCPARAMS_PFL 0x00000002
#define BM_USBCTRL_HCCPARAMS_ADC 0x00000001
HW_REGISTER_0(HW_USBCTRL_DCIVERSION, REGS_USBCTRL_BASE, 0x00000120)
#define HW_USBCTRL_DCIVERSION_ADDR (REGS_USBCTRL_BASE + 0x00000120)
#define BP_USBCTRL_DCIVERSION_DCIVERSION      0
#define BM_USBCTRL_DCIVERSION_DCIVERSION 0x0000FFFF
#define BF_USBCTRL_DCIVERSION_DCIVERSION(v)  \
	(((v) << 0) & BM_USBCTRL_DCIVERSION_DCIVERSION)
HW_REGISTER_0(HW_USBCTRL_DCCPARAMS, REGS_USBCTRL_BASE, 0x00000124)
#define HW_USBCTRL_DCCPARAMS_ADDR (REGS_USBCTRL_BASE + 0x00000124)
#define BM_USBCTRL_DCCPARAMS_HC 0x00000100
#define BM_USBCTRL_DCCPARAMS_DC 0x00000080
#define BP_USBCTRL_DCCPARAMS_DEN      0
#define BM_USBCTRL_DCCPARAMS_DEN 0x0000001F
#define BF_USBCTRL_DCCPARAMS_DEN(v)  \
	(((v) << 0) & BM_USBCTRL_DCCPARAMS_DEN)
HW_REGISTER_0(HW_USBCTRL_USBCMD, REGS_USBCTRL_BASE, 0x00000140)
#define HW_USBCTRL_USBCMD_ADDR (REGS_USBCTRL_BASE + 0x00000140)
#define BP_USBCTRL_USBCMD_ITC      16
#define BM_USBCTRL_USBCMD_ITC 0x00FF0000
#define BF_USBCTRL_USBCMD_ITC(v)  \
	(((v) << 16) & BM_USBCTRL_USBCMD_ITC)
#define BV_USBCTRL_USBCMD_ITC__IMM	   0x0
#define BV_USBCTRL_USBCMD_ITC__1_MICROFRAME  0x1
#define BV_USBCTRL_USBCMD_ITC__2_MICROFRAME  0x2
#define BV_USBCTRL_USBCMD_ITC__4_MICROFRAME  0x4
#define BV_USBCTRL_USBCMD_ITC__8_MICROFRAME  0x8
#define BV_USBCTRL_USBCMD_ITC__16_MICROFRAME 0x10
#define BV_USBCTRL_USBCMD_ITC__32_MICROFRAME 0x20
#define BV_USBCTRL_USBCMD_ITC__64_MICROFRAME 0x40
#define BM_USBCTRL_USBCMD_FS2 0x00008000
#define BM_USBCTRL_USBCMD_ATDTW 0x00004000
#define BM_USBCTRL_USBCMD_SUTW 0x00002000
#define BM_USBCTRL_USBCMD_ASPE 0x00000800
#define BP_USBCTRL_USBCMD_ASP      8
#define BM_USBCTRL_USBCMD_ASP 0x00000300
#define BF_USBCTRL_USBCMD_ASP(v)  \
	(((v) << 8) & BM_USBCTRL_USBCMD_ASP)
#define BM_USBCTRL_USBCMD_LR 0x00000080
#define BM_USBCTRL_USBCMD_IAA 0x00000040
#define BM_USBCTRL_USBCMD_ASE 0x00000020
#define BM_USBCTRL_USBCMD_PSE 0x00000010
#define BM_USBCTRL_USBCMD_FS1 0x00000008
#define BM_USBCTRL_USBCMD_FS0 0x00000004
#define BM_USBCTRL_USBCMD_RST 0x00000002
#define BM_USBCTRL_USBCMD_RS 0x00000001
HW_REGISTER_0(HW_USBCTRL_USBSTS, REGS_USBCTRL_BASE, 0x00000144)
#define HW_USBCTRL_USBSTS_ADDR (REGS_USBCTRL_BASE + 0x00000144)
#define BM_USBCTRL_USBSTS_TI1 0x02000000
#define BM_USBCTRL_USBSTS_TI0 0x01000000
#define BM_USBCTRL_USBSTS_UPI 0x00080000
#define BM_USBCTRL_USBSTS_UAI 0x00040000
#define BM_USBCTRL_USBSTS_NAKI 0x00010000
#define BM_USBCTRL_USBSTS_AS 0x00008000
#define BM_USBCTRL_USBSTS_PS 0x00004000
#define BM_USBCTRL_USBSTS_RCL 0x00002000
#define BM_USBCTRL_USBSTS_HCH 0x00001000
#define BM_USBCTRL_USBSTS_ULPII 0x00000400
#define BM_USBCTRL_USBSTS_SLI 0x00000100
#define BM_USBCTRL_USBSTS_SRI 0x00000080
#define BM_USBCTRL_USBSTS_URI 0x00000040
#define BM_USBCTRL_USBSTS_AAI 0x00000020
#define BM_USBCTRL_USBSTS_SEI 0x00000010
#define BM_USBCTRL_USBSTS_FRI 0x00000008
#define BM_USBCTRL_USBSTS_PCI 0x00000004
#define BM_USBCTRL_USBSTS_UEI 0x00000002
#define BM_USBCTRL_USBSTS_UI 0x00000001
HW_REGISTER_0(HW_USBCTRL_USBINTR, REGS_USBCTRL_BASE, 0x00000148)
#define HW_USBCTRL_USBINTR_ADDR (REGS_USBCTRL_BASE + 0x00000148)
#define BM_USBCTRL_USBINTR_TIE1 0x02000000
#define BM_USBCTRL_USBINTR_TIE0 0x01000000
#define BM_USBCTRL_USBINTR_UPIE 0x00080000
#define BM_USBCTRL_USBINTR_UAIE 0x00040000
#define BM_USBCTRL_USBINTR_NAKE 0x00010000
#define BM_USBCTRL_USBINTR_ULPIE 0x00000400
#define BM_USBCTRL_USBINTR_SLE 0x00000100
#define BM_USBCTRL_USBINTR_SRE 0x00000080
#define BM_USBCTRL_USBINTR_URE 0x00000040
#define BM_USBCTRL_USBINTR_AAE 0x00000020
#define BM_USBCTRL_USBINTR_SEE 0x00000010
#define BM_USBCTRL_USBINTR_FRE 0x00000008
#define BM_USBCTRL_USBINTR_PCE 0x00000004
#define BM_USBCTRL_USBINTR_UEE 0x00000002
#define BM_USBCTRL_USBINTR_UE 0x00000001
HW_REGISTER_0(HW_USBCTRL_FRINDEX, REGS_USBCTRL_BASE, 0x0000014c)
#define HW_USBCTRL_FRINDEX_ADDR (REGS_USBCTRL_BASE + 0x0000014c)
#define BP_USBCTRL_FRINDEX_FRINDEX      3
#define BM_USBCTRL_FRINDEX_FRINDEX 0x00003FF8
#define BF_USBCTRL_FRINDEX_FRINDEX(v)  \
	(((v) << 3) & BM_USBCTRL_FRINDEX_FRINDEX)
#define BV_USBCTRL_FRINDEX_FRINDEX__N_12 12
#define BV_USBCTRL_FRINDEX_FRINDEX__N_11 11
#define BV_USBCTRL_FRINDEX_FRINDEX__N_10 10
#define BV_USBCTRL_FRINDEX_FRINDEX__N_9  9
#define BV_USBCTRL_FRINDEX_FRINDEX__N_8  8
#define BV_USBCTRL_FRINDEX_FRINDEX__N_7  7
#define BV_USBCTRL_FRINDEX_FRINDEX__N_6  6
#define BV_USBCTRL_FRINDEX_FRINDEX__N_5  5
#define BP_USBCTRL_FRINDEX_UINDEX      0
#define BM_USBCTRL_FRINDEX_UINDEX 0x00000007
#define BF_USBCTRL_FRINDEX_UINDEX(v)  \
	(((v) << 0) & BM_USBCTRL_FRINDEX_UINDEX)
HW_REGISTER_0(HW_USBCTRL_PERIODICLISTBASE, REGS_USBCTRL_BASE, 0x00000154)
#define HW_USBCTRL_PERIODICLISTBASE_ADDR (REGS_USBCTRL_BASE + 0x00000154)
#define BP_USBCTRL_PERIODICLISTBASE_PERBASE      12
#define BM_USBCTRL_PERIODICLISTBASE_PERBASE 0xFFFFF000
#define BF_USBCTRL_PERIODICLISTBASE_PERBASE(v) \
	(((v) << 12) & BM_USBCTRL_PERIODICLISTBASE_PERBASE)
HW_REGISTER_0(HW_USBCTRL_DEVICEADDR, REGS_USBCTRL_BASE, 0x00000154)
#define HW_USBCTRL_DEVICEADDR_ADDR (REGS_USBCTRL_BASE + 0x00000154)
#define BP_USBCTRL_DEVICEADDR_USBADR      25
#define BM_USBCTRL_DEVICEADDR_USBADR 0xFE000000
#define BF_USBCTRL_DEVICEADDR_USBADR(v) \
	(((v) << 25) & BM_USBCTRL_DEVICEADDR_USBADR)
#define BM_USBCTRL_DEVICEADDR_USBADRA 0x01000000
HW_REGISTER_0(HW_USBCTRL_ASYNCLISTADDR, REGS_USBCTRL_BASE, 0x00000158)
#define HW_USBCTRL_ASYNCLISTADDR_ADDR (REGS_USBCTRL_BASE + 0x00000158)
#define BP_USBCTRL_ASYNCLISTADDR_ASYBASE      5
#define BM_USBCTRL_ASYNCLISTADDR_ASYBASE 0xFFFFFFE0
#define BF_USBCTRL_ASYNCLISTADDR_ASYBASE(v) \
	(((v) << 5) & BM_USBCTRL_ASYNCLISTADDR_ASYBASE)
HW_REGISTER_0(HW_USBCTRL_ENDPOINTLISTADDR, REGS_USBCTRL_BASE, 0x00000158)
#define HW_USBCTRL_ENDPOINTLISTADDR_ADDR (REGS_USBCTRL_BASE + 0x00000158)
#define BP_USBCTRL_ENDPOINTLISTADDR_EPBASE      11
#define BM_USBCTRL_ENDPOINTLISTADDR_EPBASE 0xFFFFF800
#define BF_USBCTRL_ENDPOINTLISTADDR_EPBASE(v) \
	(((v) << 11) & BM_USBCTRL_ENDPOINTLISTADDR_EPBASE)
HW_REGISTER_0(HW_USBCTRL_TTCTRL, REGS_USBCTRL_BASE, 0x0000015c)
#define HW_USBCTRL_TTCTRL_ADDR (REGS_USBCTRL_BASE + 0x0000015c)
#define BP_USBCTRL_TTCTRL_TTHA      24
#define BM_USBCTRL_TTCTRL_TTHA 0x7F000000
#define BF_USBCTRL_TTCTRL_TTHA(v)  \
	(((v) << 24) & BM_USBCTRL_TTCTRL_TTHA)
HW_REGISTER_0(HW_USBCTRL_BURSTSIZE, REGS_USBCTRL_BASE, 0x00000160)
#define HW_USBCTRL_BURSTSIZE_ADDR (REGS_USBCTRL_BASE + 0x00000160)
#define BP_USBCTRL_BURSTSIZE_TXPBURST      8
#define BM_USBCTRL_BURSTSIZE_TXPBURST 0x0000FF00
#define BF_USBCTRL_BURSTSIZE_TXPBURST(v)  \
	(((v) << 8) & BM_USBCTRL_BURSTSIZE_TXPBURST)
#define BP_USBCTRL_BURSTSIZE_RXPBURST      0
#define BM_USBCTRL_BURSTSIZE_RXPBURST 0x000000FF
#define BF_USBCTRL_BURSTSIZE_RXPBURST(v)  \
	(((v) << 0) & BM_USBCTRL_BURSTSIZE_RXPBURST)
HW_REGISTER_0(HW_USBCTRL_TXFILLTUNING, REGS_USBCTRL_BASE, 0x00000164)
#define HW_USBCTRL_TXFILLTUNING_ADDR (REGS_USBCTRL_BASE + 0x00000164)
#define BP_USBCTRL_TXFILLTUNING_TXFIFOTHRES      16
#define BM_USBCTRL_TXFILLTUNING_TXFIFOTHRES 0x003F0000
#define BF_USBCTRL_TXFILLTUNING_TXFIFOTHRES(v)  \
	(((v) << 16) & BM_USBCTRL_TXFILLTUNING_TXFIFOTHRES)
#define BP_USBCTRL_TXFILLTUNING_TXSCHEALTH      8
#define BM_USBCTRL_TXFILLTUNING_TXSCHEALTH 0x00001F00
#define BF_USBCTRL_TXFILLTUNING_TXSCHEALTH(v)  \
	(((v) << 8) & BM_USBCTRL_TXFILLTUNING_TXSCHEALTH)
#define BP_USBCTRL_TXFILLTUNING_TXSCHOH      0
#define BM_USBCTRL_TXFILLTUNING_TXSCHOH 0x0000007F
#define BF_USBCTRL_TXFILLTUNING_TXSCHOH(v)  \
	(((v) << 0) & BM_USBCTRL_TXFILLTUNING_TXSCHOH)
HW_REGISTER_0(HW_USBCTRL_IC_USB, REGS_USBCTRL_BASE, 0x0000016c)
#define HW_USBCTRL_IC_USB_ADDR (REGS_USBCTRL_BASE + 0x0000016c)
#define BM_USBCTRL_IC_USB_IC_ENABLE 0x00000008
#define BP_USBCTRL_IC_USB_IC_VDD      0
#define BM_USBCTRL_IC_USB_IC_VDD 0x00000007
#define BF_USBCTRL_IC_USB_IC_VDD(v)  \
	(((v) << 0) & BM_USBCTRL_IC_USB_IC_VDD)
#define BV_USBCTRL_IC_USB_IC_VDD__VOLTAGE_NONE 0x0
#define BV_USBCTRL_IC_USB_IC_VDD__VOLTAGE_1_0  0x1
#define BV_USBCTRL_IC_USB_IC_VDD__VOLTAGE_1_2  0x2
#define BV_USBCTRL_IC_USB_IC_VDD__VOLTAGE_1_5  0x3
#define BV_USBCTRL_IC_USB_IC_VDD__VOLTAGE_1_8  0x4
#define BV_USBCTRL_IC_USB_IC_VDD__VOLTAGE_3_0  0x5
#define BV_USBCTRL_IC_USB_IC_VDD__RESERVED0    0x6
#define BV_USBCTRL_IC_USB_IC_VDD__RESERVED1    0x7
HW_REGISTER_0(HW_USBCTRL_ULPI, REGS_USBCTRL_BASE, 0x00000170)
#define HW_USBCTRL_ULPI_ADDR (REGS_USBCTRL_BASE + 0x00000170)
#define BM_USBCTRL_ULPI_ULPIWU 0x80000000
#define BM_USBCTRL_ULPI_ULPIRUN 0x40000000
#define BM_USBCTRL_ULPI_ULPIRW 0x20000000
#define BM_USBCTRL_ULPI_ULPISS 0x08000000
#define BP_USBCTRL_ULPI_ULPIPORT      24
#define BM_USBCTRL_ULPI_ULPIPORT 0x07000000
#define BF_USBCTRL_ULPI_ULPIPORT(v)  \
	(((v) << 24) & BM_USBCTRL_ULPI_ULPIPORT)
#define BP_USBCTRL_ULPI_ULPIADDR      16
#define BM_USBCTRL_ULPI_ULPIADDR 0x00FF0000
#define BF_USBCTRL_ULPI_ULPIADDR(v)  \
	(((v) << 16) & BM_USBCTRL_ULPI_ULPIADDR)
#define BP_USBCTRL_ULPI_ULPIDATRD      8
#define BM_USBCTRL_ULPI_ULPIDATRD 0x0000FF00
#define BF_USBCTRL_ULPI_ULPIDATRD(v)  \
	(((v) << 8) & BM_USBCTRL_ULPI_ULPIDATRD)
#define BP_USBCTRL_ULPI_ULPIDATWR      0
#define BM_USBCTRL_ULPI_ULPIDATWR 0x000000FF
#define BF_USBCTRL_ULPI_ULPIDATWR(v)  \
	(((v) << 0) & BM_USBCTRL_ULPI_ULPIDATWR)
HW_REGISTER_0(HW_USBCTRL_ENDPTNAK, REGS_USBCTRL_BASE, 0x00000178)
#define HW_USBCTRL_ENDPTNAK_ADDR (REGS_USBCTRL_BASE + 0x00000178)
#define BP_USBCTRL_ENDPTNAK_EPTN      16
#define BM_USBCTRL_ENDPTNAK_EPTN 0x001F0000
#define BF_USBCTRL_ENDPTNAK_EPTN(v)  \
	(((v) << 16) & BM_USBCTRL_ENDPTNAK_EPTN)
#define BP_USBCTRL_ENDPTNAK_EPRN      0
#define BM_USBCTRL_ENDPTNAK_EPRN 0x0000001F
#define BF_USBCTRL_ENDPTNAK_EPRN(v)  \
	(((v) << 0) & BM_USBCTRL_ENDPTNAK_EPRN)
HW_REGISTER_0(HW_USBCTRL_ENDPTNAKEN, REGS_USBCTRL_BASE, 0x0000017c)
#define HW_USBCTRL_ENDPTNAKEN_ADDR (REGS_USBCTRL_BASE + 0x0000017c)
#define BP_USBCTRL_ENDPTNAKEN_EPTNE      16
#define BM_USBCTRL_ENDPTNAKEN_EPTNE 0x001F0000
#define BF_USBCTRL_ENDPTNAKEN_EPTNE(v)  \
	(((v) << 16) & BM_USBCTRL_ENDPTNAKEN_EPTNE)
#define BP_USBCTRL_ENDPTNAKEN_EPRNE      0
#define BM_USBCTRL_ENDPTNAKEN_EPRNE 0x0000001F
#define BF_USBCTRL_ENDPTNAKEN_EPRNE(v)  \
	(((v) << 0) & BM_USBCTRL_ENDPTNAKEN_EPRNE)
HW_REGISTER_0(HW_USBCTRL_PORTSC1, REGS_USBCTRL_BASE, 0x00000184)
#define HW_USBCTRL_PORTSC1_ADDR (REGS_USBCTRL_BASE + 0x00000184)
#define BP_USBCTRL_PORTSC1_PTS      30
#define BM_USBCTRL_PORTSC1_PTS 0xC0000000
#define BF_USBCTRL_PORTSC1_PTS(v) \
	(((v) << 30) & BM_USBCTRL_PORTSC1_PTS)
#define BV_USBCTRL_PORTSC1_PTS__UTMI   0
#define BV_USBCTRL_PORTSC1_PTS__PHIL   1
#define BV_USBCTRL_PORTSC1_PTS__ULPI   2
#define BV_USBCTRL_PORTSC1_PTS__SERIAL 3
#define BM_USBCTRL_PORTSC1_STS 0x20000000
#define BM_USBCTRL_PORTSC1_PTW 0x10000000
#define BP_USBCTRL_PORTSC1_PSPD      26
#define BM_USBCTRL_PORTSC1_PSPD 0x0C000000
#define BF_USBCTRL_PORTSC1_PSPD(v)  \
	(((v) << 26) & BM_USBCTRL_PORTSC1_PSPD)
#define BV_USBCTRL_PORTSC1_PSPD__FULL 0
#define BV_USBCTRL_PORTSC1_PSPD__LOW  1
#define BV_USBCTRL_PORTSC1_PSPD__HIGH 2
#define BM_USBCTRL_PORTSC1_SRT 0x02000000
#define BM_USBCTRL_PORTSC1_PFSC 0x01000000
#define BM_USBCTRL_PORTSC1_PHCD 0x00800000
#define BM_USBCTRL_PORTSC1_WKOC 0x00400000
#define BM_USBCTRL_PORTSC1_WKDS 0x00200000
#define BM_USBCTRL_PORTSC1_WKCN 0x00100000
#define BP_USBCTRL_PORTSC1_PTC      16
#define BM_USBCTRL_PORTSC1_PTC 0x000F0000
#define BF_USBCTRL_PORTSC1_PTC(v)  \
	(((v) << 16) & BM_USBCTRL_PORTSC1_PTC)
#define BV_USBCTRL_PORTSC1_PTC__TEST_DISABLE	 0
#define BV_USBCTRL_PORTSC1_PTC__TEST_J_STATE	 1
#define BV_USBCTRL_PORTSC1_PTC__TEST_K_STATE	 2
#define BV_USBCTRL_PORTSC1_PTC__TEST_J_SE0_NAK       3
#define BV_USBCTRL_PORTSC1_PTC__TEST_PACKET	  4
#define BV_USBCTRL_PORTSC1_PTC__TEST_FORCE_ENABLE_HS 5
#define BV_USBCTRL_PORTSC1_PTC__TEST_FORCE_ENABLE_FS 6
#define BV_USBCTRL_PORTSC1_PTC__TEST_FORCE_ENABLE_LS 7
#define BP_USBCTRL_PORTSC1_PIC      14
#define BM_USBCTRL_PORTSC1_PIC 0x0000C000
#define BF_USBCTRL_PORTSC1_PIC(v)  \
	(((v) << 14) & BM_USBCTRL_PORTSC1_PIC)
#define BV_USBCTRL_PORTSC1_PIC__OFF   0
#define BV_USBCTRL_PORTSC1_PIC__AMBER 1
#define BV_USBCTRL_PORTSC1_PIC__GREEN 2
#define BV_USBCTRL_PORTSC1_PIC__UNDEF 3
#define BM_USBCTRL_PORTSC1_PO 0x00002000
#define BM_USBCTRL_PORTSC1_PP 0x00001000
#define BP_USBCTRL_PORTSC1_LS      10
#define BM_USBCTRL_PORTSC1_LS 0x00000C00
#define BF_USBCTRL_PORTSC1_LS(v)  \
	(((v) << 10) & BM_USBCTRL_PORTSC1_LS)
#define BV_USBCTRL_PORTSC1_LS__SE0     0
#define BV_USBCTRL_PORTSC1_LS__K_STATE 1
#define BV_USBCTRL_PORTSC1_LS__J_STATE 2
#define BV_USBCTRL_PORTSC1_LS__UNDEF   3
#define BM_USBCTRL_PORTSC1_HSP 0x00000200
#define BM_USBCTRL_PORTSC1_PR 0x00000100
#define BM_USBCTRL_PORTSC1_SUSP 0x00000080
#define BM_USBCTRL_PORTSC1_FPR 0x00000040
#define BM_USBCTRL_PORTSC1_OCC 0x00000020
#define BM_USBCTRL_PORTSC1_OCA 0x00000010
#define BM_USBCTRL_PORTSC1_PEC 0x00000008
#define BM_USBCTRL_PORTSC1_PE 0x00000004
#define BM_USBCTRL_PORTSC1_CSC 0x00000002
#define BM_USBCTRL_PORTSC1_CCS 0x00000001
HW_REGISTER_0(HW_USBCTRL_OTGSC, REGS_USBCTRL_BASE, 0x000001a4)
#define HW_USBCTRL_OTGSC_ADDR (REGS_USBCTRL_BASE + 0x000001a4)
#define BM_USBCTRL_OTGSC_DPIE 0x40000000
#define BM_USBCTRL_OTGSC_ONEMSE 0x20000000
#define BM_USBCTRL_OTGSC_BSEIE 0x10000000
#define BM_USBCTRL_OTGSC_BSVIE 0x08000000
#define BM_USBCTRL_OTGSC_ASVIE 0x04000000
#define BM_USBCTRL_OTGSC_AVVIE 0x02000000
#define BM_USBCTRL_OTGSC_IDIE 0x01000000
#define BM_USBCTRL_OTGSC_DPIS 0x00400000
#define BM_USBCTRL_OTGSC_ONEMSS 0x00200000
#define BM_USBCTRL_OTGSC_BSEIS 0x00100000
#define BM_USBCTRL_OTGSC_BSVIS 0x00080000
#define BM_USBCTRL_OTGSC_ASVIS 0x00040000
#define BM_USBCTRL_OTGSC_AVVIS 0x00020000
#define BM_USBCTRL_OTGSC_IDIS 0x00010000
#define BM_USBCTRL_OTGSC_DPS 0x00004000
#define BM_USBCTRL_OTGSC_ONEMST 0x00002000
#define BM_USBCTRL_OTGSC_BSE 0x00001000
#define BM_USBCTRL_OTGSC_BSV 0x00000800
#define BM_USBCTRL_OTGSC_ASV 0x00000400
#define BM_USBCTRL_OTGSC_AVV 0x00000200
#define BM_USBCTRL_OTGSC_ID 0x00000100
#define BM_USBCTRL_OTGSC_HABA 0x00000080
#define BM_USBCTRL_OTGSC_HADP 0x00000040
#define BM_USBCTRL_OTGSC_IDPU 0x00000020
#define BM_USBCTRL_OTGSC_DP 0x00000010
#define BM_USBCTRL_OTGSC_OT 0x00000008
#define BM_USBCTRL_OTGSC_HAAR 0x00000004
#define BM_USBCTRL_OTGSC_VC 0x00000002
#define BM_USBCTRL_OTGSC_VD 0x00000001
HW_REGISTER_0(HW_USBCTRL_USBMODE, REGS_USBCTRL_BASE, 0x000001a8)
#define HW_USBCTRL_USBMODE_ADDR (REGS_USBCTRL_BASE + 0x000001a8)
#define BM_USBCTRL_USBMODE_VBPS 0x00000020
#define BM_USBCTRL_USBMODE_SDIS 0x00000010
#define BM_USBCTRL_USBMODE_SLOM 0x00000008
#define BM_USBCTRL_USBMODE_ES 0x00000004
#define BP_USBCTRL_USBMODE_CM      0
#define BM_USBCTRL_USBMODE_CM 0x00000003
#define BF_USBCTRL_USBMODE_CM(v)  \
	(((v) << 0) & BM_USBCTRL_USBMODE_CM)
#define BV_USBCTRL_USBMODE_CM__IDLE   0x0
#define BV_USBCTRL_USBMODE_CM__DEVICE 0x2
#define BV_USBCTRL_USBMODE_CM__HOST   0x3
HW_REGISTER_0(HW_USBCTRL_ENDPTSETUPSTAT, REGS_USBCTRL_BASE, 0x000001ac)
#define HW_USBCTRL_ENDPTSETUPSTAT_ADDR (REGS_USBCTRL_BASE + 0x000001ac)
#define BP_USBCTRL_ENDPTSETUPSTAT_ENDPTSETUPSTAT      0
#define BM_USBCTRL_ENDPTSETUPSTAT_ENDPTSETUPSTAT 0x0000001F
#define BF_USBCTRL_ENDPTSETUPSTAT_ENDPTSETUPSTAT(v)  \
	(((v) << 0) & BM_USBCTRL_ENDPTSETUPSTAT_ENDPTSETUPSTAT)
HW_REGISTER_0(HW_USBCTRL_ENDPTPRIME, REGS_USBCTRL_BASE, 0x000001b0)
#define HW_USBCTRL_ENDPTPRIME_ADDR (REGS_USBCTRL_BASE + 0x000001b0)
#define BP_USBCTRL_ENDPTPRIME_PETB      16
#define BM_USBCTRL_ENDPTPRIME_PETB 0x001F0000
#define BF_USBCTRL_ENDPTPRIME_PETB(v)  \
	(((v) << 16) & BM_USBCTRL_ENDPTPRIME_PETB)
#define BP_USBCTRL_ENDPTPRIME_PERB      0
#define BM_USBCTRL_ENDPTPRIME_PERB 0x0000001F
#define BF_USBCTRL_ENDPTPRIME_PERB(v)  \
	(((v) << 0) & BM_USBCTRL_ENDPTPRIME_PERB)
HW_REGISTER_0(HW_USBCTRL_ENDPTFLUSH, REGS_USBCTRL_BASE, 0x000001b4)
#define HW_USBCTRL_ENDPTFLUSH_ADDR (REGS_USBCTRL_BASE + 0x000001b4)
#define BP_USBCTRL_ENDPTFLUSH_FETB      16
#define BM_USBCTRL_ENDPTFLUSH_FETB 0x001F0000
#define BF_USBCTRL_ENDPTFLUSH_FETB(v)  \
	(((v) << 16) & BM_USBCTRL_ENDPTFLUSH_FETB)
#define BP_USBCTRL_ENDPTFLUSH_FERB      0
#define BM_USBCTRL_ENDPTFLUSH_FERB 0x0000001F
#define BF_USBCTRL_ENDPTFLUSH_FERB(v)  \
	(((v) << 0) & BM_USBCTRL_ENDPTFLUSH_FERB)
HW_REGISTER_0(HW_USBCTRL_ENDPTSTAT, REGS_USBCTRL_BASE, 0x000001b8)
#define HW_USBCTRL_ENDPTSTAT_ADDR (REGS_USBCTRL_BASE + 0x000001b8)
#define BP_USBCTRL_ENDPTSTAT_ETBR      16
#define BM_USBCTRL_ENDPTSTAT_ETBR 0x001F0000
#define BF_USBCTRL_ENDPTSTAT_ETBR(v)  \
	(((v) << 16) & BM_USBCTRL_ENDPTSTAT_ETBR)
#define BP_USBCTRL_ENDPTSTAT_ERBR      0
#define BM_USBCTRL_ENDPTSTAT_ERBR 0x0000001F
#define BF_USBCTRL_ENDPTSTAT_ERBR(v)  \
	(((v) << 0) & BM_USBCTRL_ENDPTSTAT_ERBR)
HW_REGISTER_0(HW_USBCTRL_ENDPTCOMPLETE, REGS_USBCTRL_BASE, 0x000001bc)
#define HW_USBCTRL_ENDPTCOMPLETE_ADDR (REGS_USBCTRL_BASE + 0x000001bc)
#define BP_USBCTRL_ENDPTCOMPLETE_ETCE      16
#define BM_USBCTRL_ENDPTCOMPLETE_ETCE 0x001F0000
#define BF_USBCTRL_ENDPTCOMPLETE_ETCE(v)  \
	(((v) << 16) & BM_USBCTRL_ENDPTCOMPLETE_ETCE)
#define BP_USBCTRL_ENDPTCOMPLETE_ERCE      0
#define BM_USBCTRL_ENDPTCOMPLETE_ERCE 0x0000001F
#define BF_USBCTRL_ENDPTCOMPLETE_ERCE(v)  \
	(((v) << 0) & BM_USBCTRL_ENDPTCOMPLETE_ERCE)
HW_REGISTER_0(HW_USBCTRL_ENDPTCTRL0, REGS_USBCTRL_BASE, 0x000001c0)
#define HW_USBCTRL_ENDPTCTRL0_ADDR (REGS_USBCTRL_BASE + 0x000001c0)
#define BM_USBCTRL_ENDPTCTRL0_TXE 0x00800000
#define BP_USBCTRL_ENDPTCTRL0_TXT      18
#define BM_USBCTRL_ENDPTCTRL0_TXT 0x000C0000
#define BF_USBCTRL_ENDPTCTRL0_TXT(v)  \
	(((v) << 18) & BM_USBCTRL_ENDPTCTRL0_TXT)
#define BV_USBCTRL_ENDPTCTRL0_TXT__CONTROL 0
#define BM_USBCTRL_ENDPTCTRL0_TXS 0x00010000
#define BM_USBCTRL_ENDPTCTRL0_RXE 0x00000080
#define BP_USBCTRL_ENDPTCTRL0_RXT      2
#define BM_USBCTRL_ENDPTCTRL0_RXT 0x0000000C
#define BF_USBCTRL_ENDPTCTRL0_RXT(v)  \
	(((v) << 2) & BM_USBCTRL_ENDPTCTRL0_RXT)
#define BV_USBCTRL_ENDPTCTRL0_RXT__CONTROL 0
#define BM_USBCTRL_ENDPTCTRL0_RXS 0x00000001
/*
 *  multi-register-define name HW_USBCTRL_ENDPTCTRLn
 *	      base 0x000001C0
 *	      count 5
 *	      offset 0x4
 */
HW_REGISTER_0_INDEXED(HW_USBCTRL_ENDPTCTRLn, REGS_USBCTRL_BASE, 0x000001c4,
		       0x4)
#define BM_USBCTRL_ENDPTCTRLn_TXE 0x00800000
#define BM_USBCTRL_ENDPTCTRLn_TXR 0x00400000
#define BM_USBCTRL_ENDPTCTRLn_TXI 0x00200000
#define BP_USBCTRL_ENDPTCTRLn_TXT      18
#define BM_USBCTRL_ENDPTCTRLn_TXT 0x000C0000
#define BF_USBCTRL_ENDPTCTRLn_TXT(v)  \
	(((v) << 18) & BM_USBCTRL_ENDPTCTRLn_TXT)
#define BV_USBCTRL_ENDPTCTRLn_TXT__CONTROL 0
#define BV_USBCTRL_ENDPTCTRLn_TXT__ISO     1
#define BV_USBCTRL_ENDPTCTRLn_TXT__BULK    2
#define BV_USBCTRL_ENDPTCTRLn_TXT__INT     3
#define BM_USBCTRL_ENDPTCTRLn_TXD 0x00020000
#define BM_USBCTRL_ENDPTCTRLn_TXS 0x00010000
#define BM_USBCTRL_ENDPTCTRLn_RXE 0x00000080
#define BM_USBCTRL_ENDPTCTRLn_RXR 0x00000040
#define BM_USBCTRL_ENDPTCTRLn_RXI 0x00000020
#define BP_USBCTRL_ENDPTCTRLn_RXT      2
#define BM_USBCTRL_ENDPTCTRLn_RXT 0x0000000C
#define BF_USBCTRL_ENDPTCTRLn_RXT(v)  \
	(((v) << 2) & BM_USBCTRL_ENDPTCTRLn_RXT)
#define BV_USBCTRL_ENDPTCTRLn_RXT__CONTROL 0
#define BV_USBCTRL_ENDPTCTRLn_RXT__ISO     1
#define BV_USBCTRL_ENDPTCTRLn_RXT__BULK    2
#define BV_USBCTRL_ENDPTCTRLn_RXT__INT     3
#define BM_USBCTRL_ENDPTCTRLn_RXD 0x00000002
#define BM_USBCTRL_ENDPTCTRLn_RXS 0x00000001
#endif /* __ARCH_ARM___USBCTRL_H */
