/*
 *  Copyright 2008-2009 Freescale Semiconductor, Inc. All Rights Reserved.
 */

/*
 * The code contained herein is licensed under the GNU General Public
 * License. You may obtain a copy of the GNU General Public License
 * Version 2 or later at the following locations:
 *
 * http://www.opensource.org/licenses/gpl-license.html
 * http://www.gnu.org/copyleft/gpl.html
 */
/*---------------------------------------------------------------------------
 * Pegatron Modify History
 *---------------------------------------------------------------------------
 * 2009/11/05  Huimin Lin - 1. add debug message
                            2. add PMIC suspend green LED
 *---------------------------------------------------------------------------
 * 2009/11/20  Eric Chou  - 1. modify
 *                          2. fine-tune
 *---------------------------------------------------------------------------
 * 2009/12/25  Huimin Lin  - 1. add 	- to disable touch wakeup
 *						 2. modify -to fix the LCD blink issue when device resumes 
 *---------------------------------------------------------------------------
 * 2010/1/4	  Huimin Lin  - 1. modify - to sync the power key wakeup and pm solution from Spider1 codebase
 *---------------------------------------------------------------------------
 * 2010/04/23             - 1. modify usb_vbus_power condition of mx51_suspend_end().
 *---------------------------------------------------------------------------
 * 2010/04/30             - 1. fixed isACadapter() -> isOtgHostMode().
 *                              VBUS supply HOST mode.
 *---------------------------------------------------------------------------
 * 2010/05/19             - 1. delete enable_usb_clock(),enable_26mhz().
 *                              -> gpio_usb_power(). 
 *---------------------------------------------------------------------------
 */

#include <linux/module.h>
#include <linux/init.h>
#include <linux/io.h>
#include <linux/kernel.h>
#include <linux/clk.h>
#include <linux/platform_device.h>
#include <linux/regulator/consumer.h>
#include <linux/suspend.h>
#include <asm/cacheflush.h>
#include <asm/tlb.h>
#include <asm/mach/map.h>
#include "crm_regs.h"


#define DRAM_TEST 1

#if DRAM_TEST
#include "iomux.h"
#include <mach/gpio.h>
#include <asm/io.h>
#endif

#if ( 1 ) // add by pega Huimin 2009.11.05 - setting PMIC
#include <linux/pmic_external.h>
#endif

#define DEBUG_TRACE        1
#if ( DEBUG_TRACE )
#define DEBUG_PRINTK(x)    printk x
#else
#define DEBUG_PRINTK(x)
#endif

//add by pega Huimin 2009.12.25, to disable the touchscreen wakeup
#define USE_TS_WAKEUP_FIX		1

//add by pega Huimin 2009.12.25, to fix the LCD blink issue when device resumes
#define USE_LCD_BLINK_FIX		1

//add by pega kevin 20100311 , to fix supend can't charge
#define ENABLE_OTG_POWER 1

#ifdef ENABLE_OTG_POWER
#include <mach/arc_otg.h>
#endif

// add by pega Eric 2009.11.20
// for normal
#define LEDG_N_PERIOD  3   // REG_LED_CTL2 = 53[13:12] = LEDGPER
#define LEDG_N_RAMP    0   // REG_LED_CTL2 = 53[14]    = LEDGRAMP
#define LEDG_N_CYCLE   32  // REG_LED_CTL2 = 53[20:15] = LEDGDC
#define LEDG_N_CURRENT 4   // REG_LED_CTL2 = 53[23:21] = LEDG
// for suspend
#define LEDG_S_PERIOD  3   // max = 3  , 0 = 1/256 , 1 = 1/8 , 2 = 1s , 3 = 2s
#define LEDG_S_RAMP    0   // max = 1  ,
#define LEDG_S_CYCLE   16  // max = 32 , 0 = 0/32 , 1 = 1/32 , 32 = 32/32
#define LEDG_S_CURRENT 4   // max = 7  , 0 = 0 mA , 1 = 3 mA , 4 = 12mA , 7 = 21 mA

static struct device *pm_dev;
struct clk *gpc_dvfs_clk;
extern void cpu_do_suspend_workaround(u32 sdclk_iomux_addr);
extern void cpu_cortexa8_do_idle(u32);

extern void usb_vbus_power(int on);
extern int  isOtgHostMode (void);

extern int iram_ready;
void *suspend_iram_base;
void (*suspend_in_iram)(u32 sdclk_iomux_addr) = NULL;

//add by pega Huimin 2009.12.25
void enable_usb_clock(int enable);
//add by pega Huimin 2010.03.08
void enable_26mhz(int enable);

//add by pega Huimin 2009.12.25, to disable the touchscreen wakeup
#if ( USE_TS_WAKEUP_FIX )
int disable_mxc_ts_int(int disable);
#endif

//add by pega Huimin 2009.12.25, to fix the LCD blink issue when device resumes
#if ( USE_LCD_BLINK_FIX )
void enable_lcd_power(int enable);
#endif

//Modify by pega Huimin 2010.1.4
#if defined(CONFIG_MACH_MX51_SENDAI)
/*
 * is_near_wakeup - check wakeup
 *  sleep -> Power-SW -> wakeup
 *   for cut Power-SW interrupt
 */
static volatile unsigned long wakeup_jiffies;
int is_near_wakeup (void)
{
	unsigned long jif = jiffies;
	unsigned long dif;

	/*
	 * check wakeup judge band time
	 */
	if (wakeup_jiffies == 0) {
		return 0;	/* no near wakeup */
	}
	if (wakeup_jiffies <= jif) {
		dif = jif - wakeup_jiffies;
	} else {
		dif = 0xffffffff - wakeup_jiffies + jif;
	}

	if (dif < (HZ * 5)) {
		return 1;	/* near wakeup(wakeup 5sec) */
	}
	wakeup_jiffies = 0;
	return 0;		/* no near wakeup */
}
#endif /* CONFIG_MACH_MX51_SENDAI */


// mx51_suspend_prepare
//
// mx51_suspend_enter
// sleep.....
// mx51_suspend_finish
// wake up ....
// mx51_suspend_end

/*
 * Called after processes are frozen, but before we shut down devices.
 */
static int mx51_suspend_prepare(void)
{
   unsigned int value;

   DEBUG_PRINTK(("[%s] \n",  __func__));

//add by pega Huimin 2009.12.25, to fix the LCD blink issue when device resumes

#if ( USE_LCD_BLINK_FIX )
 enable_lcd_power(0);
#endif

//add by pega Huimin 2009.12.25, to disable the touchscreen wakeup
#if ( USE_TS_WAKEUP_FIX )
 disable_mxc_ts_int(1);
#endif

//add by pega kevin 20100311 , fix can't charge in suspend mode
#if ( ENABLE_OTG_POWER )
 usb_vbus_power(0);
#endif

   // add by pega Huimin 2009.11.05
   // modify by pega Eric 2009.11.20 - REG_LED_CTL2 = 53[13:12]= LEDGPER , [14] = LEDGRAMP , [15:20] = LEDGDC , [23:21] = LEDG
   // modify by pega Huimin 2010.03.08
   #if ( 1 )
   value = 0;
   DEBUG_PRINTK(("REG_LED_CTL2 = reg %d = %x \n", REG_LED_CTL2, value));
   pmic_write_reg(REG_LED_CTL2, value, 0xFFF000); // only write green LED setting
   #else
// pmic_read_reg(REG_LED_CTL2, &value, 0xFFF000); // only read green LED setting
   value = ( LEDG_S_CURRENT << 21 ) + ( LEDG_S_CYCLE << 15 ) + ( LEDG_S_RAMP << 14 ) + ( LEDG_S_PERIOD << 12 );
   DEBUG_PRINTK(("REG_LED_CTL2 = reg %d = %x \n", REG_LED_CTL2, value));
   pmic_write_reg(REG_LED_CTL2, value, 0xFFF000); // only write green LED setting
   #endif

   return 0;
}

/*
 *  before we into suspend
 */
static int mx51_suspend_enter(suspend_state_t state)
{
   u32 sdclk_iomux_addr = IO_ADDRESS(IOMUXC_BASE_ADDR + 0x4b8);

   DEBUG_PRINTK(("[%s] suspend_state = %d \n",  __func__,state));

   if (gpc_dvfs_clk == NULL)
      gpc_dvfs_clk = clk_get(NULL, "gpc_dvfs_clk");
   /* gpc clock is needed for SRPG */
   clk_enable(gpc_dvfs_clk);
   switch (state) {
   case PM_SUSPEND_MEM:
//		usb_reset(0); //CONFIG_MACH_MX51_SENDAI //Modify by pega Huimin 2010.1.4
      mxc_cpu_lp_set(STOP_POWER_OFF);
      break;
   case PM_SUSPEND_STANDBY:
      mxc_cpu_lp_set(WAIT_UNCLOCKED_POWER_OFF);
      break;
   default:

 //Modify by pega Huimin 2010.1.4 	
#if defined(CONFIG_MACH_MX51_SENDAI)
		clk_disable(gpc_dvfs_clk);
#endif /* CONFIG_MACH_MX51_SENDAI */
      return -EINVAL;
   }

#if defined(CONFIG_MACH_MX51_SENDAI)
	if (tzic_enable_wake(0) != 0) {
		__raw_writel(0, MXC_SRPG_EMPGC0_SRPGCR);
		__raw_writel(0, MXC_SRPG_EMPGC1_SRPGCR);
		//usb_reset(1);
		clk_disable(gpc_dvfs_clk);
		return -EAGAIN;
	}
#else
	if (tzic_enable_wake(0) != 0)
		return -EAGAIN;
#endif /* CONFIG_MACH_MX51_SENDAI */

   if (state == PM_SUSPEND_MEM) {
   	
 //Modify by pega Huimin 2010.1.4  	
#if defined(CONFIG_MACH_MX51_SENDAI)
		wakeup_jiffies = 0;

		local_flush_tlb_all();
		flush_cache_all();
		/* Run the suspend code from iRAM. */
		suspend_in_iram(sdclk_iomux_addr);

		wakeup_jiffies = jiffies;
		if (wakeup_jiffies == 0) {
			wakeup_jiffies = 1;
		}
#else
		local_flush_tlb_all();
		flush_cache_all();

		/* Run the suspend code from iRAM. */
		suspend_in_iram(sdclk_iomux_addr);
#endif /* CONFIG_MACH_MX51_SENDAI */

      /*clear the EMPGC0/1 bits */
      __raw_writel(0, MXC_SRPG_EMPGC0_SRPGCR);
      __raw_writel(0, MXC_SRPG_EMPGC1_SRPGCR);
//		usb_reset(1); //CONFIG_MACH_MX51_SENDAI //Modify by pega Huimin 2010.1.4
   } else {
      if ((mxc_cpu_is_rev(CHIP_REV_2_0)) < 0) {
         /* do cpu_idle_workaround */
         u32 l2_iram_addr = IDLE_IRAM_BASE_ADDR;
         if (!iram_ready)
            return 0;
         if (l2_iram_addr > 0x1FFE8000)
            cpu_cortexa8_do_idle(IO_ADDRESS(l2_iram_addr));
      } else {
         cpu_do_idle();
      }
   }
   clk_disable(gpc_dvfs_clk);

//add by pega Huimin 2009.12.25
#if ( 0 )
enable_usb_clock(0);
enable_26mhz(0); //add by pega Huimin 2010.0308
#endif

   return 0;
}

/*
 * Called before devices are re-setup.
 */
static void mx51_suspend_finish(void)
{
   DEBUG_PRINTK(("[%s] \n",  __func__));

 //add by pega Huimin 2009.12.25
#if ( 0 )
enable_26mhz(1); //add by pega Huimin 2010.0308
enable_usb_clock(1);
#endif
/* Andrew20100506 - start
 *       move to mx51_suspend_finish() to fix USB storage on OTG will have new
 *       folder after resume.
 */
//add by pega kevin 20100311 , fix can't charge in suspend mode
#if ( ENABLE_OTG_POWER )

 /*
  * check AC adapter connect
  */
 if (isOtgHostMode () == 1) {
    printk("mx51_suspend_end open vbus power\n");
    usb_vbus_power(1);
 }
#endif 
/* Andrew20100506 - end */
}

/*
 * Called after devices are re-setup, but before processes are thawed.
 */
static void mx51_suspend_end(void)
{
   unsigned int value;

   DEBUG_PRINTK(("[%s] \n",  __func__));

   // add by pega Huimin 2009.11.05
   // modify by pega Eric 2009.11.20 - REG_LED_CTL2 = 53[13:12]= LEDGPER , [14] = LEDGRAMP , [15:20] = LEDGDC , [23:21] = LEDG
   #if ( 1 )
// pmic_read_reg(REG_LED_CTL2, &value, 0xFFF000); // only read green LED setting
   value = ( LEDG_N_CURRENT << 21 ) + ( LEDG_N_CYCLE << 15 ) + ( LEDG_N_RAMP << 14 ) + ( LEDG_N_PERIOD << 12 );
   DEBUG_PRINTK(("REG_LED_CTL2 = reg %d = %x \n", REG_LED_CTL2, value));
   pmic_write_reg(REG_LED_CTL2, value, 0xFFF000); // only write green LED setting
   #endif

//add by pega Huimin 2009.12.25, to disable the touchscreen wakeup
#if ( USE_TS_WAKEUP_FIX )
disable_mxc_ts_int(0);
#endif

//add by pega Huimin 2009.12.25, to fix the LCD blink issue when device resumes
#if ( USE_LCD_BLINK_FIX )
enable_lcd_power(1);
#endif

/* Andrew20100506 - start
 *       move to mx51_suspend_finish() to fix USB storage on OTG will have new
 *       folder after resume.
 */
#if 0
//add by pega kevin 20100311 , fix can't charge in suspend mode
#if ( ENABLE_OTG_POWER )

 /*
  * check AC adapter connect
  */
 if (isOtgHostMode () == 1) {
    printk("mx51_suspend_end open vbus power\n");
    usb_vbus_power(1);
 }
#endif 
/* Andrew20100506 - end */

#endif

#if ( DRAM_TEST )
   __raw_writel(0xe3 , (IO_ADDRESS(IOMUXC_BASE_ADDR) + 0x04b8)); //DRAM clock driver strength high to medium 0xE7 -> 0xE3
#endif

}

static int mx51_pm_valid(suspend_state_t state)
{
   return (state > PM_SUSPEND_ON && state <= PM_SUSPEND_MAX);
}

struct platform_suspend_ops mx51_suspend_ops = {
   .valid = mx51_pm_valid,
   .prepare = mx51_suspend_prepare,
   .enter = mx51_suspend_enter,
   .finish = mx51_suspend_finish,
   .end = mx51_suspend_end,
};


static int __devinit mx51_pm_probe(struct platform_device *pdev)
{
   pm_dev = &pdev->dev;
   return 0;
}

static struct platform_driver mx51_pm_driver = {
   .driver = {
         .name = "mx51_pm",
         },
   .probe = mx51_pm_probe,
};

static int __init pm_init(void)
{
   pr_info("Static Power Management for Freescale i.MX51\n");
   if (platform_driver_register(&mx51_pm_driver) != 0) {
      printk(KERN_ERR "mx51_pm_driver register failed\n");
      return -ENODEV;
   }
   suspend_set_ops(&mx51_suspend_ops);
   /* Move suspend routine into iRAM */
   suspend_iram_base = IO_ADDRESS(SUSPEND_IRAM_BASE_ADDR);
   memcpy(suspend_iram_base, cpu_do_suspend_workaround, SZ_4K);
   /* Need to remap the area here since we want the memory region
       to be executable. */
   suspend_iram_base = __arm_ioremap(SUSPEND_IRAM_BASE_ADDR, SZ_4K,
                              MT_HIGH_VECTORS);
   suspend_in_iram = (void *)suspend_iram_base;

   printk(KERN_INFO "PM driver module loaded\n");

   return 0;
}


static void __exit pm_cleanup(void)
{
   /* Unregister the device structure */
   platform_driver_unregister(&mx51_pm_driver);
}

module_init(pm_init);
module_exit(pm_cleanup);

MODULE_AUTHOR("Freescale Semiconductor, Inc.");
MODULE_DESCRIPTION("PM driver");
MODULE_LICENSE("GPL");

