#include <linux/module.h>
#include <linux/device.h>
#include <linux/delay.h>
#include <linux/proc_fs.h>

#define SPIDER2_KERNEL_VERSION    "2.060"
#define SPIDER2_PROC_NAME_BOOT    "ver_boot"
#define SPIDER2_PROC_NAME_KERNEL  "ver_kernel"
#define SPIDER2_PROC_NAME_SW      "sw"

/*
 * bootsw
 *  b31 -
 *  b30 -
 *  ...
 *  b03 - Board QA0    (1:QA0)
 *  b02 - have LAN-PHY (TG-board)
 *  b01 - LEFT-SW  at boot (1:ON)
 *  b00 - RIGHT-SW at boot (1:ON)
 */
static unsigned int bootsw;

/*
 * is_fec - check have CAP1014
 */
int is_fec (void)
{
	if ( bootsw & 0x0004 ) {
		return 1;
	}
	return 0;
}
EXPORT_SYMBOL(is_fec);

/*
 * is_cap1014 - check have CAP1014
 */
int is_cap1014 (void)
{
	if ( bootsw & 0x0004 ) {
		return 0;
	}
	return 1;
}
EXPORT_SYMBOL(is_cap1014);

/*
 * is_oj6sh - check have OJ6SH
 */
int is_oj6sh (void)
{
	if ( bootsw & 0x0004 ) {
		return 0;
	}
	return 1;
}
EXPORT_SYMBOL(is_oj6sh);

/*
 * is_board_qa0 - check board type QA0/TG
 */
int is_board_qa0 (void)
{
	if ( bootsw & 0x0008 ) {
		return 1;
	}
	return 0;
}
EXPORT_SYMBOL(is_board_qa0);

/*
 * bootsw - parse cmdline for bootsw=0xXXXX
 */
static int __init get_bootsw (char *str)
{
	if (str) {
		sscanf (&(str [1]), "%x", &bootsw);
	}
	return 1;
}
__setup("bootsw", get_bootsw);

/*
 * bootVer - parse cmdline for bootVer=XXXX
 */
static char spider2_ver_boot   [16];
static char spider2_ver_kernel [16];


static int bootVer_setup(char *p)
{
        memset (spider2_ver_boot, 0, sizeof(spider2_ver_boot));
        strcpy (spider2_ver_boot, p);

        memset (spider2_ver_kernel, 0, sizeof(spider2_ver_kernel));
        strcpy (spider2_ver_kernel, SPIDER2_KERNEL_VERSION);

        return 0;
}
__setup("bootVer=", bootVer_setup);

#ifdef CONFIG_PROC_FS
/*
 * spider_ver_proc_read - show version
 */
static struct proc_dir_entry *proc_spider2_ver_boot = NULL;
static struct proc_dir_entry *proc_spider2_ver_kernel = NULL;
static int spider2_ver_proc_read(char *buffer, char **start, off_t offset,
				int count, int *eof, void *data)
{
	int   len;
	char *p = buffer;

	p += sprintf(p, "%s\n", (char *) data);

	len = (p - buffer) -offset;
	if (len < 0) {
		len = 0;
	}
	*start = buffer + offset;

	return len;
}

/*
 * spider_proc_sw_read - sw information
 */

#if 0
static struct proc_dir_entry *proc_spider2_sw = NULL;
static int spider2_proc_sw_read(char *buffer, char **start, off_t offset,
			       int count, int *eof, void *data)
{
	int            len, i;
	unsigned short val = 0;
	char          *p = buffer;
	extern int get_gpio_sw_status (void);

	/*
	 *  b15 - 
	 *  b14 - 
	 *  b13 - 
	 *  b12 - 
	 *  b11 - 
	 *  b10 - 
	 *  b09 - LEFT-SW  at boot (1:ON)
	 *  b08 - RIGHT-SW at boot (1:ON)
	 *  b07 - 
	 *  b06 - BATT COMP (1:COMPLETE)
	 *  b05 - BATT CHARG(1:CHARGE)
	 *  b04 - AC adapter(1:CONNECT)
	 *  b03 - HeadPhone (1:CONNECT)
	 *  b02 - COVER-SW  (1:OPEN)
	 *  b01 - LEFT-SW   (1:ON)
	 *  b00 - RIGHT-SW  (1:ON)
	 */
	val  = (bootsw & 3) << 8;	/* boot */
	val |= get_gpio_sw_status ();	/* current sw */

	for ( i = 0 ; i < 16 ; i++ ) {
		p += sprintf (p, "%d ", (val >> (15 - i)) & 1);
	}
	p  += sprintf (p, "\n");
	len = (p - buffer) - offset;
	if (len < 0) {
		len = 0;
	}
	*start = buffer + offset;

	return len;
}
#endif

/*
 * spider_ver_setup_proc_entry - show version initialize
 */
static int spider2_ver_setup_proc_entry(void)
{
	proc_spider2_ver_boot = create_proc_entry(SPIDER2_PROC_NAME_BOOT, S_IRUGO, NULL);
	if (proc_spider2_ver_boot == NULL) {
		printk(KERN_ERR "Cannot init proc entry for spider2_ver_boot\n");
		return (-1);
	}
	proc_spider2_ver_boot->owner     = THIS_MODULE;
	proc_spider2_ver_boot->data      = (void *) spider2_ver_boot;
	proc_spider2_ver_boot->read_proc = spider2_ver_proc_read;

	proc_spider2_ver_kernel = create_proc_entry(SPIDER2_PROC_NAME_KERNEL, S_IRUGO, NULL);
	if (proc_spider2_ver_kernel == NULL) {
		printk(KERN_ERR "Cannot init proc entry for spider2_ver_kernel\n");
		return (-1);
	}
	proc_spider2_ver_kernel->owner     = THIS_MODULE;
	proc_spider2_ver_kernel->data      = (void *) spider2_ver_kernel;
	proc_spider2_ver_kernel->read_proc = spider2_ver_proc_read;

   #if 0
	proc_spider2_sw = create_proc_entry(SPIDER2_PROC_NAME_SW, S_IRUGO, NULL);
	if (proc_spider2_sw == NULL) {
		printk(KERN_ERR "Cannot init proc entry for spider2_sw\n");
		return (-1);
	}
	proc_spider2_sw->owner     = THIS_MODULE;
	proc_spider2_sw->read_proc = spider2_proc_sw_read;
   #endif

	return 0;
}
late_initcall(spider2_ver_setup_proc_entry);
#endif /* CONFIG_PROC_FS */

static int __init bootinfo_init(void)
{
	return 0;
}

static void __exit bootinfo_exit(void)
{
#ifdef CONFIG_PROC_FS
	if (proc_spider2_ver_boot != 0) {
		remove_proc_entry (SPIDER2_PROC_NAME_BOOT, proc_spider2_ver_boot);
	}
	if (proc_spider2_ver_kernel != 0) {
		remove_proc_entry (SPIDER2_PROC_NAME_KERNEL, proc_spider2_ver_kernel);
	}

   #if 0
	if (proc_spider2_sw != 0) {
		remove_proc_entry (SPIDER2_PROC_NAME_SW, proc_spider2_sw);
	}
   #endif

#endif /* CONFIG_PROC_FS */
}

module_init(bootinfo_init);
module_exit(bootinfo_exit);

MODULE_DESCRIPTION("boot information");
MODULE_AUTHOR("Nissin Systems Co.,Ltd");
MODULE_LICENSE("GPL");
