/*
 * STMP RTC Register Definitions
 *
 * Copyright 2008-2009 Freescale Semiconductor
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 */

#ifndef __ARCH_ARM___RTC_H
#define __ARCH_ARM___RTC_H  1

#include <mach/stmp3xxx_regs.h>

#define REGS_RTC_BASE (REGS_BASE + 0x5c000)
#define REGS_RTC_BASE_PHYS (0x8005C000)
#define REGS_RTC_SIZE 0x00002000
HW_REGISTER(HW_RTC_CTRL, REGS_RTC_BASE, 0x00000000)
#define HW_RTC_CTRL_ADDR (REGS_RTC_BASE + 0x00000000)
#define BM_RTC_CTRL_SFTRST 0x80000000
#define BM_RTC_CTRL_CLKGATE 0x40000000
#define BM_RTC_CTRL_SUPPRESS_COPY2ANALOG 0x00000040
#define BM_RTC_CTRL_FORCE_UPDATE 0x00000020
#define BM_RTC_CTRL_WATCHDOGEN 0x00000010
#define BM_RTC_CTRL_ONEMSEC_IRQ 0x00000008
#define BM_RTC_CTRL_ALARM_IRQ 0x00000004
#define BM_RTC_CTRL_ONEMSEC_IRQ_EN 0x00000002
#define BM_RTC_CTRL_ALARM_IRQ_EN 0x00000001
HW_REGISTER(HW_RTC_STAT, REGS_RTC_BASE, 0x00000010)
#define HW_RTC_STAT_ADDR (REGS_RTC_BASE + 0x00000010)
#define BM_RTC_STAT_RTC_PRESENT 0x80000000
#define BM_RTC_STAT_ALARM_PRESENT 0x40000000
#define BM_RTC_STAT_WATCHDOG_PRESENT 0x20000000
#define BM_RTC_STAT_XTAL32000_PRESENT 0x10000000
#define BM_RTC_STAT_XTAL32768_PRESENT 0x08000000
#define BP_RTC_STAT_STALE_REGS      16
#define BM_RTC_STAT_STALE_REGS 0x00FF0000
#define BF_RTC_STAT_STALE_REGS(v)  \
	(((v) << 16) & BM_RTC_STAT_STALE_REGS)
#define BP_RTC_STAT_NEW_REGS      8
#define BM_RTC_STAT_NEW_REGS 0x0000FF00
#define BF_RTC_STAT_NEW_REGS(v)  \
	(((v) << 8) & BM_RTC_STAT_NEW_REGS)
HW_REGISTER(HW_RTC_MILLISECONDS, REGS_RTC_BASE, 0x00000020)
#define HW_RTC_MILLISECONDS_ADDR (REGS_RTC_BASE + 0x00000020)
#define BP_RTC_MILLISECONDS_COUNT      0
#define BM_RTC_MILLISECONDS_COUNT 0xFFFFFFFF
#define BF_RTC_MILLISECONDS_COUNT(v)   (v)
HW_REGISTER(HW_RTC_SECONDS, REGS_RTC_BASE, 0x00000030)
#define HW_RTC_SECONDS_ADDR (REGS_RTC_BASE + 0x00000030)
#define BP_RTC_SECONDS_COUNT      0
#define BM_RTC_SECONDS_COUNT 0xFFFFFFFF
#define BF_RTC_SECONDS_COUNT(v)   (v)
HW_REGISTER(HW_RTC_ALARM, REGS_RTC_BASE, 0x00000040)
#define HW_RTC_ALARM_ADDR (REGS_RTC_BASE + 0x00000040)
#define BP_RTC_ALARM_VALUE      0
#define BM_RTC_ALARM_VALUE 0xFFFFFFFF
#define BF_RTC_ALARM_VALUE(v)   (v)
HW_REGISTER(HW_RTC_WATCHDOG, REGS_RTC_BASE, 0x00000050)
#define HW_RTC_WATCHDOG_ADDR (REGS_RTC_BASE + 0x00000050)
#define BP_RTC_WATCHDOG_COUNT      0
#define BM_RTC_WATCHDOG_COUNT 0xFFFFFFFF
#define BF_RTC_WATCHDOG_COUNT(v)   (v)
HW_REGISTER(HW_RTC_PERSISTENT0, REGS_RTC_BASE, 0x00000060)
#define HW_RTC_PERSISTENT0_ADDR (REGS_RTC_BASE + 0x00000060)
#define BP_RTC_PERSISTENT0_SPARE_ANALOG      18
#define BM_RTC_PERSISTENT0_SPARE_ANALOG 0xFFFC0000
#define BF_RTC_PERSISTENT0_SPARE_ANALOG(v) \
	(((v) << 18) & BM_RTC_PERSISTENT0_SPARE_ANALOG)
#define BM_RTC_PERSISTENT0_AUTO_RESTART 0x00020000
#define BM_RTC_PERSISTENT0_DISABLE_PSWITCH 0x00010000
#define BP_RTC_PERSISTENT0_LOWERBIAS      14
#define BM_RTC_PERSISTENT0_LOWERBIAS 0x0000C000
#define BF_RTC_PERSISTENT0_LOWERBIAS(v)  \
	(((v) << 14) & BM_RTC_PERSISTENT0_LOWERBIAS)
#define BM_RTC_PERSISTENT0_DISABLE_XTALOK 0x00002000
#define BP_RTC_PERSISTENT0_MSEC_RES      8
#define BM_RTC_PERSISTENT0_MSEC_RES 0x00001F00
#define BF_RTC_PERSISTENT0_MSEC_RES(v)  \
	(((v) << 8) & BM_RTC_PERSISTENT0_MSEC_RES)
#define BM_RTC_PERSISTENT0_ALARM_WAKE 0x00000080
#define BM_RTC_PERSISTENT0_XTAL32_FREQ 0x00000040
#define BM_RTC_PERSISTENT0_XTAL32KHZ_PWRUP 0x00000020
#define BM_RTC_PERSISTENT0_XTAL24MHZ_PWRUP 0x00000010
#define BM_RTC_PERSISTENT0_LCK_SECS 0x00000008
#define BM_RTC_PERSISTENT0_ALARM_EN 0x00000004
#define BM_RTC_PERSISTENT0_ALARM_WAKE_EN 0x00000002
#define BM_RTC_PERSISTENT0_CLOCKSOURCE 0x00000001
HW_REGISTER(HW_RTC_PERSISTENT1, REGS_RTC_BASE, 0x00000070)
#define HW_RTC_PERSISTENT1_ADDR (REGS_RTC_BASE + 0x00000070)
#define BP_RTC_PERSISTENT1_GENERAL      0
#define BM_RTC_PERSISTENT1_GENERAL 0xFFFFFFFF
#define BF_RTC_PERSISTENT1_GENERAL(v)   (v)
#define BV_RTC_PERSISTENT1_GENERAL__ENUMERATE_500MA_TWICE 0x1000
#define BV_RTC_PERSISTENT1_GENERAL__USB_BOOT_PLAYER_MODE  0x0800
#define BV_RTC_PERSISTENT1_GENERAL__SKIP_CHECKDISK	0x0400
#define BV_RTC_PERSISTENT1_GENERAL__USB_LOW_POWER_MODE    0x0200
#define BV_RTC_PERSISTENT1_GENERAL__OTG_HNP_BIT	   0x0100
#define BV_RTC_PERSISTENT1_GENERAL__OTG_ATL_ROLE_BIT      0x0080
HW_REGISTER(HW_RTC_PERSISTENT2, REGS_RTC_BASE, 0x00000080)
#define HW_RTC_PERSISTENT2_ADDR (REGS_RTC_BASE + 0x00000080)
#define BP_RTC_PERSISTENT2_GENERAL      0
#define BM_RTC_PERSISTENT2_GENERAL 0xFFFFFFFF
#define BF_RTC_PERSISTENT2_GENERAL(v)   (v)
HW_REGISTER(HW_RTC_PERSISTENT3, REGS_RTC_BASE, 0x00000090)
#define HW_RTC_PERSISTENT3_ADDR (REGS_RTC_BASE + 0x00000090)
#define BP_RTC_PERSISTENT3_GENERAL      0
#define BM_RTC_PERSISTENT3_GENERAL 0xFFFFFFFF
#define BF_RTC_PERSISTENT3_GENERAL(v)   (v)
HW_REGISTER(HW_RTC_PERSISTENT4, REGS_RTC_BASE, 0x000000a0)
#define HW_RTC_PERSISTENT4_ADDR (REGS_RTC_BASE + 0x000000a0)
#define BP_RTC_PERSISTENT4_GENERAL      0
#define BM_RTC_PERSISTENT4_GENERAL 0xFFFFFFFF
#define BF_RTC_PERSISTENT4_GENERAL(v)   (v)
HW_REGISTER(HW_RTC_PERSISTENT5, REGS_RTC_BASE, 0x000000b0)
#define HW_RTC_PERSISTENT5_ADDR (REGS_RTC_BASE + 0x000000b0)
#define BP_RTC_PERSISTENT5_GENERAL      0
#define BM_RTC_PERSISTENT5_GENERAL 0xFFFFFFFF
#define BF_RTC_PERSISTENT5_GENERAL(v)   (v)
HW_REGISTER(HW_RTC_DEBUG, REGS_RTC_BASE, 0x000000c0)
#define HW_RTC_DEBUG_ADDR (REGS_RTC_BASE + 0x000000c0)
#define BM_RTC_DEBUG_WATCHDOG_RESET_MASK 0x00000002
#define BM_RTC_DEBUG_WATCHDOG_RESET 0x00000001
HW_REGISTER_0(HW_RTC_VERSION, REGS_RTC_BASE, 0x000000d0)
#define HW_RTC_VERSION_ADDR (REGS_RTC_BASE + 0x000000d0)
#define BP_RTC_VERSION_MAJOR      24
#define BM_RTC_VERSION_MAJOR 0xFF000000
#define BF_RTC_VERSION_MAJOR(v) \
	(((v) << 24) & BM_RTC_VERSION_MAJOR)
#define BP_RTC_VERSION_MINOR      16
#define BM_RTC_VERSION_MINOR 0x00FF0000
#define BF_RTC_VERSION_MINOR(v)  \
	(((v) << 16) & BM_RTC_VERSION_MINOR)
#define BP_RTC_VERSION_STEP      0
#define BM_RTC_VERSION_STEP 0x0000FFFF
#define BF_RTC_VERSION_STEP(v)  \
	(((v) << 0) & BM_RTC_VERSION_STEP)
#endif /* __ARCH_ARM___RTC_H */
