/* Quanta ON9 Composite Keys Driver Header File
 *
 * Copyright (C) 2011 Quanta Computer Inc.
 * Author: Wayne Lin <wayne.lin@quantatw.com>
 *
 * This software is licensed under the terms of the GNU General Public
 * License version 2, as published by the Free Software Foundation, and
 * may be copied, distributed, and modified under those terms.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 */
#ifndef ON9_COMP_KEYS_DRV_H
#define ON9_COMP_KEYS_DRV_H
/*-----------------------------------------------------------------------------
 * Global Include files
 *---------------------------------------------------------------------------*/
#include <linux/input.h>
#include <linux/pmic_external.h>
#include <linux/miscdevice.h>

/*-----------------------------------------------------------------------------
 * Local Include files
 *---------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
 * MARCO and DEFINE
 *---------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
 * Data structure declare
 *---------------------------------------------------------------------------*/
struct pmic13892_event{
	pmic_event_callback_t event_handler;
	type_event event_type;
};

struct on9_comp_keys_drv_data {
        unsigned int gpio_hall;
        int irq_hall;
	struct platform_device *pdev;
        struct mutex lock;
	struct delayed_work workqueue;
	struct input_dev *on9kbd_dev;
	struct pmic13892_event pwr_event;
	struct miscdevice mdev;
	u8 mtp_mode;
};

/*-----------------------------------------------------------------------------
 * export symbol functions
 *---------------------------------------------------------------------------*/

#endif
