#include<glib/gi18n.h>
#include<locale.h>
#include<gtk/gtk.h>
#include<stdio.h>
#include<stdlib.h>
#include<errno.h>

#define GETTEXT_PACKAGE "launcherswitch"
#define ICON "/usr/share/icons/gnome/32x32/status/gtk-dialog-question.png"
#define ICON2 "/usr/share/pixmaps/launcherswitch.png"
char launcher;

GdkPixbuf *dialog_icon_pixbuf,*launcher_window_icon_pixbuf;

GSList 	*launcher_group = NULL;
//window;
GtkWidget *launcher_window;
GtkWidget *vbox;
//top part;
GtkWidget *top_fixed;
GtkWidget *top_label;
//center part;
GtkWidget *center_fixed;

GtkWidget *wbar_button;
GtkWidget *wbar_label;
GtkWidget *wbar_alignment;
GtkWidget *wbar_hbox;
GtkWidget *wbar_image;

GtkWidget *netbook_button;
GtkWidget *netbook_label;
GtkWidget *netbook_alignment;
GtkWidget *netbook_hbox;
GtkWidget *netbook_image;

GtkWidget *none_button;
GtkWidget *none_label;
GtkWidget *none_alignment;
GtkWidget *none_hbox;
GtkWidget *none_image;
//bottom part;
GtkWidget *bottom_fixed;
GtkWidget *bottom_label;
GtkWidget *cancel_button;
GtkWidget *ok_button;

gint wbar_response,nb_response,none_response,language_value;

//the function to close this program;
gint release_resource(GtkWidget *widget,GdkEvent *event,gpointer data)
{
	gtk_main_quit();
	return 0;
}

void check_language()
{
	char *str;
	str=getenv("LANG");
	if((strcmp(str,"ja_JP.UTF-8"))==0)
		language_value=1;
	else
		language_value=0;
}

//The following is the functions adjust the position of labels and icons;
//When select the button,display it's icon and hide the others;
void wbar_button_selected()
{
	if(language_value==1)
		gtk_alignment_set_padding (GTK_ALIGNMENT (wbar_alignment), 0, 0, 50, 0);
	else
  		gtk_alignment_set_padding (GTK_ALIGNMENT (wbar_alignment), 0, 0, 0, 5);
  	gtk_widget_show(wbar_image);
  	gtk_widget_hide(netbook_image);
  	gtk_widget_hide(none_image);
}

void wbar_button_unselected()
{
	if(language_value==1)
  		gtk_alignment_set_padding (GTK_ALIGNMENT (wbar_alignment), 0, 0, 35, 0);
  	else
  		gtk_alignment_set_padding (GTK_ALIGNMENT (wbar_alignment), 0, 0, 35, 0);
}

void netbook_button_selected()
{
  gtk_alignment_set_padding(GTK_ALIGNMENT(netbook_alignment),0,0,0,0);
  gtk_widget_show(netbook_image);
  gtk_widget_hide(wbar_image);
  gtk_widget_hide(none_image);
}

void netbook_button_unselected()
{
  gtk_alignment_set_padding (GTK_ALIGNMENT (netbook_alignment),0,0,40,0);
}

void none_button_selected()
{
  gtk_alignment_set_padding (GTK_ALIGNMENT (none_alignment),0,0,0,0);
  gtk_widget_show(none_image);
  gtk_widget_hide(wbar_image);
  gtk_widget_hide(netbook_image);
}

void none_button_unselected()
{
  gtk_alignment_set_padding (GTK_ALIGNMENT (none_alignment),0,0,25,0);
}

//The function to judge how to show the buttons;
void toggle_btn()
{
//	g_print("current launcher value :%c\n",launcher);
	if(launcher == '1')
	{
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(wbar_button),TRUE);
		gtk_widget_grab_focus(wbar_button);//set the focus on this button;
		wbar_button_selected();
		netbook_button_unselected();
		none_button_unselected();
	}
	else	if(launcher == '2')
	{
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(netbook_button),TRUE);
		gtk_widget_grab_focus(netbook_button);
		netbook_button_selected();
		wbar_button_unselected();
		none_button_unselected();
	}

	else	if(launcher == '0')
	{
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(none_button),TRUE);
		gtk_widget_grab_focus(none_button);
		none_button_selected();
		wbar_button_unselected();
		netbook_button_unselected();
	}
}

//The callback function when pressed the wbar_button;
void callback_button_wbar(GtkWidget *widget,gpointer data)
{
	if(launcher != '1')
	{
		launcher = '1';
	}
//judge to display icon or not;
	toggle_btn();
}
//The callback function when pressed the netbook_button;
void callback_button_netbook(GtkWidget *widget,gpointer data)
{
	if(launcher != '2')
	{
		launcher = '2';
	}
	toggle_btn();
}
//The callback function when pressed the none_button;
void callback_button_none(GtkWidget *widget,gpointer data)
{
	if(launcher != '0')
	{
		launcher = '0';
	}
	toggle_btn();
}
//----------------------------------------------------------
//get the default selected
void get_launcher_default()
{
    FILE *fp;
	char* home;
	
	home = getenv("HOME");

//	g_print("file launcher value :%s\n",home);	

	extern int errno;

	char filename[128];
	char tmp[128];
	memset(filename,0,128);
//	printf("file launcher value :%s.\n",home);	
	strcpy(filename,home);
	strcat(filename,"/.launcher");

//  the file exists judgement;
	if((access(filename,0))==-1)
	{
		FILE* fp;
		printf("The file is not exist!\n");
		
		sprintf(tmp,"touch %s",filename);
		system(tmp);	
//the file writing judgement;	
		if((fp=fopen(filename,"r"))==NULL)
		{
			printf("Read only file!\n");
			exit(0);
		}
		else
     	{
			launcher='1';//error handling;
			fputc(launcher,fp);
			printf("Initialising.........\n");
		}
		fclose(fp);
	}	
	else
	{
		fp=fopen(filename,"r");
	    launcher=fgetc(fp);
//judge the file whether is null;
	    if(launcher==EOF)
	    {
	    	printf("The file has nothing!");
	    }
	    else
	    	printf("ok!\n");
//	    printf("launcher is %c\n",launcher);
		fclose(fp);
	}
//judging how to display the buttons;
	toggle_btn();
}

//save the selected result;
void update_launcher_default()
{
     FILE *fp;
	char* home;
	home = getenv("HOME");

	char filename[128];
	memset(filename,0,128);
	strcpy(filename,home);
	strcat(filename,"/.launcher");

	//if((fp=fopen("/home/build/.launcher","w+")) != NULL)
	if((fp=fopen(filename,"w+")) != NULL)
	{	
		fputc(launcher,fp);
//		printf("save up-to-date:%c\n",launcher);
	}
	fclose(fp);
}
//------------------------------------------------------
//The following is the function of displaying the icons on top left corner of windows;
GdkPixbuf *create_pixbuf(const gchar * filename)
{
   GdkPixbuf *pixbuf;
   GError *error = NULL;

   pixbuf = gdk_pixbuf_new_from_file(filename, &error);

   if(!pixbuf) 
   {
      fprintf(stderr, "%s\n", error->message);
      g_error_free(error);
   }
   return pixbuf;
}
//the callback function of the cancel button of the message dialog;
void callback_nologout_button()
{
	update_launcher_default();
	exit(0);
}

void callback_logout_button()
{
	update_launcher_default();
	system("gnome-session-save --logout");
}
//the callback function of "OK(O)"button of launcher window;
//the following is for display a message dialog;
void callback_button_apply()
{
	GtkWidget *dialog; 
	GtkWidget *no_logout_button;
	GtkWidget *logout_button;
	GtkWidget *dialog_vbox;
	GtkWidget *action_area;
	GtkWidget *hbuttonbox;
	GtkWidget *no_logout_alignment;
	GtkWidget *logout_alignment;
	GtkWidget *logout_hbox;
	GtkWidget *no_logout_hbox;
	GtkWidget *logout_image;
	GtkWidget *no_logout_image;
	GtkWidget *logout_label;
	GtkWidget *no_logout_label;

	void dialog_destroy(GtkWidget *widget,gpointer data)
	{
		exit(1);
	}
// Create a message dialog;
  	dialog = gtk_message_dialog_new(GTK_WINDOW(launcher_window),
            						GTK_DIALOG_DESTROY_WITH_PARENT,
           	 						GTK_MESSAGE_QUESTION,
            						GTK_BUTTONS_NONE,
            						_("Do you want to change the setting?"));
//create a vbox on dialog;	
  	dialog_vbox = gtk_vbox_new (FALSE, 0);

//create a hbuttonbox on vbox;
  	hbuttonbox = gtk_hbutton_box_new();
  	gtk_widget_show(hbuttonbox);
 	gtk_box_pack_start(GTK_BOX(GTK_DIALOG(dialog)->action_area),hbuttonbox, TRUE, TRUE, 0);
  	gtk_button_box_set_layout(GTK_BUTTON_BOX (hbuttonbox),GTK_BUTTONBOX_SPREAD);

//add logout button to hbuttonbox;
  	logout_button = gtk_button_new();
  	gtk_widget_show(logout_button);
  	gtk_container_add(GTK_CONTAINER(hbuttonbox),logout_button);
	g_signal_connect(GTK_OBJECT(logout_button),"clicked",G_CALLBACK(callback_nologout_button),NULL);

//add no logout button to hbuttonbox;
  	no_logout_button = gtk_button_new ();
  	gtk_widget_show(no_logout_button);
  	gtk_container_add(GTK_CONTAINER(hbuttonbox), no_logout_button);
	g_signal_connect(GTK_OBJECT(no_logout_button),"clicked",G_CALLBACK(callback_logout_button),NULL);

//set focus on no_logout_button(on the right);
	gtk_widget_grab_focus(no_logout_button);

//set logout button alignment;
  	logout_alignment = gtk_alignment_new (0.5, 0.5, 0, 0);
  	gtk_widget_show (logout_alignment);
  	gtk_container_add (GTK_CONTAINER (logout_button), logout_alignment);

//set no logout button alignment;
  	no_logout_alignment = gtk_alignment_new (0.5, 0.5, 0, 0);
  	gtk_widget_show (no_logout_alignment);
  	gtk_container_add (GTK_CONTAINER (no_logout_button), no_logout_alignment);

//add logout_hbox and alignment;  
  	logout_hbox = gtk_hbox_new (FALSE, 2);
  	gtk_widget_show (logout_hbox);
  	gtk_container_add (GTK_CONTAINER(no_logout_alignment),logout_hbox);

//add nologout_hbox and alignment;
  	no_logout_hbox = gtk_hbox_new(FALSE, 2);
  	gtk_widget_show(no_logout_hbox);
  	gtk_container_add(GTK_CONTAINER(logout_alignment),no_logout_hbox);

//add logout_image ;
  	logout_image = gtk_image_new_from_stock("gtk-ok",GTK_ICON_SIZE_BUTTON);
  	gtk_widget_show(logout_image);
  	gtk_box_pack_start(GTK_BOX (logout_hbox),logout_image,FALSE,FALSE,0);

//add no logout_image;  
  	no_logout_image = gtk_image_new_from_stock("gtk-cancel",GTK_ICON_SIZE_BUTTON);
  	gtk_widget_show (no_logout_image);
  	gtk_box_pack_start (GTK_BOX(no_logout_hbox),no_logout_image,FALSE,FALSE,0);
  	
//add no_logout_button label;
  	no_logout_label = gtk_label_new_with_mnemonic(_("no logout"));
  	gtk_widget_show (no_logout_label);
  	gtk_box_pack_start (GTK_BOX(no_logout_hbox),no_logout_label,FALSE,FALSE,0);

//add logout_button_label;
  	logout_label = gtk_label_new_with_mnemonic(_("user logout now"));
  	gtk_widget_show(logout_label);
  	gtk_box_pack_start(GTK_BOX(logout_hbox),logout_label,FALSE,FALSE,0);

//add icon on top left corner;	
	dialog_icon_pixbuf = create_pixbuf(ICON);
	if(dialog_icon_pixbuf)
    {
      gtk_window_set_icon(GTK_WINDOW(dialog), dialog_icon_pixbuf);
      gdk_pixbuf_unref(dialog_icon_pixbuf);
    }
    
   	gtk_window_set_title(GTK_WINDOW(dialog), _("Message"));
 	gtk_dialog_run(GTK_DIALOG(dialog));
	
	gtk_main_quit();
}

//the main loop,and the beginning of this program;
int main(int argc,char* argv[])
{
//initialise;
	gtk_init(&argc,&argv);

//internationalization;
	setlocale(LC_ALL, "");
	bindtextdomain(GETTEXT_PACKAGE, "/usr/share/locale");
	textdomain(GETTEXT_PACKAGE);

//create a new window;
	launcher_window=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(launcher_window),_("launcher switch"));
	gtk_window_set_position(GTK_WINDOW(launcher_window),GTK_WIN_POS_CENTER);
	gtk_window_set_default_size(GTK_WINDOW(launcher_window),675, 295);
	gtk_container_set_border_width(GTK_CONTAINER(launcher_window),2);

//add icon on top left corner;	
	launcher_window_icon_pixbuf = create_pixbuf(ICON2);
	if(launcher_window_icon_pixbuf)
    {
      gtk_window_set_icon(GTK_WINDOW(launcher_window), launcher_window_icon_pixbuf);
      gdk_pixbuf_unref(launcher_window_icon_pixbuf);
    }


//create a vbox;
	vbox = gtk_vbox_new (FALSE, 0);
	gtk_widget_show (vbox);
	gtk_container_add (GTK_CONTAINER (launcher_window), vbox);

//create top fixed;
	top_fixed = gtk_fixed_new ();
	gtk_widget_show (top_fixed);
	gtk_box_pack_start (GTK_BOX (vbox), top_fixed, TRUE, TRUE, 0);
	gtk_widget_set_size_request (top_fixed, 347, 0);

//create top_label;
	top_label = gtk_label_new (_("Select the bar you want to use"));
	gtk_widget_show (top_label);
	gtk_fixed_put (GTK_FIXED (top_fixed), top_label, 150, 16);
	gtk_widget_set_size_request (top_label, 380, 24);
	gtk_label_set_justify (GTK_LABEL (top_label), GTK_JUSTIFY_CENTER);

//create center fixed;
	center_fixed = gtk_fixed_new ();
	gtk_widget_show (center_fixed);
	gtk_box_pack_start (GTK_BOX (vbox), center_fixed, FALSE, TRUE, 0);
	gtk_widget_set_size_request (center_fixed, 396, 90);

//create center buttons;
//about wbar_button
	wbar_button = gtk_radio_button_new (NULL);
  	gtk_widget_show (wbar_button);
  	gtk_fixed_put (GTK_FIXED (center_fixed), wbar_button, 6, 0);
  	gtk_widget_set_size_request (wbar_button, 220, 105);
  	gtk_radio_button_set_group (GTK_RADIO_BUTTON (wbar_button),launcher_group);
  	launcher_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (wbar_button));
  	gtk_toggle_button_set_mode (GTK_TOGGLE_BUTTON (wbar_button), FALSE);
//to adjust the position of labels and icons;
  	wbar_alignment = gtk_alignment_new (0.5, 0.5, 0, 0);
  	gtk_widget_show (wbar_alignment);
  	gtk_container_add (GTK_CONTAINER (wbar_button), wbar_alignment);
  	gtk_alignment_set_padding (GTK_ALIGNMENT (wbar_alignment), 0, 0, 9, 0);
	
  	wbar_hbox = gtk_hbox_new (FALSE, 1);
  	gtk_widget_show (wbar_hbox);
  	gtk_container_add (GTK_CONTAINER (wbar_alignment), wbar_hbox);
  	gtk_widget_set_size_request (wbar_hbox, 180, 80);

  	wbar_image = gtk_image_new_from_stock ("gtk-yes", GTK_ICON_SIZE_BUTTON);
  	gtk_widget_show (wbar_image);
  	gtk_box_pack_start (GTK_BOX (wbar_hbox), wbar_image, FALSE, FALSE, 0);
  	gtk_widget_set_size_request (wbar_image, 24, 24);

  	wbar_label = gtk_label_new_with_mnemonic (_("Wbar\n(default selected)"));
  	gtk_widget_show (wbar_label);
  	gtk_widget_set_size_request (wbar_label, 115, 80);
	if(language_value ==1)
  		gtk_box_pack_start(GTK_BOX(wbar_hbox),wbar_label,TRUE,FALSE,30);
	else
		gtk_box_pack_start (GTK_BOX(wbar_hbox),wbar_label,FALSE,FALSE,15);
  	gtk_label_set_justify (GTK_LABEL (wbar_label), GTK_JUSTIFY_CENTER);

	g_signal_connect(G_OBJECT(wbar_button),"pressed",G_CALLBACK(callback_button_wbar),NULL);

//about netbook_button;
	netbook_button = gtk_radio_button_new (NULL);
  	gtk_widget_show (netbook_button);
  	gtk_fixed_put (GTK_FIXED (center_fixed), netbook_button, 226, 0);
  	gtk_widget_set_size_request (netbook_button, 220, 105);
  	gtk_radio_button_set_group (GTK_RADIO_BUTTON (netbook_button),launcher_group);
  	launcher_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (netbook_button));
  	gtk_toggle_button_set_mode (GTK_TOGGLE_BUTTON (netbook_button), FALSE);

  	netbook_alignment = gtk_alignment_new (0.5, 0.5, 0, 0);
  	gtk_widget_show (netbook_alignment);
  	gtk_container_add (GTK_CONTAINER (netbook_button), netbook_alignment);
  	gtk_alignment_set_padding (GTK_ALIGNMENT (netbook_alignment), 0, 0, 9, 0);

  	netbook_hbox = gtk_hbox_new (FALSE, 2);
  	gtk_widget_show (netbook_hbox);
  	gtk_container_add (GTK_CONTAINER (netbook_alignment), netbook_hbox);
  	gtk_widget_set_size_request (netbook_hbox, 180, 80);

  	netbook_image = gtk_image_new_from_stock ("gtk-yes", GTK_ICON_SIZE_BUTTON);
  	gtk_widget_show (netbook_image);
  	gtk_box_pack_start (GTK_BOX (netbook_hbox), netbook_image, FALSE, FALSE, 0);
  	gtk_widget_set_size_request (netbook_image, 24, 24);

  	netbook_label = gtk_label_new_with_mnemonic (_("Ubuntu\nNetbook launcher"));
  	gtk_widget_show (netbook_label);
  	gtk_box_pack_start (GTK_BOX (netbook_hbox), netbook_label, FALSE, FALSE, 0);
  	gtk_label_set_justify (GTK_LABEL (netbook_label), GTK_JUSTIFY_CENTER);

	g_signal_connect(G_OBJECT(netbook_button),"pressed",G_CALLBACK(callback_button_netbook),NULL);

//about none_button;
	none_button = gtk_radio_button_new (NULL);
  	gtk_widget_show (none_button);
  	gtk_fixed_put (GTK_FIXED (center_fixed), none_button, 446, 0);
  	gtk_widget_set_size_request (none_button, 220, 105);
  	gtk_radio_button_set_group (GTK_RADIO_BUTTON (none_button),launcher_group);
  	launcher_group = gtk_radio_button_get_group (GTK_RADIO_BUTTON (none_button));
  	gtk_toggle_button_set_mode (GTK_TOGGLE_BUTTON (none_button), FALSE);

   	none_alignment = gtk_alignment_new (0.5, 0.5, 0, 0);
  	gtk_widget_show (none_alignment);
  	gtk_container_add (GTK_CONTAINER (none_button), none_alignment);
  	gtk_widget_set_size_request (none_alignment,200,84);
  	gtk_alignment_set_padding (GTK_ALIGNMENT (none_alignment), 0, 0, 0, 3);

  	none_hbox = gtk_hbox_new (FALSE, 0);
  	gtk_widget_show (none_hbox);
  	gtk_container_add (GTK_CONTAINER (none_alignment), none_hbox);
  	gtk_widget_set_size_request (none_hbox, 200, 80);

  	none_image = gtk_image_new_from_stock ("gtk-yes", GTK_ICON_SIZE_BUTTON);
  	gtk_widget_show (none_image);
  	gtk_box_pack_start (GTK_BOX (none_hbox), none_image, FALSE, TRUE, 0);
  	gtk_widget_set_size_request (none_image, 22, 24);

  	none_label = gtk_label_new_with_mnemonic (_("Don't use launcher"));
  	gtk_widget_show (none_label);
  	gtk_box_pack_start(GTK_BOX (none_hbox), none_label,FALSE, TRUE, 0);
  	gtk_widget_set_size_request (none_label, 164, 50);
  	gtk_label_set_justify (GTK_LABEL (none_label), GTK_JUSTIFY_LEFT);

	g_signal_connect(G_OBJECT(none_button),"pressed",G_CALLBACK(callback_button_none),NULL);

//bottom part;	
//create bottom fixed;
	bottom_fixed = gtk_fixed_new ();
	gtk_widget_show (bottom_fixed);
	gtk_box_pack_start (GTK_BOX (vbox), bottom_fixed, TRUE, TRUE, 0);
	gtk_widget_set_size_request (bottom_fixed, 390, 56);
	
//create bottom label;
	bottom_label = gtk_label_new (_("Setting will take effect after logging out"));
	gtk_widget_show (bottom_label);
	gtk_fixed_put (GTK_FIXED (bottom_fixed), bottom_label,60,30);
	gtk_widget_set_size_request (bottom_label,560,24);
	gtk_label_set_justify (GTK_LABEL (bottom_label), GTK_JUSTIFY_CENTER);

//create bottom buttons;	
	cancel_button = gtk_button_new_with_mnemonic (_("Cancel(_C)"));
	gtk_widget_show(cancel_button);
	gtk_fixed_put (GTK_FIXED (bottom_fixed), cancel_button,326,75);
	gtk_widget_set_size_request (cancel_button,150,40);
	gtk_button_set_use_underline(GTK_BUTTON(cancel_button),TRUE);
	g_signal_connect(G_OBJECT(cancel_button),"clicked",G_CALLBACK(release_resource),NULL);
	
	ok_button = gtk_button_new_with_mnemonic (_("OK(_O)"));
	gtk_widget_show(ok_button);
	gtk_fixed_put (GTK_FIXED (bottom_fixed), ok_button,490,75);
	gtk_widget_set_size_request (ok_button,150,40);	
	gtk_button_set_use_underline(GTK_BUTTON(ok_button),TRUE);
	g_signal_connect(G_OBJECT(ok_button),"clicked",G_CALLBACK(callback_button_apply),NULL);

//close function;
	g_signal_connect(G_OBJECT(launcher_window),"delete_event",G_CALLBACK(release_resource),NULL);
	gtk_widget_show(launcher_window);

//get initialised value;
	get_launcher_default();

//show all widget;


	gtk_main();

	return 0;
}
