/*
 * Copyright (C) 2009 Canonical Ltd
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as 
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 *
 */

#ifndef _NL_PIXBUF_LOADER_H_
#define _NL_PIXBUF_LOADER_H_

#include <gio/gio.h>
#include <glib.h>
#include <gtk/gtk.h>

#define NL_TYPE_PIXBUF_LOADER (nl_pixbuf_loader_get_type ())

#define NL_PIXBUF_LOADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj),\
	NL_TYPE_PIXBUF_LOADER, NlPixbufLoader))

#define NL_PIXBUF_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass),\
	NL_TYPE_PIXBUF_LOADER, NlPixbufLoaderClass))

#define NL_IS_PIXBUF_LOADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj),\
	NL_TYPE_PIXBUF_LOADER))

#define NL_IS_PIXBUF_LOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass),\
	NL_TYPE_PIXBUF_LOADER))

#define NL_PIXBUF_LOADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj),\
	NL_TYPE_PIXBUF_LOADER, NlPixbufLoaderClass))

typedef struct _NlPixbufLoader        NlPixbufLoader;
typedef struct _NlPixbufLoaderClass   NlPixbufLoaderClass;
typedef struct _NlPixbufLoaderPrivate NlPixbufLoaderPrivate;
 
struct _NlPixbufLoader
{
  GOutputStream parent;	

  NlPixbufLoaderPrivate *priv;
};

struct _NlPixbufLoaderClass
{
  GOutputStreamClass   parent_class;

  void (*completed) (NlPixbufLoader *loader, GdkPixbuf *pixbuf);
};

GType            nl_pixbuf_loader_get_type (void) G_GNUC_CONST;

NlPixbufLoader * nl_pixbuf_loader_new      (const gchar *uri);

#endif /* _NL_PIXBUF_LOADER_H_ */

