/*
 * lib/kdb5/kdb5int.h
 *
 * Copyright (C) 2008 by the Massachusetts Institute of Technology.
 * All rights reserved.
 *
 * Export of this software from the United States of America may
 *   require a specific license from the United States Government.
 *   It is the responsibility of any person or organization contemplating
 *   export to obtain such a license before exporting.
 * 
 * WITHIN THAT CONSTRAINT, permission to use, copy, modify, and
 * distribute this software and its documentation for any purpose and
 * without fee is hereby granted, provided that the above copyright
 * notice appear in all copies and that both that copyright notice and
 * this permission notice appear in supporting documentation, and that
 * the name of M.I.T. not be used in advertising or publicity pertaining
 * to distribution of the software without specific, written prior
 * permission.  Furthermore if you modify this software you must label
 * your software as modified software and not distribute it in such a
 * fashion that it might be confused with the original M.I.T. software.
 * M.I.T. makes no representations about the suitability of
 * this software for any purpose.  It is provided "as is" without express
 * or implied warranty.
 * 
 *
 * Private header file for the kdb5 library for internal functions
 */

#ifndef __KDB5INT_H__
#define __KDB5INT_H__

#include "kdb5.h"

krb5_error_code
krb5int_put_principal_no_log(krb5_context kcontext,
			     krb5_db_entry *entries, int *nentries);

krb5_error_code
krb5int_delete_principal_no_log(krb5_context kcontext,
				krb5_principal search_for,
				int *nentries);

#endif /* __KDB5INT_H__ */
