#include<glib/gi18n.h>
#include<locale.h>
#include<gtk/gtk.h>
#include<stdio.h>
#include<stdlib.h>
#include<gconf/gconf-client.h>
#include<string.h>


#define GETTEXT_PACKAGE "keysetup"

#define LEFT_S  "/spider/key_setting/left_key_short_press"
#define LEFT_L  "/spider/key_setting/left_key_long_press"
#define RIGHT_S "/spider/key_setting/right_key_short_press"
#define RIGHT_L "/spider/key_setting/right_key_long_press"
#define BOTH_S  "/spider/key_setting/both_key_short_press"
#define BOTH_L  "/spider/key_setting/both_key_long_press"

#define ICON "/usr/share/pixmaps/keysetup.png"

GtkWidget *wnd;
GtkWidget *fixed;

GdkPixbuf *wnd_icon_pixbuf;

GtkWidget *short_press_label;
GtkWidget *long_press_label;
GtkWidget *left_hw_key_label;
GtkWidget *right_hw_key_label;
GtkWidget *both_hw_key_label;

GtkWidget *left_key_short_press;
GtkWidget *left_key_long_press;
GtkWidget *right_key_short_press;
GtkWidget *right_key_long_press;
GtkWidget *both_key_short_press;
GtkWidget *both_key_long_press;
GConfClient *client;

GtkWidget *initialize_button;
GtkWidget *close_button;

static gint left_short,left_long,right_short,right_long,both_short,both_long,language;
static gint val_left_short,val_left_long,val_right_short,val_right_long,val_both_short,val_both_long;

void save_result();

void left_short_default()
{
	GConfValue *left_short;
	
	if((left_short=gconf_client_get(client,LEFT_S,NULL))==NULL)
		gtk_combo_box_set_active(GTK_COMBO_BOX(left_key_short_press),0);
	else 
	{
		val_left_short = gconf_client_get_int(client,LEFT_S,NULL);
		gtk_combo_box_set_active(GTK_COMBO_BOX(left_key_short_press), val_left_short);
	}
}

void left_long_default()
{
	GConfValue *left_long;
	
	if((left_long=gconf_client_get(client,LEFT_L,NULL))==NULL)
		gtk_combo_box_set_active(GTK_COMBO_BOX(left_key_long_press),0);
	else 
	{
		val_left_long = gconf_client_get_int(client,LEFT_L,NULL);
		gtk_combo_box_set_active(GTK_COMBO_BOX(left_key_long_press), val_left_long);
	}
}

void right_short_default()
{
	GConfValue *right_short;
	
	if((right_short=gconf_client_get(client,RIGHT_S,NULL))==NULL)
		gtk_combo_box_set_active(GTK_COMBO_BOX(right_key_short_press),1);
	else 
	{
		val_right_short = gconf_client_get_int(client,RIGHT_S,NULL);
		gtk_combo_box_set_active(GTK_COMBO_BOX(right_key_short_press), val_right_short);
	}
}

void right_long_default()
{
	GConfValue *right_long;
	
	if((right_long=gconf_client_get(client,RIGHT_L,NULL))==NULL)
		gtk_combo_box_set_active(GTK_COMBO_BOX(right_key_long_press),5);
	else 
	{
		val_right_long = gconf_client_get_int(client,RIGHT_L,NULL);
		gtk_combo_box_set_active(GTK_COMBO_BOX(right_key_long_press), val_right_long);
	}
}

void both_short_default()
{
	GConfValue *both_short;
	
	if((both_short=gconf_client_get(client,BOTH_S,NULL))==NULL)
		gtk_combo_box_set_active(GTK_COMBO_BOX(both_key_short_press),6);
	else 
	{
		val_both_short = gconf_client_get_int(client,BOTH_S,NULL);
		gtk_combo_box_set_active(GTK_COMBO_BOX(both_key_short_press), val_both_short);
	}
}

void both_long_default()
{
	GConfValue *both_long;
	
	if((both_long=gconf_client_get(client,BOTH_L,NULL))==NULL)
		gtk_combo_box_set_active(GTK_COMBO_BOX(both_key_long_press),9);
	else 
	{
		val_both_long = gconf_client_get_int(client,BOTH_L,NULL);
		gtk_combo_box_set_active(GTK_COMBO_BOX(both_key_long_press), val_both_long);
	}
}

void default_result()
{
	left_short_default();
	left_long_default();
	right_short_default();
	right_long_default();
	both_short_default();
	both_long_default();
}

void set_result()
{
	left_short=gtk_combo_box_get_active(GTK_COMBO_BOX(left_key_short_press));
	left_long=gtk_combo_box_get_active(GTK_COMBO_BOX(left_key_long_press));
	right_short=gtk_combo_box_get_active(GTK_COMBO_BOX(right_key_short_press));
	right_long=gtk_combo_box_get_active(GTK_COMBO_BOX(right_key_long_press));
	both_short=gtk_combo_box_get_active(GTK_COMBO_BOX(both_key_short_press));
	both_long=gtk_combo_box_get_active(GTK_COMBO_BOX(both_key_long_press));
	save_result();
}

void save_result()
{
	gconf_client_set_int(client,LEFT_S,left_short,NULL);
	gconf_client_set_int(client,LEFT_L,left_long,NULL);
	gconf_client_set_int(client,RIGHT_S,right_short,NULL);
	gconf_client_set_int(client,RIGHT_L,right_long,NULL);
	gconf_client_set_int(client,BOTH_S,both_short,NULL);
	gconf_client_set_int(client,BOTH_L,both_long,NULL);
}

static gboolean release_resource(GtkWidget* widget,GdkEvent* event,gpointer data)
{
	set_result();
	gtk_main_quit();
	return FALSE;
}

void initialization()
{
	gtk_combo_box_set_active(GTK_COMBO_BOX(left_key_short_press),0);
	gtk_combo_box_set_active(GTK_COMBO_BOX(left_key_long_press),0);
	gtk_combo_box_set_active(GTK_COMBO_BOX(right_key_short_press),1);
	gtk_combo_box_set_active(GTK_COMBO_BOX(right_key_long_press),5);
	gtk_combo_box_set_active(GTK_COMBO_BOX(both_key_short_press),6);
	gtk_combo_box_set_active(GTK_COMBO_BOX(both_key_long_press),9);
}

void get_env()
{
	char* string;
	char cmp;
	string=getenv("LANG");

	if(((cmp=strcmp(string,"ja_JP.UTF-8"))==0)||((cmp=strcmp(string,"zh_CN.UTF-8"))==0))
		language=1;
}

//about icon on top left corner;	
GdkPixbuf *create_pixbuf(const gchar * filename)
{
   GdkPixbuf *pixbuf;
   GError *error = NULL;

   pixbuf = gdk_pixbuf_new_from_file(filename, &error);

   if(!pixbuf) 
   {
      fprintf(stderr, "%s\n", error->message);
      g_error_free(error);
   }
   return pixbuf;
}

//main loop;
int main(int argc,char* argv[])
{
	
	gtk_init(&argc,&argv);
	get_env();//get the $LANG
	static GMainLoop *main_loop = NULL;
	gconf_init(argc, argv, NULL);
	client = gconf_client_get_default();

	setlocale(LC_ALL, "");
	bindtextdomain(GETTEXT_PACKAGE, "/usr/share/locale");
	textdomain(GETTEXT_PACKAGE);

	wnd=gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(wnd),_("H/W Key Setup Utility"));
	gtk_window_set_resizable(GTK_WINDOW(wnd),FALSE);
	gtk_window_set_default_size(GTK_WINDOW(wnd),240,70);
	gtk_window_set_position(GTK_WINDOW(wnd),GTK_WIN_POS_CENTER);
	gtk_container_set_border_width(GTK_CONTAINER(wnd),10);

//add icon on top left corner;	
	wnd_icon_pixbuf = create_pixbuf(ICON);
	if(wnd_icon_pixbuf)
    {
      gtk_window_set_icon(GTK_WINDOW(wnd), wnd_icon_pixbuf);
      gdk_pixbuf_unref(wnd_icon_pixbuf);
    }

//create a fixed
	fixed=gtk_fixed_new();
	gtk_widget_show(fixed);
	gtk_container_add(GTK_CONTAINER(wnd),fixed);

//left_key_short_press;
	left_key_short_press=gtk_combo_box_new_text();
	gtk_widget_show(left_key_short_press);
	gtk_widget_set_size_request(left_key_short_press,235,32);
	gtk_combo_box_append_text(GTK_COMBO_BOX(left_key_short_press),_("Left Mouse Button"));
	gtk_combo_box_append_text(GTK_COMBO_BOX(left_key_short_press),_("Right Mouse Button"));
	gtk_combo_box_append_text(GTK_COMBO_BOX(left_key_short_press),_("Middle Mouse Button"));
	gtk_combo_box_append_text(GTK_COMBO_BOX(left_key_short_press),_("Alt Key"));
	gtk_combo_box_append_text(GTK_COMBO_BOX(left_key_short_press),_("Ctrl Key"));
	gtk_combo_box_append_text(GTK_COMBO_BOX(left_key_short_press),_("Change Optical point mode"));
	gtk_combo_box_append_text(GTK_COMBO_BOX(left_key_short_press),_("Display the desktop"));
	gtk_combo_box_append_text(GTK_COMBO_BOX(left_key_short_press),_("Device Setup Utility"));
	gtk_combo_box_append_text(GTK_COMBO_BOX(left_key_short_press),_("Keyboard"));
	gtk_combo_box_append_text(GTK_COMBO_BOX(left_key_short_press),_("None"));

//left_key_long_press;
	left_key_long_press=gtk_combo_box_new_text();
	gtk_widget_show(left_key_long_press);
	gtk_widget_set_size_request(left_key_long_press,235,32);
	gtk_combo_box_append_text(GTK_COMBO_BOX(left_key_long_press),_("Left Mouse Button"));
	gtk_combo_box_append_text(GTK_COMBO_BOX(left_key_long_press),_("Right Mouse Button"));
	gtk_combo_box_append_text(GTK_COMBO_BOX(left_key_long_press),_("Middle Mouse Button"));
	gtk_combo_box_append_text(GTK_COMBO_BOX(left_key_long_press),_("Alt Key"));
	gtk_combo_box_append_text(GTK_COMBO_BOX(left_key_long_press),_("Ctrl Key"));
	gtk_combo_box_append_text(GTK_COMBO_BOX(left_key_long_press),_("Change Optical point mode"));
	gtk_combo_box_append_text(GTK_COMBO_BOX(left_key_long_press),_("Display the desktop"));
	gtk_combo_box_append_text(GTK_COMBO_BOX(left_key_long_press),_("Device Setup Utility"));
	gtk_combo_box_append_text(GTK_COMBO_BOX(left_key_long_press),_("Keyboard"));
	gtk_combo_box_append_text(GTK_COMBO_BOX(left_key_long_press),_("None"));

//right_key_short_press;
	right_key_short_press=gtk_combo_box_new_text();
	gtk_widget_show(right_key_short_press);
	gtk_widget_set_size_request(right_key_short_press,235,32);
	gtk_combo_box_append_text(GTK_COMBO_BOX(right_key_short_press),_("Left Mouse Button"));
	gtk_combo_box_append_text(GTK_COMBO_BOX(right_key_short_press),_("Right Mouse Button"));
	gtk_combo_box_append_text(GTK_COMBO_BOX(right_key_short_press),_("Middle Mouse Button"));
	gtk_combo_box_append_text(GTK_COMBO_BOX(right_key_short_press),_("Alt Key"));
	gtk_combo_box_append_text(GTK_COMBO_BOX(right_key_short_press),_("Ctrl Key"));
	gtk_combo_box_append_text(GTK_COMBO_BOX(right_key_short_press),_("Change Optical point mode"));
	gtk_combo_box_append_text(GTK_COMBO_BOX(right_key_short_press),_("Display the desktop"));
	gtk_combo_box_append_text(GTK_COMBO_BOX(right_key_short_press),_("Device Setup Utility"));
	gtk_combo_box_append_text(GTK_COMBO_BOX(right_key_short_press),_("Keyboard"));
	gtk_combo_box_append_text(GTK_COMBO_BOX(right_key_short_press),_("None"));

//right_key_long_press;
	right_key_long_press=gtk_combo_box_new_text();
	gtk_widget_show(right_key_long_press);
	gtk_widget_set_size_request(right_key_long_press,235,32);
	gtk_combo_box_append_text(GTK_COMBO_BOX(right_key_long_press),_("Left Mouse Button"));
	gtk_combo_box_append_text(GTK_COMBO_BOX(right_key_long_press),_("Right Mouse Button"));
	gtk_combo_box_append_text(GTK_COMBO_BOX(right_key_long_press),_("Middle Mouse Button"));
	gtk_combo_box_append_text(GTK_COMBO_BOX(right_key_long_press),_("Alt Key"));
	gtk_combo_box_append_text(GTK_COMBO_BOX(right_key_long_press),_("Ctrl Key"));
	gtk_combo_box_append_text(GTK_COMBO_BOX(right_key_long_press),_("Change Optical point mode"));
	gtk_combo_box_append_text(GTK_COMBO_BOX(right_key_long_press),_("Display the desktop"));
	gtk_combo_box_append_text(GTK_COMBO_BOX(right_key_long_press),_("Device Setup Utility"));
	gtk_combo_box_append_text(GTK_COMBO_BOX(right_key_long_press),_("Keyboard"));
	gtk_combo_box_append_text(GTK_COMBO_BOX(right_key_long_press),_("None"));

//both_key_short_press;
	both_key_short_press=gtk_combo_box_new_text();
	gtk_widget_show(both_key_short_press);
	gtk_widget_set_size_request(both_key_short_press,235,32);
	gtk_combo_box_append_text(GTK_COMBO_BOX(both_key_short_press),_("Left Mouse Button"));
	gtk_combo_box_append_text(GTK_COMBO_BOX(both_key_short_press),_("Right Mouse Button"));
	gtk_combo_box_append_text(GTK_COMBO_BOX(both_key_short_press),_("Middle Mouse Button"));
	gtk_combo_box_append_text(GTK_COMBO_BOX(both_key_short_press),_("Alt Key"));
	gtk_combo_box_append_text(GTK_COMBO_BOX(both_key_short_press),_("Ctrl Key"));
	gtk_combo_box_append_text(GTK_COMBO_BOX(both_key_short_press),_("Change Optical point mode"));
	gtk_combo_box_append_text(GTK_COMBO_BOX(both_key_short_press),_("Display the desktop"));
	gtk_combo_box_append_text(GTK_COMBO_BOX(both_key_short_press),_("Device Setup Utility"));
	gtk_combo_box_append_text(GTK_COMBO_BOX(both_key_short_press),_("Keyboard"));
	gtk_combo_box_append_text(GTK_COMBO_BOX(both_key_short_press),_("None"));

//both_key_long_press;
	both_key_long_press=gtk_combo_box_new_text();
	gtk_widget_show(both_key_long_press);
	gtk_widget_set_size_request(both_key_long_press,235,32);
	gtk_combo_box_append_text(GTK_COMBO_BOX(both_key_long_press),_("Left Mouse Button"));
	gtk_combo_box_append_text(GTK_COMBO_BOX(both_key_long_press),_("Right Mouse Button"));
	gtk_combo_box_append_text(GTK_COMBO_BOX(both_key_long_press),_("Middle Mouse Button"));
	gtk_combo_box_append_text(GTK_COMBO_BOX(both_key_long_press),_("Alt Key"));
	gtk_combo_box_append_text(GTK_COMBO_BOX(both_key_long_press),_("Ctrl Key"));
	gtk_combo_box_append_text(GTK_COMBO_BOX(both_key_long_press),_("Change Optical point mode"));
	gtk_combo_box_append_text(GTK_COMBO_BOX(both_key_long_press),_("Display the desktop"));
	gtk_combo_box_append_text(GTK_COMBO_BOX(both_key_long_press),_("Device Setup Utility"));
	gtk_combo_box_append_text(GTK_COMBO_BOX(both_key_long_press),_("Keyboard"));
	gtk_combo_box_append_text(GTK_COMBO_BOX(both_key_long_press),_("None"));

//initialize_button;
	initialize_button = gtk_button_new_with_mnemonic (_("Default"));
	gtk_widget_show (initialize_button);
	gtk_fixed_put (GTK_FIXED (fixed), initialize_button, 10, 135);
	gtk_widget_set_size_request (initialize_button, 200, 32);
	g_signal_connect(GTK_OBJECT(initialize_button),"pressed",G_CALLBACK(initialization),NULL);

//close_button;
	close_button = gtk_button_new_with_mnemonic (_("Close(_C)"));
	gtk_widget_show (close_button);
	gtk_widget_set_size_request (close_button, 200, 32);
	g_signal_connect(GTK_OBJECT(close_button),"clicked",G_CALLBACK(release_resource),NULL);

//short_press_label;
	short_press_label=gtk_label_new(_("Short Press"));
	gtk_widget_show(short_press_label);
	gtk_widget_set_size_request(short_press_label,110,17);

//long_press_label;
	long_press_label=gtk_label_new(_("Long Press"));
	gtk_widget_show(long_press_label);
	gtk_widget_set_size_request(long_press_label,110,17);

//left_hw_key_label;
	left_hw_key_label=gtk_label_new(_("Left H/W Key"));
	gtk_widget_show(left_hw_key_label);
	gtk_fixed_put(GTK_FIXED(fixed),left_hw_key_label,10,34);
	gtk_widget_set_size_request(left_hw_key_label,110,17);
	gtk_misc_set_alignment(GTK_MISC(left_hw_key_label),0,0.5);

//right_hw_key_label;
	right_hw_key_label=gtk_label_new(_("Right H/W Key"));
	gtk_widget_show(right_hw_key_label);
	gtk_fixed_put(GTK_FIXED(fixed),right_hw_key_label,10,66);
	gtk_widget_set_size_request(right_hw_key_label,110,17);
	gtk_misc_set_alignment(GTK_MISC(right_hw_key_label),0,0.5);

//both_hw_key_label;
	both_hw_key_label=gtk_label_new(_("Left and Right Keys"));
	gtk_widget_show(both_hw_key_label);
	gtk_fixed_put(GTK_FIXED(fixed),both_hw_key_label,10,98);
	gtk_widget_set_size_request(both_hw_key_label,180,17);
	gtk_misc_set_alignment(GTK_MISC(both_hw_key_label),0,0.5);

//reset size and postion according to the language evironment;
	if(language==1)
	{
		gtk_fixed_put(GTK_FIXED(fixed),left_key_short_press,90,28);
		gtk_fixed_put(GTK_FIXED(fixed),left_key_long_press,320,28);
		gtk_fixed_put(GTK_FIXED(fixed),right_key_short_press,90,60);
		gtk_fixed_put(GTK_FIXED(fixed),right_key_long_press,320,60);
		gtk_fixed_put(GTK_FIXED(fixed),both_key_short_press,90,92);
		gtk_fixed_put(GTK_FIXED(fixed),both_key_long_press,320,92);
		gtk_fixed_put (GTK_FIXED (fixed), close_button, 340, 135);
		gtk_fixed_put(GTK_FIXED(fixed),short_press_label,145,8);
		gtk_fixed_put(GTK_FIXED(fixed),long_press_label,384,8);
	}
	else
	{
		gtk_fixed_put(GTK_FIXED(fixed),left_key_short_press,165,28);
		gtk_fixed_put(GTK_FIXED(fixed),left_key_long_press,400,28);
		gtk_fixed_put(GTK_FIXED(fixed),right_key_short_press,165,60);
		gtk_fixed_put(GTK_FIXED(fixed),right_key_long_press,400,60);
		gtk_fixed_put(GTK_FIXED(fixed),both_key_short_press,165,92);
		gtk_fixed_put(GTK_FIXED(fixed),both_key_long_press,400,92);
		gtk_fixed_put (GTK_FIXED (fixed), close_button, 425, 135);
		gtk_fixed_put(GTK_FIXED(fixed),short_press_label,220,8);
		gtk_fixed_put(GTK_FIXED(fixed),long_press_label,450,8);
	}

	g_signal_connect(G_OBJECT(wnd),"delete_event",G_CALLBACK(release_resource),NULL);
	
	default_result();
	
	gtk_widget_show_all(wnd);

	gtk_main();
	
	return 0;
}
