/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */

/*
 *  Copyright (C) 2003 Hiroyuki Ikezoe
 *  Copyright (C) 2003 Takuro Ashie
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 *  $Id: kz-bookmark.h 2819 2007-01-20 05:09:01Z kous $
 */

#include "kz-bookmark-utils.h"

#include <glib/gi18n.h>
#include <string.h>

#include "kz-bookmark-file.h"

KzBookmark *
kz_bookmark_create_from_selection_data (GtkSelectionData *seldata)
{
	KzBookmark *bookmark;
	gchar **strings = NULL; 
	gchar *utf8_title = NULL;
	const gchar *title;

	if (seldata->length < 0)
		return NULL;

	strings = g_strsplit((const gchar*)seldata->data, "\n", 2);
	if (!strings)
		return NULL;

	if (strings[1] != NULL)
	{
		utf8_title = g_locale_to_utf8(strings[1],
					      strlen(strings[1]),
					      NULL,
					      NULL,
					      NULL);
	}
	if (utf8_title && g_utf8_validate(utf8_title, -1, NULL))
		title = utf8_title;
	else 
		title = _("title");

	/* FIXME! we should also add normal bookmark. */
	/* Create New KzBookmark */
	if (strstr(strings[0], "xml") ||
	    strstr(strings[0], "rss") ||
	    strstr(strings[0], "rdf"))
	{
		bookmark = KZ_BOOKMARK(kz_bookmark_file_new(strings[0],
					title,
					NULL));
	}
	else
	{
		bookmark = kz_bookmark_new_with_attrs(title, strings[0], NULL);
	}
	g_strfreev(strings);
	g_free(utf8_title);
	return bookmark;
}
