/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/* ***** BEGIN LICENSE BLOCK *****
 * Version: MPL 1.1/GPL 2.0/LGPL 2.1
 *
 * The contents of this file are subject to the Mozilla Public License Version
 * 1.1 (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 * http://www.mozilla.org/MPL/
 *
 * Software distributed under the License is distributed on an "AS IS" basis,
 * WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
 * for the specific language governing rights and limitations under the
 * License.
 *
 * The Original Code is mozilla.org code.
 *
 * The Initial Developer of the Original Code is
 * Netscape Communications Corporation.
 * Portions created by the Initial Developer are Copyright (C) 2003
 * the Initial Developer. All Rights Reserved.
 *
 * Contributor(s):
 *  Brian Ryner <bryner@brianryner.com>
 *
 * Alternatively, the contents of this file may be used under the terms of
 * either the GNU General Public License Version 2 or later (the "GPL"), or
 * the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
 * in which case the provisions of the GPL or the LGPL are applicable instead
 * of those above. If you wish to allow use of your version of this file only
 * under the terms of either the GPL or the LGPL, and not to allow others to
 * use your version of this file under the terms of the MPL, indicate your
 * decision by deleting the provisions above and replace them with the notice
 * and other provisions required by the GPL or the LGPL. If you do not delete
 * the provisions above, a recipient may use your version of this file under
 * the terms of any one of the MPL, the GPL or the LGPL.
 *
 * ***** END LICENSE BLOCK ***** */

#include "GtkPromptService.h"
#include <nsIWindowWatcher.h>
#include <nsIWebBrowserChrome.h>
#include <nsIEmbeddingSiteWindow.h>
#include <nsCOMPtr.h>
#include <nsIServiceManager.h>

#include <nsIDOMDocument.h>
#include <nsIDOM3Document.h>
#include <nsIDOMWindow.h>
#include <nsIDOMCharacterData.h>
#include <nsIDOMText.h>
#include <nsMemory.h>

#include <glib/gi18n.h>
#include "kz-prompt-dialog.h"

#include "kz-mozutils.h"

static void
kz_prompt_dialog_set_check_box(KzPromptDialog *prompt,
                               const PRUnichar* aCheckMsg,
                               PRBool* aCheckValue)
{
    if (!aCheckMsg || !aCheckValue) return;

	nsEmbedCString cCheckMsg;
	NS_UTF16ToCString(nsEmbedString(aCheckMsg),
                      NS_CSTRING_ENCODING_UTF8, cCheckMsg);

	kz_prompt_dialog_set_check_message(prompt, cCheckMsg.get());
	kz_prompt_dialog_set_check_value(prompt, *aCheckValue);
}

static void
kz_prompt_dialog_get_check_box_value(KzPromptDialog *prompt,
                                     PRBool* aCheckValue)
{
    if (!aCheckValue) return;

	*aCheckValue = kz_prompt_dialog_get_check_value(prompt);
}



GtkPromptService::GtkPromptService()
{
}

GtkPromptService::~GtkPromptService()
{
}


NS_IMPL_ISUPPORTS1(GtkPromptService, nsIPromptService)

NS_IMETHODIMP
GtkPromptService::Alert(nsIDOMWindow* aParent, const PRUnichar* aDialogTitle, 
		const PRUnichar* aDialogText)
{
	nsEmbedCString cText, cTitle;
	NS_UTF16ToCString(nsEmbedString(aDialogText),
			  NS_CSTRING_ENCODING_UTF8, cText);
	NS_UTF16ToCString(nsEmbedString(aDialogTitle),
			  NS_CSTRING_ENCODING_UTF8, cTitle);
	
        if ((strstr(cText.get(), "print preview")) ||
	    (strstr(cTitle.get(), "Printer Error")))
	{
		return NS_OK;
	}
#if 0
	nsCOMPtr<nsIDOMDocument> domDoc;
	aParent->GetDocument(getter_AddRefs(domDoc));

	nsAutoString data;
	data.Assign(aDialogText);
	nsCOMPtr<nsIDOMText> text;
	domDoc->CreateTextNode(data, getter_AddRefs(text));
	nsCOMPtr<nsIDOMCharacterData> c;
	c = do_QueryInterface(text);
	c->SetData(data);
#endif
	KzPromptDialog *prompt = KZ_PROMPT_DIALOG(kz_prompt_dialog_new_with_parent
	    						(TYPE_ALERT,
	    					         GTK_WINDOW(GetGtkWindowForDOMWindow(aParent))));
	gchar *host = GetURIForDOMWindow(aParent);
	kz_prompt_dialog_set_host (prompt, host);
	if (host)
		g_free(host);
	kz_prompt_dialog_set_title(prompt,
	    			   aDialogTitle ? cTitle.get() : _("Alert"));
	kz_prompt_dialog_set_message_text(prompt, cText.get());
	kz_prompt_dialog_run(prompt);
	gtk_widget_destroy(GTK_WIDGET(prompt));
	return NS_OK;
}

NS_IMETHODIMP
GtkPromptService::AlertCheck(nsIDOMWindow* aParent,
		const PRUnichar* aDialogTitle,
		const PRUnichar* aDialogText,
		const PRUnichar* aCheckMsg, PRBool* aCheckValue)
{
	nsEmbedCString cText, cTitle;
	NS_UTF16ToCString(nsEmbedString(aDialogText),
			  NS_CSTRING_ENCODING_UTF8, cText);
	NS_UTF16ToCString(nsEmbedString(aDialogTitle),
			  NS_CSTRING_ENCODING_UTF8, cTitle);

	KzPromptDialog *prompt = KZ_PROMPT_DIALOG(kz_prompt_dialog_new_with_parent
	    						(TYPE_ALERT_CHECK,
	    					         GTK_WINDOW(GetGtkWindowForDOMWindow(aParent))));
	gchar *host = GetURIForDOMWindow(aParent);
	kz_prompt_dialog_set_host (prompt, host);
	if (host)
		g_free(host);
	kz_prompt_dialog_set_title(prompt,
	    			   aDialogTitle ? cTitle.get() : _("Alert"));
	kz_prompt_dialog_set_message_text(prompt, cText.get());
	kz_prompt_dialog_set_check_box(prompt, aCheckMsg, aCheckValue);
	kz_prompt_dialog_run(prompt);
	kz_prompt_dialog_get_check_box_value(prompt, aCheckValue);
	gtk_widget_destroy(GTK_WIDGET(prompt));
	return NS_OK;
}

NS_IMETHODIMP
GtkPromptService::Confirm(nsIDOMWindow* aParent,
		const PRUnichar* aDialogTitle,
		const PRUnichar* aDialogText, PRBool* aConfirm)
{
	nsEmbedCString cText, cTitle;
	NS_UTF16ToCString(nsEmbedString(aDialogText),
			  NS_CSTRING_ENCODING_UTF8, cText);
	NS_UTF16ToCString(nsEmbedString(aDialogTitle),
			  NS_CSTRING_ENCODING_UTF8, cTitle);
	KzPromptDialog *prompt = KZ_PROMPT_DIALOG(kz_prompt_dialog_new_with_parent
	    						(TYPE_CONFIRM,
	    					         GTK_WINDOW(GetGtkWindowForDOMWindow(aParent))));
	gchar *host = GetURIForDOMWindow(aParent);
	kz_prompt_dialog_set_host (prompt, host);
	if (host)
		g_free(host);
	kz_prompt_dialog_set_title(prompt,
	    			   aDialogTitle ? cTitle.get() : _("Confirm"));
	kz_prompt_dialog_set_message_text(prompt, cText.get());
	kz_prompt_dialog_run(prompt);
	*aConfirm = kz_prompt_dialog_get_confirm_value(prompt);
	gtk_widget_destroy(GTK_WIDGET(prompt));
	return NS_OK;
}

NS_IMETHODIMP
GtkPromptService::ConfirmCheck(nsIDOMWindow* aParent,
		const PRUnichar* aDialogTitle,
		const PRUnichar* aDialogText,
		const PRUnichar* aCheckMsg,
		PRBool* aCheckValue, PRBool* aConfirm)
{
	nsEmbedCString cText, cTitle;
	NS_UTF16ToCString(nsEmbedString(aDialogText),
			  NS_CSTRING_ENCODING_UTF8, cText);
	NS_UTF16ToCString(nsEmbedString(aDialogTitle),
			  NS_CSTRING_ENCODING_UTF8, cTitle);

	KzPromptDialog *prompt = KZ_PROMPT_DIALOG(kz_prompt_dialog_new_with_parent
	    						(TYPE_CONFIRM_CHECK,
	    					         GTK_WINDOW(GetGtkWindowForDOMWindow(aParent))));
	gchar *host = GetURIForDOMWindow(aParent);
	kz_prompt_dialog_set_host (prompt, host);
	if (host)
		g_free(host);
	kz_prompt_dialog_set_title(prompt,
	    			   aDialogTitle ? cTitle.get() : _("Confirm"));
	kz_prompt_dialog_set_message_text(prompt, cText.get());
	kz_prompt_dialog_set_check_box(prompt, aCheckMsg, aCheckValue);
	kz_prompt_dialog_run(prompt);
	kz_prompt_dialog_get_check_box_value(prompt, aCheckValue);
	*aConfirm = kz_prompt_dialog_get_confirm_value(prompt);
	gtk_widget_destroy(GTK_WIDGET(prompt));
	return NS_OK;
}

NS_IMETHODIMP
GtkPromptService::ConfirmEx(nsIDOMWindow* aParent,
		const PRUnichar* aDialogTitle,
		const PRUnichar* aDialogText,
		PRUint32 aButtonFlags,
		const PRUnichar* aButton0Title,
		const PRUnichar* aButton1Title,
		const PRUnichar* aButton2Title,
		const PRUnichar* aCheckMsg, PRBool* aCheckValue,
		PRInt32* aRetVal)
{
	gchar *button0 = g_strdup(GetButtonLabel(aButtonFlags, BUTTON_POS_0, aButton0Title));
	gchar *button1 = g_strdup(GetButtonLabel(aButtonFlags, BUTTON_POS_1, aButton1Title));
	gchar *button2 = g_strdup(GetButtonLabel(aButtonFlags, BUTTON_POS_2, aButton2Title));

	nsEmbedCString cText, cTitle;
	NS_UTF16ToCString(nsEmbedString(aDialogText),
			  NS_CSTRING_ENCODING_UTF8, cText);
	NS_UTF16ToCString(nsEmbedString(aDialogTitle),
			  NS_CSTRING_ENCODING_UTF8, cTitle);

	KzPromptDialog *prompt = KZ_PROMPT_DIALOG(kz_prompt_dialog_new_with_parent
	    						(TYPE_UNIVERSAL,
	    					         GTK_WINDOW(GetGtkWindowForDOMWindow(aParent))));
	gchar *host = GetURIForDOMWindow(aParent);
	kz_prompt_dialog_set_host (prompt, host);
	if (host)
		g_free(host);
	kz_prompt_dialog_set_title(prompt,
	    			   aDialogTitle ? cTitle.get() : _("Confirm"));
	kz_prompt_dialog_set_message_text(prompt, cText.get());
	kz_prompt_dialog_set_check_box(prompt, aCheckMsg, aCheckValue);

	kz_prompt_dialog_set_buttons(prompt, button0, button1, button2);

	if (button0)
		g_free(button0);
	if (button1)
		g_free(button1);
	if (button2)
		g_free(button2);

	kz_prompt_dialog_run(prompt);
	kz_prompt_dialog_get_check_box_value(prompt, aCheckValue);
	*aRetVal = kz_prompt_dialog_get_button_pressed(prompt);
	gtk_widget_destroy(GTK_WIDGET(prompt));
	return NS_OK;
}

NS_IMETHODIMP
GtkPromptService::Prompt(nsIDOMWindow* aParent, const PRUnichar* aDialogTitle,
		const PRUnichar* aDialogText, PRUnichar** aValue,
		const PRUnichar* aCheckMsg, PRBool* aCheckValue,
		PRBool* aConfirm)
{

	nsEmbedCString cText, cTitle, cTextValue;
	NS_UTF16ToCString(nsEmbedString(aDialogText),
			  NS_CSTRING_ENCODING_UTF8, cText);
	NS_UTF16ToCString(nsEmbedString(aDialogTitle),
			  NS_CSTRING_ENCODING_UTF8, cTitle);
	NS_UTF16ToCString(nsEmbedString(*aValue),
			  NS_CSTRING_ENCODING_UTF8, cTextValue);

	KzPromptDialog *prompt = KZ_PROMPT_DIALOG(kz_prompt_dialog_new_with_parent
	    						(TYPE_PROMPT,
	    					         GTK_WINDOW(GetGtkWindowForDOMWindow(aParent))));
	gchar *host = GetURIForDOMWindow(aParent);
	kz_prompt_dialog_set_host (prompt, host);
	if (host)
		g_free(host);
	kz_prompt_dialog_set_title(prompt,
	    			   aDialogTitle ? cTitle.get() : _("Prompt"));
	kz_prompt_dialog_set_message_text(prompt, cText.get());
	kz_prompt_dialog_set_text_value(prompt, cTextValue.get());
	kz_prompt_dialog_set_check_box(prompt, aCheckMsg, aCheckValue);
	kz_prompt_dialog_run(prompt);
	kz_prompt_dialog_get_check_box_value(prompt, aCheckValue);
	*aConfirm = kz_prompt_dialog_get_confirm_value(prompt);
	if (aConfirm)
	{
		if (*aValue)
			nsMemory::Free(*aValue);
		const gchar *value = kz_prompt_dialog_get_text_value(prompt);
		nsEmbedString textValue;
		NS_CStringToUTF16(nsEmbedCString(value),
			  	  NS_CSTRING_ENCODING_UTF8, textValue);

		*aValue = NS_StringCloneData(textValue);
	}
	gtk_widget_destroy(GTK_WIDGET(prompt));
	return NS_OK;
}

NS_IMETHODIMP
GtkPromptService::PromptUsernameAndPassword(nsIDOMWindow* aParent,
		const PRUnichar* aDialogTitle,
		const PRUnichar* aDialogText,
		PRUnichar** aUsername,
		PRUnichar** aPassword,
		const PRUnichar* aCheckMsg,
		PRBool* aCheckValue,
		PRBool* aConfirm)
{
	nsEmbedCString cText, cTitle, cPass, cUser;
	NS_UTF16ToCString(nsEmbedString(aDialogText),
			  NS_CSTRING_ENCODING_UTF8, cText);
	NS_UTF16ToCString(nsEmbedString(aDialogTitle),
			  NS_CSTRING_ENCODING_UTF8, cTitle);
	NS_UTF16ToCString(nsEmbedString(*aUsername),
			  NS_CSTRING_ENCODING_UTF8, cUser);
	NS_UTF16ToCString(nsEmbedString(*aPassword),
			  NS_CSTRING_ENCODING_UTF8, cPass);

	KzPromptDialog *prompt = KZ_PROMPT_DIALOG(kz_prompt_dialog_new_with_parent
	    						(TYPE_PROMPT_USER_PASS,
	    					         GTK_WINDOW(GetGtkWindowForDOMWindow(aParent))));
	gchar *host = GetURIForDOMWindow(aParent);
	kz_prompt_dialog_set_host (prompt, host);
	if (host)
		g_free(host);
	kz_prompt_dialog_set_title(prompt,
	    			   aDialogTitle ? cTitle.get() : _("Prompt"));
	kz_prompt_dialog_set_message_text(prompt, cText.get());
	kz_prompt_dialog_set_user(prompt, cUser.get());
	kz_prompt_dialog_set_password(prompt, cPass.get());
	kz_prompt_dialog_set_check_box(prompt, aCheckMsg, aCheckValue);
	kz_prompt_dialog_run(prompt);
	kz_prompt_dialog_get_check_box_value(prompt, aCheckValue);
	*aConfirm = kz_prompt_dialog_get_confirm_value(prompt);
	if (aConfirm)
	{
		if (*aUsername)
			nsMemory::Free(*aUsername);
		const gchar *user = kz_prompt_dialog_get_user(prompt);
		nsEmbedString textValue;
		NS_CStringToUTF16(nsEmbedCString(user),
			  	  NS_CSTRING_ENCODING_UTF8, textValue);
		*aUsername = NS_StringCloneData(textValue);

		if (*aPassword)
			nsMemory::Free(*aPassword);
		const gchar *pass = kz_prompt_dialog_get_password(prompt);
		NS_CStringToUTF16(nsEmbedCString(pass),
			  	  NS_CSTRING_ENCODING_UTF8, textValue);
		*aPassword = NS_StringCloneData(textValue);
	}
	gtk_widget_destroy(GTK_WIDGET(prompt));
	return NS_OK;
}

NS_IMETHODIMP
GtkPromptService::PromptPassword(nsIDOMWindow* aParent,
		const PRUnichar* aDialogTitle,
		const PRUnichar* aDialogText,
		PRUnichar** aPassword,
		const PRUnichar* aCheckMsg,
		PRBool* aCheckValue, PRBool* aConfirm)
{
	nsEmbedCString cText, cTitle, cPass;
	NS_UTF16ToCString(nsEmbedString(aDialogText),
			  NS_CSTRING_ENCODING_UTF8, cText);
	NS_UTF16ToCString(nsEmbedString(aDialogTitle),
			  NS_CSTRING_ENCODING_UTF8, cTitle);
	NS_UTF16ToCString(nsEmbedString(*aPassword),
			  NS_CSTRING_ENCODING_UTF8, cPass);

	KzPromptDialog *prompt = KZ_PROMPT_DIALOG(kz_prompt_dialog_new_with_parent
	    						(TYPE_PROMPT_PASS,
	    					         GTK_WINDOW(GetGtkWindowForDOMWindow(aParent))));
	gchar *host = GetURIForDOMWindow(aParent);
	kz_prompt_dialog_set_host (prompt, host);
	if (host)
		g_free(host);
	kz_prompt_dialog_set_title(prompt,
	    			   aDialogTitle ? cTitle.get() : _("Prompt"));
	kz_prompt_dialog_set_message_text(prompt, cText.get());
	kz_prompt_dialog_set_password(prompt, cPass.get());
	kz_prompt_dialog_set_check_box(prompt, aCheckMsg, aCheckValue);
	kz_prompt_dialog_run(prompt);
	kz_prompt_dialog_get_check_box_value(prompt, aCheckValue);
	*aConfirm = kz_prompt_dialog_get_confirm_value(prompt);
	if (aConfirm)
	{
		if (*aPassword)
			nsMemory::Free(*aPassword);
		const gchar *pass = kz_prompt_dialog_get_password(prompt);
		nsEmbedString textValue;
		NS_CStringToUTF16(nsEmbedCString(pass),
			  	  NS_CSTRING_ENCODING_UTF8, textValue);
		*aPassword = NS_StringCloneData(textValue);
	}
	gtk_widget_destroy(GTK_WIDGET(prompt));
	return NS_OK;
}

NS_IMETHODIMP
GtkPromptService::Select(nsIDOMWindow* aParent, const PRUnichar* aDialogTitle,
		const PRUnichar* aDialogText, PRUint32 aCount,
		const PRUnichar** aSelectList, PRInt32* outSelection,
		PRBool* aConfirm)
{
	//prompter.SetItems(aSelectList, aCount);
	nsEmbedCString cText, cTitle;
	NS_UTF16ToCString(nsEmbedString(aDialogText),
			  NS_CSTRING_ENCODING_UTF8, cText);
	NS_UTF16ToCString(nsEmbedString(aDialogTitle),
			  NS_CSTRING_ENCODING_UTF8, cTitle);

	KzPromptDialog *prompt = KZ_PROMPT_DIALOG(kz_prompt_dialog_new_with_parent
	    						(TYPE_SELECT,
	    					         GTK_WINDOW(GetGtkWindowForDOMWindow(aParent))));
	gchar *host = GetURIForDOMWindow(aParent);
	kz_prompt_dialog_set_host (prompt, host);
	if (host)
		g_free(host);
	kz_prompt_dialog_set_title(prompt,
	    			   aDialogTitle ? cTitle.get() : _("Select"));
	kz_prompt_dialog_set_message_text(prompt, cText.get());
	kz_prompt_dialog_run(prompt);
	*outSelection = kz_prompt_dialog_get_selected_item(prompt);
	*aConfirm = kz_prompt_dialog_get_confirm_value(prompt);
	gtk_widget_destroy(GTK_WIDGET(prompt));
	return NS_OK;
}

const char *
GtkPromptService::GetButtonLabel(PRUint32 aFlags, PRUint32 aPos,
		const PRUnichar* aStringValue)
{
	const char *aLabel = NULL;
	PRUint32 posFlag = (aFlags & (255 * aPos)) / aPos;
	switch (posFlag) 
	{
		case BUTTON_TITLE_OK:
                        aLabel = GTK_STOCK_OK;
			break;
		case BUTTON_TITLE_CANCEL:
                        aLabel = GTK_STOCK_CANCEL;
			break;
		case BUTTON_TITLE_YES:
                        aLabel = GTK_STOCK_YES;
			break;
		case BUTTON_TITLE_NO:
                        aLabel = GTK_STOCK_NO;
			break;
		case BUTTON_TITLE_SAVE:
                        aLabel = GTK_STOCK_SAVE;
			break;
		case BUTTON_TITLE_DONT_SAVE:
                        aLabel = _("Don't Save");
			break;
		case BUTTON_TITLE_REVERT:
                        aLabel = _("Revert");
			break;
		case BUTTON_TITLE_IS_STRING:
		{
			nsEmbedCString cValue;
			NS_UTF16ToCString(nsEmbedString(aStringValue),
			    		  NS_CSTRING_ENCODING_UTF8, cValue);
			aLabel = cValue.get();
			break;
		}
                default:
			NS_WARNING("Unexpected button flags");
	}
	return aLabel;
}

gchar *
GtkPromptService::GetURIForDOMWindow(nsIDOMWindow* aDOMWindow)
{
	if (!aDOMWindow)
		return NULL;

	nsCOMPtr<nsIDOMDocument> domDoc;
	aDOMWindow->GetDocument(getter_AddRefs(domDoc));
	nsCOMPtr<nsIDOM3Document> doc = do_QueryInterface(domDoc);

	if (!doc)
		return NULL;

	nsString uri;
	doc->GetDocumentURI(uri);

	nsEmbedCString c_uri;
	NS_UTF16ToCString(uri, NS_CSTRING_ENCODING_UTF8, c_uri);
	return g_strdup(c_uri.get());
}
