/* -*- c-file-style: "ruby"; indent-tabs-mode: nil -*- */

#ifndef __KZ_RUBY_EXT_H__
#define __KZ_RUBY_EXT_H__

#include <rbgtk.h>

#undef PACKAGE_NAME
#undef PACKAGE_TARNAME
#undef PACKAGE_STRING
#undef PACKAGE_VERSION

#include "kazehakase.h"
#include "kz-app.h"
#include "kz-window.h"
#include "kz-notebook.h"
#include "kz-statusbar.h"
#include "kz-downloader.h"
#include "kz-downloader-group.h"
#include "kz-enum-types.h"
#include "kz-embed-event.h"

void kz_rb_ext_init (gpointer initial_address);
void kz_rb_ext_setup (KzWindow *kz);
void kz_rb_ext_cleanup (void);


#define RVAL2DLGRP(obj)    (KZ_DOWNLOADER_GROUP(RVAL2GOBJ(obj)))
#define RVAL2DL(obj)       (KZ_DOWNLOADER(RVAL2GOBJ(obj)))
#define EVENTMOUSE2RVAL(obj) \
  (BOXED2RVAL(obj, KZ_TYPE_EMBED_EVENT_MOUSE))

#define RVAL2GTKWIDGET(obj) (GTK_WIDGET(RVAL2GOBJ(obj)))

#define RVAL2KZAPP(obj) (KZ_APP(RVAL2GOBJ(obj)))
#define RVAL2KZWIN(obj) (KZ_WINDOW(RVAL2GOBJ(obj)))
#define RVAL2KZNB(obj) (KZ_NOTEBOOK(RVAL2GOBJ(obj)))
#define RVAL2KZEMB(obj) (KZ_EMBED(RVAL2GOBJ(obj)))
#define RVAL2KZTL(obj) (KZ_TAB_LABEL(RVAL2GOBJ(obj)))

#ifndef G_CHILD_ADD
#define G_CHILD_ADD(self, child) /* hide when old Ruby-GNOME2 */
#endif
#ifndef RVAL2CSTR2
#  define RVAL2CSTR2(v) (NIL_P(v) ? NULL : StringValuePtr(v))
#endif

#define KZ_RB_GET_APP (_kz_rb_get_app())

extern gchar *_kz_rb_ext_version;

extern KzApp *_kz_rb_get_app(void);

extern void _kz_rb_app_init(VALUE mKz, KzApp *app);
extern void _kz_rb_window_init(VALUE mKz);
extern void _kz_rb_notebook_init(VALUE mKz);
extern void _kz_rb_statusbar_init(VALUE mKz);
extern void _kz_rb_embed_init(VALUE mKz);
extern void _kz_rb_embed_event_init(VALUE mKz);
extern void _kz_rb_conf_init(VALUE mKz);
extern void _kz_rb_downloader_init(VALUE mKz);
extern void _kz_rb_downloader_group_init(VALUE mKz);
extern void _kz_rb_bookmark_init(VALUE mKz);
extern void _kz_rb_sidebar_init(VALUE mKz);
extern void _kz_rb_web_init(VALUE mKz);

extern void _kz_rb_setup_sidebar(KzWindow *kz);

#endif /* __KZ_RUBY_EXT_H__ */
