/*
 *  Copyright (C) 2003 Takuro Ashie <ashie@homa.ne.jp>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 *  Based on Epiphany's code.
 *  Copyright (C) 2000 Marco Pesenti Gritti
 *  Copyright (C) 2001 Philip Langdale
 */

#ifndef __KZ_MOZ_LAUNCHER_H__
#define __KZ_MOZ_LAUNCHER_H__

#include <nsIHelperAppLauncherDialog.h>
#include <nsIExternalHelperAppService.h>
#include <nsCExternalHandlerService.h>
#include <nsIWebProgressListener.h>

#define MOZILLA_STRICT_API
#include <nsEmbedString.h>
#undef MOZILLA_STRICT_API
#include <nsIURI.h>
#include <nsILocalFile.h>

#include <nsCOMPtr.h>
#include <nsISupports.h>
#include <nsError.h>

#define KZ_CONTENTHANDLER_CID			     \
{ /* 16072c4a-23a6-4996-9beb-9335c06bbeae */         \
    0x16072c4a,                                      \
    0x23a6,                                          \
    0x4996,                                          \
    {0x9b, 0xeb, 0x93, 0x35, 0xc0, 0x6b, 0xbe, 0xae} \
}

class nsIFactory;

class KzContentHandler : public nsIHelperAppLauncherDialog
{
  public:
	NS_DECL_ISUPPORTS
	NS_DECL_NSIHELPERAPPLAUNCHERDIALOG

	KzContentHandler();
	virtual ~KzContentHandler();

  private:
	/* additional members */
	NS_METHOD Init (void);
	
	nsCOMPtr<nsIHelperAppLauncher> mLauncher;
	nsCOMPtr<nsISupports> mContext;

	nsCOMPtr<nsIURI> mUri;
	nsCOMPtr<nsIFile> mTempFile;

	nsEmbedCString mMimeType;
	PRBool mUrlHelper;
	
	nsEmbedCString mUrl;
	nsEmbedCString mScheme;

	PRInt64 mTimeDownloadStarted;
	PRBool mDownloadCanceled;
	nsCOMPtr<nsIWebProgressListener> mListener;
};

extern nsresult NS_NewContentHandlerFactory(nsIFactory** aFactory);

#endif /* __KZ_MOZ_LAUNCHER_H__ */
