#!/usr/bin/python
# -*- coding: utf-8 -*-
#
# Copyright (C) 2011-2012 Canonical, Ltd.
#
# Authors:
#  Ugo Riboni <ugo.riboni@canonical.com>
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 3.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.

"""
Daemon listening on a websocket and acting as a bridge/proxy to the DBUS bus.
Allows processes on the other side (e.g. an extension running in a browser) to
register themselves as objects DBUS and to call methods on other objects on DBUS.
"""

# The imports and calls starting from this point have to be made in this exact order.
# The twisted reactor can run on top of the glib mainloop, but we need to tell this to
# twisted itself *before* we import anything else that uses twisted and causes
# the default initialization to be triggered.

from twisted.internet import glib2reactor
glib2reactor.install()
from twisted.internet import reactor

from dbus.mainloop.glib import DBusGMainLoop
DBusGMainLoop(set_as_default=True)

# Starting from this point the order of imports doesn't matter anymore

from txWS.txws import WebSocketFactory
from ws_dispatcher import DBUSFactory

if __name__ == '__main__':
   reactor.listenTCP(9000, WebSocketFactory(DBUSFactory()))
   reactor.run()
