#ifndef _BLK_COMPAT_H
#define _BLK_COMPAT_H

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,34)
#include <linux/slab.h>
void blk_queue_max_sectors(struct request_queue *rq, unsigned int pages)
{
	return blk_queue_max_hw_sectors(rq, pages);
}

void blk_queue_max_phys_segments(struct request_queue *rq, unsigned int segs)
{
	return;
}

void  blk_queue_max_hw_segments(struct request_queue *rq, unsigned short segs)
{
	return blk_queue_max_segments(rq, segs);
}
#endif

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,31)
static inline sector_t blk_rq_pos(const struct request *rq)
{
	return rq->sector;
}

static inline unsigned int blk_rq_sectors(struct request *rq)
{
	return rq->nr_sectors;
}

struct request *blk_fetch_request(struct request_queue *q)
{
	return elv_next_request(q);
}

void blk_queue_logical_block_size(struct request_queue *q, unsigned short page_size)
{
	blk_queue_hardsect_size(q, page_size);
}
#endif

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,26)
static inline const char *dev_name(const struct device *dev)
{
	return dev->bus_id;
}

extern int dev_set_name(struct device *dev, const char *name, ...)
			__attribute__((format(printf, 2, 3)));
#endif

#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,28)
void end_queued_request(struct request *rq, int error)
{
	__blk_end_request(rq, error, blk_rq_bytes(rq));
}
#endif

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,25)
static inline int __blk_end_request(struct request *rq, int error,
                                    unsigned int nr_bytes)
{
	int chunk;

	if (!error)
		chunk = end_that_request_chunk(rq, 1, nr_bytes);
	else
		chunk = end_that_request_first(rq, error, nr_bytes);

	if (!chunk) {
		add_disk_randomness(rq->rq_disk);
		blkdev_dequeue_request(rq);
		end_that_request_last(rq, error < 0 ? error : 1);
	}

	return chunk;
}

unsigned int blk_rq_bytes(struct request *rq)
{
	if (blk_fs_request(rq))
		return rq->hard_nr_sectors << 9;

	return rq->data_len;
}

unsigned int blk_rq_cur_bytes(struct request *rq)
{
	if (blk_fs_request(rq))
		return rq->current_nr_sectors << 9;

	if (rq->bio)
		return rq->bio->bi_size;

	return rq->data_len;
}
#endif

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,24)
static inline void sg_set_page(struct scatterlist *sg, struct page *page,
                               unsigned int len, unsigned int offset)
{
	sg->page = page;
        sg->offset = offset;
        sg->length = len;
}

static inline struct page *sg_page(struct scatterlist *sg)
{
	return sg->page;
}

static unsigned int rq_byte_size(struct request *rq)
{
	if (blk_fs_request(rq))
		return rq->hard_nr_sectors << 9;

	return rq->data_len;
}

static inline void __end_request(struct request *rq, int uptodate,
				 unsigned int nr_bytes, int dequeue)
{
	if (!end_that_request_chunk(rq, uptodate, nr_bytes)) {
		if (dequeue)
			blkdev_dequeue_request(rq);
		add_disk_randomness(rq->rq_disk);
		end_that_request_last(rq, uptodate);
	}
}

void end_queued_request(struct request *rq, int uptodate)
{
	__end_request(rq, uptodate, rq_byte_size(rq), 1);
}
#endif

#endif
