/*
 * Copyright (C) 2012 The Android Open Source Project
 * Copyright (C) 2015-2018 Intel Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * !! Do not include this file directly !!
 *
 * Include icamera_metadata_base.h instead.
 */

/**
 * ! Do not edit this file directly !
 *
 * Generated automatically from icamera_metadata_tags.mako
 */

/**
 * Top level hierarchy definitions for camera metadata. *_INFO sections are for
 * the static metadata that can be retrived without opening the camera device.
 * New sections must be added right before CAMERA_SECTION_COUNT to maintain
 * existing enumerations.
 */
typedef enum icamera_metadata_section {
    CAMERA_AE,
    CAMERA_AWB,
    CAMERA_AF,
    CAMERA_CONTROL,
    CAMERA_DEMOSAIC,
    CAMERA_EDGE,
    CAMERA_FLASH,
    CAMERA_FLASH_INFO,
    CAMERA_HOT_PIXEL,
    CAMERA_JPEG,
    CAMERA_LENS,
    CAMERA_LENS_INFO,
    CAMERA_NOISE_REDUCTION,
    CAMERA_REQUEST,
    CAMERA_SCALER,
    CAMERA_SENSOR,
    CAMERA_SENSOR_INFO,
    CAMERA_SHADING,
    CAMERA_STATISTICS,
    CAMERA_STATISTICS_INFO,
    CAMERA_TONEMAP,
    CAMERA_LED,
    CAMERA_INFO,
    CAMERA_BLACK_LEVEL,
    CAMERA_SYNC,
    CAMERA_REPROCESS,
    INTEL_INFO,
    INTEL_CONTROL,
    INTEL_CONTROL_ISP,
    CAMERA_SECTION_COUNT
} icamera_metadata_section_t;

/**
 * Hierarchy positions in enum space.
 */
typedef enum icamera_metadata_section_start {
    CAMERA_AE_START                = CAMERA_AE                 << 16,
    CAMERA_AWB_START               = CAMERA_AWB                << 16,
    CAMERA_AF_START                = CAMERA_AF                 << 16,
    CAMERA_CONTROL_START           = CAMERA_CONTROL            << 16,
    CAMERA_DEMOSAIC_START          = CAMERA_DEMOSAIC           << 16,
    CAMERA_EDGE_START              = CAMERA_EDGE               << 16,
    CAMERA_FLASH_START             = CAMERA_FLASH              << 16,
    CAMERA_FLASH_INFO_START        = CAMERA_FLASH_INFO         << 16,
    CAMERA_HOT_PIXEL_START         = CAMERA_HOT_PIXEL          << 16,
    CAMERA_JPEG_START              = CAMERA_JPEG               << 16,
    CAMERA_LENS_START              = CAMERA_LENS               << 16,
    CAMERA_LENS_INFO_START         = CAMERA_LENS_INFO          << 16,
    CAMERA_NOISE_REDUCTION_START   = CAMERA_NOISE_REDUCTION    << 16,
    CAMERA_REQUEST_START           = CAMERA_REQUEST            << 16,
    CAMERA_SCALER_START            = CAMERA_SCALER             << 16,
    CAMERA_SENSOR_START            = CAMERA_SENSOR             << 16,
    CAMERA_SENSOR_INFO_START       = CAMERA_SENSOR_INFO        << 16,
    CAMERA_SHADING_START           = CAMERA_SHADING            << 16,
    CAMERA_STATISTICS_START        = CAMERA_STATISTICS         << 16,
    CAMERA_STATISTICS_INFO_START   = CAMERA_STATISTICS_INFO    << 16,
    CAMERA_TONEMAP_START           = CAMERA_TONEMAP            << 16,
    CAMERA_LED_START               = CAMERA_LED                << 16,
    CAMERA_INFO_START              = CAMERA_INFO               << 16,
    CAMERA_BLACK_LEVEL_START       = CAMERA_BLACK_LEVEL        << 16,
    CAMERA_SYNC_START              = CAMERA_SYNC               << 16,
    CAMERA_REPROCESS_START         = CAMERA_REPROCESS          << 16,
    INTEL_INFO_START               = INTEL_INFO                << 16,
    INTEL_CONTROL_START            = INTEL_CONTROL             << 16,
    INTEL_CONTROL_ISP_START        = INTEL_CONTROL_ISP         << 16,
} icamera_metadata_section_start_t;

/**
 * Main enum for defining camera metadata tags.  New entries must always go
 * before the section _END tag to preserve existing enumeration values.  In
 * addition, the name and type of the tag needs to be added to
 * src/metadata/icamera_metadata_tag_info.c
 */
typedef enum icamera_metadata_tag {
    CAMERA_AE_MODE =                                  // enum         | public
            CAMERA_AE_START,
    CAMERA_AE_LOCK,                                   // enum         | public
    CAMERA_AE_REGIONS,                                // int32[]      | public
    CAMERA_AE_ANTIBANDING_MODE,                       // enum         | public
    CAMERA_AE_COMPENSATION,                           // int32        | public
    CAMERA_AE_TARGET_FPS_RANGE,                       // float[]      | public
    CAMERA_AE_PRECAPTURE_TRIGGER,                     // enum         | public
    CAMERA_AE_STATE,                                  // enum         | public
    CAMERA_AE_AVAILABLE_MODES,                        // byte[]       | public
    CAMERA_AE_AVAILABLE_ANTIBANDING_MODES,            // byte[]       | public
    CAMERA_AE_COMPENSATION_STEP,                      // rational     | public
    CAMERA_AE_COMPENSATION_RANGE,                     // int32[]      | public
    CAMERA_AE_AVAILABLE_TARGET_FPS_RANGES,            // float[]      | public
    CAMERA_AE_LOCK_AVAILABLE,                         // enum         | public
    CAMERA_AE_END,

    CAMERA_AWB_MODE =                                 // enum         | public
            CAMERA_AWB_START,
    CAMERA_AWB_COLOR_TRANSFORM,                       // float[]      | public
    CAMERA_AWB_COLOR_GAINS,                           // float[]      | public
    CAMERA_AWB_LOCK,                                  // enum         | public
    CAMERA_AWB_REGIONS,                               // int32[]      | public
    CAMERA_AWB_CCT_RANGE,                             // int32[]      | public
    CAMERA_AWB_GAINS,                                 // int32[]      | public
    CAMERA_AWB_GAIN_SHIFT,                            // int32[]      | public
    CAMERA_AWB_WHITE_POINT,                           // int32[]      | public
    CAMERA_AWB_CONVERGE_SPEED,                        // enum         | public
    CAMERA_AWB_CONVERGE_SPEED_MODE,                   // enum         | public
    CAMERA_AWB_STATE,                                 // enum         | public
    CAMERA_AWB_RESULT,                                // byte[]       | public
    CAMERA_AWB_AVAILABLE_MODES,                       // byte[]       | public
    CAMERA_AWB_LOCK_AVAILABLE,                        // enum         | public
    CAMERA_AWB_END,

    CAMERA_AF_MODE =                                  // enum         | public
            CAMERA_AF_START,
    CAMERA_AF_REGIONS,                                // int32[]      | public
    CAMERA_AF_TRIGGER,                                // enum         | public
    CAMERA_AF_AVAILABLE_MODES,                        // byte[]       | public
    CAMERA_AF_STATE,                                  // enum         | public
    CAMERA_AF_END,

    CAMERA_CONTROL_CAPTUREINTENT =                    // enum         | public
            CAMERA_CONTROL_START,
    CAMERA_CONTROL_EFFECT_MODE,                       // enum         | public
    CAMERA_CONTROL_MODE,                              // enum         | public
    CAMERA_CONTROL_SCENE_MODE,                        // enum         | public
    CAMERA_CONTROL_VIDEO_STABILIZATION_MODE,          // enum         | public
    CAMERA_CONTROL_AVAILABLE_EFFECTS,                 // byte[]       | public
    CAMERA_CONTROL_AVAILABLE_MODES,                   // byte[]       | public
    CAMERA_CONTROL_AVAILABLE_SCENE_MODES,             // byte[]       | public
    CAMERA_CONTROL_AVAILABLE_VIDEO_STABILIZATION_MODES,
                                                      // byte[]       | public
    CAMERA_CONTROL_MAX_REGIONS,                       // int32[]      | hidden
    CAMERA_CONTROL_SCENE_MODE_OVERRIDES,              // byte[]       | system
    CAMERA_CONTROL_AVAILABLE_HIGH_SPEED_VIDEO_CONFIGURATIONS,
                                                      // int32[]      | hidden
    CAMERA_CONTROL_END,

    CAMERA_DEMOSAIC_MODE =                            // enum         | system
            CAMERA_DEMOSAIC_START,
    CAMERA_DEMOSAIC_END,

    CAMERA_EDGE_MODE =                                // enum         | public
            CAMERA_EDGE_START,
    CAMERA_EDGE_STRENGTH,                             // byte         | system
    CAMERA_EDGE_AVAILABLE_EDGE_MODES,                 // byte[]       | public
    CAMERA_EDGE_END,

    CAMERA_FLASH_FIRING_POWER =                       // byte         | system
            CAMERA_FLASH_START,
    CAMERA_FLASH_FIRING_TIME,                         // int64        | system
    CAMERA_FLASH_MODE,                                // enum         | public
    CAMERA_FLASH_COLOR_TEMPERATURE,                   // byte         | system
    CAMERA_FLASH_MAX_ENERGY,                          // byte         | system
    CAMERA_FLASH_STATE,                               // enum         | public
    CAMERA_FLASH_END,

    CAMERA_FLASH_INFO_AVAILABLE =                     // enum         | public
            CAMERA_FLASH_INFO_START,
    CAMERA_FLASH_INFO_CHARGE_DURATION,                // int64        | system
    CAMERA_FLASH_INFO_END,

    CAMERA_HOT_PIXEL_MODE =                           // enum         | public
            CAMERA_HOT_PIXEL_START,
    CAMERA_HOT_PIXEL_AVAILABLE_HOT_PIXEL_MODES,       // byte[]       | public
    CAMERA_HOT_PIXEL_END,

    CAMERA_JPEG_GPS_COORDINATES =                     // double[]     | hidden
            CAMERA_JPEG_START,
    CAMERA_JPEG_GPS_PROCESSING_METHOD,                // byte         | hidden
    CAMERA_JPEG_GPS_TIMESTAMP,                        // int64        | hidden
    CAMERA_JPEG_ORIENTATION,                          // int32        | public
    CAMERA_JPEG_QUALITY,                              // byte         | public
    CAMERA_JPEG_THUMBNAIL_QUALITY,                    // byte         | public
    CAMERA_JPEG_THUMBNAIL_SIZE,                       // int32[]      | public
    CAMERA_JPEG_AVAILABLE_THUMBNAIL_SIZES,            // int32[]      | public
    CAMERA_JPEG_MAX_SIZE,                             // int32        | system
    CAMERA_JPEG_SIZE,                                 // int32        | system
    CAMERA_JPEG_END,

    CAMERA_LENS_APERTURE =                            // float        | public
            CAMERA_LENS_START,
    CAMERA_LENS_FILTER_DENSITY,                       // float        | public
    CAMERA_LENS_FOCAL_LENGTH,                         // float        | public
    CAMERA_LENS_FOCUS_DISTANCE,                       // float        | public
    CAMERA_LENS_OPTICAL_STABILIZATION_MODE,           // enum         | public
    CAMERA_LENS_FACING,                               // enum         | public
    CAMERA_LENS_FOCUS_RANGE,                          // float[]      | public
    CAMERA_LENS_STATE,                                // enum         | public
    CAMERA_LENS_END,

    CAMERA_LENS_INFO_AVAILABLE_APERTURES =            // float[]      | public
            CAMERA_LENS_INFO_START,
    CAMERA_LENS_INFO_AVAILABLE_FILTER_DENSITIES,      // float[]      | public
    CAMERA_LENS_INFO_AVAILABLE_FOCAL_LENGTHS,         // float[]      | public
    CAMERA_LENS_INFO_AVAILABLE_OPTICAL_STABILIZATION, // byte[]       | public
    CAMERA_LENS_INFO_HYPERFOCAL_DISTANCE,             // float        | public
    CAMERA_LENS_INFO_MINIMUM_FOCUS_DISTANCE,          // float        | public
    CAMERA_LENS_INFO_SHADING_MAP_SIZE,                // int32[]      | hidden
    CAMERA_LENS_INFO_FOCUS_DISTANCE_CALIBRATION,      // enum         | public
    CAMERA_LENS_INFO_END,

    CAMERA_NOISE_REDUCTION_MODE =                     // enum         | public
            CAMERA_NOISE_REDUCTION_START,
    CAMERA_NOISE_REDUCTION_STRENGTH,                  // byte         | system
    CAMERA_NOISE_REDUCTION_AVAILABLE_NOISE_REDUCTION_MODES,
                                                      // byte[]       | public
    CAMERA_NOISE_REDUCTION_END,

    CAMERA_REQUEST_ID =                               // int32        | hidden
            CAMERA_REQUEST_START,
    CAMERA_REQUEST_METADATA_MODE,                     // enum         | system
    CAMERA_REQUEST_MAX_NUM_OUTPUT_STREAMS,            // int32[]      | hidden
    CAMERA_REQUEST_MAX_NUM_INPUT_STREAMS,             // int32        | hidden
    CAMERA_REQUEST_PIPELINE_DEPTH,                    // byte         | public
    CAMERA_REQUEST_PIPELINE_MAX_DEPTH,                // byte         | public
    CAMERA_REQUEST_PARTIAL_RESULT_COUNT,              // int32        | public
    CAMERA_REQUEST_AVAILABLE_CAPABILITIES,            // enum[]       | public
    CAMERA_REQUEST_AVAILABLE_REQUEST_KEYS,            // int32[]      | hidden
    CAMERA_REQUEST_AVAILABLE_RESULT_KEYS,             // int32[]      | hidden
    CAMERA_REQUEST_AVAILABLE_CHARACTERISTICS_KEYS,    // int32[]      | hidden
    CAMERA_REQUEST_END,

    CAMERA_SCALER_CROP_REGION =                       // int32[]      | public
            CAMERA_SCALER_START,
    CAMERA_SCALER_AVAILABLE_JPEG_SIZES,               // int32[]      | hidden
    CAMERA_SCALER_AVAILABLE_MAX_DIGITAL_ZOOM,         // float        | public
    CAMERA_SCALER_AVAILABLE_INPUT_OUTPUT_FORMATS_MAP, // int32[]      | hidden
    CAMERA_SCALER_AVAILABLE_STREAM_CONFIGURATIONS,    // int32[]      | hidden
    CAMERA_SCALER_AVAILABLE_MIN_FRAME_DURATIONS,      // int64[]      | hidden
    CAMERA_SCALER_AVAILABLE_STALL_DURATIONS,          // int64[]      | hidden
    CAMERA_SCALER_CROPPING_TYPE,                      // enum         | public
    CAMERA_SCALER_END,

    CAMERA_SENSOR_EXPOSURE_TIME =                     // int64        | public
            CAMERA_SENSOR_START,
    CAMERA_SENSOR_FRAME_DURATION,                     // int64        | public
    CAMERA_SENSOR_SENSITIVITY,                        // int32        | public
    CAMERA_SENSOR_REFERENCE_ILLUMINANT1,              // enum         | public
    CAMERA_SENSOR_REFERENCE_ILLUMINANT2,              // byte         | public
    CAMERA_SENSOR_CALIBRATION_TRANSFORM1,             // rational[]   | public
    CAMERA_SENSOR_CALIBRATION_TRANSFORM2,             // rational[]   | public
    CAMERA_SENSOR_COLOR_TRANSFORM1,                   // rational[]   | public
    CAMERA_SENSOR_COLOR_TRANSFORM2,                   // rational[]   | public
    CAMERA_SENSOR_FORWARD_MATRIX1,                    // rational[]   | public
    CAMERA_SENSOR_FORWARD_MATRIX2,                    // rational[]   | public
    CAMERA_SENSOR_BASE_GAIN_FACTOR,                   // rational     | system
    CAMERA_SENSOR_BLACK_LEVEL_PATTERN,                // int32[]      | public
    CAMERA_SENSOR_MAX_ANALOG_SENSITIVITY,             // int32        | public
    CAMERA_SENSOR_ORIENTATION,                        // int32        | public
    CAMERA_SENSOR_PROFILE_HUE_SAT_MAP_DIMENSIONS,     // int32[]      | system
    CAMERA_SENSOR_TIMESTAMP,                          // int64        | public
    CAMERA_SENSOR_TEMPERATURE,                        // float        | system
    CAMERA_SENSOR_NEUTRAL_COLOR_POINT,                // rational[]   | public
    CAMERA_SENSOR_NOISE_PROFILE,                      // double[]     | public
    CAMERA_SENSOR_PROFILE_HUE_SAT_MAP,                // float[]      | system
    CAMERA_SENSOR_PROFILE_TONE_CURVE,                 // float[]      | system
    CAMERA_SENSOR_GREEN_SPLIT,                        // float        | public
    CAMERA_SENSOR_TEST_PATTERN_DATA,                  // int32[]      | public
    CAMERA_SENSOR_TEST_PATTERN_MODE,                  // enum         | public
    CAMERA_SENSOR_AVAILABLE_TEST_PATTERN_MODES,       // int32[]      | public
    CAMERA_SENSOR_OPAQUE_RAW_SIZE,                    // int32[]      | system
    CAMERA_SENSOR_ROLLING_SHUTTER_SKEW,               // int64        | public
    CAMERA_SENSOR_END,

    CAMERA_SENSOR_INFO_ACTIVE_ARRAY_SIZE =            // int32[]      | public
            CAMERA_SENSOR_INFO_START,
    CAMERA_SENSOR_INFO_SENSITIVITY_RANGE,             // int32[]      | public
    CAMERA_SENSOR_INFO_COLOR_FILTER_ARRANGEMENT,      // enum         | public
    CAMERA_SENSOR_INFO_EXPOSURE_TIME_RANGE,           // int64[]      | public
    CAMERA_SENSOR_INFO_MAX_FRAME_DURATION,            // int64        | public
    CAMERA_SENSOR_INFO_PHYSICAL_SIZE,                 // float[]      | public
    CAMERA_SENSOR_INFO_PIXEL_ARRAY_SIZE,              // int32[]      | public
    CAMERA_SENSOR_INFO_WHITE_LEVEL,                   // int32        | public
    CAMERA_SENSOR_INFO_TIMESTAMP_SOURCE,              // enum         | public
    CAMERA_SENSOR_INFO_END,

    CAMERA_SHADING_MODE =                             // enum         | public
            CAMERA_SHADING_START,
    CAMERA_SHADING_STRENGTH,                          // byte         | system
    CAMERA_SHADING_AVAILABLE_MODES,                   // byte[]       | public
    CAMERA_SHADING_END,

    CAMERA_STATISTICS_FACE_DETECT_MODE =              // enum         | public
            CAMERA_STATISTICS_START,
    CAMERA_STATISTICS_HISTOGRAM_MODE,                 // enum         | system
    CAMERA_STATISTICS_SHARPNESS_MAP_MODE,             // enum         | system
    CAMERA_STATISTICS_HOT_PIXEL_MAP_MODE,             // enum         | public
    CAMERA_STATISTICS_FACE_IDS,                       // int32[]      | hidden
    CAMERA_STATISTICS_FACE_LANDMARKS,                 // int32[]      | hidden
    CAMERA_STATISTICS_FACE_RECTANGLES,                // int32[]      | hidden
    CAMERA_STATISTICS_FACE_SCORES,                    // byte[]       | hidden
    CAMERA_STATISTICS_HISTOGRAM,                      // int32[]      | system
    CAMERA_STATISTICS_SHARPNESS_MAP,                  // int32[]      | system
    CAMERA_STATISTICS_LENS_SHADING_CORRECTION_MAP,    // byte         | public
    CAMERA_STATISTICS_LENS_SHADING_MAP,               // float[]      | hidden
    CAMERA_STATISTICS_PREDICTED_COLOR_GAINS,          // float[]      | hidden
    CAMERA_STATISTICS_PREDICTED_COLOR_TRANSFORM,      // rational[]   | hidden
    CAMERA_STATISTICS_SCENE_FLICKER,                  // enum         | public
    CAMERA_STATISTICS_HOT_PIXEL_MAP,                  // int32[]      | public
    CAMERA_STATISTICS_LENS_SHADING_MAP_MODE,          // enum         | public
    CAMERA_STATISTICS_END,

    CAMERA_STATISTICS_INFO_AVAILABLE_FACE_DETECT_MODES = 
                                                      // byte[]       | public
            CAMERA_STATISTICS_INFO_START,
    CAMERA_STATISTICS_INFO_HISTOGRAM_BUCKET_COUNT,    // int32        | system
    CAMERA_STATISTICS_INFO_MAX_FACE_COUNT,            // int32        | public
    CAMERA_STATISTICS_INFO_MAX_HISTOGRAM_COUNT,       // int32        | system
    CAMERA_STATISTICS_INFO_MAX_SHARPNESS_MAP_VALUE,   // int32        | system
    CAMERA_STATISTICS_INFO_SHARPNESS_MAP_SIZE,        // int32[]      | system
    CAMERA_STATISTICS_INFO_AVAILABLE_HOT_PIXEL_MAP_MODES,
                                                      // byte[]       | public
    CAMERA_STATISTICS_INFO_END,

    CAMERA_TONEMAP_CURVE_BLUE =                       // float[]      | public
            CAMERA_TONEMAP_START,
    CAMERA_TONEMAP_CURVE_GREEN,                       // float[]      | public
    CAMERA_TONEMAP_CURVE_RED,                         // float[]      | public
    CAMERA_TONEMAP_MODE,                              // enum         | public
    CAMERA_TONEMAP_MAX_CURVE_POINTS,                  // int32        | public
    CAMERA_TONEMAP_AVAILABLE_TONE_MAP_MODES,          // byte[]       | public
    CAMERA_TONEMAP_GAMMA,                             // float        | public
    CAMERA_TONEMAP_PRESET_CURVE,                      // enum         | public
    CAMERA_TONEMAP_END,

    CAMERA_LED_TRANSMIT =                             // enum         | hidden
            CAMERA_LED_START,
    CAMERA_LED_AVAILABLE_LEDS,                        // enum[]       | hidden
    CAMERA_LED_END,

    CAMERA_INFO_SUPPORTED_HARDWARE_LEVEL =            // enum         | public
            CAMERA_INFO_START,
    CAMERA_INFO_END,

    CAMERA_BLACK_LEVEL_LOCK =                         // enum         | public
            CAMERA_BLACK_LEVEL_START,
    CAMERA_BLACK_LEVEL_END,

    CAMERA_SYNC_FRAME_NUMBER =                        // enum         | hidden
            CAMERA_SYNC_START,
    CAMERA_SYNC_MAX_LATENCY,                          // enum         | public
    CAMERA_SYNC_END,

    CAMERA_REPROCESS_MAX_CAPTURE_STALL =              // int32        | public
            CAMERA_REPROCESS_START,
    CAMERA_REPROCESS_END,

    INTEL_INFO_AVAILABLE_CONFIGURATIONS =             // int32[]      | hidden
            INTEL_INFO_START,
    INTEL_INFO_AVAILABLE_FEATURES,                    // enum[]       | public
    INTEL_INFO_AE_EXPOSURE_TIME_RANGE,                // int32[]      | public
    INTEL_INFO_AE_GAIN_RANGE,                         // int32[]      | public
    INTEL_INFO_WFOV,                                  // enum         | public
    INTEL_INFO_SENSOR_MOUNT_TYPE,                     // enum         | public
    INTEL_INFO_END,

    INTEL_CONTROL_IMAGE_ENHANCEMENT =                 // int32        | public
            INTEL_CONTROL_START,
    INTEL_CONTROL_SENSITIVITY_GAIN,                   // float        | public
    INTEL_CONTROL_FRAME_RATE,                         // float        | public
    INTEL_CONTROL_AE_CONVERGE_SPEED,                  // enum         | public
    INTEL_CONTROL_NR_MODE,                            // enum         | public
    INTEL_CONTROL_NR_LEVEL,                           // int32[]      | public
    INTEL_CONTROL_IRIS_MODE,                          // enum         | public
    INTEL_CONTROL_AE_DISTRIBUTION_PRIORITY,           // enum         | public
    INTEL_CONTROL_IRIS_LEVEL,                         // int32        | public
    INTEL_CONTROL_WDR_MODE,                           // enum         | public
    INTEL_CONTROL_WDR_LEVEL,                          // byte         | public
    INTEL_CONTROL_BLC_AREA_MODE,                      // enum         | public
    INTEL_CONTROL_SCENE_MODE,                         // enum         | public
    INTEL_CONTROL_WEIGHT_GRID_MODE,                   // enum         | public
    INTEL_CONTROL_AE_CONVERGE_SPEED_MODE,             // enum         | public
    INTEL_CONTROL_DEINTERLACE_MODE,                   // enum         | public
    INTEL_CONTROL_CUSTOM_AIC_PARAM,                   // byte         | public
    INTEL_CONTROL_YUV_COLOR_RANGE,                    // enum         | public
    INTEL_CONTROL_SENSITIVITY_GAIN_RANGE,             // float[]      | public
    INTEL_CONTROL_EXPOSURE_TIME_RANGE,                // int32[]      | public
    INTEL_CONTROL_FISHEYE_DEWARPING_MODE,             // enum         | public
    INTEL_CONTROL_LTM_TUNING_DATA,                    // byte[]       | public
    INTEL_CONTROL_DIGITAL_ZOOM_RATIO,                 // float        | public
    INTEL_CONTROL_LDC_MODE,                           // enum         | public
    INTEL_CONTROL_RSC_MODE,                           // enum         | public
    INTEL_CONTROL_FLIP_MODE,                          // enum         | public
    INTEL_CONTROL_MONO_DOWNSCALE,                     // enum         | public
    INTEL_CONTROL_RUN3_A_CADENCE,                     // int32        | public
    INTEL_CONTROL_VIEW_PROJECTION,                    // byte[]       | public
    INTEL_CONTROL_VIEW_ROTATION,                      // byte[]       | public
    INTEL_CONTROL_VIEW_FINE_ADJUSTMENTS,              // byte[]       | public
    INTEL_CONTROL_CAMERA_ROTATION,                    // byte[]       | public
    INTEL_CONTROL_SCALER_CROP_REGION,                 // int32[]      | public
    INTEL_CONTROL_END,

    INTEL_CONTROL_ISP_SUPPORTED_CTRL_IDS =            // int32[]      | public
            INTEL_CONTROL_ISP_START,
    INTEL_CONTROL_ISP_ENABLED_CTRL_IDS,               // int32[]      | public
    INTEL_CONTROL_ISP_WB_GAINS,                       // byte[]       | public
    INTEL_CONTROL_ISP_COLOR_CORRECTION_MATRIX,        // byte[]       | public
    INTEL_CONTROL_ISP_ADVANCED_COLOR_CORRECTION_MATRIX,
                                                      // byte[]       | public
    INTEL_CONTROL_ISP_BXT_CSC,                        // byte[]       | public
    INTEL_CONTROL_ISP_BXT_DEMOSAIC,                   // byte[]       | public
    INTEL_CONTROL_ISP_SC_IEFD,                        // byte[]       | public
    INTEL_CONTROL_ISP_SEE,                            // byte[]       | public
    INTEL_CONTROL_ISP_BNLM,                           // byte[]       | public
    INTEL_CONTROL_ISP_TNR5_21,                        // byte[]       | public
    INTEL_CONTROL_ISP_XNR_DSS,                        // byte[]       | public
    INTEL_CONTROL_ISP_GAMMA_TONE_MAP,                 // byte[]       | public
    INTEL_CONTROL_ISP_TNR5_22,                        // byte[]       | public
    INTEL_CONTROL_ISP_TNR5_25,                        // byte[]       | public
    INTEL_CONTROL_ISP_END,

} icamera_metadata_tag_t;

/**
 * Enumeration definitions for the various entries that need them
 */

// CAMERA_AE_MODE
typedef enum icamera_metadata_enum_camera_ae_mode {
    CAMERA_AE_MODE_MANUAL,
    CAMERA_AE_MODE_AUTO,
} icamera_metadata_enum_camera_ae_mode_t;

// CAMERA_AE_LOCK
typedef enum icamera_metadata_enum_camera_ae_lock {
    CAMERA_AE_LOCK_OFF,
    CAMERA_AE_LOCK_ON,
} icamera_metadata_enum_camera_ae_lock_t;

// CAMERA_AE_ANTIBANDING_MODE
typedef enum icamera_metadata_enum_camera_ae_antibanding_mode {
    CAMERA_AE_ANTIBANDING_MODE_AUTO,
    CAMERA_AE_ANTIBANDING_MODE_50HZ,
    CAMERA_AE_ANTIBANDING_MODE_60HZ,
    CAMERA_AE_ANTIBANDING_MODE_OFF,
} icamera_metadata_enum_camera_ae_antibanding_mode_t;

// CAMERA_AE_PRECAPTURE_TRIGGER
typedef enum icamera_metadata_enum_camera_ae_precapture_trigger {
    CAMERA_AE_PRECAPTURE_TRIGGER_IDLE,
    CAMERA_AE_PRECAPTURE_TRIGGER_START,
} icamera_metadata_enum_camera_ae_precapture_trigger_t;

// CAMERA_AE_STATE
typedef enum icamera_metadata_enum_camera_ae_state {
    CAMERA_AE_STATE_INACTIVE,
    CAMERA_AE_STATE_SEARCHING,
    CAMERA_AE_STATE_CONVERGED,
    CAMERA_AE_STATE_LOCKED,
    CAMERA_AE_STATE_FLASH_REQUIRED,
    CAMERA_AE_STATE_PRECAPTURE,
} icamera_metadata_enum_camera_ae_state_t;

// CAMERA_AE_LOCK_AVAILABLE
typedef enum icamera_metadata_enum_camera_ae_lock_available {
    CAMERA_AE_LOCK_AVAILABLE_FALSE,
    CAMERA_AE_LOCK_AVAILABLE_TRUE,
} icamera_metadata_enum_camera_ae_lock_available_t;

// CAMERA_AWB_MODE
typedef enum icamera_metadata_enum_camera_awb_mode {
    CAMERA_AWB_MODE_AUTO,
    CAMERA_AWB_MODE_INCANDESCENT,
    CAMERA_AWB_MODE_FLUORESCENT,
    CAMERA_AWB_MODE_DAYLIGHT,
    CAMERA_AWB_MODE_FULL_OVERCAST,
    CAMERA_AWB_MODE_PARTLY_OVERCAST,
    CAMERA_AWB_MODE_SUNSET,
    CAMERA_AWB_MODE_VIDEO_CONFERENCE,
    CAMERA_AWB_MODE_MANUAL_CCT_RANGE,
    CAMERA_AWB_MODE_MANUAL_WHITE_POINT,
    CAMERA_AWB_MODE_MANUAL_GAIN,
    CAMERA_AWB_MODE_MANUAL_COLOR_TRANSFORM,
} icamera_metadata_enum_camera_awb_mode_t;

// CAMERA_AWB_LOCK
typedef enum icamera_metadata_enum_camera_awb_lock {
    CAMERA_AWB_LOCK_OFF,
    CAMERA_AWB_LOCK_ON,
} icamera_metadata_enum_camera_awb_lock_t;

// CAMERA_AWB_CONVERGE_SPEED
typedef enum icamera_metadata_enum_camera_awb_converge_speed {
    CAMERA_AWB_CONVERGE_SPEED_NORMAL,
    CAMERA_AWB_CONVERGE_SPEED_MID,
    CAMERA_AWB_CONVERGE_SPEED_LOW,
} icamera_metadata_enum_camera_awb_converge_speed_t;

// CAMERA_AWB_CONVERGE_SPEED_MODE
typedef enum icamera_metadata_enum_camera_awb_converge_speed_mode {
    CAMERA_AWB_CONVERGE_SPEED_MODE_HAL,
    CAMERA_AWB_CONVERGE_SPEED_MODE_AIQ,
} icamera_metadata_enum_camera_awb_converge_speed_mode_t;

// CAMERA_AWB_STATE
typedef enum icamera_metadata_enum_camera_awb_state {
    CAMERA_AWB_STATE_INACTIVE,
    CAMERA_AWB_STATE_SEARCHING,
    CAMERA_AWB_STATE_CONVERGED,
    CAMERA_AWB_STATE_LOCKED,
} icamera_metadata_enum_camera_awb_state_t;

// CAMERA_AWB_LOCK_AVAILABLE
typedef enum icamera_metadata_enum_camera_awb_lock_available {
    CAMERA_AWB_LOCK_AVAILABLE_FALSE,
    CAMERA_AWB_LOCK_AVAILABLE_TRUE,
} icamera_metadata_enum_camera_awb_lock_available_t;

// CAMERA_AF_MODE
typedef enum icamera_metadata_enum_camera_af_mode {
    CAMERA_AF_MODE_OFF,
    CAMERA_AF_MODE_AUTO,
    CAMERA_AF_MODE_MACRO,
    CAMERA_AF_MODE_CONTINUOUS_VIDEO,
    CAMERA_AF_MODE_CONTINUOUS_PICTURE,
    CAMERA_AF_MODE_EDOF,
} icamera_metadata_enum_camera_af_mode_t;

// CAMERA_AF_TRIGGER
typedef enum icamera_metadata_enum_camera_af_trigger {
    CAMERA_AF_TRIGGER_IDLE,
    CAMERA_AF_TRIGGER_START,
    CAMERA_AF_TRIGGER_CANCEL,
} icamera_metadata_enum_camera_af_trigger_t;

// CAMERA_AF_STATE
typedef enum icamera_metadata_enum_camera_af_state {
    CAMERA_AF_STATE_INACTIVE,
    CAMERA_AF_STATE_PASSIVE_SCAN,
    CAMERA_AF_STATE_PASSIVE_FOCUSED,
    CAMERA_AF_STATE_ACTIVE_SCAN,
    CAMERA_AF_STATE_FOCUSED_LOCKED,
    CAMERA_AF_STATE_NOT_FOCUSED_LOCKED,
    CAMERA_AF_STATE_PASSIVE_UNFOCUSED,
} icamera_metadata_enum_camera_af_state_t;

// CAMERA_CONTROL_CAPTUREINTENT
typedef enum icamera_metadata_enum_camera_control_captureintent {
    CAMERA_CONTROL_CAPTUREINTENT_CUSTOM,
    CAMERA_CONTROL_CAPTUREINTENT_PREVIEW,
    CAMERA_CONTROL_CAPTUREINTENT_STILL_CAPTURE,
    CAMERA_CONTROL_CAPTUREINTENT_VIDEO_RECORD,
    CAMERA_CONTROL_CAPTUREINTENT_VIDEO_SNAPSHOT,
    CAMERA_CONTROL_CAPTUREINTENT_ZERO_SHUTTER_LAG,
    CAMERA_CONTROL_CAPTUREINTENT_MANUAL,
    CAMERA_CONTROL_CAPTUREINTENT_MOTION_TRACKING,
} icamera_metadata_enum_camera_control_captureintent_t;

// CAMERA_CONTROL_EFFECT_MODE
typedef enum icamera_metadata_enum_camera_control_effect_mode {
    CAMERA_CONTROL_EFFECT_MODE_OFF,
    CAMERA_CONTROL_EFFECT_MODE_MONO,
    CAMERA_CONTROL_EFFECT_MODE_NEGATIVE,
    CAMERA_CONTROL_EFFECT_MODE_SOLARIZE,
    CAMERA_CONTROL_EFFECT_MODE_SEPIA,
    CAMERA_CONTROL_EFFECT_MODE_POSTERIZE,
    CAMERA_CONTROL_EFFECT_MODE_WHITEBOARD,
    CAMERA_CONTROL_EFFECT_MODE_BLACKBOARD,
    CAMERA_CONTROL_EFFECT_MODE_AQUA,
} icamera_metadata_enum_camera_control_effect_mode_t;

// CAMERA_CONTROL_MODE
typedef enum icamera_metadata_enum_camera_control_mode {
    CAMERA_CONTROL_MODE_OFF,
    CAMERA_CONTROL_MODE_AUTO,
    CAMERA_CONTROL_MODE_USE_SCENE_MODE,
    CAMERA_CONTROL_MODE_OFF_KEEP_STATE,
} icamera_metadata_enum_camera_control_mode_t;

// CAMERA_CONTROL_SCENE_MODE
typedef enum icamera_metadata_enum_camera_control_scene_mode {
    CAMERA_CONTROL_SCENE_MODE_DISABLED                          = 0,
    CAMERA_CONTROL_SCENE_MODE_FACE_PRIORITY,
    CAMERA_CONTROL_SCENE_MODE_ACTION,
    CAMERA_CONTROL_SCENE_MODE_PORTRAIT,
    CAMERA_CONTROL_SCENE_MODE_LANDSCAPE,
    CAMERA_CONTROL_SCENE_MODE_NIGHT,
    CAMERA_CONTROL_SCENE_MODE_NIGHT_PORTRAIT,
    CAMERA_CONTROL_SCENE_MODE_THEATRE,
    CAMERA_CONTROL_SCENE_MODE_BEACH,
    CAMERA_CONTROL_SCENE_MODE_SNOW,
    CAMERA_CONTROL_SCENE_MODE_SUNSET,
    CAMERA_CONTROL_SCENE_MODE_STEADYPHOTO,
    CAMERA_CONTROL_SCENE_MODE_FIREWORKS,
    CAMERA_CONTROL_SCENE_MODE_SPORTS,
    CAMERA_CONTROL_SCENE_MODE_PARTY,
    CAMERA_CONTROL_SCENE_MODE_CANDLELIGHT,
    CAMERA_CONTROL_SCENE_MODE_BARCODE,
    CAMERA_CONTROL_SCENE_MODE_HIGH_SPEED_VIDEO,
    CAMERA_CONTROL_SCENE_MODE_HDR,
} icamera_metadata_enum_camera_control_scene_mode_t;

// CAMERA_CONTROL_VIDEO_STABILIZATION_MODE
typedef enum icamera_metadata_enum_camera_control_video_stabilization_mode {
    CAMERA_CONTROL_VIDEO_STABILIZATION_MODE_OFF,
    CAMERA_CONTROL_VIDEO_STABILIZATION_MODE_ON,
} icamera_metadata_enum_camera_control_video_stabilization_mode_t;

// CAMERA_DEMOSAIC_MODE
typedef enum icamera_metadata_enum_camera_demosaic_mode {
    CAMERA_DEMOSAIC_MODE_FAST,
    CAMERA_DEMOSAIC_MODE_HIGH_QUALITY,
} icamera_metadata_enum_camera_demosaic_mode_t;

// CAMERA_EDGE_MODE
typedef enum icamera_metadata_enum_camera_edge_mode {
    CAMERA_EDGE_MODE_OFF,
    CAMERA_EDGE_MODE_FAST,
    CAMERA_EDGE_MODE_HIGH_QUALITY,
    CAMERA_EDGE_MODE_ZERO_SHUTTER_LAG,
} icamera_metadata_enum_camera_edge_mode_t;

// CAMERA_FLASH_MODE
typedef enum icamera_metadata_enum_camera_flash_mode {
    CAMERA_FLASH_MODE_OFF,
    CAMERA_FLASH_MODE_SINGLE,
    CAMERA_FLASH_MODE_TORCH,
} icamera_metadata_enum_camera_flash_mode_t;

// CAMERA_FLASH_STATE
typedef enum icamera_metadata_enum_camera_flash_state {
    CAMERA_FLASH_STATE_UNAVAILABLE,
    CAMERA_FLASH_STATE_CHARGING,
    CAMERA_FLASH_STATE_READY,
    CAMERA_FLASH_STATE_FIRED,
    CAMERA_FLASH_STATE_PARTIAL,
} icamera_metadata_enum_camera_flash_state_t;

// CAMERA_FLASH_INFO_AVAILABLE
typedef enum icamera_metadata_enum_camera_flash_info_available {
    CAMERA_FLASH_INFO_AVAILABLE_FALSE,
    CAMERA_FLASH_INFO_AVAILABLE_TRUE,
} icamera_metadata_enum_camera_flash_info_available_t;

// CAMERA_HOT_PIXEL_MODE
typedef enum icamera_metadata_enum_camera_hot_pixel_mode {
    CAMERA_HOT_PIXEL_MODE_OFF,
    CAMERA_HOT_PIXEL_MODE_FAST,
    CAMERA_HOT_PIXEL_MODE_HIGH_QUALITY,
} icamera_metadata_enum_camera_hot_pixel_mode_t;

// CAMERA_LENS_OPTICAL_STABILIZATION_MODE
typedef enum icamera_metadata_enum_camera_lens_optical_stabilization_mode {
    CAMERA_LENS_OPTICAL_STABILIZATION_MODE_OFF,
    CAMERA_LENS_OPTICAL_STABILIZATION_MODE_ON,
} icamera_metadata_enum_camera_lens_optical_stabilization_mode_t;

// CAMERA_LENS_FACING
typedef enum icamera_metadata_enum_camera_lens_facing {
    CAMERA_LENS_FACING_FRONT,
    CAMERA_LENS_FACING_BACK,
} icamera_metadata_enum_camera_lens_facing_t;

// CAMERA_LENS_STATE
typedef enum icamera_metadata_enum_camera_lens_state {
    CAMERA_LENS_STATE_STATIONARY,
    CAMERA_LENS_STATE_MOVING,
} icamera_metadata_enum_camera_lens_state_t;

// CAMERA_LENS_INFO_FOCUS_DISTANCE_CALIBRATION
typedef enum icamera_metadata_enum_camera_lens_info_focus_distance_calibration {
    CAMERA_LENS_INFO_FOCUS_DISTANCE_CALIBRATION_UNCALIBRATED,
    CAMERA_LENS_INFO_FOCUS_DISTANCE_CALIBRATION_APPROXIMATE,
    CAMERA_LENS_INFO_FOCUS_DISTANCE_CALIBRATION_CALIBRATED,
} icamera_metadata_enum_camera_lens_info_focus_distance_calibration_t;

// CAMERA_NOISE_REDUCTION_MODE
typedef enum icamera_metadata_enum_camera_noise_reduction_mode {
    CAMERA_NOISE_REDUCTION_MODE_OFF,
    CAMERA_NOISE_REDUCTION_MODE_FAST,
    CAMERA_NOISE_REDUCTION_MODE_HIGH_QUALITY,
    CAMERA_NOISE_REDUCTION_MODE_MINIMAL,
    CAMERA_NOISE_REDUCTION_MODE_ZERO_SHUTTER_LAG,
} icamera_metadata_enum_camera_noise_reduction_mode_t;

// CAMERA_REQUEST_METADATA_MODE
typedef enum icamera_metadata_enum_camera_request_metadata_mode {
    CAMERA_REQUEST_METADATA_MODE_NONE,
    CAMERA_REQUEST_METADATA_MODE_FULL,
} icamera_metadata_enum_camera_request_metadata_mode_t;

// CAMERA_REQUEST_AVAILABLE_CAPABILITIES
typedef enum icamera_metadata_enum_camera_request_available_capabilities {
    CAMERA_REQUEST_AVAILABLE_CAPABILITIES_BACKWARD_COMPATIBLE,
    CAMERA_REQUEST_AVAILABLE_CAPABILITIES_MANUAL_SENSOR,
    CAMERA_REQUEST_AVAILABLE_CAPABILITIES_MANUAL_POST_PROCESSING,
    CAMERA_REQUEST_AVAILABLE_CAPABILITIES_RAW,
    CAMERA_REQUEST_AVAILABLE_CAPABILITIES_ZSL,
    CAMERA_REQUEST_AVAILABLE_CAPABILITIES_READ_SENSOR_SETTINGS,
    CAMERA_REQUEST_AVAILABLE_CAPABILITIES_BURST_CAPTURE,
} icamera_metadata_enum_camera_request_available_capabilities_t;

// CAMERA_SCALER_CROPPING_TYPE
typedef enum icamera_metadata_enum_camera_scaler_cropping_type {
    CAMERA_SCALER_CROPPING_TYPE_CENTER_ONLY,
    CAMERA_SCALER_CROPPING_TYPE_FREEFORM,
} icamera_metadata_enum_camera_scaler_cropping_type_t;

// CAMERA_SENSOR_REFERENCE_ILLUMINANT1
typedef enum icamera_metadata_enum_camera_sensor_reference_illuminant1 {
    CAMERA_SENSOR_REFERENCE_ILLUMINANT1_DAYLIGHT                = 1,
    CAMERA_SENSOR_REFERENCE_ILLUMINANT1_FLUORESCENT             = 2,
    CAMERA_SENSOR_REFERENCE_ILLUMINANT1_TUNGSTEN                = 3,
    CAMERA_SENSOR_REFERENCE_ILLUMINANT1_FLASH                   = 4,
    CAMERA_SENSOR_REFERENCE_ILLUMINANT1_FINE_WEATHER            = 9,
    CAMERA_SENSOR_REFERENCE_ILLUMINANT1_CLOUDY_WEATHER          = 10,
    CAMERA_SENSOR_REFERENCE_ILLUMINANT1_SHADE                   = 11,
    CAMERA_SENSOR_REFERENCE_ILLUMINANT1_DAYLIGHT_FLUORESCENT    = 12,
    CAMERA_SENSOR_REFERENCE_ILLUMINANT1_DAY_WHITE_FLUORESCENT   = 13,
    CAMERA_SENSOR_REFERENCE_ILLUMINANT1_COOL_WHITE_FLUORESCENT  = 14,
    CAMERA_SENSOR_REFERENCE_ILLUMINANT1_WHITE_FLUORESCENT       = 15,
    CAMERA_SENSOR_REFERENCE_ILLUMINANT1_STANDARD_A              = 17,
    CAMERA_SENSOR_REFERENCE_ILLUMINANT1_STANDARD_B              = 18,
    CAMERA_SENSOR_REFERENCE_ILLUMINANT1_STANDARD_C              = 19,
    CAMERA_SENSOR_REFERENCE_ILLUMINANT1_D55                     = 20,
    CAMERA_SENSOR_REFERENCE_ILLUMINANT1_D65                     = 21,
    CAMERA_SENSOR_REFERENCE_ILLUMINANT1_D75                     = 22,
    CAMERA_SENSOR_REFERENCE_ILLUMINANT1_D50                     = 23,
    CAMERA_SENSOR_REFERENCE_ILLUMINANT1_ISO_STUDIO_TUNGSTEN     = 24,
} icamera_metadata_enum_camera_sensor_reference_illuminant1_t;

// CAMERA_SENSOR_TEST_PATTERN_MODE
typedef enum icamera_metadata_enum_camera_sensor_test_pattern_mode {
    CAMERA_SENSOR_TEST_PATTERN_MODE_OFF,
    CAMERA_SENSOR_TEST_PATTERN_MODE_SOLID_COLOR,
    CAMERA_SENSOR_TEST_PATTERN_MODE_COLOR_BARS,
    CAMERA_SENSOR_TEST_PATTERN_MODE_COLOR_BARS_FADE_TO_GRAY,
    CAMERA_SENSOR_TEST_PATTERN_MODE_PN9,
    CAMERA_SENSOR_TEST_PATTERN_MODE_CUSTOM1                     = 256,
} icamera_metadata_enum_camera_sensor_test_pattern_mode_t;

// CAMERA_SENSOR_INFO_COLOR_FILTER_ARRANGEMENT
typedef enum icamera_metadata_enum_camera_sensor_info_color_filter_arrangement {
    CAMERA_SENSOR_INFO_COLOR_FILTER_ARRANGEMENT_RGGB,
    CAMERA_SENSOR_INFO_COLOR_FILTER_ARRANGEMENT_GRBG,
    CAMERA_SENSOR_INFO_COLOR_FILTER_ARRANGEMENT_GBRG,
    CAMERA_SENSOR_INFO_COLOR_FILTER_ARRANGEMENT_BGGR,
    CAMERA_SENSOR_INFO_COLOR_FILTER_ARRANGEMENT_RGB,
} icamera_metadata_enum_camera_sensor_info_color_filter_arrangement_t;

// CAMERA_SENSOR_INFO_TIMESTAMP_SOURCE
typedef enum icamera_metadata_enum_camera_sensor_info_timestamp_source {
    CAMERA_SENSOR_INFO_TIMESTAMP_SOURCE_UNKNOWN,
    CAMERA_SENSOR_INFO_TIMESTAMP_SOURCE_REALTIME,
} icamera_metadata_enum_camera_sensor_info_timestamp_source_t;

// CAMERA_SHADING_MODE
typedef enum icamera_metadata_enum_camera_shading_mode {
    CAMERA_SHADING_MODE_OFF,
    CAMERA_SHADING_MODE_FAST,
    CAMERA_SHADING_MODE_HIGH_QUALITY,
} icamera_metadata_enum_camera_shading_mode_t;

// CAMERA_STATISTICS_FACE_DETECT_MODE
typedef enum icamera_metadata_enum_camera_statistics_face_detect_mode {
    CAMERA_STATISTICS_FACE_DETECT_MODE_OFF,
    CAMERA_STATISTICS_FACE_DETECT_MODE_SIMPLE,
    CAMERA_STATISTICS_FACE_DETECT_MODE_FULL,
} icamera_metadata_enum_camera_statistics_face_detect_mode_t;

// CAMERA_STATISTICS_HISTOGRAM_MODE
typedef enum icamera_metadata_enum_camera_statistics_histogram_mode {
    CAMERA_STATISTICS_HISTOGRAM_MODE_OFF,
    CAMERA_STATISTICS_HISTOGRAM_MODE_ON,
} icamera_metadata_enum_camera_statistics_histogram_mode_t;

// CAMERA_STATISTICS_SHARPNESS_MAP_MODE
typedef enum icamera_metadata_enum_camera_statistics_sharpness_map_mode {
    CAMERA_STATISTICS_SHARPNESS_MAP_MODE_OFF,
    CAMERA_STATISTICS_SHARPNESS_MAP_MODE_ON,
} icamera_metadata_enum_camera_statistics_sharpness_map_mode_t;

// CAMERA_STATISTICS_HOT_PIXEL_MAP_MODE
typedef enum icamera_metadata_enum_camera_statistics_hot_pixel_map_mode {
    CAMERA_STATISTICS_HOT_PIXEL_MAP_MODE_OFF,
    CAMERA_STATISTICS_HOT_PIXEL_MAP_MODE_ON,
} icamera_metadata_enum_camera_statistics_hot_pixel_map_mode_t;

// CAMERA_STATISTICS_SCENE_FLICKER
typedef enum icamera_metadata_enum_camera_statistics_scene_flicker {
    CAMERA_STATISTICS_SCENE_FLICKER_NONE,
    CAMERA_STATISTICS_SCENE_FLICKER_50HZ,
    CAMERA_STATISTICS_SCENE_FLICKER_60HZ,
} icamera_metadata_enum_camera_statistics_scene_flicker_t;

// CAMERA_STATISTICS_LENS_SHADING_MAP_MODE
typedef enum icamera_metadata_enum_camera_statistics_lens_shading_map_mode {
    CAMERA_STATISTICS_LENS_SHADING_MAP_MODE_OFF,
    CAMERA_STATISTICS_LENS_SHADING_MAP_MODE_ON,
} icamera_metadata_enum_camera_statistics_lens_shading_map_mode_t;

// CAMERA_TONEMAP_MODE
typedef enum icamera_metadata_enum_camera_tonemap_mode {
    CAMERA_TONEMAP_MODE_CONTRAST_CURVE,
    CAMERA_TONEMAP_MODE_FAST,
    CAMERA_TONEMAP_MODE_HIGH_QUALITY,
    CAMERA_TONEMAP_MODE_GAMMA_VALUE,
    CAMERA_TONEMAP_MODE_PRESET_CURVE,
} icamera_metadata_enum_camera_tonemap_mode_t;

// CAMERA_TONEMAP_PRESET_CURVE
typedef enum icamera_metadata_enum_camera_tonemap_preset_curve {
    CAMERA_TONEMAP_PRESET_CURVE_SRGB,
    CAMERA_TONEMAP_PRESET_CURVE_REC709,
} icamera_metadata_enum_camera_tonemap_preset_curve_t;

// CAMERA_LED_TRANSMIT
typedef enum icamera_metadata_enum_camera_led_transmit {
    CAMERA_LED_TRANSMIT_OFF,
    CAMERA_LED_TRANSMIT_ON,
} icamera_metadata_enum_camera_led_transmit_t;

// CAMERA_LED_AVAILABLE_LEDS
typedef enum icamera_metadata_enum_camera_led_available_leds {
    CAMERA_LED_AVAILABLE_LEDS_TRANSMIT,
} icamera_metadata_enum_camera_led_available_leds_t;

// CAMERA_INFO_SUPPORTED_HARDWARE_LEVEL
typedef enum icamera_metadata_enum_camera_info_supported_hardware_level {
    CAMERA_INFO_SUPPORTED_HARDWARE_LEVEL_LIMITED,
    CAMERA_INFO_SUPPORTED_HARDWARE_LEVEL_FULL,
    CAMERA_INFO_SUPPORTED_HARDWARE_LEVEL_LEGACY,
} icamera_metadata_enum_camera_info_supported_hardware_level_t;

// CAMERA_BLACK_LEVEL_LOCK
typedef enum icamera_metadata_enum_camera_black_level_lock {
    CAMERA_BLACK_LEVEL_LOCK_OFF,
    CAMERA_BLACK_LEVEL_LOCK_ON,
} icamera_metadata_enum_camera_black_level_lock_t;

// CAMERA_SYNC_FRAME_NUMBER
typedef enum icamera_metadata_enum_camera_sync_frame_number {
    CAMERA_SYNC_FRAME_NUMBER_CONVERGING                         = -1,
    CAMERA_SYNC_FRAME_NUMBER_UNKNOWN                            = -2,
} icamera_metadata_enum_camera_sync_frame_number_t;

// CAMERA_SYNC_MAX_LATENCY
typedef enum icamera_metadata_enum_camera_sync_max_latency {
    CAMERA_SYNC_MAX_LATENCY_PER_FRAME_CONTROL                   = 0,
    CAMERA_SYNC_MAX_LATENCY_UNKNOWN                             = -1,
} icamera_metadata_enum_camera_sync_max_latency_t;

// INTEL_INFO_AVAILABLE_FEATURES
typedef enum icamera_metadata_enum_intel_info_available_features {
    INTEL_INFO_AVAILABLE_FEATURES_MANUAL_EXPOSURE               = 0,
    INTEL_INFO_AVAILABLE_FEATURES_MANUAL_WHITE_BALANCE          = 1,
    INTEL_INFO_AVAILABLE_FEATURES_IMAGE_ENHANCEMENT             = 2,
    INTEL_INFO_AVAILABLE_FEATURES_NOISE_REDUCTION               = 3,
    INTEL_INFO_AVAILABLE_FEATURES_SCENE_MODE                    = 4,
    INTEL_INFO_AVAILABLE_FEATURES_WEIGHT_GRID_MODE              = 5,
    INTEL_INFO_AVAILABLE_FEATURES_PER_FRAME_CONTROL             = 6,
    INTEL_INFO_AVAILABLE_FEATURES_ISP_CONTROL                   = 7,
} icamera_metadata_enum_intel_info_available_features_t;

// INTEL_INFO_WFOV
typedef enum icamera_metadata_enum_intel_info_wfov {
    INTEL_INFO_WFOV_OFF,
    INTEL_INFO_WFOV_ON,
} icamera_metadata_enum_intel_info_wfov_t;

// INTEL_INFO_SENSOR_MOUNT_TYPE
typedef enum icamera_metadata_enum_intel_info_sensor_mount_type {
    INTEL_INFO_SENSOR_MOUNT_TYPE_WALL_MOUNTED,
    INTEL_INFO_SENSOR_MOUNT_TYPE_CEILING_MOUNTER,
} icamera_metadata_enum_intel_info_sensor_mount_type_t;

// INTEL_CONTROL_AE_CONVERGE_SPEED
typedef enum icamera_metadata_enum_intel_control_ae_converge_speed {
    INTEL_CONTROL_AE_CONVERGE_SPEED_NORMAL,
    INTEL_CONTROL_AE_CONVERGE_SPEED_MID,
    INTEL_CONTROL_AE_CONVERGE_SPEED_LOW,
} icamera_metadata_enum_intel_control_ae_converge_speed_t;

// INTEL_CONTROL_NR_MODE
typedef enum icamera_metadata_enum_intel_control_nr_mode {
    INTEL_CONTROL_NR_MODE_OFF,
    INTEL_CONTROL_NR_MODE_AUTO,
    INTEL_CONTROL_NR_MODE_MANUAL_NORMAL,
    INTEL_CONTROL_NR_MODE_MANUAL_EXPERT,
} icamera_metadata_enum_intel_control_nr_mode_t;

// INTEL_CONTROL_IRIS_MODE
typedef enum icamera_metadata_enum_intel_control_iris_mode {
    INTEL_CONTROL_IRIS_MODE_AUTO,
    INTEL_CONTROL_IRIS_MODE_MANUAL,
    INTEL_CONTROL_IRIS_MODE_CUSTOMIZED,
} icamera_metadata_enum_intel_control_iris_mode_t;

// INTEL_CONTROL_AE_DISTRIBUTION_PRIORITY
typedef enum icamera_metadata_enum_intel_control_ae_distribution_priority {
    INTEL_CONTROL_AE_DISTRIBUTION_PRIORITY_AUTO,
    INTEL_CONTROL_AE_DISTRIBUTION_PRIORITY_SHUTTER,
    INTEL_CONTROL_AE_DISTRIBUTION_PRIORITY_ISO,
    INTEL_CONTROL_AE_DISTRIBUTION_PRIORITY_APERTURE,
} icamera_metadata_enum_intel_control_ae_distribution_priority_t;

// INTEL_CONTROL_WDR_MODE
typedef enum icamera_metadata_enum_intel_control_wdr_mode {
    INTEL_CONTROL_WDR_MODE_OFF,
    INTEL_CONTROL_WDR_MODE_ON,
    INTEL_CONTROL_WDR_MODE_AUTO,
} icamera_metadata_enum_intel_control_wdr_mode_t;

// INTEL_CONTROL_BLC_AREA_MODE
typedef enum icamera_metadata_enum_intel_control_blc_area_mode {
    INTEL_CONTROL_BLC_AREA_MODE_OFF,
    INTEL_CONTROL_BLC_AREA_MODE_ON,
} icamera_metadata_enum_intel_control_blc_area_mode_t;

// INTEL_CONTROL_SCENE_MODE
typedef enum icamera_metadata_enum_intel_control_scene_mode {
    INTEL_CONTROL_SCENE_MODE_AUTO,
    INTEL_CONTROL_SCENE_MODE_HDR,
    INTEL_CONTROL_SCENE_MODE_ULL,
    INTEL_CONTROL_SCENE_MODE_VIDEO_LL,
    INTEL_CONTROL_SCENE_MODE_HDR2,
} icamera_metadata_enum_intel_control_scene_mode_t;

// INTEL_CONTROL_WEIGHT_GRID_MODE
typedef enum icamera_metadata_enum_intel_control_weight_grid_mode {
    INTEL_CONTROL_WEIGHT_GRID_MODE_AUTO,
    INTEL_CONTROL_WEIGHT_GRID_MODE_CUSTOM_WEIGHT_GRID1,
    INTEL_CONTROL_WEIGHT_GRID_MODE_CUSTOM_WEIGHT_GRID2,
    INTEL_CONTROL_WEIGHT_GRID_MODE_CUSTOM_WEIGHT_GRID3,
} icamera_metadata_enum_intel_control_weight_grid_mode_t;

// INTEL_CONTROL_AE_CONVERGE_SPEED_MODE
typedef enum icamera_metadata_enum_intel_control_ae_converge_speed_mode {
    INTEL_CONTROL_AE_CONVERGE_SPEED_MODE_HAL,
    INTEL_CONTROL_AE_CONVERGE_SPEED_MODE_AIQ,
} icamera_metadata_enum_intel_control_ae_converge_speed_mode_t;

// INTEL_CONTROL_DEINTERLACE_MODE
typedef enum icamera_metadata_enum_intel_control_deinterlace_mode {
    INTEL_CONTROL_DEINTERLACE_MODE_OFF,
    INTEL_CONTROL_DEINTERLACE_MODE_WEAVING,
} icamera_metadata_enum_intel_control_deinterlace_mode_t;

// INTEL_CONTROL_YUV_COLOR_RANGE
typedef enum icamera_metadata_enum_intel_control_yuv_color_range {
    INTEL_CONTROL_YUV_COLOR_RANGE_FULL,
    INTEL_CONTROL_YUV_COLOR_RANGE_REDUCED,
} icamera_metadata_enum_intel_control_yuv_color_range_t;

// INTEL_CONTROL_FISHEYE_DEWARPING_MODE
typedef enum icamera_metadata_enum_intel_control_fisheye_dewarping_mode {
    INTEL_CONTROL_FISHEYE_DEWARPING_MODE_OFF,
    INTEL_CONTROL_FISHEYE_DEWARPING_MODE_REARVIEW,
    INTEL_CONTROL_FISHEYE_DEWARPING_MODE_HITCHVIEW,
} icamera_metadata_enum_intel_control_fisheye_dewarping_mode_t;

// INTEL_CONTROL_LDC_MODE
typedef enum icamera_metadata_enum_intel_control_ldc_mode {
    INTEL_CONTROL_LDC_MODE_OFF,
    INTEL_CONTROL_LDC_MODE_ON,
} icamera_metadata_enum_intel_control_ldc_mode_t;

// INTEL_CONTROL_RSC_MODE
typedef enum icamera_metadata_enum_intel_control_rsc_mode {
    INTEL_CONTROL_RSC_MODE_OFF,
    INTEL_CONTROL_RSC_MODE_ON,
} icamera_metadata_enum_intel_control_rsc_mode_t;

// INTEL_CONTROL_FLIP_MODE
typedef enum icamera_metadata_enum_intel_control_flip_mode {
    INTEL_CONTROL_FLIP_MODE_NONE,
    INTEL_CONTROL_FLIP_MODE_VFLIP,
    INTEL_CONTROL_FLIP_MODE_HFLIP,
    INTEL_CONTROL_FLIP_MODE_VHFLIP,
} icamera_metadata_enum_intel_control_flip_mode_t;

// INTEL_CONTROL_MONO_DOWNSCALE
typedef enum icamera_metadata_enum_intel_control_mono_downscale {
    INTEL_CONTROL_MONO_DOWNSCALE_OFF,
    INTEL_CONTROL_MONO_DOWNSCALE_ON,
} icamera_metadata_enum_intel_control_mono_downscale_t;

