/*
 * Hornsey - Moblin Media Player.
 * Copyright © 2009 Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef __HRN_VIEW_H__
#define __HRN_VIEW_H__

#include <clutter/clutter.h>

G_BEGIN_DECLS

#define HRN_TYPE_VIEW    (hrn_view_get_type ())

#define HRN_VIEW(obj)         \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), HRN_TYPE_VIEW, HrnView))

#define HRN_VIEW_CLASS(klass)       \
  (G_TYPE_CHECK_CLASS_CAST ((klass), HRN_TYPE_VIEW,  HrnViewClass))

#define HRN_IS_VIEW(obj)      \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj),  HRN_TYPE_VIEW))

#define HRN_IS_VIEW_CLASS(klass)  \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), HRN_TYPE_VIEW))

#define HRN_VIEW_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), HRN_TYPE_VIEW,  HrnViewClass))

typedef struct _HrnView HrnView;
typedef struct _HrnViewClass HrnViewClass;
typedef struct _HrnViewPrivate HrnViewPrivate;

struct _HrnViewClass
{
  ClutterActorClass parent_class;
};

struct _HrnView
{
  ClutterActor parent;

  HrnViewPrivate *priv;
  gint            bkl_item_type_mask;
  gchar          *search;

  gboolean dirty_frames;
};

GType         hrn_view_get_type (void) G_GNUC_CONST;

ClutterActor *hrn_view_new (void);

/* the following functions should be made proper methods of the
 * ClusterView (or flow) class
 */

gint          hrn_view_center      (ClutterActor *self,
                                    gint          item_no);
ClutterActor *hrn_view_build       ();
void          hrn_view_start       (void);
void          hrn_set_zoom         (gdouble zoom);
void          hrn_set_zoom_hard    (gdouble zoom);  /* without animation */
gdouble       hrn_get_zoom         (void);
gint          hrn_view_get_pos     (void);
void          hrn_view_set_pos     (gint pos);
gdouble       hrn_view_get_loc     (void);
void          hrn_view_set_loc     (gdouble loc);
gint          hrn_view_get_count   (void);
void          hrn_view_scroll      (gdouble stage_percentage);
BklItem *     hrn_view_item_to_bkl_item (gint item);
gint          hrn_view_find_uri    (const gchar *uri);
gfloat        hrn_view_compute_x   (gint    num,
                                    gint    accum_pos,
                                    gdouble scale);
gfloat        hrn_view_compute_y   (gint    num,
                                    gint    accum_pos,
                                     gdouble scale);
void         hrn_view_set_source    (HrnView      *view,
                                     HrnSource    *source);
HrnSource*   hrn_view_get_source    (HrnView      *view);
guint        hrn_view_get_filter    (HrnView      *view);
void         hrn_view_set_filter    (HrnView      *view,
                                     guint         bkl_item_type_mask);
void         hrn_view_set_search     (HrnView     *view,
                                      const gchar *search);
gint         hrn_view_get_focused    (HrnView     *self);
void         hrn_view_set_sort       (HrnView     *view,
                                      const gchar *sortfunc);
const gchar *hrn_view_get_sort       (HrnView     *view);
gint         hrn_view_center_pos     (void); /* eeek */
void         hrn_view_reposition     (HrnView     *self);
gboolean     hrn_view_labels_visible (HrnView     *self);
const gchar *hrn_view_get_search     (HrnView     *view);
gboolean     hrn_view_is_selected    (const gchar *uri);
void         hrn_view_set_selected   (HrnView     *view,
                                      const gchar *uri,
                                      BklItem     *item,
                                      gboolean     state);
GList *      hrn_view_get_selected   (HrnView     *view);
gboolean     hrn_view_has_selected   (void);

G_END_DECLS

#endif /* __HRN_VIEW_H__ */
