#include "hrn.h"
#include "hrn-toolbar-group.h"
#include "hrn-toolbar.h"
#include "hrn-toolbar-theatre.h"

enum
{
  PROP_0,
};

struct _HrnToolbarGroupPrivate
{
  NbtkWidget         *view_toolbar;
  NbtkWidget         *theatre_toolbar;
  HrnToolbarGroupMode mode;
};

#define GET_PRIVATE(obj) (G_TYPE_INSTANCE_GET_PRIVATE ((obj), \
                                                       HRN_TYPE_TOOLBAR_GROUP, \
                                                       HrnToolbarGroupPrivate))
G_DEFINE_TYPE (HrnToolbarGroup, hrn_toolbar_group, CLUTTER_TYPE_GROUP);

static void
hrn_toolbar_group_class_init (HrnToolbarGroupClass *klass)
{
  g_type_class_add_private (klass, sizeof (HrnToolbarGroupPrivate));
}

static void
hrn_toolbar_group_init (HrnToolbarGroup *self)
{
  HrnToolbarGroupPrivate *priv = GET_PRIVATE (self);
  ClutterActor           *stage;
  guint                   width;

  self->priv = priv;

  priv->mode = HRN_TOOLBAR_GROUP_MODE_VIEW;

  stage = clutter_stage_get_default ();
  width = clutter_actor_get_width (stage);

  priv->view_toolbar = hrn_toolbar_new ();
  clutter_group_add ((ClutterGroup *) self,
                     (ClutterActor *) priv->view_toolbar);
  clutter_actor_show ((ClutterActor *) priv->view_toolbar);

  clutter_actor_set_size ((ClutterActor *) priv->view_toolbar, width, 62);

  priv->theatre_toolbar = hrn_toolbar_theatre_new ();
  clutter_group_add ((ClutterGroup *) self,
                     (ClutterActor *) priv->theatre_toolbar);
  clutter_actor_hide ((ClutterActor *) priv->theatre_toolbar);
  clutter_actor_set_opacity ((ClutterActor *) priv->theatre_toolbar, 0x00);
  clutter_actor_set_size ((ClutterActor *) priv->theatre_toolbar, width, 62);
}

HrnToolbarGroup *
hrn_toolbar_group_new (void)
{
  HrnToolbarGroup *group;

  group = g_object_new (HRN_TYPE_TOOLBAR_GROUP, NULL);

  return group;
}

static void
hide_on_complete (ClutterAnimation *anim, ClutterActor     *actor)
{
  clutter_actor_hide (actor);
}

void
hrn_toolbar_group_set_mode (HrnToolbarGroup *group, HrnToolbarGroupMode mode)
{
  HrnToolbarGroupPrivate *priv = group->priv;
  ClutterAnimation       *anim;

  if (priv->mode == mode)
    {
      return;
    }

  priv->mode = mode;
  switch (mode)
    {
      case HRN_TOOLBAR_GROUP_MODE_VIEW:
        anim = clutter_actor_animate ((ClutterActor *) priv->theatre_toolbar,
                                      CLUTTER_LINEAR, HRN_FROM_THEATRE_DURATION,
                                      "opacity", 0x00,
                                      NULL);
        g_signal_connect (anim, "completed",
                          G_CALLBACK (hide_on_complete), priv->theatre_toolbar);

        clutter_actor_show ((ClutterActor *) priv->view_toolbar);
        clutter_actor_animate ((ClutterActor *) priv->view_toolbar,
                               CLUTTER_LINEAR, HRN_FROM_THEATRE_DURATION,
                               "opacity", 0xff,
                               NULL);

        /* When switching to view mode, focus the toolbar */
        hrn_toolbar_focused (CLUTTER_ACTOR (priv->view_toolbar));
        break;

      case HRN_TOOLBAR_GROUP_MODE_THEATRE:
        anim = clutter_actor_animate ((ClutterActor *) priv->view_toolbar,
                                      CLUTTER_LINEAR, HRN_TO_THEATRE_DURATION,
                                      "opacity", 0x00,
                                      NULL);
        g_signal_connect (anim, "completed",
                          G_CALLBACK (hide_on_complete), priv->view_toolbar);

        clutter_actor_show ((ClutterActor *) priv->theatre_toolbar);
        clutter_actor_animate ((ClutterActor *) priv->theatre_toolbar,
                               CLUTTER_LINEAR, HRN_TO_THEATRE_DURATION,
                               "opacity", 0xff,
                               NULL);
        break;
    }
}

void
hrn_toolbar_group_set_pinned (HrnToolbarGroup *group, gboolean pinned)
{
  HrnToolbarGroupPrivate *priv = group->priv;

  if (pinned)
    {
      hrn_toolbar_set_pinned ((HrnToolbar *) priv->view_toolbar);
    }
  else
    {
      hrn_toolbar_unpin ((HrnToolbar *) priv->view_toolbar);
    }
}

HrnToolbar *
hrn_toolbar_group_get_view_toolbar (HrnToolbarGroup *group)
{
  HrnToolbarGroupPrivate *priv = group->priv;

  return (HrnToolbar *) priv->view_toolbar;
}

HrnToolbarTheatre *
hrn_toolbar_group_get_theatre_toolbar (
  HrnToolbarGroup *group)
{
  HrnToolbarGroupPrivate *priv = group->priv;

  return (HrnToolbarTheatre *) priv->theatre_toolbar;
}
