/*
 * Hornsey - Moblin Media Player.
 * Copyright © 2007, 2008, 2009 Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA
 */
#ifndef _HRN_TEXTURE_CACHE
#define _HRN_TEXTURE_CACHE

#include <glib-object.h>
#include <clutter/clutter.h>

G_BEGIN_DECLS

#define HRN_TYPE_TEXTURE_CACHE    hrn_texture_cache_get_type ()

#define HRN_TEXTURE_CACHE(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), HRN_TYPE_TEXTURE_CACHE, HrnTextureCache))

#define HRN_TEXTURE_CACHE_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), HRN_TYPE_TEXTURE_CACHE, HrnTextureCacheClass))

#define HRN_IS_TEXTURE_CACHE(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), HRN_TYPE_TEXTURE_CACHE))

#define HRN_IS_TEXTURE_CACHE_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), HRN_TYPE_TEXTURE_CACHE))

#define HRN_TEXTURE_CACHE_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), HRN_TYPE_TEXTURE_CACHE, HrnTextureCacheClass))

typedef struct
{
  /*< private >*/
  GObject parent;
} HrnTextureCache;

typedef struct
{
  GObjectClass parent_class;
} HrnTextureCacheClass;

GType             hrn_texture_cache_get_type (void);

HrnTextureCache * hrn_texture_cache_new (void);
HrnTextureCache * hrn_texture_cache_get_default (void);
ClutterActor    * hrn_texture_cache_get_sq_texture(HrnTextureCache *self,
                                                   const gchar     *path_or_uri,
                                                   gboolean         load_async);
ClutterActor    * hrn_texture_cache_get_texture   (HrnTextureCache *self,
                                                   const gchar     *path_or_uri,
                                                   gboolean         load_async);
gint              hrn_texture_cache_get_size      (HrnTextureCache *self);
void              hrn_texture_cache_evict_items   (HrnTextureCache *self,
                                                   gint             count);

ClutterActor * hrn_texture_load_sq (const gchar *path);
ClutterActor * hrn_texture_load    (const gchar *path);

G_END_DECLS

#endif /* _HRN_TEXTURE_CACHE */
