#include <glib.h>
#include <glib/gi18n.h>

#include "hrn.h"
#include "hrn-marshal.h"
#include "hrn-sidebar-subitem.h"
#include "nbtk-im-label.h"

enum
{
  PROP_0,
};

enum
{
  PINNED,
  RENAMED,
  LAST_SIGNAL
};

struct _HrnSidebarSubitemPrivate
{
  char       *qname;
  char       *title;
  NbtkWidget *label;
  NbtkWidget *icon;
  NbtkWidget *pin;

  HrnSource *source;
};

struct _rename_data
{
  HrnSidebarSubitem *item;

  ClutterActor *old_focus;
  ClutterActor *shade[4];
  guint         activate_handler;
  guint         grab_handler;
};

#define SIDEBAR_WIDTH    170

#define GET_PRIVATE(obj)  (G_TYPE_INSTANCE_GET_PRIVATE ((obj), \
                             HRN_TYPE_SIDEBAR_SUBITEM, \
                             HrnSidebarSubitemPrivate))

G_DEFINE_TYPE (HrnSidebarSubitem, hrn_sidebar_subitem, NBTK_TYPE_BUTTON);
static guint32 signals[LAST_SIGNAL] = { 0, };

static void
hrn_sidebar_subitem_finalize (GObject *object)
{
  HrnSidebarSubitem        *item = (HrnSidebarSubitem *) object;
  HrnSidebarSubitemPrivate *priv = item->priv;

  if (priv->title)
    {
      g_free (priv->title);
      priv->title = NULL;
    }
  if (priv->qname)
    {
      g_free (priv->qname);
      priv->qname = NULL;
    }

  G_OBJECT_CLASS (hrn_sidebar_subitem_parent_class)->finalize (object);
}

static void
hrn_sidebar_subitem_dispose (GObject *object)
{
  HrnSidebarSubitem        *self = (HrnSidebarSubitem *) object;
  HrnSidebarSubitemPrivate *priv = self->priv;

  if (priv->source)
    {
      g_object_unref (priv->source);
      priv->source = NULL;
    }

  G_OBJECT_CLASS (hrn_sidebar_subitem_parent_class)->dispose (object);
}

static void
hrn_sidebar_subitem_set_property (GObject *object, guint prop_id,
                                  const GValue *value,
                                  GParamSpec   *pspec)
{
  switch (prop_id)
    {
      default:
        break;
    }
}

static void
hrn_sidebar_subitem_get_property (GObject *object, guint prop_id,
                                  GValue     *value,
                                  GParamSpec *pspec)
{
  switch (prop_id)
    {
      default:
        break;
    }
}

static void
hrn_sidebar_subitem_class_init (HrnSidebarSubitemClass *klass)
{
  GObjectClass *o_class = (GObjectClass *) klass;

  o_class->dispose      = hrn_sidebar_subitem_dispose;
  o_class->finalize     = hrn_sidebar_subitem_finalize;
  o_class->set_property = hrn_sidebar_subitem_set_property;
  o_class->get_property = hrn_sidebar_subitem_get_property;

  g_type_class_add_private (klass, sizeof (HrnSidebarSubitemPrivate));

  signals[PINNED] = g_signal_new ("pinned",
                                  G_TYPE_FROM_CLASS (klass),
                                  G_SIGNAL_RUN_FIRST |
                                  G_SIGNAL_NO_RECURSE, 0, NULL, NULL,
                                  g_cclosure_marshal_VOID__BOOLEAN,
                                  G_TYPE_NONE, 1, G_TYPE_BOOLEAN);
  signals[RENAMED] = g_signal_new ("renamed",
                                   G_TYPE_FROM_CLASS (klass),
                                   G_SIGNAL_RUN_FIRST |
                                   G_SIGNAL_NO_RECURSE, 0, NULL, NULL,
                                   hrn_marshal_VOID__STRING_STRING,
                                   G_TYPE_NONE, 2,
                                   G_TYPE_STRING,
                                   G_TYPE_STRING);
}

static void
pin_clicked_cb (NbtkWidget *button, HrnSidebarSubitem *item)
{
  g_signal_emit (item, signals[PINNED], 0,
                 nbtk_button_get_checked ((NbtkButton *) button));
}

static void
destroy_shade (ClutterAnimation *anim, ClutterActor     *actor)
{
  clutter_actor_destroy (actor);
}

static void
rename_complete (ClutterText *label, struct _rename_data *data)
{
  HrnSidebarSubitemPrivate *priv  = data->item->priv;
  ClutterStage             *stage = CLUTTER_STAGE (
    clutter_stage_get_default ());
  const gchar              *new_name  = clutter_text_get_text (label);
  char                     *old_title = NULL;
  gint                      i;

  if (priv->title)
    {
      old_title   = priv->title;
      priv->title = g_strdup (new_name);
    }

  clutter_stage_set_key_focus (stage, data->old_focus);

  for (i = 0; i < 4; i++)
    {
      clutter_actor_animate (data->shade[i], CLUTTER_LINEAR, 250,
                             "opacity", 0,
                             "signal::completed", destroy_shade,
                             data->shade[i],
                             NULL);
    }

  /*g_signal_handler_disconnect (label, activate_handler);*/
  g_signal_handler_disconnect (stage, data->grab_handler);

  g_signal_emit (data->item, signals[RENAMED], 0, old_title, priv->title);
  g_free (data);

  g_free (old_title);
}

static gboolean
rename_capture (ClutterActor *stage, ClutterEvent        *event,
                struct _rename_data *data)
{
  HrnSidebarSubitem        *item = data->item;
  HrnSidebarSubitemPrivate *priv = item->priv;
  ClutterActor             *text;

  text = nbtk_im_label_get_clutter_text ((NbtkIMLabel *) priv->label);
  switch (event->type)
    {
      case CLUTTER_BUTTON_RELEASE: /* clicks outside the menu makes it go away
                                    */
        if (!hrn_actor_has_ancestor (clutter_event_get_source (event),
                                     (ClutterActor *) item))
          {
            rename_complete ((ClutterText *) text, data);
            return TRUE;
          }

      case CLUTTER_MOTION:
      case CLUTTER_BUTTON_PRESS:
        if (clutter_event_get_source (event) == (void*) priv->label)
          {
            clutter_actor_event (text, event, FALSE);
          }
        return TRUE;

      case CLUTTER_LEAVE:
      case CLUTTER_ENTER:
        return TRUE;

      default:
        if (hrn_actor_has_ancestor (clutter_event_get_source (event),
                                    (ClutterActor *) item))
          return FALSE;
        break;
    }

  return TRUE;
}

static void
rename_cb (gpointer button)
{
  struct _rename_data      *data;
  HrnSidebarSubitem        *item        = (HrnSidebarSubitem *) button;
  HrnSidebarSubitemPrivate *priv        = item->priv;
  ClutterColor              shade_color = { 0x0, 0x0, 0x0, 0xff };
  ClutterStage             *stage       = CLUTTER_STAGE (
    clutter_stage_get_default ());
  ClutterActor             *text;
  gfloat                    sw, sh;
  gfloat                    x, y;
  gfloat                    w, h;
  gint                      i;

  data       = g_new0 (struct _rename_data, 1);
  data->item = item;

  for (i = 0; i < 4; i++)
    {
      data->shade[i] = clutter_rectangle_new_with_color (&shade_color);
      clutter_actor_set_opacity (data->shade[i], 0);
      clutter_actor_animate (data->shade[i], CLUTTER_LINEAR, 250,
                             "opacity", 92, NULL);
    }

  clutter_actor_get_size (CLUTTER_ACTOR (stage), &sw, &sh);
  clutter_actor_get_transformed_position (button, &x, &y);
  clutter_actor_get_transformed_size (button, &w, &h);

  clutter_actor_set_position (data->shade[0], x, y + h);
  clutter_actor_set_size (data->shade[0], w, sh - y - h);
  clutter_actor_set_position (data->shade[1], x, 0);
  clutter_actor_set_size (data->shade[1], w, y);
  clutter_actor_set_position (data->shade[2], x + w, 0);
  clutter_actor_set_size (data->shade[2], sw - x - w, sh);
  clutter_actor_set_position (data->shade[3], 0, 0);
  clutter_actor_set_size (data->shade[3], x, sh);

  clutter_container_add (CLUTTER_CONTAINER (stage),
                         data->shade[0], data->shade[1],
                         data->shade[2], data->shade[3], NULL);

  data->old_focus = clutter_stage_get_key_focus (stage);

  text = nbtk_im_label_get_clutter_text ((NbtkIMLabel *) priv->label);
  clutter_text_set_editable (CLUTTER_TEXT (text), TRUE);
  clutter_text_set_single_line_mode (CLUTTER_TEXT (text), TRUE);
  clutter_text_set_activatable (CLUTTER_TEXT (text), TRUE);

  clutter_stage_set_key_focus (stage, text);
  data->activate_handler = g_signal_connect (text, "activate",
                                             G_CALLBACK (rename_complete),
                                             data);
  data->grab_handler = g_signal_connect_after (stage, "captured-event",
                                               G_CALLBACK (rename_capture),
                                               data);
  hrn_popup_close ();
}

static gpointer actions[] = { N_ ("Rename"), rename_cb, NULL };

static gboolean
query_release (ClutterActor *actor, ClutterEvent *event, gpointer button)
{
  if (event->button.button == 3)
    {
      hrn_popup_actor (event->button.x, event->button.y,
                       hrn_popup_actions ((void *) actions, actor));
      return TRUE;
    }

  return FALSE;
}

static void
hrn_sidebar_subitem_init (HrnSidebarSubitem *self)
{
  HrnSidebarSubitemPrivate *priv;
  NbtkWidget               *box;

  self->priv = GET_PRIVATE (self);
  priv       = self->priv;

  nbtk_widget_set_style_class_name ((NbtkWidget *) self, "HrnSidebarSubItem");
  clutter_actor_set_reactive (CLUTTER_ACTOR (self), TRUE);

  box = nbtk_grid_new ();
  clutter_actor_set_width (CLUTTER_ACTOR (box), SIDEBAR_WIDTH);
  clutter_container_add_actor (CLUTTER_CONTAINER (self),
                               CLUTTER_ACTOR (box));
  nbtk_grid_set_homogenous_rows (NBTK_GRID (box), TRUE);
  nbtk_grid_set_valign (NBTK_GRID (box), 0.5);

  priv->pin = nbtk_button_new ();
  clutter_actor_set_size (CLUTTER_ACTOR (priv->pin), 32, 32);
  nbtk_widget_set_style_class_name (priv->pin, "HrnSidebarPin");
  nbtk_button_set_toggle_mode (NBTK_BUTTON (priv->pin), TRUE);
  nbtk_button_set_checked (NBTK_BUTTON (priv->pin), TRUE);
  g_signal_connect (priv->pin, "clicked", G_CALLBACK (pin_clicked_cb), self);

  priv->label = nbtk_im_label_new ("");
  clutter_actor_set_width (CLUTTER_ACTOR (priv->label), SIDEBAR_WIDTH - 64);

  priv->icon = nbtk_label_new ("");
  clutter_actor_set_size (CLUTTER_ACTOR (priv->icon), 32, 32);
  nbtk_widget_set_style_class_name (priv->icon, "HrnSidebarIcon");

  clutter_container_add_actor (CLUTTER_CONTAINER (box),
                               CLUTTER_ACTOR (priv->icon));
  clutter_container_add_actor (CLUTTER_CONTAINER (box),
                               CLUTTER_ACTOR (priv->label));
  clutter_container_add_actor (CLUTTER_CONTAINER (box),
                               CLUTTER_ACTOR (priv->pin));
}

HrnSidebarSubitem *
hrn_sidebar_subitem_new (HrnSource *source, const char *qname,
                         const char *title, const char *iconname,
                         gboolean show_pin,
                         gboolean can_rename)
{
  HrnSidebarSubitem        *item;
  HrnSidebarSubitemPrivate *priv;

  item = g_object_new (HRN_TYPE_SIDEBAR_SUBITEM, NULL);
  priv = item->priv;

  priv->source = g_object_ref (source);

  if (qname)
    priv->qname = g_strdup (qname);
  priv->title = g_strdup (title);
  nbtk_im_label_set_text (NBTK_IM_LABEL (priv->label), title);

  clutter_actor_set_name (CLUTTER_ACTOR (priv->icon), iconname);

  if (show_pin == FALSE)
    {
      clutter_actor_hide ((ClutterActor *) priv->pin);
    }

  if (can_rename)
    {
      g_signal_connect (item, "button-release-event",
                        G_CALLBACK (query_release), NULL);
    }

  return item;
}

const char *
hrn_sidebar_subitem_get_title (HrnSidebarSubitem *item)
{
  HrnSidebarSubitemPrivate *priv = item->priv;

  return priv->title;
}

const char *
hrn_sidebar_subitem_get_qname (HrnSidebarSubitem *item)
{
  HrnSidebarSubitemPrivate *priv = item->priv;

  return priv->qname;
}
