/*
 * Hornsey - Moblin Media Player.
 * Copyright © 2009 Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef _HRN_QUEUE_GROUP
#define _HRN_QUEUE_GROUP

#include <glib-object.h>
#include <clutter/clutter.h>

G_BEGIN_DECLS

#define HRN_TYPE_QUEUE_GROUP    hrn_queue_group_get_type ()

#define HRN_QUEUE_GROUP(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), HRN_TYPE_QUEUE_GROUP, HrnQueueGroup))

#define HRN_QUEUE_GROUP_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), HRN_TYPE_QUEUE_GROUP, HrnQueueGroupClass))

#define HRN_IS_QUEUE_GROUP(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), HRN_TYPE_QUEUE_GROUP))

#define HRN_IS_QUEUE_GROUP_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), HRN_TYPE_QUEUE_GROUP))

#define HRN_QUEUE_GROUP_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), HRN_TYPE_QUEUE_GROUP, HrnQueueGroupClass))

typedef struct
{
  /*< private >*/
  ClutterGroup parent;
} HrnQueueGroup;

typedef struct
{
  ClutterGroupClass parent_class;
} HrnQueueGroupClass;

GType          hrn_queue_group_get_type (void);

ClutterActor * hrn_queue_group_new (void);

HrnQueueGroup* hrn_queue_group_get_default (void);


#endif
