/*
 * Hornsey - Moblin Media Player.
 * Copyright © 2009 Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef _HRN_CLUSTER_H
#define _HRN_CLUSTER_H

#include <clutter/clutter.h>

G_BEGIN_DECLS

#define HRN_TYPE_CLUSTER    hrn_cluster_get_type ()

#define HRN_CLUSTER(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj), HRN_TYPE_CLUSTER, HrnCluster))

#define HRN_CLUSTER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST ((klass), HRN_TYPE_CLUSTER, HrnClusterClass))

#define HRN_IS_CLUSTER(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj), HRN_TYPE_CLUSTER))

#define HRN_IS_CLUSTER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE ((klass), HRN_TYPE_CLUSTER))

#define HRN_CLUSTER_GET_CLASS(obj) \
  (G_TYPE_INSTANCE_GET_CLASS ((obj), HRN_TYPE_CLUSTER, HrnClusterClass))

typedef struct _HrnCluster HrnCluster;
typedef struct _HrnClusterClass HrnClusterClass;
typedef struct _HrnClusterPrivate HrnClusterPrivate;

struct _HrnCluster
{
  HrnSwitcher parent_instance;

  NbtkWidget *title;
  NbtkWidget *meta;
  NbtkWidget *title2;
  NbtkWidget *meta2;

  GList             *results;
  HrnClusterPrivate *priv;
  gboolean           selected;
};

struct _HrnClusterClass
{
  /*< private >*/
  HrnSwitcherClass parent_class;
};

GType         hrn_cluster_get_type (void) G_GNUC_CONST;

ClutterActor *hrn_make_cluster (GList *results);

gboolean      hrn_cluster_get_selected (HrnCluster *cluster);
void          hrn_cluster_preload      (HrnCluster *cluster);
void          hrn_cluster_show_labels  (HrnCluster *cluster,
                                        gint        state);
void          hrn_cluster_set_selected (HrnCluster *cluster,
                                        gboolean    state);


G_END_DECLS

#endif
