/*
 * Hornsey - Moblin Media Player.
 * Copyright © 2009 Intel Corporation.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU Lesser General Public License,
 * version 2.1, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT ANY
 * WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA
 */

#include <clutter/clutter.h>
#include <math.h>
#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include "hrn.h"
#include "hrn-item-audio.h"

G_DEFINE_TYPE (HrnItemAudio, hrn_item_audio, HRN_TYPE_ITEM);

#define HRN_ITEM_AUDIO_GET_PRIVATE(obj)                 \
  (G_TYPE_INSTANCE_GET_PRIVATE ((obj), \
                                HRN_TYPE_ITEM_AUDIO, \
                                HrnItemAudioPrivate))

struct _HrnItemAudioPrivate
{
  gchar *uri;
};

/*static ClutterColor white = {0xff,0xff,0xff,0xff};*/

static GObject *
hrn_item_audio_constructor (GType type, guint n_params,
                            GObjectConstructParam *params);
static void
hrn_item_audio_dispose (GObject *object);

static void
hrn_item_audio_class_init (HrnItemAudioClass *klass)
{
  GObjectClass *gobject_class = G_OBJECT_CLASS (klass);

  gobject_class->dispose     = hrn_item_audio_dispose;
  gobject_class->constructor = hrn_item_audio_constructor;

  g_type_class_add_private (gobject_class, sizeof (HrnItemAudioPrivate));
}

static void
hrn_item_audio_init (HrnItemAudio *self)
{
  HrnItemAudioPrivate *priv = HRN_ITEM_AUDIO_GET_PRIVATE (self);

  memset (priv, 0, sizeof (priv));
}

static GObject *
hrn_item_audio_constructor (GType type, guint n_params,
                            GObjectConstructParam *params)
{
  GObject      *object;
  HrnItemAudio *item_audio;

  object = G_OBJECT_CLASS (hrn_item_audio_parent_class)->constructor (
    type, n_params, params);

  item_audio = HRN_ITEM_AUDIO (object);


  return object;
}

static void
hrn_item_audio_dispose (GObject *object)
{
  G_OBJECT_CLASS (hrn_item_audio_parent_class)->dispose (object);
}

static ClutterActor *
item_audio_alone (HrnSwitcher *switcher, guint state_no, gpointer userdata)
{
  ClutterActor *group      = clutter_group_new ();
  ClutterActor *item_audio = hrn_make_element (userdata, HRN_SQUARE|HRN_PINCHABLE);

  clutter_actor_set_scale (item_audio, 0.95, 0.95);
  clutter_actor_set_position (item_audio, DIM * 0.025, DIM * 0.025);
  clutter_group_add (CLUTTER_GROUP (group), item_audio);

  hrn_play_button_new (switcher, group, userdata);
  return group;
}

#include <string.h>


HrnItemAudio *
hrn_item_audio_create (BklItem *item, gboolean square)
{
  HrnSwitcher *self = g_object_new (HRN_TYPE_ITEM_AUDIO, "item", item, NULL);

  /*HrnItemAudioPrivate *priv = HRN_ITEM_AUDIO_GET_PRIVATE (self);*/

  HRN_ITEM (self)->item = item; /* XXX: take a reference ? */


  hrn_switcher_add_state_full (self, NULL, -1, 0.25,
                               item_audio_alone, item,
                               NULL, NULL);

  return HRN_ITEM_AUDIO (self);
}
