#ifndef __HRN_CLUSTER_H__
#define __HRN_CLUSTER_H__

#include <clutter/clutter.h>

#include "hrn-tileable.h"

G_BEGIN_DECLS

#define HRN_TYPE_CLUSTER                                                \
   (hrn_cluster_get_type())
#define HRN_CLUSTER(obj)                                                \
   (G_TYPE_CHECK_INSTANCE_CAST ((obj),                                  \
                                HRN_TYPE_CLUSTER,                       \
                                HrnCluster))
#define HRN_CLUSTER_CLASS(klass)                                        \
   (G_TYPE_CHECK_CLASS_CAST ((klass),                                   \
                             HRN_TYPE_CLUSTER,                          \
                             HrnClusterClass))
#define IS_HRN_CLUSTER(obj)                                             \
   (G_TYPE_CHECK_INSTANCE_TYPE ((obj),                                  \
                                HRN_TYPE_CLUSTER))
#define IS_HRN_CLUSTER_CLASS(klass)                                     \
   (G_TYPE_CHECK_CLASS_TYPE ((klass),                                   \
                             HRN_TYPE_CLUSTER))
#define HRN_CLUSTER_GET_CLASS(obj)                                      \
   (G_TYPE_INSTANCE_GET_CLASS ((obj),                                   \
                               HRN_TYPE_CLUSTER,                        \
                               HrnClusterClass))

typedef struct _HrnClusterPrivate HrnClusterPrivate;
typedef struct _HrnCluster      HrnCluster;
typedef struct _HrnClusterClass HrnClusterClass;

struct _HrnCluster
{
    ClutterGroup parent;

    HrnClusterPrivate *priv;
};

struct _HrnClusterClass
{
    ClutterGroupClass parent_class;
    HrnClusterNode *(*get_node) (HrnCluster *cluster);
    const char *(*get_label) (HrnCluster *cluster);
};

GType hrn_cluster_get_type (void) G_GNUC_CONST;

void hrn_cluster_add_actor (HrnCluster  *cluster,
                            HrnTileable *tileable);
void hrn_cluster_full (HrnCluster *cluster);
void hrn_cluster_set_secondary_reactive (HrnCluster *cluster,
                                         gboolean    reactive);
const char *hrn_cluster_get_label (HrnCluster *cluster);


G_END_DECLS

#endif /* __HRN_CLUSTER_H__ */
