import Qt 4.7
import gconf 1.0

/* FIXME: unfinished */
Page {

    GConfItem {
        id: gconf_system_settings_classes
        key: "/apps/hedley_launcher/system_settings/classes"
    }

    /* Close any settings application when hiding the page */
    onExited: {
        if(settings.running_app != null && settings.running_app.running)
            settings.running_app.close()
            settings.running_app = null

        /* Empty the list of windows that should be treated as system settings
           by the window manager (xfwm4); that list is populated via the
           app.setIsSystemSettings() call below
           This is mainly in order to workaround launchpad bug #637496.
        */
        gconf_system_settings_classes.value = []
    }
    
    FocusScope {
        focus: true
        anchors.fill: parent

        Rectangle {
            id: title_background

            anchors.left: parent.left
            anchors.leftMargin: 55
            anchors.top: parent.top
            anchors.topMargin: 35
            height: title_icon.height + 16
            width: title_icon.width + title.anchors.leftMargin + title.paintedWidth + 22
            color: "black"
            opacity: 0.3
            radius: 5
        }

        Image {
            id: title_icon

            anchors.left: parent.left
            anchors.leftMargin: 60
            anchors.top: parent.top
            anchors.topMargin: 40
            width: sourceSize.width
            height: sourceSize.height
            smooth: true
            source: "artwork/settings.png"
        }

        TextCustom {
            id: title

            anchors.left: title_icon.right
            anchors.leftMargin: 8
            anchors.top: parent.top
            anchors.topMargin: 40
            verticalAlignment: Text.AlignVCenter

            width: 200
            height: title_icon.height
            text: qsTr("System Settings")
        }

        /*
        GConfItem {
            id: gconf_system_settings
            key: "/apps/hedley_launcher/system_settings/list"
        }
        */

        QFileSystemModelQML {
            id: desktop_files

            rootPath: "/usr/share/applications/wyse_settings/"
            nameFilters: ["*.desktop"]
            nameFilterDisables: false
        }

        ListView {
            id: settings

            property QLauncherApplication running_app

            property int min_spacing: 10
            property int delegate_height: 50
            property int visible_items: Math.floor(height / (delegate_height + min_spacing))

            /* Compute a reasonable value for spacing ensuring that it is
               always ≥ min_spacing and that if there are more items in the list
               than can be displayed, only the top half of the last visible item is
               visible, thus giving a strong visual clue that there are more items
               in the list. This works well provided delegate_height > min_spacing,
               which should be a reasonable assumption. */
            spacing: (2 * height - delegate_height) / (2 * visible_items) - delegate_height

            width: 265

            clip: true
            anchors.left: title_icon.left
            anchors.top: title_icon.bottom
            anchors.topMargin: 30
            anchors.bottom: parent.bottom
            anchors.bottomMargin: 30
            orientation: ListView.Vertical
            focus: true
            currentIndex: 0

            //model: gconf_system_settings.value
            model: desktop_files

            delegate: SystemSettingsItem {
                property QLauncherApplication app

                //app: QLauncherApplication {desktop_file: model.modelData}
                app: QLauncherApplication {desktop_file: filePath}

                width: settings.width
                height: settings.delegate_height

                focus: true

                label: app.name
                icon: "image://icons/"+app.icon_name
                running: app.running
                onRunningChanged: {
                    if (running) launcherView.setCursorNormal()

                    if(running && settings.running_app != app) {
                        settings.running_app.close()
                        settings.running_app = app
                    }
                    if(!running && settings.running_app == app) settings.running_app = null
                }

                Timer {
                    id: resetCursor
                    interval: 5000
                    /* Reset the cursor if for some reason the application
                       has failed to start after 5 seconds. */
                    onTriggered: launcherView.setCursorNormal()
                }

                onClicked: {
                    if(settings.running_app == app && settings.running_app.running)
                        return

                    if(settings.running_app)
                        settings.running_app.close()

                    launcherView.setCursorBusy()
                    resetCursor.restart()

                    app.setIsSystemSettings()
                    app.launch()
                    settings.running_app = app
                }
            }
        }
    }
}
