import Qt 4.7
import gconf 1.0

/* FIXME: unfinished */
Page {
    /*
    GConfItem {
        id: gconf_connections
        key: "/apps/hedley_launcher/connections/list"
    }
    */

    QFileSystemModelQML {
        id: desktop_files
        /* Effectively calls QDesktopServices::storageLocation(QDesktopServices::HomeLocation) */
        rootPath: home_directory + "/Desktop"
        nameFilters: ["*.desktop"]
        nameFilterDisables: false
    }

    QLauncherApplication {
        id: show_desktop
        desktop_file: "/usr/share/hedley/launcher/show_desktop.desktop"
    }

    GConfItem {
        id: gconf_edit_mode_activated
        key: "/apps/hedley_launcher/edit_mode_activated"
        value: false
        onValueChanged: {
            if (value) {
                /* When activating the edit mode, minimize all the open windows
                   (https://bugs.launchpad.net/hedley/+bug/634612). */
                show_desktop.launch()
            }
        }
    }

    Applications {
        id: connections

        anchors.fill: parent
        focus: count > 0

        onLaunching_applicationChanged: {
            if(launching_application == null)
                buttons_bar.opacity = 1
            else
                buttons_bar.opacity = 0
        }

        Image {
            id: stripes

            z: -1
            source: "artwork/stripes.png"
            opacity: gconf_edit_mode_activated.value ? 0.18 : 0.0

            anchors.fill: parent
            anchors.margins: 6
            fillMode: Image.Tile

            Behavior on opacity {NumberAnimation {duration: 200; easing.type: Easing.InOutQuad}}
        }


        //model: gconf_connections.value
        model: desktop_files

        delegate: FocusScope {
            /* Trick to center Connections Item inside the grid cell */
            width: grid.cellWidth
            height: grid.cellHeight

            ConnectionsItem {
                id: application_delegate

                property QLauncherApplication app
                /*
                property GConfItem gconf_desktop_file_subscriber:
                    GConfItem {
                        key: "/apps/hedley_launcher/connections/"+model.modelData+"/desktop_file"
                    }
                */

                //app: QLauncherApplication {desktop_file: gconf_desktop_file_subscriber.value}
                app: QLauncherApplication {desktop_file: filePath}

                focus: true
                anchors.horizontalCenter: parent.horizontalCenter
                anchors.verticalCenter: parent.verticalCenter
                width: grid.delegate_width
                height: grid.delegate_height
                icon: "image://icons/"+app.icon_name
                label: app.name
                running: app.running
                contextual_actions_visible: gconf_edit_mode_activated.value
                onClicked: {
                    if(gconf_edit_mode_activated.value) {
                        /* edit mode */
                        /* execute the connection editor corresponding to the
                           type of the connection and passes as argument the
                           filename of the .desktop file of the connection
                           without its extension. */
                        var filename_index = app.desktop_file.lastIndexOf("/")+1
                        var basename = app.desktop_file.substring(filename_index).replace(".desktop", "")
                        var editor_desktop_file = "/usr/share/applications/wyse_addons/"+application_delegate.app.connection_type+".desktop"
                        if(!connection_editor_page.edit_connection(editor_desktop_file, basename))
                            popup.show("EditFailPopup.qml", null)
                    }
                    else {
                        /* launching mode */
                        if(running) {
                            app.show()
                        }
                        else {
                            var launch_result = app.launch()
                            if(!launch_result) {
                                popup.show("LaunchFailPopup.qml", app)
                            }
                            else {
                                connections.launching_application = app
                            }
                        }
                    }
                }
                /* FIXME: liblauncher's Application object does not provide us with
                          a 'launching' property therefore we are using the
                          'running' property instead to hide the launching feedback.
                          That leads to a bug whereby failing to launch an
                          application will lead to an ever showing launching feedback.

                          A 'launching' property should use the startup notification
                          standard to be properly implemented:
                          http://standards.freedesktop.org/startup-notification-spec/startup-notification-0.1.txt
                */
                onRunningChanged: if(running) {
                    connections.launching_application = null
                }
                onRemoveClicked: {
                    popup.show("ConnectionRemovalPopup.qml", app)
                }
            }
        }

        Behavior on opacity {NumberAnimation {duration: 200; easing.type: Easing.InOutQuad}}

        KeyNavigation.down: buttons_bar
    }


    GConfItem {
        id: gconf_edit_mode_available
        key: "/apps/hedley_launcher/edit_mode_available"
    }

    FocusScope {
        id: buttons_bar
        /* Note: the layout of the buttons in this item is hand-made to mimick
           the behaviour of a Row item with spacing=15. Unfortunately nesting a
           FocusRow inside a Row doesn’t work because as soon as our item
           becomes a FocusScope, it looses the layout characteristics of a Row,
           hence the need for manual positioning of the buttons. */

        focus: connections.count == 0

        anchors.top: parent.bottom
        anchors.right: parent.right
        anchors.topMargin: 3
        anchors.rightMargin: 6

        Behavior on opacity {NumberAnimation {duration: 200; easing.type: Easing.InOutQuad}}

        ButtonText {
            id: add_item_button

            anchors.right: edit_mode_button.left
            anchors.rightMargin: 15

            opacity: gconf_edit_mode_activated.value ? 1 : 0
            icon: "artwork/add.png"
            text: qsTr("Add Item")

            onClicked: {
                /* Switch to add_connection_page */
                gconf_current_page.value = 2
            }

            KeyNavigation.right: edit_mode_button
        }

        ButtonText {
            id: edit_mode_button

            focus: true

            anchors.right: parent.right

            visible: gconf_edit_mode_available.value
            icon: gconf_edit_mode_activated.value ? "artwork/back.png" : "artwork/edit_mode.png"
            text: gconf_edit_mode_activated.value ? qsTr("Exit Edit Mode") : qsTr("Enter Edit Mode")

            onClicked: gconf_edit_mode_activated.value = !gconf_edit_mode_activated.value

            KeyNavigation.left: (add_item_button.opacity > 0)?add_item_button:null
        }

        KeyNavigation.up: (connections.count > 0)?connections:null
    }
}
