/*
    run-single: Run programs singleton.
    Copyright (C) 2010, Ying-Chun Liu (PaulLiu) <paulliu@debian.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License along
    with this program; if not, write to the Free Software Foundation, Inc.,
    51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include <unistd.h>
#include <fcntl.h>
#include <dirent.h>
#include <signal.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/time.h>
#include <sys/select.h>
#include <sys/wait.h>

char * lockfilename(char *prog) {
  int i;
  char ret[1024];
  char prefix[]="/tmp/run-single-";

  snprintf(ret,1024,"%s%s.lock",prefix,prog);
  for (i=strlen(prefix); ret[i] != '\0'; i++) {
    if (ret[i] == '/') {
      ret[i] = '_';
    }
  }

  return strdup(ret);
}

int create_lock(char *prog,int pid) {
  int lockfile;
  char *filename;
  char com1[100];
  filename = lockfilename(prog);

  lockfile = open(filename,O_WRONLY|O_CREAT,0666);

  snprintf(com1,sizeof(com1),"%d",pid);

  write(lockfile,com1,strlen(com1));
  close(lockfile);
  free(filename);

  return 0;
}

int check_lock(char *prog) {
  char *filename;
  int lockfile;
  int result1;
  fd_set rdfs;
  struct timeval tv;
  DIR *procdir;
  struct dirent *entry;
  int found;
  char com1[100];

  filename = lockfilename(prog);
  lockfile = open(filename,O_RDONLY,0);

  if (lockfile==-1) {
    free(filename);
    return 0;
  }

  result1 = 0;
  while (1) {
    tv.tv_usec=1;
    tv.tv_sec=0;
    FD_ZERO(&rdfs);
    FD_SET(lockfile,&rdfs);
    if (select(lockfile+1,&rdfs,NULL,NULL,&tv) > 0) {
      if (FD_ISSET(lockfile,&rdfs)) {
	char c;
	if (read(lockfile,&c,1)==1) {
	  result1 *= 10;
	  result1 += c-'0';
	} else {
	  break;
	}
      } else {
	break;
      }
    } else {
      break;
    }
  }

  close(lockfile);
  free(filename);

  procdir = opendir("/proc");
  if (!procdir) {
    return 0;
  }

  snprintf(com1,sizeof(com1),"%d",result1);
  found=0;
  while (1) {
    entry = readdir(procdir);
    if (!entry) { break; }
    if (strcmp(com1,entry->d_name)==0) {
      found=1;
      break;
    }
  }
  closedir(procdir);

  if (!found) {
    return 0;
  }

  return result1;
}


int main(int argc,char *argv[]) {

  pid_t pid;
  int status=0;
  int i,j;
  int killFlag=0;
  char **new_argv;
  char lockname[256];
  int prev_pid=0;

  if (argc<=1) {
    return 0;
  }
  
  i=1;
  strncpy(lockname,"",sizeof(lockname));
  if (argc>=3) {
    if (strcmp(argv[i],"-l")==0) {
      strncpy(lockname,argv[i+1],sizeof(lockname));
      i+=2;
    }
  }
  if (argc>=2) {
    if (strcmp(argv[i],"-k")==0) {
      killFlag=1;
      i+=1;
    }
  }

  new_argv = (char **) malloc(sizeof(char *)*(argc+1));

  for (j=0 ; i<argc && j<argc; i++,j++) {
    new_argv[j] = argv[i];
    new_argv[j+1] = NULL;
  }
  
  if (strcmp(lockname,"")==0) {
    strncpy(lockname,new_argv[0],sizeof(lockname));
  }

  prev_pid = check_lock(lockname);
  if (prev_pid) {
    if (killFlag) {
      for (i=0; i<=10; i++) {
        int wait_prev_pid;
        if (i==0) {
          kill(prev_pid,SIGTERM);
        } else {
          kill(prev_pid,SIGKILL);
        }
        wait_prev_pid = check_lock(lockname);
        if (wait_prev_pid) {
          usleep(300000);
        } else {
          break;
        }
      }
    } else {
      exit(1);
    }
  }

  pid = fork();

  if (pid<0) {
    fprintf(stderr,"Fork error\n");
    exit(1);
  }

  if (pid>0) {
    create_lock(lockname,pid);
    close(0);
    close(1);
    close(2);
    waitpid(pid,&status,0);
    unlink(lockfilename(lockname));
  } else if (pid==0) {
    execvp(new_argv[0], new_argv);
  }
  return 0;
}
