import unittest

from gwibber.microblog.util.time import parsetime


class TimeParseTest(unittest.TestCase):
    def test_type(self):
        # parsetime() should always return int seconds since the epoch.
        self.assertTrue(isinstance(parsetime('2012-05-10T13:36:45'), int))

    def test_parse_naive(self):
        # ISO 8601 standard format without timezone.
        self.assertEqual(parsetime('2012-05-10T13:36:45'), 1336682205)

    def test_parse_utctz(self):
        # ISO 8601 standard format with UTC timezone.
        self.assertEqual(parsetime('2012-05-10T13:36:45 +0000'), 1336682205)

    def test_parse_naive_altsep(self):
        # ISO 8601 alternative format without timezone.
        self.assertEqual(parsetime('2012-05-10 13:36:45'), 1336682205)

    def test_parse_utctz_altsep(self):
        # ISO 8601 alternative format with UTC timezone.
        self.assertEqual(parsetime('2012-05-10T13:36:45 +0000'), 1336682205)

    def test_bad_time_string(self):
        # Odd unsupported format.
        self.assertRaises(ValueError, parsetime, '2012/05/10 13:36:45')

    def test_non_utc(self):
        # Non-UTC timezones are get converted to UTC, before conversion to
        # epoch seconds.
        self.assertEqual(parsetime('2012-05-10T13:36:45 -0400'), 1336696605)

    def test_nonstandard_twitter(self):
        # Sigh.  Twitter has to be different.
        self.assertEqual(parsetime('Thu May 10 13:36:45 +0000 2012'),
                         1336682205)

    def test_nonstandard_twitter_non_utc(self):
        # Sigh.  Twitter has to be different.
        self.assertEqual(parsetime('Thu May 10 13:36:45 -0400 2012'),
                         1336696605)

    def test_nonstandard_facebook(self):
        # Sigh.  Facebook gets close, but no cigar.
        self.assertEqual(parsetime('2012-05-10T13:36:45+0000'), 1336682205)

    def test_multiple_timezones(self):
        # Multiple timezone strings are not supported.
        self.assertRaises(ValueError, parsetime,
                          '2012-05-10T13:36:45 +0000 -0400')
