/*
 * Copyright (C) 2008-2009 Freescale Semiconductor, Inc. All rights reserved.
 *
 */
 
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
 
/*
 * Module Name:    rv_def.h 
 *
 * Description:    Head file for RealMedia video decoder defines.
 *
 * Portability:    This code is written for Linux OS and Gstreamer
 */  
 
/*
 * Changelog: 
 * Aug 25 2008 Sario HU <b01138@freescale.com>
 * - Initial version
 *
 */



#ifndef __RV_DEF_H__
#define __RV_DEF_H__


#define HX_RV20VIDEO_ID   0x52563230  /* 'RV20' */

#define HX_RV30VIDEO_ID   0x52563330  /* 'RV30' */
#define HX_RV40VIDEO_ID   0x52563430  /* 'RV40' */
#define HX_RV89COMBO_ID   0x54524F4D  /* 'TROM' (raw TCK format) */

#define RV40_SPO_FLAG_BFRAMES               0x00001000
#define RV40_SPO_BITS_NUMRESAMPLE_IMAGES    0x00070000  /* max of 8 RPR images sizes */
#define RV40_SPO_BITS_NUMRESAMPLE_IMAGES_SHIFT 16

#define RV20_MAJOR_BITSTREAM_VERSION  2

#define RV30_MAJOR_BITSTREAM_VERSION  3


#define RV40_MAJOR_BITSTREAM_VERSION  4
#define RV40_BITSTREAM_VERSION        0
#define RV40_PRODUCT_RELEASE          2
#define RV40_FRONTEND_VERSION         0
#define RAW_BITSTREAM_MINOR_VERSION   128

#define RAW_RVG2_MAJOR_VERSION        2
#define RAW_RVG2_BITSTREAM_VERSION    RAW_BITSTREAM_MINOR_VERSION
#define RAW_RVG2_PRODUCT_RELEASE      0
#define RAW_RVG2_FRONTEND_VERSION     0

#define RAW_RV8_MAJOR_VERSION         3
#define RAW_RV8_BITSTREAM_VERSION     RAW_BITSTREAM_MINOR_VERSION
#define RAW_RV8_PRODUCT_RELEASE       0
#define RAW_RV8_FRONTEND_VERSION      0

#define RAW_RV9_MAJOR_VERSION         4
#define RAW_RV9_BITSTREAM_VERSION     RAW_BITSTREAM_MINOR_VERSION
#define RAW_RV9_PRODUCT_RELEASE       0
#define RAW_RV9_FRONTEND_VERSION      0

#define RV_BITSTREAM_MAJOR_VERSION          4
#define RV_BITSTREAM_MAJOR_VERSION_RV8      3
#define RV_BITSTREAM_MINOR_VERSION          0
#define RV_BITSTREAM_MINOR_VERSION_RV8      2
#define RV_BITSTREAM_RELEASE_VERSION        0

#define HX_MEDIA_VIDEO    0x5649444F /* 'VIDO' */



/*
 * Macro: HX_GET_MAJOR_VERSION()
 *
 * Given the encoded product version,
 * returns the major version number.
 */
#define HX_GET_MAJOR_VERSION(prodVer)   ((prodVer >> 28) & 0xF)

/*
 * Macro: HX_GET_MINOR_VERSION()
 *
 * Given the encoded product version,
 * returns the minor version number.
 */
#define HX_GET_MINOR_VERSION(prodVer)   ((prodVer >> 20) & 0xFF)
/*
 * Macro: HX_ENCODE_PROD_VERSION()
 *
 * Given the major version, minor version,
 * release number, and build number,
 * returns the encoded product version.
 */
#define HX_ENCODE_PROD_VERSION(major,minor,release,build)   \
            ((U32)((U32)major << 28) | ((U32)minor << 20) | \
            ((U32)release << 12) | (U32)build)



#define	GET_DATA_BYTES(src,dst,tmp,n) \
{\
	switch(n)	\
	{	\
	case 1:	\
		dst=*src;	\
		src++;	\
		break;	\
	case 2:	\
		tmp=*src;	\
		dst=tmp;	\
		src++;	\
		tmp=*src;	\
		dst |= (tmp<<8);	\
		src++;	\
		break;	\
	case 4:	\
		tmp=*src;	\
		dst=tmp;	\
		src++;	\
		tmp=*src;	\
		dst |= (tmp<<8);	\
		src++;	\
		tmp=*src;	\
		dst |= (tmp<<16);	\
		src++;	\
		tmp=*src;	\
		dst |= (tmp<<24);	\
		src++;	\
		break;	\
	default:	\
		GST_ERROR("Error number of bytes\n");	\
		break;	\
	}	\
}

#define BYTE_SWAP_U32(A)  ((((guint32)(A) & 0xff000000) >> 24) | \
                              (((guint32)(A) & 0x00ff0000) >> 8)  | \
                              (((guint32)(A) & 0x0000ff00) << 8)  | \
                              (((guint32)(A) & 0x000000ff) << 24))


#endif //__RV_DEF_H__

