/*
 * Copyright (C) 2008-2009 Freescale Semiconductor, Inc. All rights reserved.
 *
 */
 
/*
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */
 
/*
 * Module Name:    mfw_gst_rmdemuxer.h
 *
 * Description:    Head file for RealMedia demuxer plugin for Gstreamer.
 *
 * Portability:    This code is written for Linux OS and Gstreamer
 */  
 
/*
 * Changelog: 
 * Aug 22 2008 Sario HU <b01138@freescale.com>
 * - Initial version
 *
 */

/*===============================================================================
                            INCLUDE FILES
=============================================================================*/
#ifndef __MFW_GST_RM_DEMUXER_H__
#define __MFW_GST_RM_DEMUXER_H__

/*=============================================================================
                              CONSTANTS
=============================================================================*/
/* None. */

/*=============================================================================
                               ENUMS
=============================================================================*/
/* None */
enum {
    VIDEO_INDEX = 0,
    AUDIO_INDEX = 1,
    MAX_SRC_PADS 
};

#define AUDIO_MASK (1<<AUDIO_INDEX)
#define VIDEO_MASK (1<<VIDEO_INDEX)
#define FIRST_MASK (1<<MAX_SRC_PADS)
#define SEGMENT_NOT_SEND_MASK (1<<(MAX_SRC_PADS+1))

/*=============================================================================
                               MACROS
=============================================================================*/
G_BEGIN_DECLS

#define MFW_GST_TYPE_RM_DEMUXER \
  (mfw_gst_type_rm_demuxer_get_type())
#define MFW_GST_RM_DEMUXER(obj) \
  (G_TYPE_CHECK_INSTANCE_CAST((obj),MFW_GST_TYPE_RM_DEMUXER,MFW_GST_RMDEMUX_INFO_T))
#define MFW_GST_RM_DEMUXER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_CAST((klass),MFW_GST_TYPE_RM_DEMUXER,MFW_GST_RMDEMUX_INFO_CLASS_T))
#define MFW_GST_IS_RM_DEMUXER(obj) \
  (G_TYPE_CHECK_INSTANCE_TYPE((obj),MFW_GST_TYPE_RM_DEMUXER))
#define GST_IS_RM_DEMUXER_CLASS(klass) \
  (G_TYPE_CHECK_CLASS_TYPE((klass),MFW_GST_TYPE_RM_DEMUXER))

/*=============================================================================
                            STRUCTURES AND OTHER TYPEDEFS
=============================================================================*/
typedef struct  {
    gint64 length;		                               /* Length of the file/buffer */
    guint64 offset;	                                   /* Present location.         */
} File_Info;

typedef struct {
    GstBuffer * delayhead;
    GstBuffer * delaytail;
}SyncControl;

typedef struct _MFW_GST_RMDEMUX_INFO_T {
    GstElement element;		                            /* instance of base class      */
    GstPad *sinkpad;		                            /* sink pad of element         */
    GstPad *srcpad[MAX_SRC_PADS];	                    /* src pads for output data    */
    GstCaps *caps[MAX_SRC_PADS];	                    /* src pad capability          */
    gint streamID[MAX_SRC_PADS];
    rm_stream_header * streamHeader[MAX_SRC_PADS];
    
    File_Info file_info;	                    /* file information            */
    GstSegment segment;		                            /* configured play segment     */
    gboolean stop_request;	                            /* stop request flag           */
    
	gboolean seek_flag;
    gboolean seek_video;
    guint new_seg_flag;
    guint64 desired_seek_time;
    guint64 actual_seek_time;
    guint64 firstvideo_time;
    guint64 firstaudio_time;

    rm_parser * rmparser;
    
    ra_depack * radepack;
    rv_depack * rvdepack;
    
    ra_format_info * rainfo;
    rv_format_info * rvinfo;
    
    rm_stream_header * raheader;
    rm_stream_header * rvheader;

    gboolean opaquedatapushed;

    gboolean firstaudio;
#ifdef MEMORY_DEBUG
    Mem_Mgr memmgr;
#endif

    guint streamMask;

    gboolean eosfile;
    GstBuffer * vhead;
    GstBuffer * vtail;
    guint vframenum;

    SyncControl audiosync;
    SyncControl videosync;
    
    gboolean videokeyfound;
    gboolean audiokeyfound;
    gboolean videodropto;

    gboolean videosent;
    guint64 new_seg_time;
    gboolean readerror;
    gboolean freshstart;

} MFW_GST_RMDEMUX_INFO_T;


typedef struct _MFW_GST_RMDEMUX_INFO_CLASS_T {
    GstElementClass parent_class;

} MFW_GST_RMDEMUX_INFO_CLASS_T;

/*=============================================================================
                           GLOBAL VARIABLE DECLARATIONS
=============================================================================*/

/* None. */

/*=============================================================================
                            FUNCTION PROTOTYPES
=============================================================================*/
GType mfw_gst_type_rm_demuxer_get_type(void);

/*===========================================================================*/
G_END_DECLS
#endif /*__MFW_GST_RM_DEMUXER_H__*/
