/* game-view.c generated by valac 0.15.2.11-7b14d, the Vala compiler
 * generated from game-view.vala, do not modify */


#include <glib.h>
#include <glib-object.h>
#include <clutter/clutter.h>
#include "config.h"
#include <float.h>
#include <math.h>


#define TYPE_GAME_VIEW (game_view_get_type ())
#define GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_VIEW, GameView))
#define GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_VIEW, GameViewClass))
#define IS_GAME_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_VIEW))
#define IS_GAME_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_VIEW))
#define GAME_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_VIEW, GameViewClass))

typedef struct _GameView GameView;
typedef struct _GameViewClass GameViewClass;
typedef struct _GameViewPrivate GameViewPrivate;

#define TYPE_LED_ARRAY (led_array_get_type ())
#define LED_ARRAY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LED_ARRAY, LEDArray))
#define LED_ARRAY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LED_ARRAY, LEDArrayClass))
#define IS_LED_ARRAY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LED_ARRAY))
#define IS_LED_ARRAY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LED_ARRAY))
#define LED_ARRAY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LED_ARRAY, LEDArrayClass))

typedef struct _LEDArray LEDArray;
typedef struct _LEDArrayClass LEDArrayClass;

#define TYPE_BOARD_VIEW (board_view_get_type ())
#define BOARD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BOARD_VIEW, BoardView))
#define BOARD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BOARD_VIEW, BoardViewClass))
#define IS_BOARD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BOARD_VIEW))
#define IS_BOARD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BOARD_VIEW))
#define BOARD_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BOARD_VIEW, BoardViewClass))

typedef struct _BoardView BoardView;
typedef struct _BoardViewClass BoardViewClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _BoardViewPrivate BoardViewPrivate;

struct _GameView {
	ClutterGroup parent_instance;
	GameViewPrivate * priv;
};

struct _GameViewClass {
	ClutterGroupClass parent_class;
};

struct _GameViewPrivate {
	ClutterTexture* backing_texture;
	ClutterTexture* highlight_texture;
	ClutterTexture* off_texture;
	ClutterTexture* on_texture;
	ClutterTexture* led_back_texture;
	ClutterTexture* arrow_texture;
	gint current_level;
	GList* actor_remove_queue;
	LEDArray* score_view;
	ClutterGroup* board_group;
	BoardView* board_view;
	BoardView* new_board_view;
	ClutterActor* backing_view;
	ClutterActor* left_arrow;
	ClutterActor* right_arrow;
	ClutterActor* key_cursor_view;
	ClutterTimeline* timeline;
	gint key_cursor_x;
	gint key_cursor_y;
	gboolean key_cursor_ready;
	gint last_direction;
	gint last_sign;
};

struct _BoardView {
	ClutterGroup parent_instance;
	BoardViewPrivate * priv;
	gboolean playable;
};

struct _BoardViewClass {
	ClutterGroupClass parent_class;
};


static gpointer game_view_parent_class = NULL;

GType game_view_get_type (void) G_GNUC_CONST;
GType led_array_get_type (void) G_GNUC_CONST;
GType board_view_get_type (void) G_GNUC_CONST;
#define GAME_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_GAME_VIEW, GameViewPrivate))
enum  {
	GAME_VIEW_DUMMY_PROPERTY
};
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
GameView* game_view_new (gint level);
GameView* game_view_construct (GType object_type, gint level);
static BoardView* game_view_create_board_view (GameView* self, gint level);
LEDArray* led_array_new (gint n_digits, ClutterActor* back_texture);
LEDArray* led_array_construct (GType object_type, gint n_digits, ClutterActor* back_texture);
void led_array_set_value (LEDArray* self, gint value);
static gboolean game_view_left_arrow_button_release_cb (GameView* self, ClutterActor* actor, ClutterButtonEvent* event);
static gboolean _game_view_left_arrow_button_release_cb_clutter_actor_button_release_event (ClutterActor* _sender, ClutterButtonEvent* event, gpointer self);
static gboolean game_view_right_arrow_button_release_cb (GameView* self, ClutterActor* actor, ClutterButtonEvent* event);
static gboolean _game_view_right_arrow_button_release_cb_clutter_actor_button_release_event (ClutterActor* _sender, ClutterButtonEvent* event, gpointer self);
BoardView* board_view_new (ClutterTexture* off_texture, ClutterTexture* on_texture);
BoardView* board_view_construct (GType object_type, ClutterTexture* off_texture, ClutterTexture* on_texture);
void board_view_load_level (BoardView* self, gint level);
static void game_view_game_won_cb (GameView* self);
static void _game_view_game_won_cb_board_view_game_won (BoardView* _sender, gpointer self);
static void game_view_transition_complete_cb (GameView* self);
void board_view_slide_in (BoardView* self, gint direction, gint sign, ClutterTimeline* timeline);
void board_view_slide_out (BoardView* self, gint direction, gint sign, ClutterTimeline* timeline);
static void _game_view_transition_complete_cb_clutter_timeline_completed (ClutterTimeline* _sender, gpointer self);
static void game_view_swap_board (GameView* self, gint direction);
void board_view_swap_in (BoardView* self, gfloat direction, ClutterTimeline* timeline);
void board_view_swap_out (BoardView* self, gfloat direction, ClutterTimeline* timeline);
void game_view_hide_cursor (GameView* self);
void game_view_move_cursor (GameView* self, gint x_step, gint y_step);
void board_view_get_light_position (BoardView* self, gint x, gint y, gfloat* xx, gfloat* yy);
void game_view_activate_cursor (GameView* self);
void board_view_toggle_light (BoardView* self, gint x, gint y, gboolean animate);
void game_view_reset_game (GameView* self);
static void game_view_finalize (GObject* obj);


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void _g_list_free__g_object_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
	g_list_free (self);
}


static gboolean _game_view_left_arrow_button_release_cb_clutter_actor_button_release_event (ClutterActor* _sender, ClutterButtonEvent* event, gpointer self) {
	gboolean result;
	result = game_view_left_arrow_button_release_cb (self, _sender, event);
	return result;
}


static gboolean _game_view_right_arrow_button_release_cb_clutter_actor_button_release_event (ClutterActor* _sender, ClutterButtonEvent* event, gpointer self) {
	gboolean result;
	result = game_view_right_arrow_button_release_cb (self, _sender, event);
	return result;
}


GameView* game_view_construct (GType object_type, gint level) {
	GameView * self = NULL;
	ClutterTexture* _tmp44_;
	ClutterTexture* _tmp45_;
	ClutterTexture* _tmp46_;
	ClutterTexture* _tmp47_;
	ClutterTexture* _tmp48_;
	ClutterTexture* _tmp49_;
	ClutterTexture* _tmp50_;
	ClutterTexture* _tmp51_;
	ClutterTexture* _tmp52_;
	ClutterTexture* _tmp53_;
	ClutterTexture* _tmp54_;
	ClutterTexture* _tmp55_;
	ClutterTexture* _tmp56_;
	gfloat _tmp57_;
	gfloat _tmp58_;
	gfloat real_board_width;
	ClutterTexture* _tmp59_;
	gfloat _tmp60_;
	gfloat _tmp61_;
	gfloat real_board_height;
	ClutterGroup* _tmp62_;
	ClutterGroup* _tmp63_;
	ClutterGroup* _tmp64_;
	gint _tmp65_;
	gint _tmp66_;
	BoardView* _tmp67_ = NULL;
	BoardView* _tmp68_;
	ClutterGroup* _tmp69_;
	BoardView* _tmp70_;
	ClutterTexture* _tmp71_;
	ClutterClone* _tmp72_;
	ClutterActor* _tmp73_;
	ClutterActor* _tmp74_;
	ClutterActor* _tmp75_;
	ClutterTexture* _tmp76_;
	LEDArray* _tmp77_;
	LEDArray* _tmp78_;
	LEDArray* _tmp79_;
	gint _tmp80_;
	LEDArray* _tmp81_;
	LEDArray* _tmp82_;
	gfloat _tmp83_;
	gfloat _tmp84_;
	LEDArray* _tmp85_;
	LEDArray* _tmp86_;
	LEDArray* _tmp87_;
	gfloat _tmp88_;
	gfloat _tmp89_;
	LEDArray* _tmp90_;
	gfloat _tmp91_;
	gfloat _tmp92_;
	ClutterTexture* _tmp93_;
	ClutterClone* _tmp94_;
	ClutterActor* _tmp95_;
	ClutterActor* _tmp96_;
	ClutterActor* _tmp97_;
	ClutterActor* _tmp98_;
	ClutterActor* _tmp99_;
	LEDArray* _tmp100_;
	gfloat _tmp101_;
	gfloat _tmp102_;
	LEDArray* _tmp103_;
	gfloat _tmp104_ = 0.0F;
	gfloat _tmp105_;
	LEDArray* _tmp106_;
	gfloat _tmp107_;
	gfloat _tmp108_;
	LEDArray* _tmp109_;
	gfloat _tmp110_;
	gfloat _tmp111_;
	ClutterActor* _tmp112_;
	ClutterTexture* _tmp113_;
	ClutterClone* _tmp114_;
	ClutterActor* _tmp115_;
	ClutterActor* _tmp116_;
	ClutterActor* _tmp117_;
	ClutterActor* _tmp118_;
	ClutterActor* _tmp119_;
	ClutterActor* _tmp120_;
	ClutterActor* _tmp121_;
	gfloat _tmp122_;
	gfloat _tmp123_;
	LEDArray* _tmp124_;
	gfloat _tmp125_;
	gfloat _tmp126_;
	LEDArray* _tmp127_;
	gfloat _tmp128_;
	gfloat _tmp129_;
	ClutterActor* _tmp130_;
	ClutterTexture* _tmp131_;
	ClutterClone* _tmp132_;
	ClutterActor* _tmp133_;
	ClutterActor* _tmp134_;
	ClutterActor* _tmp135_;
	ClutterActor* _tmp136_;
	GError * _inner_error_ = NULL;
	self = (GameView*) g_object_new (object_type, NULL);
	{
		gchar* _tmp0_ = NULL;
		gchar* _tmp1_;
		ClutterTexture* _tmp2_;
		ClutterTexture* _tmp3_;
		ClutterTexture* _tmp4_;
		ClutterTexture* _tmp5_;
		ClutterTexture* _tmp6_;
		gchar* _tmp7_ = NULL;
		gchar* _tmp8_;
		ClutterTexture* _tmp9_;
		ClutterTexture* _tmp10_;
		ClutterTexture* _tmp11_;
		ClutterTexture* _tmp12_;
		ClutterTexture* _tmp13_;
		gchar* _tmp14_ = NULL;
		gchar* _tmp15_;
		ClutterTexture* _tmp16_;
		ClutterTexture* _tmp17_;
		ClutterTexture* _tmp18_;
		ClutterTexture* _tmp19_;
		ClutterTexture* _tmp20_;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_;
		ClutterTexture* _tmp23_;
		ClutterTexture* _tmp24_;
		ClutterTexture* _tmp25_;
		ClutterTexture* _tmp26_;
		ClutterTexture* _tmp27_;
		gchar* _tmp28_ = NULL;
		gchar* _tmp29_;
		ClutterTexture* _tmp30_;
		ClutterTexture* _tmp31_;
		ClutterTexture* _tmp32_;
		ClutterTexture* _tmp33_;
		ClutterTexture* _tmp34_;
		gchar* _tmp35_ = NULL;
		gchar* _tmp36_;
		ClutterTexture* _tmp37_;
		ClutterTexture* _tmp38_;
		ClutterTexture* _tmp39_;
		ClutterTexture* _tmp40_;
		ClutterTexture* _tmp41_;
		_tmp0_ = g_build_filename (DATADIR, "backing.svg", NULL);
		_tmp1_ = _tmp0_;
		_tmp2_ = (ClutterTexture*) clutter_texture_new_from_file (_tmp1_, &_inner_error_);
		_tmp3_ = g_object_ref_sink (_tmp2_);
		_tmp4_ = _tmp3_;
		_g_free0 (_tmp1_);
		_tmp5_ = _tmp4_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == CLUTTER_TEXTURE_ERROR) {
				goto __catch1_clutter_texture_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp6_ = g_object_ref_sink (_tmp5_);
		_g_object_unref0 (self->priv->backing_texture);
		self->priv->backing_texture = _tmp6_;
		_tmp7_ = g_build_filename (DATADIR, "highlight.svg", NULL);
		_tmp8_ = _tmp7_;
		_tmp9_ = (ClutterTexture*) clutter_texture_new_from_file (_tmp8_, &_inner_error_);
		_tmp10_ = g_object_ref_sink (_tmp9_);
		_tmp11_ = _tmp10_;
		_g_free0 (_tmp8_);
		_tmp12_ = _tmp11_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == CLUTTER_TEXTURE_ERROR) {
				goto __catch1_clutter_texture_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp13_ = g_object_ref_sink (_tmp12_);
		_g_object_unref0 (self->priv->highlight_texture);
		self->priv->highlight_texture = _tmp13_;
		_tmp14_ = g_build_filename (DATADIR, "off.svg", NULL);
		_tmp15_ = _tmp14_;
		_tmp16_ = (ClutterTexture*) clutter_texture_new_from_file (_tmp15_, &_inner_error_);
		_tmp17_ = g_object_ref_sink (_tmp16_);
		_tmp18_ = _tmp17_;
		_g_free0 (_tmp15_);
		_tmp19_ = _tmp18_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == CLUTTER_TEXTURE_ERROR) {
				goto __catch1_clutter_texture_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp20_ = g_object_ref_sink (_tmp19_);
		_g_object_unref0 (self->priv->off_texture);
		self->priv->off_texture = _tmp20_;
		_tmp21_ = g_build_filename (DATADIR, "on.svg", NULL);
		_tmp22_ = _tmp21_;
		_tmp23_ = (ClutterTexture*) clutter_texture_new_from_file (_tmp22_, &_inner_error_);
		_tmp24_ = g_object_ref_sink (_tmp23_);
		_tmp25_ = _tmp24_;
		_g_free0 (_tmp22_);
		_tmp26_ = _tmp25_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == CLUTTER_TEXTURE_ERROR) {
				goto __catch1_clutter_texture_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp27_ = g_object_ref_sink (_tmp26_);
		_g_object_unref0 (self->priv->on_texture);
		self->priv->on_texture = _tmp27_;
		_tmp28_ = g_build_filename (DATADIR, "led-back.svg", NULL);
		_tmp29_ = _tmp28_;
		_tmp30_ = (ClutterTexture*) clutter_texture_new_from_file (_tmp29_, &_inner_error_);
		_tmp31_ = g_object_ref_sink (_tmp30_);
		_tmp32_ = _tmp31_;
		_g_free0 (_tmp29_);
		_tmp33_ = _tmp32_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == CLUTTER_TEXTURE_ERROR) {
				goto __catch1_clutter_texture_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp34_ = g_object_ref_sink (_tmp33_);
		_g_object_unref0 (self->priv->led_back_texture);
		self->priv->led_back_texture = _tmp34_;
		_tmp35_ = g_build_filename (DATADIR, "arrow.svg", NULL);
		_tmp36_ = _tmp35_;
		_tmp37_ = (ClutterTexture*) clutter_texture_new_from_file (_tmp36_, &_inner_error_);
		_tmp38_ = g_object_ref_sink (_tmp37_);
		_tmp39_ = _tmp38_;
		_g_free0 (_tmp36_);
		_tmp40_ = _tmp39_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == CLUTTER_TEXTURE_ERROR) {
				goto __catch1_clutter_texture_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp41_ = g_object_ref_sink (_tmp40_);
		_g_object_unref0 (self->priv->arrow_texture);
		self->priv->arrow_texture = _tmp41_;
	}
	goto __finally1;
	__catch1_clutter_texture_error:
	{
		GError* e = NULL;
		GError* _tmp42_;
		const gchar* _tmp43_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp42_ = e;
		_tmp43_ = _tmp42_->message;
		g_warning ("game-view.vala:47: Failed to load textures: %s", _tmp43_);
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp44_ = self->priv->backing_texture;
	clutter_actor_hide ((ClutterActor*) _tmp44_);
	_tmp45_ = self->priv->backing_texture;
	clutter_container_add_actor ((ClutterContainer*) self, (ClutterActor*) _tmp45_);
	_tmp46_ = self->priv->highlight_texture;
	clutter_actor_hide ((ClutterActor*) _tmp46_);
	_tmp47_ = self->priv->highlight_texture;
	clutter_container_add_actor ((ClutterContainer*) self, (ClutterActor*) _tmp47_);
	_tmp48_ = self->priv->off_texture;
	clutter_actor_hide ((ClutterActor*) _tmp48_);
	_tmp49_ = self->priv->off_texture;
	clutter_container_add_actor ((ClutterContainer*) self, (ClutterActor*) _tmp49_);
	_tmp50_ = self->priv->on_texture;
	clutter_actor_hide ((ClutterActor*) _tmp50_);
	_tmp51_ = self->priv->on_texture;
	clutter_container_add_actor ((ClutterContainer*) self, (ClutterActor*) _tmp51_);
	_tmp52_ = self->priv->led_back_texture;
	clutter_actor_hide ((ClutterActor*) _tmp52_);
	_tmp53_ = self->priv->led_back_texture;
	clutter_container_add_actor ((ClutterContainer*) self, (ClutterActor*) _tmp53_);
	_tmp54_ = self->priv->arrow_texture;
	clutter_actor_hide ((ClutterActor*) _tmp54_);
	_tmp55_ = self->priv->arrow_texture;
	clutter_container_add_actor ((ClutterContainer*) self, (ClutterActor*) _tmp55_);
	_tmp56_ = self->priv->off_texture;
	_tmp57_ = clutter_actor_get_width ((ClutterActor*) _tmp56_);
	_tmp58_ = _tmp57_;
	real_board_width = (5 * _tmp58_) + 4;
	_tmp59_ = self->priv->off_texture;
	_tmp60_ = clutter_actor_get_height ((ClutterActor*) _tmp59_);
	_tmp61_ = _tmp60_;
	real_board_height = (5 * _tmp61_) + 4;
	_tmp62_ = (ClutterGroup*) clutter_group_new ();
	_tmp63_ = g_object_ref_sink (_tmp62_);
	_g_object_unref0 (self->priv->board_group);
	self->priv->board_group = _tmp63_;
	_tmp64_ = self->priv->board_group;
	clutter_container_add_actor ((ClutterContainer*) self, (ClutterActor*) _tmp64_);
	_tmp65_ = level;
	self->priv->current_level = _tmp65_;
	_tmp66_ = self->priv->current_level;
	_tmp67_ = game_view_create_board_view (self, _tmp66_);
	_g_object_unref0 (self->priv->board_view);
	self->priv->board_view = _tmp67_;
	_tmp68_ = self->priv->board_view;
	_tmp68_->playable = TRUE;
	_tmp69_ = self->priv->board_group;
	_tmp70_ = self->priv->board_view;
	clutter_container_add_actor ((ClutterContainer*) _tmp69_, (ClutterActor*) _tmp70_);
	_tmp71_ = self->priv->backing_texture;
	_tmp72_ = (ClutterClone*) clutter_clone_new ((ClutterActor*) _tmp71_);
	_tmp73_ = (ClutterActor*) g_object_ref_sink (_tmp72_);
	_g_object_unref0 (self->priv->backing_view);
	self->priv->backing_view = _tmp73_;
	_tmp74_ = self->priv->backing_view;
	clutter_actor_set_position (_tmp74_, (gfloat) 0, real_board_height);
	_tmp75_ = self->priv->backing_view;
	clutter_container_add_actor ((ClutterContainer*) self, _tmp75_);
	_tmp76_ = self->priv->led_back_texture;
	_tmp77_ = led_array_new (5, (ClutterActor*) _tmp76_);
	_tmp78_ = g_object_ref_sink (_tmp77_);
	_g_object_unref0 (self->priv->score_view);
	self->priv->score_view = _tmp78_;
	_tmp79_ = self->priv->score_view;
	_tmp80_ = self->priv->current_level;
	led_array_set_value (_tmp79_, _tmp80_);
	_tmp81_ = self->priv->score_view;
	_tmp82_ = self->priv->score_view;
	_tmp83_ = clutter_actor_get_width ((ClutterActor*) _tmp82_);
	_tmp84_ = _tmp83_;
	clutter_actor_set_anchor_point ((ClutterActor*) _tmp81_, _tmp84_ / 2, (gfloat) 0);
	_tmp85_ = self->priv->score_view;
	clutter_actor_set_position ((ClutterActor*) _tmp85_, real_board_width / 2, real_board_height + 18);
	_tmp86_ = self->priv->score_view;
	clutter_container_add_actor ((ClutterContainer*) self, (ClutterActor*) _tmp86_);
	_tmp87_ = self->priv->score_view;
	_tmp88_ = clutter_actor_get_y ((ClutterActor*) _tmp87_);
	_tmp89_ = _tmp88_;
	_tmp90_ = self->priv->score_view;
	_tmp91_ = clutter_actor_get_height ((ClutterActor*) _tmp90_);
	_tmp92_ = _tmp91_;
	clutter_actor_set_size ((ClutterActor*) self, real_board_width, _tmp89_ + _tmp92_);
	_tmp93_ = self->priv->arrow_texture;
	_tmp94_ = (ClutterClone*) clutter_clone_new ((ClutterActor*) _tmp93_);
	_tmp95_ = (ClutterActor*) g_object_ref_sink (_tmp94_);
	_g_object_unref0 (self->priv->left_arrow);
	self->priv->left_arrow = _tmp95_;
	_tmp96_ = self->priv->left_arrow;
	g_object_set (_tmp96_, "anchor-gravity", CLUTTER_GRAVITY_CENTER, NULL);
	_tmp97_ = self->priv->left_arrow;
	clutter_actor_set_reactive (_tmp97_, TRUE);
	_tmp98_ = self->priv->left_arrow;
	g_signal_connect_object (_tmp98_, "button-release-event", (GCallback) _game_view_left_arrow_button_release_cb_clutter_actor_button_release_event, self, 0);
	_tmp99_ = self->priv->left_arrow;
	_tmp100_ = self->priv->score_view;
	_tmp101_ = clutter_actor_get_x ((ClutterActor*) _tmp100_);
	_tmp102_ = _tmp101_;
	_tmp103_ = self->priv->score_view;
	g_object_get ((ClutterActor*) _tmp103_, "anchor-x", &_tmp104_, NULL);
	_tmp105_ = _tmp104_;
	_tmp106_ = self->priv->score_view;
	_tmp107_ = clutter_actor_get_y ((ClutterActor*) _tmp106_);
	_tmp108_ = _tmp107_;
	_tmp109_ = self->priv->score_view;
	_tmp110_ = clutter_actor_get_height ((ClutterActor*) _tmp109_);
	_tmp111_ = _tmp110_;
	clutter_actor_set_position (_tmp99_, (_tmp102_ - _tmp105_) / 2, (_tmp108_ + (_tmp111_ / 2)) - 10);
	_tmp112_ = self->priv->left_arrow;
	clutter_container_add_actor ((ClutterContainer*) self, _tmp112_);
	_tmp113_ = self->priv->arrow_texture;
	_tmp114_ = (ClutterClone*) clutter_clone_new ((ClutterActor*) _tmp113_);
	_tmp115_ = (ClutterActor*) g_object_ref_sink (_tmp114_);
	_g_object_unref0 (self->priv->right_arrow);
	self->priv->right_arrow = _tmp115_;
	_tmp116_ = self->priv->right_arrow;
	g_object_set (_tmp116_, "anchor-gravity", CLUTTER_GRAVITY_CENTER, NULL);
	_tmp117_ = self->priv->right_arrow;
	clutter_actor_set_reactive (_tmp117_, TRUE);
	_tmp118_ = self->priv->right_arrow;
	g_signal_connect_object (_tmp118_, "button-release-event", (GCallback) _game_view_right_arrow_button_release_cb_clutter_actor_button_release_event, self, 0);
	_tmp119_ = self->priv->right_arrow;
	g_object_set (_tmp119_, "rotation-angle-y", (gdouble) 180, NULL);
	_tmp120_ = self->priv->right_arrow;
	_tmp121_ = self->priv->left_arrow;
	_tmp122_ = clutter_actor_get_x (_tmp121_);
	_tmp123_ = _tmp122_;
	_tmp124_ = self->priv->score_view;
	_tmp125_ = clutter_actor_get_y ((ClutterActor*) _tmp124_);
	_tmp126_ = _tmp125_;
	_tmp127_ = self->priv->score_view;
	_tmp128_ = clutter_actor_get_height ((ClutterActor*) _tmp127_);
	_tmp129_ = _tmp128_;
	clutter_actor_set_position (_tmp120_, real_board_width - _tmp123_, (_tmp126_ + (_tmp129_ / 2)) - 10);
	_tmp130_ = self->priv->right_arrow;
	clutter_container_add_actor ((ClutterContainer*) self, _tmp130_);
	_tmp131_ = self->priv->highlight_texture;
	_tmp132_ = (ClutterClone*) clutter_clone_new ((ClutterActor*) _tmp131_);
	_tmp133_ = (ClutterActor*) g_object_ref_sink (_tmp132_);
	_g_object_unref0 (self->priv->key_cursor_view);
	self->priv->key_cursor_view = _tmp133_;
	_tmp134_ = self->priv->key_cursor_view;
	clutter_actor_set_position (_tmp134_, (gfloat) (-100), (gfloat) (-100));
	_tmp135_ = self->priv->key_cursor_view;
	g_object_set (_tmp135_, "anchor-gravity", CLUTTER_GRAVITY_CENTER, NULL);
	_tmp136_ = self->priv->key_cursor_view;
	clutter_container_add_actor ((ClutterContainer*) self, _tmp136_);
	return self;
}


GameView* game_view_new (gint level) {
	return game_view_construct (TYPE_GAME_VIEW, level);
}


static void _game_view_game_won_cb_board_view_game_won (BoardView* _sender, gpointer self) {
	game_view_game_won_cb (self);
}


static BoardView* game_view_create_board_view (GameView* self, gint level) {
	BoardView* result = NULL;
	ClutterTexture* _tmp0_;
	ClutterTexture* _tmp1_;
	BoardView* _tmp2_;
	BoardView* _tmp3_;
	BoardView* view;
	gint _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->off_texture;
	_tmp1_ = self->priv->on_texture;
	_tmp2_ = board_view_new (_tmp0_, _tmp1_);
	_tmp3_ = g_object_ref_sink (_tmp2_);
	view = _tmp3_;
	_tmp4_ = level;
	board_view_load_level (view, _tmp4_);
	g_signal_connect_object (view, "game-won", (GCallback) _game_view_game_won_cb_board_view_game_won, self, 0);
	view->playable = FALSE;
	result = view;
	return result;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void game_view_transition_complete_cb (GameView* self) {
	BoardView* _tmp0_;
	BoardView* _tmp1_;
	BoardView* _tmp2_;
	BoardView* _tmp3_;
	GList* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->board_view;
	clutter_actor_destroy ((ClutterActor*) _tmp0_);
	_tmp1_ = self->priv->new_board_view;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->board_view);
	self->priv->board_view = _tmp2_;
	_tmp3_ = self->priv->board_view;
	_tmp3_->playable = TRUE;
	_g_object_unref0 (self->priv->new_board_view);
	self->priv->new_board_view = NULL;
	_g_object_unref0 (self->priv->timeline);
	self->priv->timeline = NULL;
	_tmp4_ = self->priv->actor_remove_queue;
	{
		GList* actor_collection = NULL;
		GList* actor_it = NULL;
		actor_collection = _tmp4_;
		for (actor_it = actor_collection; actor_it != NULL; actor_it = actor_it->next) {
			ClutterActor* _tmp5_;
			ClutterActor* actor = NULL;
			_tmp5_ = _g_object_ref0 ((ClutterActor*) actor_it->data);
			actor = _tmp5_;
			{
				ClutterActor* _tmp6_;
				_tmp6_ = actor;
				clutter_actor_destroy (_tmp6_);
				_g_object_unref0 (actor);
			}
		}
	}
	__g_list_free__g_object_unref0_0 (self->priv->actor_remove_queue);
	self->priv->actor_remove_queue = NULL;
}


static void _game_view_transition_complete_cb_clutter_timeline_completed (ClutterTimeline* _sender, gpointer self) {
	game_view_transition_complete_cb (self);
}


static void game_view_game_won_cb (GameView* self) {
	gboolean _tmp0_ = FALSE;
	ClutterTimeline* _tmp1_;
	gboolean _tmp4_;
	gint _tmp5_;
	LEDArray* _tmp6_;
	gint _tmp7_;
	gint direction;
	gint sign;
	gint _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	BoardView* _tmp23_ = NULL;
	ClutterGroup* _tmp24_;
	BoardView* _tmp25_;
	ClutterTimeline* _tmp26_;
	BoardView* _tmp27_;
	gint _tmp28_;
	gint _tmp29_;
	ClutterTimeline* _tmp30_;
	BoardView* _tmp31_;
	gint _tmp32_;
	gint _tmp33_;
	ClutterTimeline* _tmp34_;
	ClutterTimeline* _tmp35_;
	gint _tmp36_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->timeline;
	if (_tmp1_ != NULL) {
		ClutterTimeline* _tmp2_;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = self->priv->timeline;
		_tmp3_ = clutter_timeline_is_playing (_tmp2_);
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp4_ = _tmp0_;
	if (_tmp4_) {
		return;
	}
	_tmp5_ = self->priv->current_level;
	self->priv->current_level = _tmp5_ + 1;
	_tmp6_ = self->priv->score_view;
	_tmp7_ = self->priv->current_level;
	led_array_set_value (_tmp6_, _tmp7_);
	direction = 0;
	sign = 0;
	{
		gboolean _tmp8_;
		_tmp8_ = TRUE;
		while (TRUE) {
			gboolean _tmp9_;
			gint32 _tmp16_ = 0;
			gint _tmp17_ = 0;
			gboolean _tmp18_ = FALSE;
			gint _tmp19_;
			_tmp9_ = _tmp8_;
			if (!_tmp9_) {
				gboolean _tmp10_ = FALSE;
				gint _tmp11_;
				gint _tmp12_;
				gboolean _tmp15_;
				_tmp11_ = self->priv->last_direction;
				_tmp12_ = direction;
				if (_tmp11_ == _tmp12_) {
					_tmp10_ = TRUE;
				} else {
					gint _tmp13_;
					gint _tmp14_;
					_tmp13_ = self->priv->last_sign;
					_tmp14_ = sign;
					_tmp10_ = _tmp13_ == _tmp14_;
				}
				_tmp15_ = _tmp10_;
				if (!_tmp15_) {
					break;
				}
			}
			_tmp8_ = FALSE;
			_tmp16_ = g_random_int_range ((gint32) 0, (gint32) 2);
			direction = (gint) _tmp16_;
			_tmp18_ = g_random_boolean ();
			if (_tmp18_) {
				_tmp17_ = 1;
			} else {
				_tmp17_ = -1;
			}
			_tmp19_ = _tmp17_;
			sign = _tmp19_;
		}
	}
	_tmp20_ = direction;
	self->priv->last_direction = _tmp20_;
	_tmp21_ = sign;
	self->priv->last_sign = _tmp21_;
	_tmp22_ = self->priv->current_level;
	_tmp23_ = game_view_create_board_view (self, _tmp22_);
	_g_object_unref0 (self->priv->new_board_view);
	self->priv->new_board_view = _tmp23_;
	_tmp24_ = self->priv->board_group;
	_tmp25_ = self->priv->new_board_view;
	clutter_container_add_actor ((ClutterContainer*) _tmp24_, (ClutterActor*) _tmp25_);
	_tmp26_ = clutter_timeline_new ((guint) 1500);
	_g_object_unref0 (self->priv->timeline);
	self->priv->timeline = _tmp26_;
	_tmp27_ = self->priv->new_board_view;
	_tmp28_ = direction;
	_tmp29_ = sign;
	_tmp30_ = self->priv->timeline;
	board_view_slide_in (_tmp27_, _tmp28_, _tmp29_, _tmp30_);
	_tmp31_ = self->priv->board_view;
	_tmp32_ = direction;
	_tmp33_ = sign;
	_tmp34_ = self->priv->timeline;
	board_view_slide_out (_tmp31_, _tmp32_, _tmp33_, _tmp34_);
	_tmp35_ = self->priv->timeline;
	g_signal_connect_object (_tmp35_, "completed", (GCallback) _game_view_transition_complete_cb_clutter_timeline_completed, self, 0);
	_tmp36_ = self->priv->current_level;
	g_signal_emit_by_name (self, "level-changed", _tmp36_);
}


static gboolean game_view_left_arrow_button_release_cb (GameView* self, ClutterActor* actor, ClutterButtonEvent* event) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (actor != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	game_view_swap_board (self, -1);
	result = FALSE;
	return result;
}


static gboolean game_view_right_arrow_button_release_cb (GameView* self, ClutterActor* actor, ClutterButtonEvent* event) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (actor != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	game_view_swap_board (self, 1);
	result = FALSE;
	return result;
}


static void game_view_swap_board (GameView* self, gint direction) {
	gboolean _tmp0_ = FALSE;
	ClutterTimeline* _tmp1_;
	gboolean _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gint _tmp7_;
	LEDArray* _tmp8_;
	gint _tmp9_;
	ClutterTimeline* _tmp10_;
	gint _tmp11_;
	BoardView* _tmp12_ = NULL;
	ClutterGroup* _tmp13_;
	BoardView* _tmp14_;
	BoardView* _tmp15_;
	gint _tmp16_;
	BoardView* _tmp17_;
	BoardView* _tmp18_;
	gint _tmp19_;
	ClutterTimeline* _tmp20_;
	BoardView* _tmp21_;
	gint _tmp22_;
	ClutterTimeline* _tmp23_;
	ClutterTimeline* _tmp24_;
	gint _tmp25_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->timeline;
	if (_tmp1_ != NULL) {
		ClutterTimeline* _tmp2_;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = self->priv->timeline;
		_tmp3_ = clutter_timeline_is_playing (_tmp2_);
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp4_ = _tmp0_;
	if (_tmp4_) {
		return;
	}
	_tmp5_ = self->priv->current_level;
	_tmp6_ = direction;
	self->priv->current_level = _tmp5_ + _tmp6_;
	_tmp7_ = self->priv->current_level;
	if (_tmp7_ <= 0) {
		self->priv->current_level = 1;
		return;
	}
	_tmp8_ = self->priv->score_view;
	_tmp9_ = self->priv->current_level;
	led_array_set_value (_tmp8_, _tmp9_);
	_tmp10_ = clutter_timeline_new ((guint) 500);
	_g_object_unref0 (self->priv->timeline);
	self->priv->timeline = _tmp10_;
	_tmp11_ = self->priv->current_level;
	_tmp12_ = game_view_create_board_view (self, _tmp11_);
	_g_object_unref0 (self->priv->new_board_view);
	self->priv->new_board_view = _tmp12_;
	_tmp13_ = self->priv->board_group;
	_tmp14_ = self->priv->new_board_view;
	clutter_container_add_actor ((ClutterContainer*) _tmp13_, (ClutterActor*) _tmp14_);
	_tmp15_ = self->priv->new_board_view;
	_tmp16_ = direction;
	clutter_actor_set_depth ((ClutterActor*) _tmp15_, (gfloat) ((-250) * _tmp16_));
	_tmp17_ = self->priv->new_board_view;
	clutter_actor_set_opacity ((ClutterActor*) _tmp17_, (guint) 0);
	_tmp18_ = self->priv->new_board_view;
	_tmp19_ = direction;
	_tmp20_ = self->priv->timeline;
	board_view_swap_in (_tmp18_, (gfloat) _tmp19_, _tmp20_);
	_tmp21_ = self->priv->board_view;
	_tmp22_ = direction;
	_tmp23_ = self->priv->timeline;
	board_view_swap_out (_tmp21_, (gfloat) _tmp22_, _tmp23_);
	_tmp24_ = self->priv->timeline;
	g_signal_connect_object (_tmp24_, "completed", (GCallback) _game_view_transition_complete_cb_clutter_timeline_completed, self, 0);
	_tmp25_ = self->priv->current_level;
	g_signal_emit_by_name (self, "level-changed", _tmp25_);
}


void game_view_hide_cursor (GameView* self) {
	ClutterActor* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->key_cursor_view;
	clutter_actor_animate (_tmp0_, (gulong) CLUTTER_EASE_OUT_SINE, (guint) 250, "opacity", 0, NULL);
	self->priv->key_cursor_ready = FALSE;
}


void game_view_move_cursor (GameView* self, gint x_step, gint y_step) {
	gboolean _tmp0_;
	gfloat x = 0.0F;
	gfloat y = 0.0F;
	BoardView* _tmp13_;
	gint _tmp14_;
	gint _tmp15_;
	gfloat _tmp16_ = 0.0F;
	gfloat _tmp17_ = 0.0F;
	gboolean _tmp18_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->key_cursor_ready;
	if (_tmp0_) {
		gint _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _tmp6_ = 0;
		gint _tmp7_;
		gint _tmp8_ = 0;
		gint _tmp9_;
		gint _tmp10_ = 0;
		gint _tmp11_;
		gint _tmp12_ = 0;
		_tmp1_ = self->priv->key_cursor_x;
		_tmp2_ = x_step;
		self->priv->key_cursor_x = _tmp1_ + _tmp2_;
		_tmp3_ = self->priv->key_cursor_y;
		_tmp4_ = y_step;
		self->priv->key_cursor_y = _tmp3_ + _tmp4_;
		_tmp5_ = self->priv->key_cursor_x;
		_tmp6_ = MAX (_tmp5_, 0);
		self->priv->key_cursor_x = _tmp6_;
		_tmp7_ = self->priv->key_cursor_x;
		_tmp8_ = MIN (_tmp7_, 4);
		self->priv->key_cursor_x = _tmp8_;
		_tmp9_ = self->priv->key_cursor_y;
		_tmp10_ = MAX (_tmp9_, 0);
		self->priv->key_cursor_y = _tmp10_;
		_tmp11_ = self->priv->key_cursor_y;
		_tmp12_ = MIN (_tmp11_, 4);
		self->priv->key_cursor_y = _tmp12_;
	}
	_tmp13_ = self->priv->board_view;
	_tmp14_ = self->priv->key_cursor_x;
	_tmp15_ = self->priv->key_cursor_y;
	board_view_get_light_position (_tmp13_, _tmp14_, _tmp15_, &_tmp16_, &_tmp17_);
	x = _tmp16_;
	y = _tmp17_;
	_tmp18_ = self->priv->key_cursor_ready;
	if (_tmp18_) {
		ClutterActor* _tmp19_;
		gfloat _tmp20_;
		gfloat _tmp21_;
		_tmp19_ = self->priv->key_cursor_view;
		_tmp20_ = x;
		_tmp21_ = y;
		clutter_actor_animate (_tmp19_, (gulong) CLUTTER_EASE_OUT_SINE, (guint) 250, "x", _tmp20_, "y", _tmp21_, NULL);
	} else {
		ClutterActor* _tmp22_;
		ClutterActor* _tmp23_;
		gfloat _tmp24_;
		gfloat _tmp25_;
		ClutterActor* _tmp26_;
		_tmp22_ = self->priv->key_cursor_view;
		clutter_actor_set_opacity (_tmp22_, (guint) 0);
		_tmp23_ = self->priv->key_cursor_view;
		_tmp24_ = x;
		_tmp25_ = y;
		clutter_actor_set_position (_tmp23_, _tmp24_, _tmp25_);
		_tmp26_ = self->priv->key_cursor_view;
		clutter_actor_animate (_tmp26_, (gulong) CLUTTER_EASE_OUT_SINE, (guint) 250, "opacity", 255, NULL);
	}
	self->priv->key_cursor_ready = TRUE;
}


void game_view_activate_cursor (GameView* self) {
	gboolean _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->key_cursor_ready;
	if (_tmp0_) {
		BoardView* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		_tmp1_ = self->priv->board_view;
		_tmp2_ = self->priv->key_cursor_x;
		_tmp3_ = self->priv->key_cursor_y;
		board_view_toggle_light (_tmp1_, _tmp2_, _tmp3_, TRUE);
	}
}


void game_view_reset_game (GameView* self) {
	gboolean _tmp0_ = FALSE;
	ClutterTimeline* _tmp1_;
	gboolean _tmp4_;
	LEDArray* _tmp5_;
	gint _tmp6_;
	ClutterTimeline* _tmp7_;
	gint _tmp8_;
	BoardView* _tmp9_ = NULL;
	ClutterGroup* _tmp10_;
	BoardView* _tmp11_;
	BoardView* _tmp12_;
	BoardView* _tmp13_;
	BoardView* _tmp14_;
	ClutterTimeline* _tmp15_;
	BoardView* _tmp16_;
	ClutterTimeline* _tmp17_;
	ClutterTimeline* _tmp18_;
	gint _tmp19_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->timeline;
	if (_tmp1_ != NULL) {
		ClutterTimeline* _tmp2_;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = self->priv->timeline;
		_tmp3_ = clutter_timeline_is_playing (_tmp2_);
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	_tmp4_ = _tmp0_;
	if (_tmp4_) {
		return;
	}
	self->priv->current_level = 1;
	_tmp5_ = self->priv->score_view;
	_tmp6_ = self->priv->current_level;
	led_array_set_value (_tmp5_, _tmp6_);
	_tmp7_ = clutter_timeline_new ((guint) 500);
	_g_object_unref0 (self->priv->timeline);
	self->priv->timeline = _tmp7_;
	_tmp8_ = self->priv->current_level;
	_tmp9_ = game_view_create_board_view (self, _tmp8_);
	_g_object_unref0 (self->priv->new_board_view);
	self->priv->new_board_view = _tmp9_;
	_tmp10_ = self->priv->board_group;
	_tmp11_ = self->priv->new_board_view;
	clutter_container_add_actor ((ClutterContainer*) _tmp10_, (ClutterActor*) _tmp11_);
	_tmp12_ = self->priv->new_board_view;
	clutter_actor_set_depth ((ClutterActor*) _tmp12_, (gfloat) 250);
	_tmp13_ = self->priv->new_board_view;
	clutter_actor_set_opacity ((ClutterActor*) _tmp13_, (guint) 0);
	_tmp14_ = self->priv->new_board_view;
	_tmp15_ = self->priv->timeline;
	board_view_swap_in (_tmp14_, (gfloat) (-1), _tmp15_);
	_tmp16_ = self->priv->board_view;
	_tmp17_ = self->priv->timeline;
	board_view_swap_out (_tmp16_, (gfloat) (-1), _tmp17_);
	_tmp18_ = self->priv->timeline;
	g_signal_connect_object (_tmp18_, "completed", (GCallback) _game_view_transition_complete_cb_clutter_timeline_completed, self, 0);
	_tmp19_ = self->priv->current_level;
	g_signal_emit_by_name (self, "level-changed", _tmp19_);
}


static void game_view_class_init (GameViewClass * klass) {
	game_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GameViewPrivate));
	G_OBJECT_CLASS (klass)->finalize = game_view_finalize;
	g_signal_new ("level_changed", TYPE_GAME_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__INT, G_TYPE_NONE, 1, G_TYPE_INT);
}


static void game_view_instance_init (GameView * self) {
	self->priv = GAME_VIEW_GET_PRIVATE (self);
	self->priv->actor_remove_queue = NULL;
	self->priv->new_board_view = NULL;
	self->priv->key_cursor_x = 0;
	self->priv->key_cursor_y = 0;
	self->priv->key_cursor_ready = FALSE;
	self->priv->last_direction = 0;
	self->priv->last_sign = 0;
}


static void game_view_finalize (GObject* obj) {
	GameView * self;
	self = GAME_VIEW (obj);
	_g_object_unref0 (self->priv->backing_texture);
	_g_object_unref0 (self->priv->highlight_texture);
	_g_object_unref0 (self->priv->off_texture);
	_g_object_unref0 (self->priv->on_texture);
	_g_object_unref0 (self->priv->led_back_texture);
	_g_object_unref0 (self->priv->arrow_texture);
	__g_list_free__g_object_unref0_0 (self->priv->actor_remove_queue);
	_g_object_unref0 (self->priv->score_view);
	_g_object_unref0 (self->priv->board_group);
	_g_object_unref0 (self->priv->board_view);
	_g_object_unref0 (self->priv->new_board_view);
	_g_object_unref0 (self->priv->backing_view);
	_g_object_unref0 (self->priv->left_arrow);
	_g_object_unref0 (self->priv->right_arrow);
	_g_object_unref0 (self->priv->key_cursor_view);
	_g_object_unref0 (self->priv->timeline);
	G_OBJECT_CLASS (game_view_parent_class)->finalize (obj);
}


GType game_view_get_type (void) {
	static volatile gsize game_view_type_id__volatile = 0;
	if (g_once_init_enter (&game_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GameViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameView), 0, (GInstanceInitFunc) game_view_instance_init, NULL };
		GType game_view_type_id;
		game_view_type_id = g_type_register_static (clutter_group_get_type (), "GameView", &g_define_type_info, 0);
		g_once_init_leave (&game_view_type_id__volatile, game_view_type_id);
	}
	return game_view_type_id__volatile;
}



