Summary: GNat Ada Database Environment
Name: gnade
Version: VERSION
Release: BUILD
Copyright: GPL
Group: Development/Tools
Source: gnade.tar.gz
BuildRoot: /tmp/%{name}-buildroot

%description
This package contains the libraries and tools to integrate 
RDMS products into a GNAT basesd Ada 95 applications.
%prep
%setup -n gnade-src-VERSION
%build
./configure --root=$RPM_BUILD_ROOT/usr/local/gnade --nosamples --all
make
make documentation 
%install
make install

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%doc README COPYING TODO AUTHORS doc/* samples/standalone
/usr/local/gnade/include/*.ads
/usr/local/gnade/include/*.adb
/usr/local/gnade/include/*.ali
/usr/local/gnade/lib/libgnade*.a
/usr/local/gnade/lib/libgnade*.so.*
/usr/local/gnade/bin/gesql
/usr/local/gnade/bin/sql
/usr/local/gnade/bin/imp
/usr/local/gnade/bin/exp
/usr/local/gnade/bin/lsodbc
/usr/local/gnade/bin/gnade-config
/usr/local/gnade/shared/*
/usr/local/gnade/doc/*
/usr/local/gnade/etc/*

%post
profdir=/etc/profile.d
if test -e $profdir ; then
   for i in gnade.sh gnade.bash gnade.csh ; do
      echo -n "Installing $i ..." ;
      cp -a /usr/local/gnade/etc/$i $profdir
      echo " done."
   done
fi
echo
echo -n "Seting up linker configuration ..." 
libpath=/usr/local/gnade/lib
if ! grep $libpath /etc/ld.so.conf > /dev/null ; then
   echo $libpath >> /etc/ld.so.conf
   ldconfig 
fi
echo " done."
echo

%postun
profdir=/etc/profile.d
if test -e $profdir ; then
   for i in $profdir/gnade.* ; do
      echo -n "Deinstalling $i ..." ;
      rm -f $i
      echo " done."
   done
fi
echo

%changelog
* Sun Feb 22 2003 Michael Erdmann <michael.erdmann@snafu.de>
- Build for SuSe including the changes from Vasile.
* Sun Feb 16 2003 Vasile Alaiba <alaiba@ozland.ro>
- Build for Mandrake 9.0, only PostgreSQL and MySQL (removed others from %build)
- Changed %files section to list files with wildcards
- Changed BuildRoot location to /tmp/{name}-buildroot
- Changed %install section to peek files from $RPM_BUILD_ROOT
* Fri Dec 27 2002  Michael Erdmann  Michael.erdmann@snafu.de
- Now building under SuSe
* Thu Oct 11 2002  Michael Erdmann  Michael.erdmann@snafu.de
- first attempt

