-----------------------------------------------------------------------------
--  Thin Ada95 binding to OCI (Oracle Call Interface)                    --
--  Copyright (C) 2000-2004 Dmitriy Anisimkov.                              --
--  License agreement and authors contact information are in file oci.ads   --
------------------------------------------------------------------------------

--  $Id: oci-thick-strings.ads,v 1.13 2004/06/28 04:57:05 vagul Exp $

with Ada.Strings.Unbounded;

with Interfaces.C;

with OCI.Thick.Statements;

package OCI.Thick.Strings is

   use OCI.Thick.Statements;
   use Ada.Strings.Unbounded;

   subtype Default_Mode is Thick.Default_Mode;

   type Var_Type is new Limited_Variable with private;

   subtype Variable is Var_Type;

   procedure Bind
     (Stmt  : in     Statement'Class;
      Value : in out Var_Type;
      Name  : in     String);

   procedure Bind
     (Stmt  : in     Statement'Class;
      Value : in out Var_Type;
      Name  : in     String;
      Exist :    out Boolean);
   --  Exist would be set to True if the bind variable exist.
   --  otherwise the bind would not be done.

   procedure Bind
     (Stmt     : in     Statement'Class;
      Value    : in out Var_Type;
      Position : in     Positive);

   procedure Define
     (Stmt     : in     Statement'Class;
      Value    : in out Var_Type;
      Position : in     Positive);

   procedure Set_Value (Var : in out Var_Type; Value : String);

   procedure Set_Value (Var : in out Var_Type; Value : Unbounded_String);

   function Get_Value (Var : Var_Type) return Unbounded_String;

   function Get_Value (Var : Var_Type) return String;
   --  Raise exception in case of NULL data.

   function Get_Value
     (Var     : in Var_Type;
      Default : in String;
      Mode    : in Default_Mode := Instead_Any)
      return  String;
   --  Returns Default string in case of Null or/else not attached data.

   function Is_Null (Var : Var_Type) return Boolean;

   procedure Clear_Value (Var : in out Var_Type);

   function Value (Var : Var_Type) return String
      renames Get_Value;

   function Value (Var : Var_Type) return Unbounded_String
      renames Get_Value;

   function Value
     (Var     : in Var_Type;
      Default : in String;
      Mode    : in Default_Mode := Instead_Any)
      return  String renames Get_Value;

   function String_Value (Var : Var_Type) return String renames Get_Value;

   function Unbounded_String_Value
     (Var    : Var_Type)
      return Unbounded_String renames Get_Value;

private

   use Interfaces.C;

   type Char_Array_Access is access all char_array;

   type Value_Access is access all Var_Type;

   subtype Inherited is Limited_Variable;

   type Var_Type is new Inherited with record
      Name            : Unbounded_String; -- Only for debug purpose.
      Value           : Char_Array_Access;
      Next            : Char_Array_Access;
      rcode           : aliased Ub2    := 0;
      alen            : aliased size_t := 0;
      Self            : Value_Access; -- Only for complete.
   end record;

   procedure Finalize  (Object : in out Var_Type);

end OCI.Thick.Strings;
