// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GIOMM_DATAINPUTSTREAM_H
#define _GIOMM_DATAINPUTSTREAM_H


#include <glibmm.h>

// -*- Mode: C++; indent-tabs-mode: nil; c-basic-offset: 2 -*-

/* Copyright (C) 2007 The gtkmm Development Team
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free
 * Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <giomm/bufferedinputstream.h>
#include <giomm/enums.h>


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GDataInputStream GDataInputStream;
typedef struct _GDataInputStreamClass GDataInputStreamClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gio
{ class DataInputStream_Class; } // namespace Gio
namespace Gio
{

/**
 * An implementation of BufferedInputStream that allows for high-level data
 * manipulation of arbitrary data (including binary operations).
 *
 * @ingroup Streams
 *
 * @newin2p16
 */

class DataInputStream : public Gio::BufferedInputStream
{
  
#ifndef DOXYGEN_SHOULD_SKIP_THIS

public:
  typedef DataInputStream CppObjectType;
  typedef DataInputStream_Class CppClassType;
  typedef GDataInputStream BaseObjectType;
  typedef GDataInputStreamClass BaseClassType;

private:  friend class DataInputStream_Class;
  static CppClassType datainputstream_class_;

private:
  // noncopyable
  DataInputStream(const DataInputStream&);
  DataInputStream& operator=(const DataInputStream&);

protected:
  explicit DataInputStream(const Glib::ConstructParams& construct_params);
  explicit DataInputStream(GDataInputStream* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:
  virtual ~DataInputStream();

#ifndef DOXYGEN_SHOULD_SKIP_THIS
  static GType get_type()      G_GNUC_CONST;
  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GObject.
  GDataInputStream*       gobj()       { return reinterpret_cast<GDataInputStream*>(gobject_); }

  ///Provides access to the underlying C GObject.
  const GDataInputStream* gobj() const { return reinterpret_cast<GDataInputStream*>(gobject_); }

  ///Provides access to the underlying C instance. The caller is responsible for unrefing it. Use when directly setting fields in structs.
  GDataInputStream* gobj_copy();

private:


protected:
  explicit DataInputStream(const Glib::RefPtr<InputStream>& base_stream);

public:

  
  static Glib::RefPtr<DataInputStream> create(const Glib::RefPtr<InputStream>& base_stream);


  /** This function sets the byte order for the given @a stream. All subsequent
   * reads from the @a stream will be read in the given @a order.
   * @param order A DataStreamByteOrder to set.
   */
  void set_byte_order(DataStreamByteOrder order);
  
  /** Gets the byte order for the data input stream.
   * @return The @a stream's current DataStreamByteOrder.
   */
  DataStreamByteOrder get_byte_order() const;
  
  /** Sets the newline type for the @a stream.
   * 
   * Note that using G_DATA_STREAM_NEWLINE_TYPE_ANY is slightly unsafe. If a read
   * chunk ends in "CR" we must read an additional byte to know if this is "CR" or
   * "CR LF", and this might block if there is no more data availible.
   * @param type The type of new line return as DataStreamNewlineType.
   */
  void set_newline_type(DataStreamNewlineType type);
  
  /** Gets the current newline type for the @a stream.
   * @return DataStreamNewlineType for the given @a stream.
   */
  DataStreamNewlineType get_newline_type() const;

  
  /** Reads an unsigned 8-bit/1-byte value from @a stream.
   * @param cancellable Optional Cancellable object, <tt>0</tt> to ignore.
   * @return An unsigned 8-bit/1-byte value read from the @a stream or %0 
   * if an error occurred.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  guchar read_byte(const Glib::RefPtr<Cancellable>& cancellable);
#else
  guchar read_byte(const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** non-cancellable version of read_byte()
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  guchar read_byte();
#else
  guchar read_byte(std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Reads a 16-bit/2-byte value from @a stream.
   * 
   * In order to get the correct byte order for this read operation, 
   * see Glib::data_stream_get_byte_order() and Glib::data_stream_set_byte_order().
   * @param cancellable Optional Cancellable object, <tt>0</tt> to ignore.
   * @return A signed 16-bit/2-byte value read from @a stream or %0 if 
   * an error occurred.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  gint16 read_int16(const Glib::RefPtr<Cancellable>& cancellable);
#else
  gint16 read_int16(const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  /** non-cancellable version of read_int16()
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  gint16 read_int16();
#else
  gint16 read_int16(std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Reads an unsigned 16-bit/2-byte value from @a stream.
   * 
   * In order to get the correct byte order for this read operation, 
   * see Glib::data_stream_get_byte_order() and Glib::data_stream_set_byte_order().
   * @param cancellable Optional Cancellable object, <tt>0</tt> to ignore.
   * @return An unsigned 16-bit/2-byte value read from the @a stream or %0 if 
   * an error occurred.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  guint16 read_uint16(const Glib::RefPtr<Cancellable>& cancellable);
#else
  guint16 read_uint16(const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


//TODO: Real documentation:
  /** non-cancellable version of read_uint16()
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  guint16 read_uint16();
#else
  guint16 read_uint16(std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Reads a signed 32-bit/4-byte value from @a stream.
   * 
   * In order to get the correct byte order for this read operation, 
   * see Glib::data_stream_get_byte_order() and Glib::data_stream_set_byte_order().
   * 
   * The operation can be cancelled by
   * triggering the cancellable object from another thread. If the operation
   * was cancelled, a Gio::Error will be thrown with CANCELLED.
   * @param cancellable Cancellable object.
   * @return A signed 32-bit/4-byte value read from the @a stream or %0 if 
   * an error occurred.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  gint32 read_int32(const Glib::RefPtr<Cancellable>& cancellable);
#else
  gint32 read_int32(const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** non-cancellable version of read_int32()
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  gint32 read_int32();
#else
  gint32 read_int32(std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Reads an unsigned 32-bit/4-byte value from @a stream.
   * 
   * In order to get the correct byte order for this read operation, 
   * see Glib::data_stream_get_byte_order() and Glib::data_stream_set_byte_order().
   * 
   * The operation can be cancelled by
   * triggering the cancellable object from another thread. If the operation
   * was cancelled, a Gio::Error will be thrown with CANCELLED.
   * @param cancellable Cancellable object.
   * @return An unsigned 32-bit/4-byte value read from the @a stream or %0 if 
   * an error occurred.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  guint32 read_uint32(const Glib::RefPtr<Cancellable>& cancellable);
#else
  guint32 read_uint32(const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  /** non-cancellable version of read_uint32()
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  guint32 read_uint32();
#else
  guint32 read_uint32(std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Reads a 64-bit/8-byte value from @a stream.
   * 
   * In order to get the correct byte order for this read operation, 
   * see Glib::data_stream_get_byte_order() and Glib::data_stream_set_byte_order().
   * 
   * The operation can be cancelled by
   * triggering the cancellable object from another thread. If the operation
   * was cancelled, a Gio::Error will be thrown with CANCELLED.
   * @param cancellable Cancellable object.
   * @return A signed 64-bit/8-byte value read from @a stream or %0 if 
   * an error occurred.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  gint64 read_int64(const Glib::RefPtr<Cancellable>& cancellable);
#else
  gint64 read_int64(const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  /** non-cancellable version of read_int64()
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  gint64 read_int64();
#else
  gint64 read_int64(std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  /** Reads an unsigned 64-bit/8-byte value from @a stream.
   * 
   * In order to get the correct byte order for this read operation, 
   * see Glib::data_stream_get_byte_order().
   * 
   * The operation can be cancelled by
   * triggering the cancellable object from another thread. If the operation
   * was cancelled, a Gio::Error will be thrown with CANCELLED.
   * @param cancellable Cancellable object.
   * @return An unsigned 64-bit/8-byte read from @a stream or %0 if 
   * an error occurred.
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  guint64 read_uint64(const Glib::RefPtr<Cancellable>& cancellable);
#else
  guint64 read_uint64(const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


  /** non-cancellable version of read_uint64()
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  guint64 read_uint64();
#else
  guint64 read_uint64(std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
  // FIXME: In C, these functions return NULL if there is an error (i.e. end of
  // stream reached), but if we use std::string, we don't have a way to tell an
  // empty string from NULL.  Perhaps we should use raw pointers as in C, but
  // that would mean we need to worry about freeing the C string...
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool read_line(std::string& line, const Glib::RefPtr<Cancellable>& cancellable);
#else
  bool read_line(std::string& line, const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  /** non-cancellable version of read_line()
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool read_line(std::string& line);
#else
  bool read_line(std::string& line, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool read_until(std::string& data, const std::string& stop_chars, const Glib::RefPtr<Cancellable>& cancellable);
#else
  bool read_until(std::string& data, const std::string& stop_chars, const Glib::RefPtr<Cancellable>& cancellable, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED

  /** non-cancellable version of read_until()
   */
#ifdef GLIBMM_EXCEPTIONS_ENABLED
  bool read_until(std::string& data, const std::string& stop_chars);
#else
  bool read_until(std::string& data, const std::string& stop_chars, std::auto_ptr<Glib::Error>& error);
#endif //GLIBMM_EXCEPTIONS_ENABLED


public:

public:
  //C++ methods used to invoke GTK+ virtual functions:
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

protected:
  //GTK+ Virtual Functions (override these to change behaviour):
#ifdef GLIBMM_VFUNCS_ENABLED
#endif //GLIBMM_VFUNCS_ENABLED

  //Default Signal Handlers::
#ifdef GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED
#endif //GLIBMM_DEFAULT_SIGNAL_HANDLERS_ENABLED


};

} // namespace Gio


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gio::DataInputStream
   */
  Glib::RefPtr<Gio::DataInputStream> wrap(GDataInputStream* object, bool take_copy = false);
}


#endif /* _GIOMM_DATAINPUTSTREAM_H */

