// GENPO - the GENeral Purpose Organ
// Copyright (C) 2003,2004 - Steve Merrony 

/* This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef APPLICATION_H
#define APPLICATION_H

#include "console.h"
#include "passingButton.h"
#include "passingCheckBox.h"

#include <alsa/asoundlib.h>

#include <qbuttongroup.h>
#include <qcheckbox.h>
#include <qcombobox.h>
#include <qgroupbox.h>
#include <qlabel.h>
#include <qlayout.h>
#include <qmainwindow.h>
#include <qpushbutton.h>

#define APP_NAME "GENPO - The General Purpose Organ"
#define APP_VERSION "0.9.6"

class QTextEdit;

class ApplicationWindow: public QMainWindow
{
  Q_OBJECT

public:
  ApplicationWindow( volatile Console * );
  ~ApplicationWindow();
  
  Console *console;

  public slots:
    void changeStop( int );
    void pistonChanged( void * );
    void couplerChanged( void * );
    void toePistonChanged( void * );
    void generalCancel();


protected:
  void closeEvent( QCloseEvent* );

private slots:
  void choose();
  void load( const QString &fileName );
  void reload();
  void midiPanic();
  void about();
  void pullStop( int, int );
  void pushStop( int, int );
  void silenceMidiChannel( int );
  void dumpVoices();
  void customEvent( QCustomEvent* );
  void changePiston( int, int );
  void changeToePiston( int );
 
private:
    QString      filename;
    QWidget      *central;
    QLabel       *desc;
    QGridLayout  *grid;
    QHBoxLayout  *mcBox[MAX_DIVISIONS];
    //QVBoxLayout  *pvbox[MAX_DIVISIONS];
    QGridLayout  *pvbox[MAX_DIVISIONS];
    QVBoxLayout  *cvbox[MAX_DIVISIONS];
    QLabel       *divisionLabels[MAX_DIVISIONS];
    QButtonGroup *stopGroup;
    QPushButton  *stopButtons[MAX_DIVISIONS][MAX_STOPS];
    PassingButton  *pistonButtons[MAX_DIVISIONS][MAX_PISTONS];
    PassingCheckBox *couplerCheckBoxes[MAX_DIVISIONS][MAX_COUPLERS];
    QGroupBox    *pgrp[MAX_DIVISIONS]; 
    QButtonGroup *cgrp[MAX_DIVISIONS]; 
    QGroupBox     *tpgrp;
    QHBoxLayout   *tphbox;
    PassingButton *toePistonButtons[MAX_TOE_PISTONS];
    QPushButton  *gcButton;

    volatile midi_seq  *seq;
    volatile midi_port *op_a, *op_b;

    typedef struct {
      int manual, coupler;
    } couple_t;

    couple_t couples[MAX_DIVISIONS * MAX_COUPLERS];

    typedef struct {
      int manual, piston;
    } piston_t;

    piston_t pistons[MAX_DIVISIONS * MAX_PISTONS];
    
    ToePiston toePistons[MAX_TOE_PISTONS];
};


#endif
