
//*@@@+++@@@@******************************************************************
//
// Microsoft Windows Media
// Copyright (C) Microsoft Corporation. All rights reserved.
//
//*@@@---@@@@******************************************************************
/*
 ***********************************************************************
 * Copyright 2005-2010 by Freescale Semiconductor, Inc.
 * All modifications are confidential and proprietary information
 * of Freescale Semiconductor, Inc.
 ***********************************************************************
 */
#ifdef UNDER_CE
#include <windows.h>
#endif

#include <stdio.h>
#include <math.h>
#include <assert.h>

#include "wavfileio.h"
//#include "msaudioenc.h"
#include "wma8_enc_interface.h"
#include "rawio.h"
#include "asf.h"
#include "tchar.h"
#include <ctype.h>

#include <time.h>

#ifdef TIME_PROFILE
#include <sys/time.h>
#endif


#define ALIGN			   	4
#define STRING_SIZE 512		//Really long name also will be taken care of
#define MAX_METADATA_CHARS 255 // Max length of Metadata in chars

//#ifdef ADD_ASF
  //unsigned int nSize,nSR;
//#endif
#define TRUE 1
#define FALSE 0

// global vars
RawFileIO *pRawOutput = NULL;		// file ptr to our output Raw file
//unsigned char *pbAudioBuffer = NULL;		// ptr to our audio buffer
/***************************************************************************
 *
 *   FUNCTION NAME - alloc_align
 *
 *   DESCRIPTION
 *          This function simulates to allocate memory in the internal
 *          memory. This function when used by the application should
 *          ensure that the memory address returned in always aligned
 *          to long boundry.
 *
 *   ARGUMENTS
 *       size              - Size of the memory requested.
 *
 *   RETURN VALUE
 *       base address of the memory chunck allocated.
 *
 ***************************************************************************/
#ifdef TEST_PERFORMANCE
//For input buffer
typedef struct
{
	int file_size;
	int bytes_read;
	char *buff;
	char *buff_head;
}struct_input_data;
#endif
void* alloc_align (int size)
{
    int mask = -1;                                    //Initally set mask to 0xFFFFFFFF
    void *retBuffer;
    void*buffer = (void *)malloc(size+ALIGN);
	 mask <<= 2;//LOG2(ALIGN);                     //Generate mask to clear lsb's
    retBuffer = (void*)(((int)((U8*)buffer+ALIGN))&mask);//Generate aligned pointer
    ((U8*)retBuffer)[-1] = (U8)((U8*)retBuffer-(U8*)buffer);//Write offset to newPtr-1
    return retBuffer;
}

void free_Aligned(void *ptr){
    U8* realBuffer = (U8*)ptr;
    U8 bytesBack;
    if (realBuffer == NULL) return;
    bytesBack = ((U8*)ptr)[-1];      //Get offset to real pointer from -1 possition
    realBuffer -= bytesBack;    //Get original pointer address
    free(realBuffer);
}

void CopyCharToWChar(word *dst, TCHAR *src, int length)
{
    while (length--) *dst++ = (word) *src++;
}

int IsNumeric(TCHAR *str)
{
    while (*str && _istdigit(*str)) str++;
    return (!*str);
}

int ProcessCommandLine(WMAEEncoderParams *pEncParams,ASFParams *psASFParams, int argc, TCHAR *argv[])
{
  int	iIndex = 0;

  Bool bValidEncodeData = TRUE;

  // make sure we have something to work with
  if((NULL == pEncParams) || (NULL == argv) || (0 > argc)) return FALSE;

  //let's assume we have a valid encode

    // loop through our command line arguments and set things up

    for( iIndex=1; iIndex < argc && bValidEncodeData; iIndex++ )
    {
        // input file
        if(0 == _tcscmp(_T("-i"),argv[iIndex]))
	    {
	        iIndex++;
            if( iIndex < argc )
	            _tcscpy(pEncParams->App_szInputFileName,argv[iIndex]);
            else
            {
                printf("(-i) -i requires an argument.\n" );
                bValidEncodeData = FALSE;
            }
	        continue;
	    }
        // output file
        if(0 == _tcscmp(_T("-o"),argv[iIndex]))
	    {
	        iIndex++;
	        if( iIndex < argc )
            {
                int iLen;
                _tcscpy(pEncParams->App_szOutputFileName, argv[iIndex]);
                iLen = _tcslen(pEncParams->App_szOutputFileName);
                if (iLen == _tcscspn(argv[iIndex], _T("."))  &&
                    iLen < STRING_SIZE-4)
                {
                    _tcscat(pEncParams->App_szOutputFileName, _T(".wma"));
                }
            }
            else
            {
                printf("(-o) -o requires an argument.\n" );
                bValidEncodeData = FALSE;
            }
	        continue;
	    }
        // standard profile
        if(0 == _tcscmp(_T("-p"),argv[iIndex]))
	    {
            printf("(-p) profiles are not supported.\n" );
            bValidEncodeData = FALSE;
        /*
	  // first, retrieve the profile the user wants to encode to
	  iIndex++;
	  pEncodeData->iStandardProfile = _ttoi(argv[iIndex]);

	  // make sure it's a valid audio only profile
	  if((14 > pEncodeData->iStandardProfile) && (20 < pEncodeData->iStandardProfile))
	    {
	      // something went wrong here, we are going to fail
	      pEncodeData->App_bValidEncodeData = FALSE;
	    } else
	      {
		// when this flag is set, we ignore any of the custom settings provided
		pEncodeData->bCustomProfile		= FALSE;

	      }
	  continue;
      */
	    }
        if( 0 == _tcscmp(_T("-s"), argv[iIndex] ))
        {
            iIndex++; // -s usually takes an arg
            printf("warning: -s option ignored - there is no resampler.\n" );
            continue;
        }
        if( 0 == _tcscmp(_T("-c"), argv[iIndex] ))
        {
            iIndex++; // -c usually takes an arg
            printf("warning: -c option ignored - there is no resampler.\n" );
            continue;
        }

        // output bit rate
        if(0 == _tcscmp(_T("-a"),argv[iIndex]))
	    {
	        // we'll actually store this in the cbSize member
	        iIndex++;
            if( iIndex < argc )
            {
    	        if (IsNumeric( argv[iIndex] ))
                {
                    pEncParams->App_iDstAudioBitRate	= _ttoi(argv[iIndex]);
//    	            pEncParams->bCustomProfile	= TRUE;
                }
                else
                {
                    printf("(-a) -a requires a numeric argument.\n" );
                    bValidEncodeData = FALSE;
                }
            }
            else
            {
                printf("(-a) -a requires an argument.\n" );
                bValidEncodeData = FALSE;
            }
	        continue;
	    }

        // content title
        if(0 == _tcscmp(_T("-title"),argv[iIndex]))
	    {
	        iIndex++;
            if( iIndex < argc )
            {
                psASFParams->g_cTitle = _tcslen( argv[iIndex] ) + 1; // +1 for NULL
                if ( psASFParams->g_cTitle <= MAX_METADATA_CHARS + 1)
                {
                    if (psASFParams->g_wszTitle) free_Aligned( psASFParams->g_wszTitle );
                    psASFParams->g_wszTitle = (word *)alloc_align( psASFParams->g_cTitle * sizeof(word) );
                    if (psASFParams->g_wszTitle)
                    {
                        CopyCharToWChar(psASFParams->g_wszTitle, argv[iIndex], psASFParams->g_cTitle);
                    }
                    else
                    {
                        printf("Could not allocate memory for [Title].\n" );
                        psASFParams->g_cTitle = 0;
                        bValidEncodeData = FALSE;
                    }
                }
                else
                {
                    printf("(-title) -title argument too long.\n" );
                    bValidEncodeData = FALSE;
                }
            }
            else
            {
                printf("(-title) -title requires an argument.\n" );
                bValidEncodeData = FALSE;
            }
	        continue;
	    }

        // content author
        if(0 == _tcscmp(_T("-author"),argv[iIndex]))
	    {
	        iIndex++;
            if( iIndex < argc )
            {
                psASFParams->g_cAuthor = _tcslen( argv[iIndex] ) + 1; // +1 for NULL
                if ( psASFParams->g_cAuthor <= MAX_METADATA_CHARS + 1)
                {
                    if (psASFParams->g_wszAuthor) free_Aligned( psASFParams->g_wszAuthor );
                    psASFParams->g_wszAuthor = (word*)alloc_align( psASFParams->g_cAuthor * sizeof(word) );
                    if (psASFParams->g_wszAuthor)
                    {
                        CopyCharToWChar(psASFParams->g_wszAuthor, argv[iIndex], psASFParams->g_cAuthor);
                    }
                    else
                    {
                        printf("Could not allocate memory for [Author].\n" );
                        psASFParams->g_cAuthor = 0;
                        bValidEncodeData = FALSE;
                    }
                }
                else
                {
                    printf("(-author) -author argument too long.\n" );
                    bValidEncodeData = FALSE;
                }
            }
            else
            {
                printf("(-author) -author requires an argument.\n" );
                bValidEncodeData = FALSE;
            }
	        continue;
	    }

        // content copyright
        if(0 == _tcscmp(_T("-cr"),argv[iIndex]))
	    {
	        iIndex++;
            if( iIndex < argc )
            {
                psASFParams->g_cCopyright = _tcslen( argv[iIndex] ) + 1; // +1 for NULL
                if (psASFParams->g_cCopyright <= MAX_METADATA_CHARS + 1)
                {
                    if (psASFParams->g_wszCopyright) free_Aligned ( psASFParams->g_wszCopyright );
                    psASFParams->g_wszCopyright = (word*)alloc_align( psASFParams->g_cCopyright * sizeof(word) );
                    if (psASFParams->g_wszCopyright)
                    {
                        CopyCharToWChar(psASFParams->g_wszCopyright, argv[iIndex], psASFParams->g_cCopyright);
                    }
                    else
                    {
                        printf("Could not allocate memory for [Copyright].\n" );
                        psASFParams->g_cCopyright = 0;
                        bValidEncodeData = FALSE;
                    }
                }
                else
                {
                    printf("(-cr) -cr argument too long.\n" );
                    bValidEncodeData = FALSE;
                }
            }
            else
            {
                printf("(-cr) -cr requires an argument.\n" );
                bValidEncodeData = FALSE;
            }
	        continue;
	    }

        // content description
        if(0 == _tcscmp(_T("-desc"),argv[iIndex]))
	    {
	        iIndex++;
            if( iIndex < argc )
            {
                psASFParams->g_cDescription = _tcslen( argv[iIndex] ) + 1; // +1 for NULL
                if (psASFParams->g_cDescription <= MAX_METADATA_CHARS + 1)
                {
                    if (psASFParams->g_wszDescription) free_Aligned ( psASFParams->g_wszDescription );
                    psASFParams->g_wszDescription = (word*)alloc_align( psASFParams->g_cDescription * sizeof(word) );
                    if (psASFParams->g_wszDescription)
                    {
                        CopyCharToWChar(psASFParams->g_wszDescription, argv[iIndex], psASFParams->g_cDescription);
                    }
                    else
                    {
                        printf("Could not allocate memory for [Description].\n" );
                        psASFParams->g_cDescription = 0;
                        bValidEncodeData = FALSE;
                    }
                }
                else
                {
                    printf("(-desc) -desc argument too long.\n" );
                    bValidEncodeData = FALSE;
                }
            }
            else
            {
                printf("(-desc) -desc requires an argument.\n" );
                bValidEncodeData = FALSE;
            }
	        continue;
	    }

        // content rating
        if(0 == _tcscmp(_T("-rating"),argv[iIndex]))
	    {
	        iIndex++;
            if( iIndex < argc )
            {
                psASFParams->g_cRating = _tcslen( argv[iIndex] ) + 1; // +1 for NULL
                if (psASFParams->g_cRating <= MAX_METADATA_CHARS + 1)
                {
                    if (psASFParams->g_wszRating) free_Aligned ( psASFParams->g_wszRating );
                    psASFParams->g_wszRating = (word*)alloc_align( psASFParams->g_cRating * sizeof(word) );
                    if (psASFParams->g_wszRating)
                    {
                        CopyCharToWChar(psASFParams->g_wszRating, argv[iIndex], psASFParams->g_cRating);
                    }
                    else
                    {
                        printf("Could not allocate memory for [Rating].\n" );
                        psASFParams->g_cRating = 0;
                        bValidEncodeData = FALSE;
                    }
                }
                else
                {
                    printf("(-rating) -rating argument too long.\n" );
                    bValidEncodeData = FALSE;
                }
            }
            else
            {
                printf("(-rating) -rating requires an argument.\n" );
                bValidEncodeData = FALSE;
            }
	        continue;
	    }

        // If we have reached here, we have an unrecognized input parameter
        printf("(%s) Unrecognized parameter.\n", argv[iIndex] );
        bValidEncodeData = FALSE;
    }

    // no file's provided
    if((0 == _tcslen(pEncParams->App_szInputFileName )) ||
       (0 == _tcslen(pEncParams->App_szOutputFileName)))
    {
      // without an input/outputfile we are broken
      bValidEncodeData = FALSE;

    }

  // return whatever we have come up with
  return bValidEncodeData;

}

int PushRawData(unsigned char *pRawDataBuffer, unsigned int nRawDataLen)
{
  int nSampleWrote;
  rfioSeek(pRawOutput,pRawOutput->m_sizeData , 0);
  nSampleWrote = rfioWrite(pRawOutput,pRawDataBuffer,nRawDataLen);
  return nSampleWrote;
}

int GetAudioData(WavFileIO *App_pAudioInput, unsigned char *pbAudioDataBuffer, const long long iByteOffset,
             const int iNumBytesWanted, const char iSize )
{
  wfioSeek( App_pAudioInput, (int)iByteOffset, 0 );
  return wfioRead( App_pAudioInput, pbAudioDataBuffer,
                   iNumBytesWanted, iSize );
}
#ifdef TEST_PERFORMANCE
int GetAudioData_New(struct_input_data *input_data, unsigned char *pbAudioDataBuffer, const long long iByteOffset,
             const int iNumBytesWanted, const char iSize )
{
  input_data->buff = input_data->buff_head + (int)iByteOffset;
  memcpy(pbAudioDataBuffer,input_data->buff,sizeof(char)*iNumBytesWanted);
  return iNumBytesWanted;
}
#endif

void FreeContentDescriptionFields()
{
  /*
  if(g_wszTitle)
    free (g_wszTitle);
  if(g_wszAuthor)
    free (g_wszAuthor);
  if(g_wszCopyright)
    free (g_wszCopyright);
  if(g_wszDescription)
    free (g_wszDescription);
  if(g_wszRating)
    free (g_wszRating);
  */
}

void UsageBanner()
{
  // show how to use this sample
  fprintf(stderr,"\nUsage:\n\n");
  fprintf(stderr,"-i filename\t\tThe file to convert.  Required.\n");
  fprintf(stderr,"-o filename\t\tThe name of the base output WMA file. Required.\n");
  //fprintf(stderr,"[-p #]\tOne of the following profiles to be encoded.\n\n");

  //fprintf(stderr,"\t14:\t\tProfile_AudioOnly_FMRadioMono_28K\n");
  //fprintf(stderr,"\t15:\t\tProfile_AudioOnly_FMRadioStereo_28K\n");
  //fprintf(stderr,"\t16:\t\tProfile_AudioOnly_Modem_56K\n");
  //fprintf(stderr,"\t17:\t\tProfile_AudioOnly_NearCDQuality_48K\n");
  //fprintf(stderr,"\t18:\t\tProfile_AudioOnly_CDQuality_64K\n");
  //fprintf(stderr,"\t19:\t\tProfile_AudioOnly_CDAudiophileQuality_96K\n");
  //fprintf(stderr,"\t20:\t\tProfile_AudioOnly_CDAudiophileQuality_128K\n\n");
  //
  //fprintf(stderr,"\t\t\tAll other arguments are ignored if a profile is given.\n\n");
  //
  fprintf(stderr,"[-a #]\t\t\tAudio bit rate (in bits) to be encoded.\n");
  //fprintf(stderr,"[-s #]\t\t\tAudio sampling rate to be encoded.\n");
  //fprintf(stderr,"[-c #]\t\t\tNumber of audio channels to be encoded, 1 or 2.\n\n");
  //fprintf(stderr,"If no standard or customer profile information is provided, encoder will default to the CDQuality_64k standard profile.\n\n");
  // terminate this process, we are done here
  fprintf(stderr,"[-title <title>]\tContent title.\n");
  fprintf(stderr,"[-author <author>]\tContent author.\n");
  fprintf(stderr,"[-desc <description>]\tContent description.\n");
  fprintf(stderr,"[-cr <copyright>]\tContent copyright.\n");
  fprintf(stderr,"[-rating <rating>]\tContent rating.\n");
  fprintf(stderr,"\t\tNOTE: maximum length of each metadata field is 255.\n");
}



long long cbCurr;
long long cbLeft;

int InsertNewSamples(WavFileIO *App_pAudioInput, unsigned char* pInputCurr, const int nDataWanted )
{
    const char  iSize   = 1;
    const int cbSrc   = (int)( nDataWanted < cbLeft ?
                               nDataWanted : cbLeft );
    int cbReturnedLen = 0;

    if( 0 < cbSrc )
    {
        cbReturnedLen = GetAudioData( App_pAudioInput, pInputCurr, cbCurr, cbSrc, iSize ) * iSize;
        if( 0 > cbReturnedLen )
        {
            // this indicates that getAudioData failed.
            assert( !"GetAudioData() failed." );
            return FALSE;
        }
    }

    if( cbReturnedLen < nDataWanted )
    {
        memset( pInputCurr + cbReturnedLen,
            0, nDataWanted - cbReturnedLen );
    }

    cbCurr += nDataWanted;
    cbLeft -= nDataWanted;

    // return true if no data remains, otherwise false.

    return ( cbSrc <= 0 );
}

#ifdef TEST_PERFORMANCE
int InsertNewSamples_New(struct_input_data *input_data, unsigned char* pInputCurr, const int nDataWanted )
{
    const char  iSize   = 1;
    const int cbSrc   = (int)( nDataWanted < cbLeft ?
                               nDataWanted : cbLeft );
    int cbReturnedLen = 0;

    if( 0 < cbSrc )
    {
        cbReturnedLen = GetAudioData_New( input_data, pInputCurr, cbCurr, cbSrc, iSize ) * iSize;
        if( 0 > cbReturnedLen )
        {
            // this indicates that getAudioData failed.
            assert( !"GetAudioData() failed." );
            return FALSE;
        }
    }

    if( cbReturnedLen < nDataWanted )
    {
        memset( pInputCurr + cbReturnedLen,
            0, nDataWanted - cbReturnedLen );
    }

    cbCurr += nDataWanted;
    cbLeft -= nDataWanted;

    // return true if no data remains, otherwise false.

    return ( cbSrc <= 0 );
}
#endif
void SetAsfParams(ASFParams *pAsfParams, WMAEEncoderParams sWMAEncParams)
{
  pAsfParams->WMAE_packet_byte_length = sWMAEncParams.WMAE_packet_byte_length;

  pAsfParams->pFormat.nAudioDelaySizeMs = sWMAEncParams.pFormat.nAudioDelaySizeMs;
  pAsfParams->pFormat.nSamplesPerSec = sWMAEncParams.pFormat.nSamplesPerSec;
  pAsfParams->pFormat.nAvgBytesPerSec = sWMAEncParams.pFormat.nAvgBytesPerSec;
  pAsfParams->pFormat.nChannels = sWMAEncParams.pFormat.nChannels;
  pAsfParams->pFormat.nSamplesPerSec = sWMAEncParams.pFormat.nSamplesPerSec;
  pAsfParams->pFormat.nAvgBytesPerSec = sWMAEncParams.pFormat.nAvgBytesPerSec;
  pAsfParams->pFormat.nSamplesPerFrame = sWMAEncParams.pFormat.nSamplesPerFrame;
  pAsfParams->pFormat.wEncodeOptions = sWMAEncParams.pFormat.wEncodeOptions;

}

clock_t start, finish;

#ifdef BUFEMPT_DUMP
FILE *fp_buf;  //buffer emptyness dump
#endif

#ifdef DEBUG_DUMP
FILE *fBitstream;
FILE *fAsf;
FILE *fStepSize;
#endif
#ifdef UNICODE
int __cdecl wmain(int argc, LPCTSTR argv[])
#elif UNDER_CE
int MSVC_CDECL main(int argc, LPCTSTR argv[])
#else
int  main(int argc, char * argv[])
#endif
{
  //CAudioObjectEncoder *pauenc = NULL;
  WMAEEncoderConfig *psEncConfig=NULL;
  WMAEEncoderParams sEncParams;
  WavFileIO *App_pAudioInput = NULL;		// file ptr to our input WAV file
  tWMAEncodeStatus iStatus;
  WMAEMemAllocInfoSub *mem;
  WMAE_INT32 i, j;
  WMAE_INT32 nr=0;
//  WMAFormatInfo Format = {0};
  int m_bNoMoreData= FALSE;
  int duration = 0;
  int FrameNum = 0 ;

  ASFParams *psASFParams = NULL;
#ifdef ADD_ASF
  ASFRESULTS rcAsf = cASF_NoErr;
#endif
  short * wavInBuf = NULL;
  char * wmaOutBuf = NULL;
  char * asfOutBuf = NULL;

#ifdef MEASURE_HEAP_USAGE
  int s32TotalMallocBytes = 0;
#endif

  TCHAR App_szInputFileName[STRING_SIZE];	// input file name
  TCHAR App_szOutputFileName[STRING_SIZE];	// output file name

#ifdef CCM_MHZ_MEASURE
  int prev_clk, curr_clk, tot_clk=0, max_frm, max_clk,  clk, max_sf, tot_sample;
  double curr_mhz, den, tot_mhz=0.0;
  FILE *fp_mhz;
  int sample_rate;
  int nLookAheadFrames;
#endif
#ifdef TIME_PROFILE
    struct timeval StartTime, EndTime;
    unsigned long TotalEncTimeUs = 0,MinTime = 0,MaxTime = 0,Minframe = 0,Maxframe = 0,CurEncTimeUs = 0 ,total_samples=0,MaxTime_samples=0;
    int nframe = 0;
    unsigned char chname[] = "[PROFILE-INFO]";
    FILE *fp_perf;
    int nLookAheadFrames;
#endif
#ifdef TEST_PERFORMANCE
	struct_input_data *input_data;
#endif
#ifdef UNDER_CE         // for taking timing on wince platform
	BOOL Flag;
	LARGE_INTEGER lpFrequency ;
	LARGE_INTEGER lpPerformanceCountBegin;
	LARGE_INTEGER lpPerformanceCountEnd;
	__int64 TotalDecTime=0;
	__int64 Temp;
	FILE *fp_performance;
	__int64 total_samples = 0;
	 int nLookAheadFrames = 0;
	 int nframe = 0;
#endif
#if 0
  start = clock();
#endif
//  sturctSizeInfo();

  fprintf(stdout,"\nWMA Encoder sample application.\n");

  // Output the WMA8 Encoder Version Info
  printf("%s \n", WMA8ECodecVersionInfo());

#ifdef DEBUG_DUMP
    fBitstream = fopen("bitstream.dat", "wt");
    fAsf = fopen("asf.dat", "wt");
    fStepSize = fopen("fStepSize.dat", "wt");
#endif
  // initialize our encode data struct
  memset((void *)&sEncParams,0,sizeof(WMAEEncoderParams));

  sEncParams.App_szInputFileName = (TCHAR *)App_szInputFileName;
  sEncParams.App_szOutputFileName = (TCHAR *)App_szOutputFileName;

  psASFParams = (ASFParams *)alloc_align(sizeof(ASFParams));
  if(psASFParams == NULL)
  {
    fprintf(stderr,"Out of Memory!\n");
    goto Cleanup;;
  }
  memset(psASFParams,0,sizeof(ASFParams));

  // process the command line
  if(FALSE == ProcessCommandLine(&sEncParams,psASFParams,argc,argv))
  {
    UsageBanner();
    FreeContentDescriptionFields();
    exit(1);
  }

  // at this point we believe we have enough information for an encode...start with the input file
  App_pAudioInput = wfioNew();

  if(NULL == App_pAudioInput)
    {
      fprintf(stderr,"! Cannot create WAV read/write object.\r\n");
      iStatus = (tWMAEncodeStatus) -1;
      goto Cleanup;
    }

  iStatus = wfioOpen(App_pAudioInput,sEncParams.App_szInputFileName,NULL,0,wfioModeRead);

  if(0 != iStatus)
    {
      fprintf(stderr,"! Unable to open the requested input file.\r\n");
      iStatus = (tWMAEncodeStatus) -1;
      goto Cleanup;
    }

  pRawOutput = rfioNew();

  if(NULL == pRawOutput)
    {
      fprintf(stderr,"! Cannot create Raw write object.\r\n");
      iStatus = (tWMAEncodeStatus) -1;
      goto Cleanup;
    }

//  iStatus = rfioOpen(pRawOutput,"port.wma",rfioModeWrite);

  iStatus = rfioOpen(pRawOutput,sEncParams.App_szOutputFileName,rfioModeWrite);

  if(0 != iStatus)
    {
      fprintf(stderr,"! Unable to open the requested output file.\r\n");
      iStatus = (tWMAEncodeStatus) -1;
      goto Cleanup;
    }

  // retrieve our source audio information
  sEncParams.App_pAudioInput = wfioGetFormat(App_pAudioInput);

  if(NULL == sEncParams.App_pAudioInput)
    {
      fprintf(stderr,"! Unable to read WAV header information from requested input file.\r\n");
      iStatus = (tWMAEncodeStatus) -1;
      goto Cleanup;
    }

    // only 22, 32, 44kHz are currently supported. other sampling
    // frequencies require new excitation / masking tables. see
    // contents of exct_tbl_*.h, which can be generated from
    // floating-point code.

    if( 48000 != sEncParams.App_pAudioInput->nSamplesPerSec &&
        44100 != sEncParams.App_pAudioInput->nSamplesPerSec &&
        32000 != sEncParams.App_pAudioInput->nSamplesPerSec &&
        22050 != sEncParams.App_pAudioInput->nSamplesPerSec )
    {
        fprintf( stdout, " Only 48, 44.1, 32, and 22kHz sampling rates are supported.\n" );
        goto Cleanup;
    }

  if( 0 == sEncParams.App_iDstAudioBitRate ) sEncParams.App_iDstAudioBitRate = 70000;

  // destination sample rate / # channels / duration are the same as the source.
  sEncParams.App_iDstAudioSampleRate = sEncParams.App_pAudioInput->nSamplesPerSec;
  sEncParams.App_iDstAudioChannels   = sEncParams.App_pAudioInput->nChannels;
  sEncParams.App_iAudioSrcLength     = wfioGetDataLength(App_pAudioInput);

  duration = (unsigned int)(( (unsigned long long)sEncParams.App_iAudioSrcLength * 1000 ) /
             ( sEncParams.App_pAudioInput->nSamplesPerSec
             * sEncParams.App_pAudioInput->nBlockAlign ));

  fprintf(stdout,"\r\nSource Audio Configuration\r\n\r\n");
  fprintf(stdout,"- Bit Rate        : %d kbps\r\n",( ( sEncParams.App_pAudioInput->nAvgBytesPerSec + 62 ) / 125 ));
  fprintf(stdout,"- Sampling Rate   : %2.1f kHz\r\n",(float)sEncParams.App_pAudioInput->nSamplesPerSec / 1000 );
  fprintf(stdout,"- Channels        : %d\r\n",sEncParams.App_pAudioInput->nChannels );
  fprintf(stdout,"- Duration        : %d ms\r\n\r\n",duration );

  psEncConfig = (WMAEEncoderConfig *)alloc_align(sizeof(WMAEEncoderConfig));
  if(psEncConfig == NULL)
  {
    fprintf(stderr,"Out of Memory!\n");
    goto Cleanup;
  }

  psEncConfig->psEncodeParams = &sEncParams;

  if((iStatus = eWMAEQueryMem(psEncConfig))!= WMA_Succeeded)
  {
    fprintf(stderr,"Query Memory Failed!\n");
    goto Cleanup;
  }

  /* Number of memory chunk requests by the decoder */
  nr = psEncConfig->sWMAEMemInfo.s32NumReqs;
  for(i = 0; i < nr; i++)
  {
      mem = &(psEncConfig->sWMAEMemInfo.sMemInfoSub[i]);

      if (mem->s32WMAEType == WMAE_FAST_MEMORY)
      {
          mem->app_base_ptr = alloc_align (mem->s32WMAESize);

#ifdef MEASURE_HEAP_USAGE
          s32TotalMallocBytes +=  mem->s32WMAESize;
#endif
          if (mem->app_base_ptr == NULL)
              goto Cleanup;
      }
      else
      {
          mem->app_base_ptr = alloc_align (mem->s32WMAESize);

#ifdef MEASURE_HEAP_USAGE
          s32TotalMallocBytes +=  mem->s32WMAESize;
#endif
          if (mem->app_base_ptr == NULL)
              goto Cleanup;
      }
  }

  iStatus = eInitWMAEncoder( psEncConfig );

  if(iStatus != WMA_Succeeded)
  {
    fprintf(stderr, "** Init WMA Encoder Failed!\n");
    goto Cleanup;
  }

#ifdef TIME_PROFILE
        fp_perf=fopen("test_result.xls","a+");
        nLookAheadFrames = sEncParams.pFormat.nLookaheadSamples/ sEncParams.pFormat.nSamplesPerFrame;
#endif
#ifdef CCM_MHZ_MEASURE
        nLookAheadFrames = sEncParams.pFormat.nLookaheadSamples/ sEncParams.pFormat.nSamplesPerFrame;
#endif

  sEncParams.App_iDstAudioBitRate    = sEncParams.pFormat.nAvgBytesPerSec * 8;
  sEncParams.App_iDstAudioSampleRate = sEncParams.pFormat.nSamplesPerSec;
  sEncParams.App_iDstAudioChannels   = sEncParams.pFormat.nChannels;

  fprintf(stdout,"\r\nDestination Audio Configuration\r\n\r\n");
  fprintf(stdout,"- Bit Rate        : %d kbps\r\n", ( sEncParams.App_iDstAudioBitRate + 500 )/ 1000 );
  fprintf(stdout,"- Sampling Rate   : %2.1f kHz\r\n",(float)sEncParams.App_iDstAudioSampleRate / 1000 );
  fprintf(stdout,"- Channels        : %d\r\n",sEncParams.App_iDstAudioChannels );
  fprintf(stdout,"- Duration        : %d ms\r\n\r\n",duration );



  wavInBuf = (short *)alloc_align(sizeof(short)*sEncParams.pFormat.nSamplesPerFrame*sEncParams.pFormat.nChannels);
  if(wavInBuf == NULL)
  {
    fprintf(stderr,"Out of Memory!\n");
    goto Cleanup;
  }
#ifdef ADD_ASF
  SetAsfParams(psASFParams,sEncParams);
  rcAsf = add_asf_file_header (psASFParams);
  if(rcAsf != cASF_NoErr)
  {
    fprintf(stderr,"Add Asf file header failed.\n");
    goto Cleanup;
  }
  asfOutBuf = (char *)alloc_align(sizeof(char)*psASFParams->g_asf_packet_size);
  if(asfOutBuf == NULL)
  {
    fprintf(stderr,"Out of Memory!\n");
    goto Cleanup;
  }
#endif
  wmaOutBuf = (char *)alloc_align(sizeof(char)*sEncParams.WMAE_packet_byte_length);
  if(wmaOutBuf == NULL)
  {
    fprintf(stderr,"Out of Memory!\n");
    goto Cleanup;
  }


#ifdef  BUFEMPT_DUMP
  fp_buf=fopen("bufempt.log","w");
#endif

#ifdef CCM_MHZ_MEASURE
  {
      TCHAR file_name[100] = {0};
      TCHAR tmp[100] = {0};
      TCHAR dot = '.';
      int j = 0;

      strcpy(tmp, sEncParams.App_szOutputFileName);
      while (tmp[j] != '\0')
      {
          if (tmp[j] == dot)
          {
              file_name[j] = '\0';
              strcat (file_name, _T("_mhz"));
              break;
          }
          file_name[j] = tmp[j];
          j++;
      }

      fp_mhz = _tfopen(file_name, _T("wt") );
      max_clk = 0; max_frm = 0;
  }
#endif

  // all set to encode our content
  fprintf(stdout,"* Encoding content, this may take awhile...\r\n");

  cbCurr=0;
  cbLeft = (long long) sEncParams.App_iAudioSrcLength;
#ifdef CCM_MHZ_MEASURE
    tot_sample = sEncParams.App_iAudioSrcLength/(sizeof(short) * sEncParams.pFormat.nChannels);
#endif
#ifdef TEST_PERFORMANCE
    input_data = (struct_input_data *)alloc_align(sizeof(struct_input_data));
    if(input_data == NULL)
    {
        printf("Error Allocating memory for input file struct \n");
        return;
    }

    input_data->file_size = 0;
    input_data->bytes_read = 0;
    input_data->file_size = sEncParams.App_iAudioSrcLength;

    input_data->buff = (char *)alloc_align(sizeof(char)*input_data->file_size);
    if(input_data->buff == NULL)
    {
        printf("Error Allocating memory for input buffer \n");
        exit(1);
    }

    input_data->buff_head = input_data->buff;
    wfioSeek( App_pAudioInput, 0, 0 );
    wfioRead( App_pAudioInput, input_data->buff,
                   input_data->file_size, sizeof(char) );

    wfioClose(App_pAudioInput);
#endif
 #ifdef UNDER_CE
		nLookAheadFrames = sEncParams.pFormat.nLookaheadSamples/ sEncParams.pFormat.nSamplesPerFrame;
		fp_performance = fopen("test_performance_result.xls","a+");
#endif
    while( iStatus != WMA_NoMoreFrames )
    {

        #ifdef TEST_PERFORMANCE
        m_bNoMoreData = InsertNewSamples_New( input_data, (unsigned char*)wavInBuf,
                sizeof(short) * sEncParams.pFormat.nSamplesPerFrame*sEncParams.pFormat.nChannels );
        #else
        m_bNoMoreData = InsertNewSamples( App_pAudioInput, (unsigned char*)wavInBuf,
                sizeof(short) * sEncParams.pFormat.nSamplesPerFrame*sEncParams.pFormat.nChannels );
        #endif
#ifdef CCM_MHZ_MEASURE
        __asm
        {
            mrc p15, 0, prev_clk, c15, c12, 0;  /* Read the Monitor conrol register */
            orr prev_clk, prev_clk, 0xf;
            mcr p15, 0, prev_clk, c15, c12, 0   /* write rge Monitor control regsiter */
                mrc p15, 0, prev_clk, c15, c12, 1;  /* Read count register 0 */
        }

#endif
#ifdef TIME_PROFILE
        gettimeofday(&StartTime, NULL);
#endif
#ifdef UNDER_CE						//Timing starts for decode call
               //INTERRUPTS_OFF;
			   Flag=QueryPerformanceFrequency(&lpFrequency);
			   Flag=QueryPerformanceCounter(&lpPerformanceCountBegin);
#endif
        iStatus = eWMAEncodeFrame( psEncConfig,wavInBuf,wmaOutBuf,m_bNoMoreData);
        if((int)iStatus < 0)
        {
	        fprintf(stderr,"WMA Encode Frame Failed!\n");
          goto Cleanup;
        }
        FrameNum++;
        //printf("Frame: %d encoded.\n", FrameNum);
#ifdef UNDER_CE						//Timing Ends for Decode call
                Flag=QueryPerformanceCounter(&lpPerformanceCountEnd);
				nframe ++;
				if(nframe >=nLookAheadFrames)
			{
				Temp=(((lpPerformanceCountEnd.QuadPart - lpPerformanceCountBegin.QuadPart)*1000000)/(lpFrequency.QuadPart));
				TotalDecTime += Temp;
			}

#endif
#ifdef CCM_MHZ_MEASURE
        __asm
        {
            mrc p15, 0, curr_clk, c15, c12, 1;  /* Read cycle count register 0 */
        }
        clk = (curr_clk-prev_clk);
        tot_clk += clk;
        sample_rate = sEncParams.pFormat.nSamplesPerSec;
        if ((curr_clk-prev_clk) > max_clk)
        {
            max_clk = curr_clk-prev_clk;
            max_frm = FrameNum;
            max_sf = sample_rate;
        }
        if(FrameNum >= nLookAheadFrames)
        {
            den = (double)(sEncParams.pFormat.nSamplesPerFrame * 1000000.0);
            curr_mhz = (double)((double)(64.0*clk*sample_rate)/den);
            tot_mhz += curr_mhz;
            fprintf(fp_mhz, "Frame: %d, MCPS: %f\n", FrameNum, curr_mhz);

        }
#endif
#ifdef TIME_PROFILE
        gettimeofday(&EndTime, NULL);
        nframe++;
        if(nframe >=nLookAheadFrames)
        {
          CurEncTimeUs = (EndTime.tv_usec - StartTime.tv_usec) + (EndTime.tv_sec - StartTime.tv_sec)*1000000L;
          TotalEncTimeUs += CurEncTimeUs;
          if(CurEncTimeUs > MaxTime)
          {
  	          MaxTime_samples = sEncParams.pFormat.nSamplesPerFrame;
              MaxTime = CurEncTimeUs;
              Maxframe = nframe - nLookAheadFrames+1;
          }

#ifdef TIME_MEASURE_FRAME
          fprintf(fp_perf, "Frame %d, EncTime: %f\n", nframe-nLookAheadFrames, CurEncTimeUs);
#endif
        }
#endif //TIME_PROFILE

#ifdef ADD_ASF
        //rcAsf = asf_packetize(&psASFParams,outBuf);
        rcAsf = asf_packetize (psASFParams, wmaOutBuf, asfOutBuf, sEncParams.WMAE_isPacketReady, sEncParams.WMAE_nEncodeSamplesDone);

        if(rcAsf != cASF_NoErr)
        {
          fprintf(stderr,"Add Asf packet failed.\n");
          goto Cleanup;
        }
#endif
    }
#ifdef UNDER_CE
	    total_samples = (__int64 )sEncParams.App_iAudioSrcLength/(sizeof(short) * sEncParams.pFormat.nChannels);
	 _ftprintf(fp_performance,TEXT("%s\t %ld\t %ld\t %I64d\t %d\t \n"),argv[2], sEncParams.pFormat.nSamplesPerSec,sEncParams.pFormat.nAvgBytesPerSec*8,TotalDecTime, total_samples);
	fclose(fp_performance);
#endif //UNDER_CE
#ifdef CCM_MHZ_MEASURE
	tot_mhz = tot_mhz/(FrameNum-nLookAheadFrames+1);
	fprintf (fp_mhz, "Max Mhz for %s occurs at frame number = %d\n", sEncParams.App_szOutputFileName, max_frm);
	fprintf (fp_mhz, "Max Mhz = %f Avg Mhz = %f\n", curr_mhz,tot_mhz);
	fprintf (fp_mhz, "total clk = %d, total samples: %d\n", tot_clk,tot_sample);
	fprintf (fp_mhz, "\n");
	fclose (fp_mhz);
#endif
#ifdef TIME_PROFILE
    total_samples = (long long )sEncParams.App_iAudioSrcLength/(sizeof(short) * sEncParams.pFormat.nChannels);
    fprintf(fp_perf,"%s\t%d\t%ld\t%ld\t%ld\t%ld\t%d\t%ld\t%ld\n",sEncParams.App_szInputFileName,sEncParams.pFormat.nSamplesPerSec,sEncParams.pFormat.nAvgBytesPerSec*8,MaxTime,MaxTime_samples,\
		    Maxframe,nframe-nLookAheadFrames,TotalEncTimeUs,total_samples);
    fclose(fp_perf);
#endif

  // see if things went as planned here
  if((int)iStatus < 0)
    {
      fprintf(stderr,"! Unable to encode content.\r\n\r\n");
      goto Cleanup;
    }

#ifdef ADD_ASF
  psASFParams->nSize = sEncParams.App_iAudioSrcLength;
  psASFParams->nSR = sEncParams.App_pAudioInput->nSamplesPerSec;


  rcAsf = update_asf_file_header( psASFParams,
      sEncParams.App_iDstAudioBitRate    / 1000,
      sEncParams.App_iDstAudioSampleRate / 1000,
      sEncParams.App_iDstAudioChannels,
      sEncParams.App_pAudioInput->nBlockAlign,
      sEncParams.pFormat.nSamplesPerFrame);

   if(rcAsf != cASF_NoErr)
  {
    fprintf(stderr,"Update Asf file header failed.\n");
    goto Cleanup;
  }
#endif

  fprintf(stdout,"* Encode of content is complete.\r\n\r\n");
#if 0
  finish = clock();
#endif
#if 0
  {
   double time;
   FILE *fp=fopen("result_port_timing.txt","a");
   time = (double)(finish-start)/CLOCKS_PER_SEC;
   fprintf(fp,"%s\t\t %d\t\t %10.6lf\n",
	   sEncParams.App_szInputFileName,sEncParams.App_iDstAudioBitRate,time);
  }
#endif

Cleanup:
#ifdef  BUFEMPT_DUMP
  fclose(fp_buf);
#endif

    if(wavInBuf)
    {
        free_Aligned(wavInBuf);
    }

    if(wmaOutBuf)
    {
        free_Aligned(wmaOutBuf);
    }

    if(asfOutBuf)
    {
        free_Aligned(asfOutBuf);
    }
#ifdef ADD_ASF
    if(psASFParams)
    {
      free_Aligned(psASFParams);
    }
#endif
    for (i = 0; i < nr; i++)
    {
        if((psEncConfig == NULL)&&(psEncConfig->sWMAEMemInfo.sMemInfoSub[i].app_base_ptr))
        {
            free_Aligned (psEncConfig->sWMAEMemInfo.sMemInfoSub[i].app_base_ptr);
        }
    }

    if(psEncConfig)
    {
        free_Aligned (psEncConfig);
    }

  //if(pauenc)
  //  auencDelete (pauenc);

  // close our input file
  if(App_pAudioInput)
    wfioClose(App_pAudioInput);
  if(sEncParams.App_pAudioInput)
    free(App_pAudioInput);

  // close output file
  if(pRawOutput)
    {
      rfioClose(pRawOutput);
      free(pRawOutput);
    }

  // free the buffers allocated for content description
  FreeContentDescriptionFields();

  exit(0);
}




