/****************************************************************************
 *                                                                          *
 * Copyright 1999-2005 ATI Technologies Inc., Markham, Ontario, CANADA.     *
 * All Rights Reserved.                                                     *
 *                                                                          *
 * Your use and or redistribution of this software in source and \ or       *
 * binary form, with or without modification, is subject to: (i) your       *
 * ongoing acceptance of and compliance with the terms and conditions of    *
 * the ATI Technologies Inc. software End User License Agreement; and (ii)  *
 * your inclusion of this notice in any version of this software that you   *
 * use or redistribute.  A copy of the ATI Technologies Inc. software End   *
 * User License Agreement is included with this software and is also        *
 * available by contacting ATI Technologies Inc. at http://www.ati.com      *
 *                                                                          *
 ****************************************************************************/

/** \brief Declarations for KCL IOMMU supporting interfaces */

#ifndef KCL_IOMMU_H
#define KCL_IOMMU_H

#include "kcl_config.h"
#include "kcl_type.h"
#include "kcl_pci.h"

typedef union _iommu_req_perm_
{
    struct
    {
        uint32_t read    :  1;
        uint32_t write   :  1;
        uint32_t exec    :  1;
        uint32_t priv    :  1; 
        uint32_t res     :  28;  
    };   
    uint32_t all;
} KCL_IOMMU_req_perm_t;

typedef union _iommu_info_
{
    int max_pasids;            //Only defined if pasid_sup == 1
    int gvas_size;             //maximum guest virtual address space supported by the iommu driver
    int pas_size;              //maximum physical address generated by the iommu driver
    uint32_t ats_sup   :1;     //The device features an IOTLB and the IOMMU is capable of the ATS protovol
    uint32_t pri_sup   :1;     //The device features an PRI protocol and the IOMMU is able to handle them using PPR log
    uint32_t pasid_sup :1;     //The device features multiple address space and the IOMMU supports guest translations 
    uint32_t exec_sup  :1;     //execution provileges supported 
    uint32_t priv_sup  :1;     //User/Supervisor privileges supported
    uint32_t reserved  :27;   
} KCL_IOMMU_info_t;

//need to check iommu driver defines
typedef enum {
    KCL_IOMMU_PRI_SUCCESS,
    KCL_IOMMU_PRI_INVALID_RESPONSE,    
    KCL_IOMMU_PRI_RESPONSE_FAILURE,
    KCL_IOMMU_PRI_DROP,
}KCL_IOMMU_INVALID_PRI_RESPONSE;
    
    

int ATI_API_CALL KCL_IOMMU_InitDevice( KCL_PCI_DevHandle pcidev, KCL_IOMMU_info_t* pInfo);
void ATI_API_CALL KCL_IOMMU_FreeDevice( KCL_PCI_DevHandle pcidev);
int ATI_API_CALL KCL_IOMMU_BindPasid( KCL_PCI_DevHandle pcidev, int pid, int  pasid);
void ATI_API_CALL KCL_IOMMU_UnbindPasid( KCL_PCI_DevHandle pcidev, int  pasid);


#endif
