/****************************************************************************
 *                                                                          *
 * Copyright 1999-2005 ATI Technologies Inc., Markham, Ontario, CANADA.     *
 * All Rights Reserved.                                                     *
 *                                                                          *
 * Your use and or redistribution of this software in source and \ or       *
 * binary form, with or without modification, is subject to: (i) your       *
 * ongoing acceptance of and compliance with the terms and conditions of    *
 * the ATI Technologies Inc. software End User License Agreement; and (ii)  *
 * your inclusion of this notice in any version of this software that you   *
 * use or redistribute.  A copy of the ATI Technologies Inc. software End   *
 * User License Agreement is included with this software and is also        *
 * available by contacting ATI Technologies Inc. at http://www.ati.com      *
 *                                                                          *
 ****************************************************************************/

/** \brief Declarations for KCL debug supporting interfaces */

#ifndef KCL_DEBUG_H
#define KCL_DEBUG_H

#include "kcl_config.h"

typedef enum
{
    FN_DEBUG_LEVEL1  = 0 , 
    FN_DEBUG_LEVEL2  = 1 ,
    FN_DEBUG_LEVEL3  = 2 ,
    FN_DEBUG_LEVEL4  = 3 ,
    FN_DEBUG_LEVEL5  = 4 ,
    FN_DEBUG_LEVEL6  = 5 ,
    FN_DEBUG_TRACEOUT = 6,
    FN_DEBUG_TRACE    = 7,
    FN_DEBUG_MAXIMUM  = 0x8
} FN_DEBUG;

typedef enum
{
   FN_FIREGL_OPEN_RELEASE = 0 ,
   FN_FIREGL_IOCTL        = 1 ,
   FN_FIREGL_MMAP         = 2 ,
   FN_FIREGL_READ_WRITE   = 3 ,   
   
   FN_FIREGL_FASYNC       = 4 ,
   FN_FIREGL_POLL         = 5 ,
   FN_FIREGL_LSEEK        = 6 ,
   FN_FIREGL_COMPAT_IOCTL = 7 ,
   
   FN_DRM_VM_OPEN_CLOSE   = 8 ,
   FN_DRM_NOPAGE          = 9 ,
   FN_FIREGL_ACPI         = 10,
   FN_FIREGL_IRQ          = 11,
   
   FN_FIREGL_PROC         = 12,
   FN_FIREGL_KAS          = 13,
   FN_FIREGL_KCL          = 14,
   FN_FIREGL_INIT         = 15,
   
   FN_GENERIC1            = 16,
   FN_GENERIC2            = 17,
   FN_GENERIC3            = 18,      //Added more if  necessary to 0x1f(31)
   
   FN_FIREGL_RESERVED     = 0x20,    //0x20 -0x3f reserverd 
   FN_GENERIC_MAXIMUM     = 0x3f
} FN_TRACE;

extern void ATI_API_CALL firegl_trace(unsigned int traceMask,
                                      unsigned int debugMask,
                                      void* name,
                                      int line,
                                      long param,
                                      const char* fmt,
                                      ...);

#define MAX_STRING_LENGTH    256

void ATI_API_CALL KCL_DEBUG_Print(const char* fmt, ...);
int ATI_API_CALL KCL_DEBUG_RegKbdHandler(int enable);
int ATI_API_CALL KCL_DEBUG_RegKbdDumpHandler(int enable);
void ATI_API_CALL KCL_DEBUG_OsDump(void);

#define KCL_DEBUG_ERROR(fmt, arg...)                                        \
    KCL_DEBUG_Print("<3>[fglrx:%s] *ERROR* " fmt, __FUNCTION__, ##arg)

#define KCL_DEBUG_INFO(fmt, arg...)                                         \
    KCL_DEBUG_Print("<6>[fglrx] " fmt, ##arg)

#define KCL_DEBUG_TRACE(m, p, fmt, arg...)  \
    do                                      \
    {                                       \
        firegl_trace(m,                     \
                     FN_DEBUG_TRACE,        \
                     (void*)__FUNCTION__,   \
                     (int)(__LINE__),       \
                     (long)(p),             \
                     fmt,                   \
                     ##arg);                \
    } while (0)

#define KCL_DEBUG_TRACEIN  KCL_DEBUG_TRACE

#define KCL_DEBUG_TRACEOUT(m, p, fmt, arg...)                                                                     \
    do                                      \
    {                                       \
        firegl_trace(m,                     \
                     FN_DEBUG_TRACEOUT,     \
                     (void*)__FUNCTION__,   \
                     (int)(__LINE__),       \
                     (long)(p),             \
                     fmt,                   \
                     ##arg);                \
    } while (0)

#define KCL_DEBUG1(m, fmt, arg...)          \
    do                                      \
    {                                       \
        firegl_trace(m,                     \
                     FN_DEBUG_LEVEL1,       \
                     (void*)__FUNCTION__,   \
                     (int)__LINE__,         \
                     0,                     \
                     fmt,                   \
                     ##arg);                \
    } while (0)

#define KCL_DEBUG2(m, fmt, arg...)          \
    do                                      \
    {                                       \
        firegl_trace(m,                     \
                     FN_DEBUG_LEVEL2,       \
                     (void*)__FUNCTION__,   \
                     (int)__LINE__,         \
                     0,                     \
                     fmt,                   \
                     ##arg);                \
    } while (0)

#define KCL_DEBUG3(m, fmt, arg...)          \
    do                                      \
    {                                       \
        firegl_trace(m,                     \
                     FN_DEBUG_LEVEL3,       \
                     (void*)__FUNCTION__,   \
                     (int)__LINE__,         \
                     0,                     \
                     fmt,                   \
                     ##arg);                \
    } while (0)

#define KCL_DEBUG4(m, fmt, arg...)          \
    do                                      \
    {                                       \
        firegl_trace(m,                     \
                     FN_DEBUG_LEVEL4,       \
                     (void*)__FUNCTION__,   \
                     (int)__LINE__,         \
                     0,                     \
                     fmt,                   \
                     ##arg);                \
    } while (0)

#define KCL_DEBUG5(m, fmt, arg...)          \
    do                                      \
    {                                       \
        firegl_trace(m,                     \
                     FN_DEBUG_LEVEL5,       \
                     (void*)__FUNCTION__,   \
                     (int)__LINE__,         \
                     0,                     \
                     fmt,                   \
                     ##arg);                \
    } while (0)

#define KCL_DEBUG6(m, fmt, arg...)          \
    do                                      \
    {                                       \
        firegl_trace(m,                     \
                     FN_DEBUG_LEVEL6,       \
                     (void*)__FUNCTION__,   \
                     (int)__LINE__,         \
                     0,                     \
                     fmt,                   \
                     ##arg);                \
    } while (0)

#endif
