/* $Id: dio48_loopback.c,v 1.10 2009-01-28 12:59:20 potyra Exp $ 
 *
 * Copyright (C) 2008-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include <stdio.h>
#include <string.h>

#include "glue-log.h"
#include "glue-shm.h"

#include "dio48_loopback.h"

#define COMP "dio48_loopback"

struct cpssp {
	struct sig_std_logic_merge *forward_a00_b00;
	struct sig_std_logic_merge *forward_a01_b01;
	struct sig_std_logic_merge *forward_a02_b02;
	struct sig_std_logic_merge *forward_a03_b03;
	struct sig_std_logic_merge *forward_a04_b04;
	struct sig_std_logic_merge *forward_a05_b05;
	struct sig_std_logic_merge *forward_a06_b06;
	struct sig_std_logic_merge *forward_a07_b07;

	struct sig_std_logic_merge *forward_c00_c04;
	struct sig_std_logic_merge *forward_c01_c05;
	struct sig_std_logic_merge *forward_c02_c06;
	struct sig_std_logic_merge *forward_c03_c07;

	struct sig_std_logic_merge *forward_a10_b10;
	struct sig_std_logic_merge *forward_a11_b11;
	struct sig_std_logic_merge *forward_a12_b12;
	struct sig_std_logic_merge *forward_a13_b13;
	struct sig_std_logic_merge *forward_a14_b14;
	struct sig_std_logic_merge *forward_a15_b15;
	struct sig_std_logic_merge *forward_a16_b16;
	struct sig_std_logic_merge *forward_a17_b17;

	struct sig_std_logic_merge *forward_c10_c14;
	struct sig_std_logic_merge *forward_c11_c15;
	struct sig_std_logic_merge *forward_c12_c16;
	struct sig_std_logic_merge *forward_c13_c17;
};

void
dio48_loopback_init(
	unsigned int nr,
	struct sig_dio48 *port_dio48
)
{
	struct cpssp *cpssp;

	cpssp = shm_map(COMP, nr, sizeof(*cpssp), 0);

	cpssp->forward_a00_b00 = sig_std_logic_merge(
		port_dio48->sig[0 * 24 + 0], port_dio48->sig[0 * 24 + 8]);
	cpssp->forward_a01_b01 = sig_std_logic_merge(
		port_dio48->sig[0 * 24 + 1], port_dio48->sig[0 * 24 + 9]);
	cpssp->forward_a02_b02 = sig_std_logic_merge(
		port_dio48->sig[0 * 24 + 2], port_dio48->sig[0 * 24 + 10]);
	cpssp->forward_a03_b03 = sig_std_logic_merge(
		port_dio48->sig[0 * 24 + 3], port_dio48->sig[0 * 24 + 11]);
	cpssp->forward_a04_b04 = sig_std_logic_merge(
		port_dio48->sig[0 * 24 + 4], port_dio48->sig[0 * 24 + 12]);
	cpssp->forward_a05_b05 = sig_std_logic_merge(
		port_dio48->sig[0 * 24 + 5], port_dio48->sig[0 * 24 + 13]);
	cpssp->forward_a06_b06 = sig_std_logic_merge(
		port_dio48->sig[0 * 24 + 6], port_dio48->sig[0 * 24 + 14]);
	cpssp->forward_a07_b07 = sig_std_logic_merge(
		port_dio48->sig[0 * 24 + 7], port_dio48->sig[0 * 24 + 15]);

	cpssp->forward_c00_c04 = sig_std_logic_merge(
		port_dio48->sig[0 * 24 + 16], port_dio48->sig[0 * 24 + 20]);
	cpssp->forward_c01_c05 = sig_std_logic_merge(
		port_dio48->sig[0 * 24 + 17], port_dio48->sig[0 * 24 + 21]);
	cpssp->forward_c02_c06 = sig_std_logic_merge(
		port_dio48->sig[0 * 24 + 18], port_dio48->sig[0 * 24 + 22]);
	cpssp->forward_c03_c07 = sig_std_logic_merge(
		port_dio48->sig[0 * 24 + 19], port_dio48->sig[0 * 24 + 23]);

	cpssp->forward_a10_b10 = sig_std_logic_merge(
		port_dio48->sig[1 * 24 + 0], port_dio48->sig[1 * 24 + 8]);
	cpssp->forward_a11_b11 = sig_std_logic_merge(
		port_dio48->sig[1 * 24 + 1], port_dio48->sig[1 * 24 + 9]);
	cpssp->forward_a12_b12 = sig_std_logic_merge(
		port_dio48->sig[1 * 24 + 2], port_dio48->sig[1 * 24 + 10]);
	cpssp->forward_a13_b13 = sig_std_logic_merge(
		port_dio48->sig[1 * 24 + 3], port_dio48->sig[1 * 24 + 11]);
	cpssp->forward_a14_b14 = sig_std_logic_merge(
		port_dio48->sig[1 * 24 + 4], port_dio48->sig[1 * 24 + 12]);
	cpssp->forward_a15_b15 = sig_std_logic_merge(
		port_dio48->sig[1 * 24 + 5], port_dio48->sig[1 * 24 + 13]);
	cpssp->forward_a16_b16 = sig_std_logic_merge(
		port_dio48->sig[1 * 24 + 6], port_dio48->sig[1 * 24 + 14]);
	cpssp->forward_a17_b17 = sig_std_logic_merge(
		port_dio48->sig[1 * 24 + 7], port_dio48->sig[1 * 24 + 15]);

	cpssp->forward_c10_c14 = sig_std_logic_merge(
		port_dio48->sig[1 * 24 + 16], port_dio48->sig[1 * 24 + 20]);
	cpssp->forward_c11_c15 = sig_std_logic_merge(
		port_dio48->sig[1 * 24 + 17], port_dio48->sig[1 * 24 + 21]);
	cpssp->forward_c12_c16 = sig_std_logic_merge(
		port_dio48->sig[1 * 24 + 18], port_dio48->sig[1 * 24 + 22]);
	cpssp->forward_c13_c17 = sig_std_logic_merge(
		port_dio48->sig[1 * 24 + 19], port_dio48->sig[1 * 24 + 23]);
}

void
dio48_loopback_create(unsigned int nr, const char *name)
{
	struct cpssp *cpssp;

	shm_create(COMP, nr, sizeof(*cpssp));
	cpssp = shm_map(COMP, nr, sizeof(*cpssp), 0);

	shm_unmap(cpssp, sizeof(*cpssp));
}

void
dio48_loopback_destroy(unsigned int nr)
{
	struct cpssp *cpssp;

	cpssp = shm_map(COMP, nr, sizeof(*cpssp), 0);

	shm_unmap(cpssp, sizeof(*cpssp));
	shm_destroy(COMP, nr);
}
