/* $Id: cpu_intel_x86_64.c,v 1.10 2009-01-28 12:59:19 potyra Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "config.h"

#include <assert.h>
#include "fixme.h"
#include <stdio.h>

#include "glue-shm.h"

#include "chip_intel_x86_64.h"

#include "cpu_intel_x86_64.h"

#define COMP    "cpu_intel_x86_64"

struct cpssp {
        unsigned int chip;
};

void
cpu_intel_x86_64_init(
        unsigned int nr,
        struct sig_host_bus *port_conn
)
{
        struct cpssp *cpssp;

        cpssp = shm_map(COMP, nr, sizeof(*cpssp), 0);

        chip_intel_x86_64_init(cpssp->chip,
			port_conn->power,
			port_conn->n_reset,
			port_conn->n_init,
			port_conn->lint0,
			port_conn->lint0,
			port_conn->smi,
			port_conn->n_ferr,
			port_conn->n_ignne,
			port_conn->a20,
#if CONFIG_CPU_APIC_SUPPORT
			port_conn->icc,
#endif
			port_conn->main);
}

void
cpu_intel_x86_64_create(unsigned int nr, const char *name)
{
        struct cpssp *cpssp;

        shm_create(COMP, nr, sizeof(*cpssp));
        cpssp = shm_map(COMP, nr, sizeof(*cpssp), 0);

        cpssp->chip = chip_intel_x86_64_create();

        shm_unmap(cpssp, sizeof(*cpssp));
}

void
cpu_intel_x86_64_destroy(unsigned int nr)
{
        struct cpssp *cpssp;

        cpssp = shm_map(COMP, nr, sizeof(*cpssp), 0);

        chip_intel_x86_64_destroy(cpssp->chip);

        shm_unmap(cpssp, sizeof(*cpssp));
        shm_destroy(COMP, nr);
}
