/*
 * $Id: conn_dimm.c,v 1.8 2009-01-28 12:59:19 potyra Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "glue-shm.h"

#include "conn_dimm.h"

#define COMP	"conn_dimm"

struct cpssp {
	struct sig_boolean_merge *forward_power;
	struct sig_cs_merge *forward_cs0;
	struct sig_cs_merge *forward_cs1;
#if 0	/* FIXME */
	struct sig_mem_bus_main_forward forward_main;
#endif
	struct sig_i2c_bus_merge *forward_i2cbus;
	struct sig_boolean_merge *forward_id0;
	struct sig_boolean_merge *forward_id1;
	struct sig_boolean_merge *forward_id2;
};

void
conn_dimm_init(
	unsigned int nr,

	struct sig_mem_bus *port_mem,

	struct sig_boolean *port_power,
	struct sig_cs *port_cs0,
	struct sig_cs *port_cs1,
	struct sig_mem_bus_main *port_main,
	struct sig_i2c_bus *port_i2cbus,
	struct sig_boolean *port_id0,
	struct sig_boolean *port_id1,
	struct sig_boolean *port_id2
)
{
	struct cpssp *cpssp;

	cpssp = shm_map(COMP, nr, sizeof(*cpssp), 0);

	cpssp->forward_power = sig_boolean_merge(port_power, port_mem->power);
	cpssp->forward_cs0 = sig_cs_merge(port_cs0, port_mem->cs0);
	cpssp->forward_cs1 = sig_cs_merge(port_cs1, port_mem->cs1);
#if 0 /* FIXME */
	sig_mem_bus_main_forward_init(&cpssp->forward_main,
			port_main, port_mem->main);
#endif
	cpssp->forward_i2cbus = sig_i2c_bus_merge(port_i2cbus, port_mem->i2cbus);
	cpssp->forward_id0 = sig_boolean_merge(port_id0, port_mem->id0);
	cpssp->forward_id1 = sig_boolean_merge(port_id1, port_mem->id1);
	cpssp->forward_id2 = sig_boolean_merge(port_id2, port_mem->id2);
}

unsigned int
conn_dimm_create(void)
{
	static unsigned int nr;

	shm_create(COMP, nr, sizeof(struct cpssp));

	return nr++;
}

void
conn_dimm_destroy(unsigned int nr)
{
	shm_destroy(COMP, nr);
}
