/*
 * $Id: conn_agp.c,v 1.5 2009-01-28 12:59:19 potyra Exp $
 *
 * Copyright (C) 2003-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "glue-shm.h"

#include "conn_agp.h"

#define COMP	"conn_agp"

struct cpssp {
	struct sig_boolean_merge *forward_p3_3V;
	struct sig_boolean_merge *forward_p5V;
	struct sig_boolean_merge *forward_p12V;
	struct sig_boolean_merge *forward_n_reset;
	struct sig_agp_bus_main_merge *forward_main;
	struct sig_boolean_or_merge *forward_intA;
	struct sig_boolean_or_merge *forward_intB;
};

void
conn_agp_init(
	unsigned int nr,

	struct sig_agp_bus *dev,

	struct sig_boolean *mb_p3_3V,
	struct sig_boolean *mb_p5V,
	struct sig_boolean *mb_p12V,
	struct sig_boolean *mb_n_reset,
	struct sig_agp_bus_main *mb_main,
	struct sig_boolean_or *mb_intA,
	struct sig_boolean_or *mb_intB
)
{
	struct cpssp *cpssp;

	cpssp = shm_map(COMP, nr, sizeof(*cpssp), 0);

	cpssp->forward_p3_3V = sig_boolean_merge(mb_p3_3V, dev->p3_3V);
	cpssp->forward_p5V = sig_boolean_merge(mb_p5V, dev->p5V);
	cpssp->forward_p12V = sig_boolean_merge(mb_p12V, dev->p12V);
	cpssp->forward_n_reset = sig_boolean_merge(mb_n_reset, dev->n_reset);
	cpssp->forward_main = sig_agp_bus_main_merge(mb_main, dev->main);
	cpssp->forward_intA = sig_boolean_or_merge(dev->intA, mb_intA);
	cpssp->forward_intB = sig_boolean_or_merge(dev->intB, mb_intB);
}

unsigned int
conn_agp_create(void)
{
	static unsigned int nr = 0;

	shm_create(COMP, nr, sizeof(struct cpssp));

	return nr++;
}

void
conn_agp_destroy(unsigned int nr)
{
	shm_destroy(COMP, nr);
}
