/* $Id: disk.h,v 1.36 2009-01-28 14:37:56 potyra Exp $ 
 *
 * Copyright (C) 2004-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __DISK_H_INCLUDED
#define __DISK_H_INCLUDED

#include "build_config.h"
#include "compiler.h"

/* ==================== RUNTIME_RM || INIT_RM ==================== */
#if defined(RUNTIME_RM) || defined(INIT_RM)

extern unsigned char 
read_sector_lba_atapi(
	unsigned char device,
	unsigned short num,
	uint32_t /* long long */ block,
	unsigned short buffer_seg, unsigned short buffer_off,
	unsigned int sector_size);

extern unsigned char 
ide_harddisk_read_chs(
	unsigned char device,
	unsigned char num,
	unsigned short cylinder, unsigned char head, unsigned char sector,
	unsigned short buffer_seg, unsigned short buffer_off);

extern void
floppy_tick(void);

#endif /* RUNTIME_RM || INIT_RM */
/* ==================== REAL-MODE INIT ==================== */
#ifdef INIT_RM

extern void
disk_init(void);

extern const char *
get_identify_floppy(unsigned short drive);

extern void
floppy_init(void);

#endif /* INIT_RM */

#endif /* __DISK_H_INCLUDED */
