/* $Id: sig_cardbus.c,v 1.12 2009-01-27 17:06:41 potyra Exp $ 
 *
 * Copyright (C) 2006-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include <assert.h>
#include <stdio.h>

#include "glue-shm.h"

#include "sig_cardbus.h"

struct sig_cardbus *
sig_cardbus_init(const char *name, unsigned int nr)
{
	char n[1000];
	struct sig_cardbus *c;

	c = shm_map(name, nr, sizeof(*c), 0);

	sprintf(n, "%s-conn", name);
	c->conn = sig_boolean_init(n, nr);
	sprintf(n, "%s-+5V", name);
	c->p5V = sig_boolean_init(n, nr);
	sprintf(n, "%s-n_reset", name);
	c->n_reset = sig_boolean_init(n, nr);
	sprintf(n, "%s-bus", name);
	c->bus = sig_pci_bus_main_init(n, nr);
	sprintf(n, "%s-irq", name);
	c->irq = sig_boolean_or_init(n, nr);

	return c;
}

void
sig_cardbus_create(const char *name, unsigned int nr)
{
	char n[1000];

	shm_create(name, nr, sizeof(struct sig_cardbus));

	sprintf(n, "%s-conn", name);
	sig_boolean_create(n, nr);
	sprintf(n, "%s-+5V", name);
	sig_boolean_create(n, nr);
	sprintf(n, "%s-n_reset", name);
	sig_boolean_create(n, nr);
	sprintf(n, "%s-bus", name);
	sig_pci_bus_main_create(n, nr);
	sprintf(n, "%s-irq", name);
	sig_boolean_or_create(n, nr);
}

void
sig_cardbus_destroy(const char *name, unsigned int nr)
{
	char n[1000];

	shm_destroy(name, nr);

	sprintf(n, "%s-conn", name);
	sig_boolean_destroy(n, nr);
	sprintf(n, "%s-+5V", name);
	sig_boolean_destroy(n, nr);
	sprintf(n, "%s-n_reset", name);
	sig_boolean_destroy(n, nr);
	sprintf(n, "%s-bus", name);
	sig_pci_bus_main_destroy(n, nr);
	sprintf(n, "%s-irq", name);
	sig_boolean_or_destroy(n, nr);
}
